# frozen_string_literal: true

module EE
  module VulnerabilityFlagHelpers
    def vulnerability_flags_for(uuids)
      vulnerability_findings
        .by_uuid(uuids)
        .eager_load_vulnerability_flags
        .to_h { |finding| [finding.uuid, finding.vulnerability_flags] }
    end
  end
end
