# frozen_string_literal: true

module Types
  class VulnerabilityStateEnum < BaseEnum
    graphql_name 'VulnerabilityState'
    description 'The state of the vulnerability'

    # FIXME: https://gitlab.com/gitlab-org/gitlab/-/issues/350109
    DESCRIPTION_TEXT = 'For details, see [vulnerability status values]' \
                       '(https://docs.gitlab.com/ee/user/application_security/vulnerabilities/index.html#vulnerability-status-values).'

    value 'CONFIRMED', value: 'confirmed', description: DESCRIPTION_TEXT
    value 'DETECTED', value: 'detected', description: DESCRIPTION_TEXT
    value 'DISMISSED', value: 'dismissed', description: DESCRIPTION_TEXT
    value 'RESOLVED', value: 'resolved', description: DESCRIPTION_TEXT
  end
end
