# frozen_string_literal: true

module Types
  class VulnerabilityGradeEnum < BaseEnum
    graphql_name 'VulnerabilityGrade'
    description 'The grade of the vulnerable project'

    ::Vulnerabilities::Statistic.letter_grades.keys.each do |grade|
      value grade.to_s.upcase, value: grade.to_s, description: "#{grade.to_s.titleize} grade"
    end
  end
end
