# frozen_string_literal: true

module Types
  # rubocop: disable Graphql/AuthorizeTypes
  class VulnerabilityEvidenceType < BaseObject
    graphql_name 'VulnerabilityEvidence'
    description 'Represents a Vulnerability Evidence'

    field :summary,
          GraphQL::Types::String,
          null: true,
          description: 'Summary of the Vulnerability Evidence.'

    field :supporting_messages,
          [VulnerabilityEvidenceSupportingMessageType],
          null: true,
          description: 'Supporting messages of the Vulnerability Evidence.'

    field :source,
          VulnerabilityEvidenceSourceType,
          null: true,
          description: 'Source of the Vulnerability Evidence.'

    field :request,
          VulnerabilityRequestType,
          null: true,
          description: 'HTTP request of the Vulnerability Evidence.'

    field :response,
          VulnerabilityResponseType,
          null: true,
          description: 'HTTP response of the Vulnerability Evidence.'
  end
  # rubocop: enable Graphql/AuthorizeTypes
end
