# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class TableType < BaseType
      graphql_name 'VulnerabilityDetailTable'
      description 'Represents the vulnerability details table value'

      field :headers,
        [VulnerabilityDetailType],
        null: false,
        description: 'Table headers.',
        hash_key: :header

      field :rows,
        [VulnerabilityDetails::RowType],
        null: false,
        description: 'Table rows.'

      alias_method :finding, :object

      def rows
        finding[:rows].map { |row| { "row" => row } }
      end
    end
  end
end
