# frozen_string_literal: true

# Security::VulnerabilityFeedbacksFinder
#
# Used to filter VulnerabilityFeedback records for VulnerabilityFeedbacks API
#
# Arguments:
#   vulnerable: any object that has a #vulnerability_feedback method that returns
#               a collection of `VulnerabilityFeedback`s
#   params: optional! a hash with one or more of the following:
#     category: only return vulnerability feedbacks of that category
#     feedback_type: only return vulnerability feedbacks of that type

module Security
  class VulnerabilityFeedbacksFinder
    include FinderMethods

    def initialize(vulnerable, params = {})
      @params = params
      @vulnerable = vulnerable
    end

    def execute
      feedback = @vulnerable.vulnerability_feedback.with_associations.order_by_id_asc
      feedback = by_category(feedback)
      by_feedback_type(feedback)
    end

    private

    attr_reader :params, :feedback

    def by_category(feedback)
      feedback = feedback.with_category(params[:category]) if params[:category].present?
      feedback
    end

    def by_feedback_type(feedback)
      feedback = feedback.with_feedback_type(params[:feedback_type]) if params[:feedback_type].present?
      feedback
    end
  end
end
