import Vue from 'vue';
import apolloProvider from 'ee/security_dashboard/graphql/provider';
import App from 'ee/vulnerabilities/components/new_vulnerability/new_vulnerability.vue';

export default (el) => {
  if (!el) {
    return null;
  }

  return new Vue({
    el,
    apolloProvider,
    provide: {
      markdownDocsPath: el.dataset.markdownDocsPath,
      markdownPreviewPath: el.dataset.markdownPreviewPath,
      vulnerabilityReportPath: el.dataset.vulnerabilityReportPath,
      projectId: el.dataset.projectId,
    },
    render: (h) => h(App),
  });
};
