---
stage: Anti-Abuse
group: Anti-Abuse
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Report abuse **(FREE)**

You can report abuse from other GitLab users to GitLab administrators.

A GitLab administrator [can then choose](admin_area/review_abuse_reports.md) to:

- Remove the user, which deletes them from the instance.
- Block the user, which denies them access to the instance.
- Or remove the report, which retains the user's access to the instance.

You can report a user through their:

- [Profile](#report-abuse-from-the-users-profile-page)
- [Comments](#report-abuse-from-a-users-comment)
- [Issues](#report-abuse-from-an-issue)
- [Merge requests](#report-abuse-from-a-merge-request)
- [Snippets](snippets.md#mark-snippet-as-spam)

## Report abuse from the user's profile page

To report abuse from a user's profile page:

1. Anywhere in GitLab, select the name of the user.
1. In the upper-right corner of the user's profile, select **Report abuse to administrator** (**{information-o}**).
1. Select a reason for reporting the user.
1. Complete an abuse report.
1. Select **Send report**.

## Report abuse from a user's comment

> Reporting abuse from comments in epics [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/389992) in GitLab 15.10.

To report abuse from a user's comment:

1. In the comment, in the upper-right corner, select **More actions** (**{ellipsis_v}**).
1. Select **Report abuse to administrator**.
1. Select a reason for reporting the user.
1. Complete an abuse report.
1. Select **Send report**.

NOTE:
A URL to the reported user's comment is pre-filled in the abuse report's
**Message** field.

## Report abuse from an issue

1. On the issue, in the upper-right corner, select the vertical ellipsis (**{ellipsis_v}**).
1. Select **Report abuse to administrator**.
1. Select a reason for reporting the user.
1. Complete an abuse report.
1. Select **Send report**.

## Report abuse from a merge request

1. On the merge request, in the upper-right corner, select the vertical ellipsis (**{ellipsis_v}**).
1. Select **Report abuse to administrator**.
1. Select a reason for reporting this user.
1. Complete an abuse report.
1. Select **Send report**.

## Related topics

- Administrators can view and resolve abuse reports.
  For more information, see [abuse reports administration documentation](admin_area/review_abuse_reports.md).
