---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Inclusion of Functionality from Untrusted Control Sphere

## Description

JavaScript or CSS source files are included from third party domains without
[Sub-Resource Integrity (SRI)](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity).
If an attacker were to compromise the sites hosting these third party resources, they could inject malicious
script or CSS data in an attempt to compromise users of your application. However, if SRI was applied and an
attacker attempted to modify the contents of the script, the browser would not load the script and your
applications users would be protected from the malicious alterations.

## Remediation

All identified resources should be sourced from the same domain as the target application. If this is not
possible, it is strongly recommended that all `script` tags that implement `src` values, or `link` tags
that implement the `href` values include Sub-Resource Integrity. To generate SRI integrity values the
[SRI hash](https://www.srihash.org/) tool can be used, or by running one of the following commands:

- `cat FILENAME.js | openssl dgst -sha384 -binary | openssl base64 -A`
- `shasum -b -a 384 FILENAME.js | awk '{ print $1 }' | xxd -r -p | base64`

The output of these tools must be added as additional attributes, in particular: `integrity` and either
`crossorigin=anonymous` or `crossorigin=use-credentials`.
An example of a valid SRI protected script tag can be found below:

```html
<script src="https://example.com/example-framework.js"
    integrity="sha384-oqVuAfXRKap7fdgcCY5uykM6+R9GqQ8K/uxy9rx7HNQlGYl1kPzQho1wx4JwY8wC"
    crossorigin="anonymous"></script>
```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 829.1 | true | 829 | Passive | Low |

## Links

- [OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Third_Party_Javascript_Management_Cheat_Sheet.html#subresource-integrity)
- [CWE](https://cwe.mitre.org/data/definitions/829.html)
- [MDN](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity)
