# frozen_string_literal: true

class AddIndexForVulnerabilityStateTransition < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!
  NEW_INDEX_NAME = 'index_vulnerability_state_transitions_id_and_vulnerability_id'
  OLD_INDEX_NAME = 'index_vulnerability_state_transitions_on_vulnerability_id'

  def up
    add_concurrent_index(:vulnerability_state_transitions, [:vulnerability_id, :id], name: NEW_INDEX_NAME)

    remove_concurrent_index_by_name(:vulnerability_state_transitions, OLD_INDEX_NAME)
  end

  def down
    remove_concurrent_index_by_name(:vulnerability_state_transitions, NEW_INDEX_NAME)

    add_concurrent_index(:vulnerability_state_transitions, [:vulnerability_id], name: OLD_INDEX_NAME)
  end
end
