# frozen_string_literal: true

require 'spec_helper'
require_migration!

RSpec.describe CleanupVulnerabilityStateTransitionsWithSameFromStateToState, :migration,
feature_category: :vulnerability_management do
  let!(:namespace) { table(:namespaces).create!(name: 'namespace', type: 'Group', path: 'namespace') }
  let!(:user) { table(:users).create!(email: 'author@example.com', username: 'author', projects_limit: 10) }
  let!(:project) do
    table(:projects).create!(
      path: 'project',
      namespace_id: namespace.id,
      project_namespace_id: namespace.id
    )
  end

  let!(:vulnerability) do
    table(:vulnerabilities).create!(
      project_id: project.id,
      author_id: user.id,
      title: 'test',
      severity: 7,
      confidence: 7,
      report_type: 0
    )
  end

  let!(:state_transitions) { table(:vulnerability_state_transitions) }

  let!(:state_transition_with_no_state_change) do
    state_transitions.create!(
      vulnerability_id: vulnerability.id,
      from_state: 2,
      to_state: 2
    )
  end

  let!(:state_transition_with_state_change) do
    state_transitions.create!(
      vulnerability_id: vulnerability.id,
      from_state: 1,
      to_state: 2
    )
  end

  it 'deletes state transitions with no state change' do
    expect { migrate! }.to change(state_transitions, :count).from(2).to(1)
  end
end
