# frozen_string_literal: true

require 'spec_helper'

RSpec.describe GitlabSchema.types['VulnerabilityDetail'] do
  let(:expected_types) do
    [
      Types::VulnerabilityDetails::UrlType,
      Types::VulnerabilityDetails::IntType,
      Types::VulnerabilityDetails::ListType,
      Types::VulnerabilityDetails::CodeType,
      Types::VulnerabilityDetails::TextType,
      Types::VulnerabilityDetails::DiffType,
      Types::VulnerabilityDetails::TableType,
      Types::VulnerabilityDetails::CommitType,
      Types::VulnerabilityDetails::BooleanType,
      Types::VulnerabilityDetails::MarkdownType,
      Types::VulnerabilityDetails::FileLocationType,
      Types::VulnerabilityDetails::ModuleLocationType,
      Types::VulnerabilityDetails::BaseType
    ]
  end

  it 'exposes all possible types' do
    expect(described_class.possible_types).to contain_exactly(*expected_types)
  end

  describe '.resolve_type' do
    using RSpec::Parameterized::TableSyntax

    where(:type, :value, :graphql_type) do
      'url'             | nil   | Types::VulnerabilityDetails::UrlType
      'code'            | nil   | Types::VulnerabilityDetails::CodeType
      'text'            | nil   | Types::VulnerabilityDetails::TextType
      'diff'            | nil   | Types::VulnerabilityDetails::DiffType
      'table'           | nil   | Types::VulnerabilityDetails::TableType
      'commit'          | nil   | Types::VulnerabilityDetails::CommitType
      'markdown'        | nil   | Types::VulnerabilityDetails::MarkdownType
      'file-location'   | nil   | Types::VulnerabilityDetails::FileLocationType
      'module-location' | nil   | Types::VulnerabilityDetails::ModuleLocationType
      'list'            | nil   | Types::VulnerabilityDetails::ListType
      'named-list'      | nil   | Types::VulnerabilityDetails::ListType
      'other'           | nil   | Types::VulnerabilityDetails::BaseType
      'value'           | nil   | Types::VulnerabilityDetails::BaseType
      'value'           | '1'   | Types::VulnerabilityDetails::TextType
      'value'           | 412   | Types::VulnerabilityDetails::IntType
      'value'           | true  | Types::VulnerabilityDetails::BooleanType
      'value'           | false | Types::VulnerabilityDetails::BooleanType
    end

    with_them do
      it 'correctly maps type in object to GraphQL type' do
        expect(described_class.resolve_type({ 'type' => type, 'value' => value }, {})).to eq(graphql_type)
      end
    end
  end
end
