# frozen_string_literal: true

module VulnerabilityMergeRequestLinks
  class CreateService < ::BaseProjectService
    def execute
      raise Gitlab::Access::AccessDeniedError unless can?(@current_user, :admin_vulnerability_merge_request_link,
                                                          merge_request_link)

      if merge_request_link.save
        success_response
      else
        error_response
      end
    end

    private

    def merge_request_link
      @merge_request_link ||= Vulnerabilities::MergeRequestLink.new(vulnerability: params[:vulnerability],
                                                                    merge_request: params[:merge_request])
    end

    def success_response
      ServiceResponse.success(payload: { merge_request_link: @merge_request_link })
    end

    def error_response
      ServiceResponse.error(message: merge_request_link.errors.full_messages.to_sentence)
    end
  end
end
