# frozen_string_literal: true

module Types
  class VulnerabilityReportTypeEnum < BaseEnum
    graphql_name 'VulnerabilityReportType'
    description 'The type of the security scan that found the vulnerability'

    ::Enums::Vulnerability.report_types.keys.each do |report_type|
      upcase_type = report_type.to_s.upcase
      human_type = case report_type.to_sym
                   when :dast, :sast then upcase_type
                   when :api_fuzzing then 'API Fuzzing'
                   else report_type.to_s.titleize
                   end

      value upcase_type, value: report_type.to_s, description: "#{human_type} report"
    end
  end
end
