# frozen_string_literal: true

module Types
  module VulnerabilityLocation
    # rubocop: disable Graphql/AuthorizeTypes
    class DastType < BaseObject
      graphql_name 'VulnerabilityLocationDast'
      description 'Represents the location of a vulnerability found by a DAST scan'

      field :hostname, GraphQL::Types::String,
        null: true, description: 'Domain name of the vulnerable request.'

      field :param, GraphQL::Types::String,
        null: true, description: 'Query parameter for the URL on which the vulnerability occurred.'

      field :path, GraphQL::Types::String,
        null: true, description: 'URL path and query string of the vulnerable request.'

      field :request_method, GraphQL::Types::String,
        null: true, description: 'HTTP method of the vulnerable request.'
    end
  end
end
