# frozen_string_literal: true

module Types
  module Vulnerability
    class IssueLinkType < BaseObject
      graphql_name 'VulnerabilityIssueLink'
      description 'Represents an issue link of a vulnerability'

      authorize :read_issue_link

      field :id, GraphQL::Types::ID,
        null: false, description: 'GraphQL ID of the vulnerability.'

      field :link_type, ::Types::Vulnerability::IssueLinkTypeEnum,
        null: false, description: "Type of the issue link."

      field :issue, ::Types::IssueType,
        null: true, description: 'Issue attached to issue link.'
    end
  end
end
