# frozen_string_literal: true

module Types
  module Vulnerability
    class ExternalIssueLinkExternalTrackerEnum < BaseEnum
      graphql_name 'VulnerabilityExternalIssueLinkExternalTracker'
      description 'The external tracker of the external issue link related to a vulnerability'

      ::Vulnerabilities::ExternalIssueLink.external_types.keys.each do |external_type|
        value external_type.to_s.upcase, value: external_type.to_s, description: "#{external_type.titleize} external tracker"
      end
    end
  end
end
