# frozen_string_literal: true

module Representation
  class VulnerabilityScannerEntry < SimpleDelegator
    def initialize(raw_entry, report_type = raw_entry[:report_type])
      @report_type = report_type

      super(raw_entry)
    end

    attr_reader :raw_entry

    def report_type
      ::Enums::Vulnerability.report_types.key(@report_type) || @report_type
    end

    def ==(other)
      self.class === other && id == other.id && report_type == other.report_type
    end

    def self.declarative_policy_class
      'Vulnerabilities::ScannerPolicy'
    end
  end
end
