import { merge } from 'lodash';
import { SEVERITY_LEVELS } from 'ee/security_dashboard/store/constants';
import { SUPPORTING_MESSAGE_TYPES } from 'ee/vulnerabilities/constants';
import VulnerabilityDetails from './vulnerability_details.vue';

const mergeWithArgsFromStory = (story, overrides) => merge({}, story.args, overrides);

export default {
  component: VulnerabilityDetails,
  title: 'ee/vulnerabilities/vulnerability_details',
  argTypes: {
    severity: {
      options: Object.values(SEVERITY_LEVELS),
      control: { type: 'select' },
    },
  },
};

const Template = (_, { argTypes }) => ({
  components: { VulnerabilityDetails },
  props: Object.keys(argTypes),
  computed: {
    constructedVulnerability() {
      return {
        ...this.$props,
      };
    },
  },
  template: '<vulnerability-details :vulnerability="constructedVulnerability" />',
});

export const Default = Template.bind({});
Default.args = {
  title: 'Vulnerability title',
  description: 'description',
  severity: Object.values(SEVERITY_LEVELS)[0],
  reportType: 'reportType',
  project: {
    fullName: 'project fullName',
  },
  scanner: {
    name: 'scanner name',
    url: 'http://example.com/scannerUrl',
    version: '1.0',
  },
  location: {
    class: 'location class',
    method: 'location method',
    crashAddress: 'location crashAddress',
    crashState: 'location crashState',
    crashType: 'location crashType',
    stackTraceSnippet: 'location stackTraceSnippet',
    file: 'location file',
    image: 'location image',
    operatingSystem: 'location operatingSystem',
  },
  request: {
    url: 'http://example.com/requestUrl',
    body: 'request body',
    method: 'request method',
    headers: [
      { name: 'headers name - 1', value: 'headers value - 1' },
      { name: 'headers name - 2', value: 'headers value - 2' },
    ],
  },
  response: {
    body: 'response body',
    statusCode: '200',
    reasonPhrase: 'response reasonPhrase',
    headers: [
      { name: 'response headers name - 1', value: 'response headers value - 1' },
      { name: 'response headers name - 2', value: 'response headers value - 2' },
    ],
  },
  evidence: 'evidence',
  links: [
    { url: 'http://example.com/link-1' },
    { url: 'http://example.com/link-2', name: 'links name - 1' },
  ],
  identifiers: [
    { url: 'http://example.com/identifier-1', name: 'identifiers name - 1' },
    { url: 'http://example.com/identifier-2', name: 'Identifiers name - 2' },
  ],
  evidenceSource: {
    name: 'evidenceSource name',
  },
  assets: [
    { url: 'http://example.com/asset-1', name: 'assets name - 1' },
    { url: 'http://example.com/asset-2', name: 'assets name - 2' },
  ],
};

export const WithDescriptionHtml = Template.bind({});
WithDescriptionHtml.args = mergeWithArgsFromStory(Default, {
  descriptionHtml: `<strong>descriptionHtml</strong>`,
});

// `location.method` is provided by the REST API and `location.vulnerableMethod` by GraphQL - currently we need to support both
export const WithVulnerableMethod = Template.bind({});
WithVulnerableMethod.args = mergeWithArgsFromStory(Default, {
  location: {
    method: '',
    vulnerableMethod: 'location vulnerableMethod',
  },
});

export const WithNoScannerURL = Template.bind({});
WithNoScannerURL.args = mergeWithArgsFromStory(Default, {
  scanner: {
    url: '',
  },
});

export const WithSupportingMessages = Template.bind({});
WithSupportingMessages.args = mergeWithArgsFromStory(Default, {
  supportingMessages: [
    {
      name: SUPPORTING_MESSAGE_TYPES.RECORDED,
      response: {
        body: 'supportingMessages response body',
        statusCode: '200',
        reasonPhrase: 'supportingMessages reasonPhrase',
        headers: [
          {
            name: 'supportingMessages headers name - 1',
            value: 'supportingMessages headers value - 1',
          },
          {
            name: 'supportingMessages headers name - 2',
            value: 'supportingMessages headers value - 2',
          },
        ],
      },
    },
  ],
});
