---
stage: Plan
group: Optimize
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
type: reference, api
---

# DevOps Research and Assessment (DORA) key metrics API **(ULTIMATE)**

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/279039) in GitLab 13.10.
> - The legacy key/value pair `{ "<date>" => "<value>" }` was removed from the payload in GitLab 14.0.
> `time_to_restore_service` metric was introduced in GitLab 14.9.

All methods require at least the Reporter role.

## Get project-level DORA metrics

Get project-level DORA metrics.

```plaintext
GET /projects/:id/dora/metrics
```

| Attribute            | Type             | Required | Description |
|:---------------------|:-----------------|:---------|:------------|
| `id`                 | integer/string   | yes      | The ID or [URL-encoded path of the project](../rest/index.md#namespaced-path-encoding) can be accessed by the authenticated user. |
| `metric`             | string           | yes      | One of `deployment_frequency`, `lead_time_for_changes`, `time_to_restore_service` or `change_failure_rate`. |
| `end_date`           | string           | no       | Date range to end at. ISO 8601 Date format, for example `2021-03-01`. Default is the current date. |
| `environment_tier`   | string           | no       | The [tier of the environment](../../ci/environments/index.md#deployment-tier-of-environments). Default is `production`. Deprecated, use `environment_tiers`. |
| `environment_tiers`  | array of strings | no       | The [tiers of the environments](../../ci/environments/index.md#deployment-tier-of-environments). Default is `production`. |
| `interval`           | string           | no       | The bucketing interval. One of `all`, `monthly` or `daily`. Default is `daily`. |
| `start_date`         | string           | no       | Date range to start from. ISO 8601 Date format, for example `2021-03-01`. Default is 3 months ago. |

Example request:

```shell
curl --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/projects/1/dora/metrics?metric=deployment_frequency"
```

Example response:

```json
[
  { "date": "2021-03-01", "value": 3 },
  { "date": "2021-03-02", "value": 6 },
  { "date": "2021-03-03", "value": 0 },
  { "date": "2021-03-04", "value": 0 },
  { "date": "2021-03-05", "value": 0 },
  { "date": "2021-03-06", "value": 0 },
  { "date": "2021-03-07", "value": 0 },
  { "date": "2021-03-08", "value": 4 }
]
```

## Get group-level DORA metrics

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/279039) in GitLab 13.10.

Get group-level DORA metrics.

```plaintext
GET /groups/:id/dora/metrics
```

| Attribute           | Type             | Required | Description |
|:--------------------|:-----------------|:---------|:------------|
| `id`                | integer/string   | yes      | The ID or [URL-encoded path of the project](../rest/index.md#namespaced-path-encoding) can be accessed by the authenticated user. |
| `metric`            | string           | yes      | One of `deployment_frequency`, `lead_time_for_changes`, `time_to_restore_service` or `change_failure_rate`. |
| `end_date`          | string           | no       | Date range to end at. ISO 8601 Date format, for example `2021-03-01`. Default is the current date. |
| `environment_tier`  | string           | no       | The [tier of the environment](../../ci/environments/index.md#deployment-tier-of-environments). Default is `production`. Deprecated, use `environment_tiers`. |
| `environment_tiers` | array of strings | no       | The [tiers of the environments](../../ci/environments/index.md#deployment-tier-of-environments). Default is `production`. |
| `interval`          | string           | no       | The bucketing interval. One of `all`, `monthly` or `daily`. Default is `daily`. |
| `start_date`        | string           | no       | Date range to start from. ISO 8601 Date format, for example `2021-03-01`. Default is 3 months ago. |

Example request:

```shell
curl --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/groups/1/dora/metrics?metric=deployment_frequency"
```

Example response:

```json
[
  { "date": "2021-03-01", "value": 3 },
  { "date": "2021-03-02", "value": 6 },
  { "date": "2021-03-03", "value": 0 },
  { "date": "2021-03-04", "value": 0 },
  { "date": "2021-03-05", "value": 0 },
  { "date": "2021-03-06", "value": 0 },
  { "date": "2021-03-07", "value": 0 },
  { "date": "2021-03-08", "value": 4 }
]
```

## The `value` field

For both the project and group-level endpoints above, the `value` field in the
API response has a different meaning depending on the provided `metric` query
parameter:

| `metric` query parameter   | Description of `value` in response |
|:---------------------------|:-----------------------------------|
| `deployment_frequency`     | The API returns the total number of successful deployments during the time period. [Issue 371271](https://gitlab.com/gitlab-org/gitlab/-/issues/371271) proposes to update the API to return the daily average instead of the total number. |
| `change_failure_rate`      | The number of incidents divided by the number of deployments during the time period. Available only for production environment. |
| `lead_time_for_changes`    | The median number of seconds between the merge of the merge request (MR) and the deployment of the MR commits for all MRs deployed during the time period. |
| `time_to_restore_service`  | The median number of seconds an incident was open during the time period. Available only for production environment. |

NOTE:
The API returns the `monthly` and `all` intervals by calculating the median of the daily median values. This can introduce a slight inaccuracy in the returned data.
