# frozen_string_literal: true
class AddVulnerabilityReadsAllStatusIndex < Gitlab::Database::Migration[2.0]
  INDEX_NAME = 'index_vulnerability_reads_on_namespace_type_severity_id'

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerability_reads, %i[namespace_id report_type severity vulnerability_id], name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
