# frozen_string_literal: true

class AddTmpIndexForPotentiallyMisassociatedVulnerabilityOccurrences < Gitlab::Database::Migration[2.0]
  INDEX_NAME = "tmp_index_vulnerability_occurrences_on_id_and_scanner_id"
  REPORT_TYPES = { cluster_image_scanning: 7, generic: 99 }.freeze
  CLAUSE = "report_type IN (#{REPORT_TYPES.values.join(',')})"

  disable_ddl_transaction!

  def up
    prepare_async_index :vulnerability_occurrences,
                        [:id, :scanner_id],
                        where: CLAUSE,
                        name: INDEX_NAME
  end

  def down
    unprepare_async_index_by_name :vulnerability_occurrences, INDEX_NAME
  end
end
