# frozen_string_literal: true

class RemoveCiPipelinesVulnerabilityStatisticsLatestPipelineIdFk < Gitlab::Database::Migration[1.0]
  disable_ddl_transaction!

  def up
    with_lock_retries do
      execute('LOCK ci_pipelines, vulnerability_statistics IN ACCESS EXCLUSIVE MODE')

      remove_foreign_key_if_exists(:vulnerability_statistics, :ci_pipelines, name: "fk_e8b13c928f")
    end
  end

  def down
    add_concurrent_foreign_key(:vulnerability_statistics, :ci_pipelines, name: "fk_e8b13c928f", column: :latest_pipeline_id, target_column: :id, on_delete: :nullify)
  end
end
