# frozen_string_literal: true

require 'spec_helper'

RSpec.describe VulnerabilityExternalIssueLinks::DestroyService, feature_category: :vulnerability_management do
  let_it_be(:project) { create(:project) }
  let_it_be(:vulnerability_external_issue_link, refind: true) { create(:vulnerabilities_external_issue_link, project: project) }

  let(:service) { described_class.new(vulnerability_external_issue_link) }

  subject(:delete_external_issue_link) { service.execute }

  it 'deletes the specified vulnerability-external issue link' do
    expect { delete_external_issue_link }.to change { Vulnerabilities::ExternalIssueLink.count }.by(-1)
  end
end
