# frozen_string_literal: true

require 'spec_helper'

RSpec.describe VulnerabilityEntity do
  let(:vulnerability) { create(:vulnerability, project: project, author: user) }
  let(:project) { create(:project) }
  let(:user) { create(:user) }

  subject { described_class.new(vulnerability).as_json }

  it 'exposes vulnerability-specific elements' do
    expect(subject).to include(
      id: vulnerability.id,
      title: vulnerability.title,
      state: vulnerability.state,
      severity: vulnerability.severity,
      confidence: vulnerability.confidence,
      report_type: vulnerability.report_type,
      resolved_on_default_branch: vulnerability.resolved_on_default_branch,
      project_default_branch: vulnerability.project_default_branch,
      resolved_at: vulnerability.resolved_at,
      resolved_by_id: vulnerability.resolved_by_id,
      dismissed_at: vulnerability.dismissed_at,
      dismissed_by_id: vulnerability.dismissed_by_id,
      confirmed_at: vulnerability.confirmed_at,
      confirmed_by_id: vulnerability.confirmed_by_id
    )
  end

  it 'exposes state_transitions, issue_links and merge_request_links' do
    expect(subject).to include(:state_transitions, :issue_links, :merge_request_links)
  end
end
