# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Gitlab::VulnerabilityScanning::AffectedVersionRangeMatcher, feature_category: :vulnerability_management do
  using RSpec::Parameterized::TableSyntax

  where(:purl_type, :range, :version, :expected_result) do
    'maven' | '[,2.5]' | '1.2' | true
    'pypi' | '<=1.11.0' | '1.11' | true
    'composer' | '<=2.2.1' | '2.2.0' | true
    'golang' | '<=1.11.0' | '1.11' | true
    'maven' | '[,2.5]' | '4.3' | false
    'pypi' | '<=1.11.0' | '2.13' | false
    'composer' | '<=2.2.1' | '2.4.0' | false
    'golang' | '<=1.11.0' | '2.11' | false
  end

  with_them do
    subject(:affected) do
      described_class.new(
        purl_type: purl_type, range: range, version: version
      ).affected?
    end

    specify do
      expect(affected).to eq(expected_result)
    end
  end
end
