import { groupSelectedVulnerabilityStates } from 'ee/security_orchestration/components/policy_editor/scan_result_policy/lib';
import {
  NEWLY_DETECTED,
  PREVIOUSLY_EXISTING,
} from 'ee/security_orchestration/components/policy_editor/scan_result_policy/scan_filters/constants';

const newlyDetectedStatuses = ['new_needs_triage', 'new_dismissed'];
const previouslyExistingStatuses = ['detected', 'resolved'];

describe('groupSelectedVulnerabilityStates', () => {
  it.each`
    states                                                       | expectedGroups
    ${[]}                                                        | ${{}}
    ${newlyDetectedStatuses}                                     | ${{ [NEWLY_DETECTED]: newlyDetectedStatuses }}
    ${previouslyExistingStatuses}                                | ${{ [PREVIOUSLY_EXISTING]: previouslyExistingStatuses }}
    ${[...newlyDetectedStatuses, ...previouslyExistingStatuses]} | ${{ [NEWLY_DETECTED]: newlyDetectedStatuses, [PREVIOUSLY_EXISTING]: previouslyExistingStatuses }}
  `(
    'should return $expectedGroups state when $statuses statuses are provided',
    ({ states, expectedGroups }) => {
      expect(groupSelectedVulnerabilityStates(states)).toEqual(expectedGroups);
    },
  );

  describe('transform "newly_detected" status', () => {
    it('returns transformed statuses when "newly_detected" status is present', () => {
      expect(groupSelectedVulnerabilityStates([NEWLY_DETECTED])).toEqual({
        [NEWLY_DETECTED]: newlyDetectedStatuses,
      });
    });

    it('doesn\'t produce duplicates when "newly_detected" and other corresponding status are provided', () => {
      expect(groupSelectedVulnerabilityStates([NEWLY_DETECTED, ...newlyDetectedStatuses])).toEqual({
        [NEWLY_DETECTED]: newlyDetectedStatuses,
      });
    });
  });
});
