import { GlLink, GlTruncate } from '@gitlab/ui';
import VulnerabilityPath from 'ee/security_dashboard/components/shared/vulnerability_report/vulnerability_path.vue';
import { mountExtended } from 'helpers/vue_test_utils_helper';
import { vulnerabilities } from '../../mock_data';

describe('VulnerabilityPath', () => {
  let wrapper;

  const defaultVulnerabilityWithImage = vulnerabilities[0];

  const createWrapper = (props = {}) => {
    wrapper = mountExtended(VulnerabilityPath, {
      propsData: {
        location: defaultVulnerabilityWithImage.location,
        ...props,
      },
    });
  };

  const findVulnerabilityText = () => wrapper.findComponent(GlTruncate);
  const findVulnerabilityLink = () => wrapper.findComponent(GlLink);

  it('should display vulnerability path as text and image', () => {
    createWrapper();

    expect(findVulnerabilityLink().exists()).toBe(false);
    expect(findVulnerabilityText().exists()).toBe(true);

    expect(findVulnerabilityText().props()).toMatchObject({
      text: defaultVulnerabilityWithImage.location.image,
      position: 'middle',
    });
  });

  it('should display path as link blob path', () => {
    const vulnerabilityWithBloPathAndFile = vulnerabilities[1];
    createWrapper({ location: vulnerabilityWithBloPathAndFile.location });

    expect(findVulnerabilityLink().exists()).toBe(true);
    expect(findVulnerabilityLink().attributes('href')).toBe(
      `${vulnerabilityWithBloPathAndFile.location.blobPath}#L${vulnerabilityWithBloPathAndFile.location.startLine}`,
    );
    expect(findVulnerabilityText().props()).toMatchObject({
      text: `${vulnerabilityWithBloPathAndFile.location.file}:${vulnerabilityWithBloPathAndFile.location.startLine}`,
      position: 'middle',
    });
  });

  it('should display file path before regular path', () => {
    const vulnerabilityWithFileAndPath = vulnerabilities[6];
    createWrapper({ location: vulnerabilityWithFileAndPath.location });

    expect(findVulnerabilityLink().exists()).toBe(false);
    expect(findVulnerabilityText().exists()).toBe(true);

    expect(findVulnerabilityText().props()).toMatchObject({
      text: vulnerabilityWithFileAndPath.location.file,
      position: 'middle',
    });
  });

  it('should not render component if there is no location string', () => {
    defaultVulnerabilityWithImage.location = undefined;
    createWrapper();
    expect(wrapper.html()).toBe('');
  });
});
