import ActivityFilter from 'ee/security_dashboard/components/shared/filters/activity_filter.vue';
import ClusterFilter from 'ee/security_dashboard/components/shared/filters/cluster_filter.vue';
import ImageFilter from 'ee/security_dashboard/components/shared/filters/image_filter.vue';
import VulnerabilityFilters from 'ee/security_dashboard/components/shared/vulnerability_report/vulnerability_filters.vue';
import ProjectFilter from 'ee/security_dashboard/components/shared/filters/project_filter.vue';
import SeverityFilter from 'ee/security_dashboard/components/shared/filters/severity_filter.vue';
import StatusFilter from 'ee/security_dashboard/components/shared/filters/status_filter.vue';
import ToolFilter from 'ee/security_dashboard/components/shared/filters/tool_filter.vue';
import ToolWithVendorFilter from 'ee/security_dashboard/components/shared/filters/tool_with_vendor_filter.vue';
import { shallowMountExtended } from 'helpers/vue_test_utils_helper';
import { FILTERS } from 'ee/security_dashboard/components/shared/vulnerability_report/constants';

describe('Vulnerability filters component', () => {
  let wrapper;

  const createWrapper = ({ filters }) => {
    wrapper = shallowMountExtended(VulnerabilityFilters, {
      propsData: { filters },
    });
  };

  it('emits filters-changed event when filter is changed', () => {
    createWrapper({ filters: [FILTERS.STATUS] });
    const filter = wrapper.findComponent(StatusFilter);
    const data = { a: 1 };
    filter.vm.$emit('filter-changed', data);

    expect(wrapper.emitted('filters-changed')[0][0]).toMatchObject(data);
  });

  it.each`
    name                  | filters                    | expectedComponent
    ${'activity'}         | ${[FILTERS.ACTIVITY]}      | ${ActivityFilter}
    ${'project'}          | ${[FILTERS.PROJECT]}       | ${ProjectFilter}
    ${'severity'}         | ${[FILTERS.SEVERITY]}      | ${SeverityFilter}
    ${'status'}           | ${[FILTERS.STATUS]}        | ${StatusFilter}
    ${'tool simple'}      | ${[FILTERS.TOOL_SIMPLE]}   | ${ToolFilter}
    ${'pipeline tool'}    | ${[FILTERS.TOOL_PIPELINE]} | ${ToolFilter}
    ${'tool with vendor'} | ${[FILTERS.TOOL_VENDOR]}   | ${ToolWithVendorFilter}
    ${'cluster'}          | ${[FILTERS.CLUSTER]}       | ${ClusterFilter}
    ${'image'}            | ${[FILTERS.IMAGE]}         | ${ImageFilter}
  `(`shows the expected component for filter '$name'`, ({ filters, expectedComponent }) => {
    createWrapper({ filters });

    expect(wrapper.findComponent(expectedComponent).exists()).toBe(true);
  });
});
