# frozen_string_literal: true

module Gitlab
  module VulnerabilityScanning
    class AffectedVersionRangeMatcher
      attr_reader :purl_type, :range, :version

      def initialize(purl_type:, range:, version:)
        @purl_type = purl_type
        @range = range
        @version = version
      end

      def affected?
        type =
          case purl_type
          when 'golang'
            'go'
          when 'composer'
            'packagist'
          else
            purl_type
          end

        SemverDialects::VersionChecker.version_sat?(type, version, range)
      end
    end
  end
end
