# frozen_string_literal: true

module Gitlab
  module Llm
    module OpenAi
      module Completions
        class ExplainVulnerability < Gitlab::Llm::Completions::Base
          DEFAULT_ERROR = 'An unexpected error has occurred.'

          def execute(user, vulnerability, _options)
            template = ai_prompt_class.new(vulnerability)
            response = response_for(user, template)
            response_modifier = Gitlab::Llm::OpenAi::ResponseModifiers::Chat.new(response)

            ::Gitlab::Llm::GraphqlSubscriptionResponseService.new(
              user, vulnerability, response_modifier, options: { request_id: params[:request_id] }
            ).execute
          end

          private

          def response_for(user, template)
            client_class = ::Gitlab::Llm::OpenAi::Client
            client_class
              .new(user)
              .chat(content: template.to_prompt, **template.options(client_class))
          end
        end
      end
    end
  end
end
