# frozen_string_literal: true

module EE
  module API
    module Entities
      class VulnerabilityRelatedIssue < ::API::Entities::IssueBasic
        # vulnerability_link_* attributes come from joined Vulnerabilities::IssueLink record
        expose :vulnerability_link_id
        expose :vulnerability_link_type do |related_issue|
          ::Vulnerabilities::IssueLink.link_types.key(related_issue.vulnerability_link_type)
        end
      end
    end
  end
end
