# frozen_string_literal: true

module EE
  module API
    module Entities
      class VulnerabilityIssueLink < Grape::Entity
        expose :id
        expose :vulnerability, using: ::EE::API::Entities::Vulnerability
        expose :issue, using: ::API::Entities::IssueBasic, if: -> (vulnerability_issue_link, options) {
          Ability.allowed?(options[:current_user], :read_issue, vulnerability_issue_link.issue)
        }
        expose :link_type
      end
    end
  end
end
