# frozen_string_literal: true

module Llm
  class ExplainVulnerabilityService < BaseService
    def valid?
      super && Ability.allowed?(user, :explain_vulnerability, resource)
    end

    private

    def perform
      perform_async(user, resource, :explain_vulnerability, options)
    end
  end
end
