# frozen_string_literal: true

class VulnerabilityPolicy < BasePolicy
  delegate { @subject.project }

  # Only users who can read vulnerability can comment.
  # It would not be safe to prevent :create_note in project policy,
  # since note permissions are shared, and this can have ripple effect on other parts.
  rule { ~can?(:read_security_resource) }.prevent :create_note
  rule { can?(:read_security_resource) }.enable :read_vulnerability

  condition(:can_explain_vulnerability?, scope: :subject) do
    Feature.enabled?(:openai_experimentation, @subject&.project) &&
      Feature.enabled?(:explain_vulnerability, @subject&.project) &&
      ::Gitlab::Llm::StageCheck.available?(@subject&.project&.root_ancestor, :explain_vulnerability) &&
      @subject&.send_to_ai?
  end

  rule { can_explain_vulnerability? & can?(:read_security_resource) }.enable(:explain_vulnerability)
end
