# frozen_string_literal: true

module Types
  # rubocop: disable Graphql/AuthorizeTypes
  class VulnerabilityResponseType < BaseObject
    graphql_name 'VulnerabilityResponse'
    description 'Represents a Vulnerability Response'

    field :body, GraphQL::Types::String,
      null: true, description: 'Body of the Vulnerability Response.'

    field :status_code, GraphQL::Types::Int,
      null: true, description: 'Status Code of the Vulnerability Response.'

    field :reason_phrase, GraphQL::Types::String,
      null: true, description: 'Reason Phrase of the Vulnerability Response.'

    field :headers, [VulnerabilityRequestResponseHeaderType],
      null: false, description: 'HTTP headers of the Vulnerability Response.'
  end
  # rubocop: enable Graphql/AuthorizeTypes
end
