# frozen_string_literal: true

module Types
  # rubocop: disable Graphql/AuthorizeTypes
  class VulnerabilityIdentifierType < BaseObject
    graphql_name 'VulnerabilityIdentifier'
    description 'Represents a vulnerability identifier'

    field :name,
          GraphQL::Types::String,
          null: true,
          description: 'Name of the vulnerability identifier.'

    field :url,
          GraphQL::Types::String,
          null: true,
          description: 'URL of the vulnerability identifier.'

    field :external_type,
          GraphQL::Types::String,
          null: true,
          description: 'External type of the vulnerability identifier.'

    field :external_id,
          GraphQL::Types::String,
          null: true,
          description: 'External ID of the vulnerability identifier.'
  end
  # rubocop: enable Graphql/AuthorizeTypes
end
