# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class ListType < BaseType
      graphql_name 'VulnerabilityDetailList'
      description 'Represents the vulnerability details list value'

      field :items, [VulnerabilityDetailType], null: false, description: 'List of details.'

      def items
        return object[:items] || [] if object[:type] == 'list'

        ::Resolvers::Vulnerabilities::DetailsResolver.with_field_name(object[:items])
      end
    end
  end
end
