# frozen_string_literal: true

module Types
  module PermissionTypes
    class Vulnerability < BasePermissionType
      graphql_name 'VulnerabilityPermissions'
      description 'Check permissions for the current user on a vulnerability'

      abilities :read_vulnerability_feedback,
                :create_vulnerability_feedback,
                :destroy_vulnerability_feedback,
                :update_vulnerability_feedback,
                :create_vulnerability_export,
                :admin_vulnerability_issue_link,
                :admin_vulnerability_external_issue_link,
                :admin_vulnerability,
                :read_vulnerability
    end
  end
end
