# frozen_string_literal: true

module Projects
  module Security
    class VulnerabilityReportController < Projects::ApplicationController
      before_action do
        push_frontend_feature_flag(:dismissal_reason, @project)
      end

      before_action :authorize_read_vulnerability!

      feature_category :vulnerability_management
      urgency :low

      alias_method :vulnerable, :project
    end
  end
end
