import { s__ } from '~/locale';

const SAST = 'SAST';
const DEPENDENCY_SCANNING = 'DEPENDENCY_SCANNING';
const CONTAINER_SCANNING = 'CONTAINER_SCANNING';
const DAST = 'DAST';
const SECRET_DETECTION = 'SECRET_DETECTION';
const COVERAGE_FUZZING = 'COVERAGE_FUZZING';
const API_FUZZING = 'API_FUZZING';
const CLUSTER_IMAGE_SCANNING = 'CLUSTER_IMAGE_SCANNING';
const GENERIC = 'GENERIC';

// This is a capture of all possible values of the GraphQL type `VulnerabilityReportType`
export const REPORT_TYPES = [
  SAST,
  DEPENDENCY_SCANNING,
  CONTAINER_SCANNING,
  DAST,
  SECRET_DETECTION,
  COVERAGE_FUZZING,
  API_FUZZING,
  CLUSTER_IMAGE_SCANNING,
  GENERIC,
];

/**
 * Note: once https://gitlab.com/gitlab-org/gitlab/-/issues/376022 is implemented, this mapping (and possibly the REPORT_TYPE array) can be removed.
 */
export const REPORT_TYPES_TO_HUMAN_READABLE = {
  SAST: s__('ciReport|SAST'),
  DEPENDENCY_SCANNING: s__('ciReport|Dependency Scanning'),
  CONTAINER_SCANNING: s__('ciReport|Container Scanning'),
  DAST: s__('ciReport|DAST'),
  SECRET_DETECTION: s__('ciReport|Secret Detection'),
  COVERAGE_FUZZING: s__('ciReport|Coverage Fuzzing'),
  API_FUZZING: s__('ciReport|API Fuzzing'),
  CLUSTER_IMAGE_SCANNING: s__('ciReport|Cluster Image Scanning'),
  GENERIC: s__('ciReport|Generic Report'),
};
