---
stage: Manage
group: Import and Integrate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# GraphQL development guidelines

This guide contains all the information to successfully contribute to the GitLab
GraphQL API. This is a living document, and we welcome contributions,
feedback, and suggestions.

## Resources

- [GraphQL API development style guide](../api_graphql_styleguide.md): development style guide for
  GraphQL.
- [GraphQL API documentation style guide](../documentation/graphql_styleguide.md): documentation
  style guide for GraphQL.
- [GraphQL API](../../api/graphql/index.md): user documentation for the GitLab GraphQL API.
- [GraphQL authorization](authorization.md): guide to using authorization in GraphQL.
- [GraphQL BatchLoader](batchloader.md): development documentation on the BatchLoader.
- [GraphQL pagination](pagination.md): development documentation on pagination.
- [GraphQL Pro](graphql_pro.md): information on our GraphQL Pro subscription.
- [GraphQL monitoring](monitoring.md): tips on how to use our monitoring tools to inspect GraphQL queries.
