---
stage: Govern
group: Threat Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Vulnerability export API **(ULTIMATE)**

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/197494) in GitLab 12.10. [Updated](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/30397) in GitLab 13.0.

Every API call to vulnerability exports must be [authenticated](rest/index.md#authentication).

## Create a project-level vulnerability export

Creates a new vulnerability export for a project.

If an authenticated user doesn't have permission to
[create a new vulnerability](../user/permissions.md#project-members-permissions),
this request returns a `403 Forbidden` status code.

Vulnerability exports can be only accessed by the export's author.

```plaintext
POST /security/projects/:id/vulnerability_exports
```

| Attribute           | Type              | Required   | Description                                                                                                                  |
| ------------------- | ----------------- | ---------- | -----------------------------------------------------------------------------------------------------------------------------|
| `id`                | integer or string | yes        | The ID or [URL-encoded path](rest/index.md#namespaced-path-encoding) of the project which the authenticated user is a member of |

```shell
curl --request POST --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/projects/1/vulnerability_exports"
```

The created vulnerability export is automatically deleted after 1 hour.

Example response:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": 1,
  "group_id": null,
  "format": "csv",
  "status": "created",
  "started_at": null,
  "finished_at": null,
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
  }
}
```

## Create a group-level vulnerability export

Creates a new vulnerability export for a group.

If an authenticated user doesn't have permission to
[create a new vulnerability](../user/permissions.md#group-members-permissions),
this request returns a `403 Forbidden` status code.

Vulnerability exports can be only accessed by the export's author.

```plaintext
POST /security/groups/:id/vulnerability_exports
```

| Attribute           | Type              | Required   | Description                                                                                                                  |
| ------------------- | ----------------- | ---------- | -----------------------------------------------------------------------------------------------------------------------------|
| `id`                | integer or string | yes        | The ID or [URL-encoded path](rest/index.md#namespaced-path-encoding) of the group which the authenticated user is a member of |

```shell
curl --request POST --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/groups/1/vulnerability_exports"
```

The created vulnerability export is automatically deleted after 1 hour.

Example response:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": null,
  "group_id": 1,
  "format": "csv",
  "status": "created",
  "started_at": null,
  "finished_at": null,
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
  }
}
```

## Create an instance-level vulnerability export

Creates a new vulnerability export for the projects of the user selected in the Security Dashboard.

```plaintext
POST /security/vulnerability_exports
```

```shell
curl --request POST --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/vulnerability_exports"
```

The created vulnerability export is automatically deleted after one hour.

Example response:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": null,
  "group_id": null,
  "format": "csv",
  "status": "created",
  "started_at": null,
  "finished_at": null,
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
  }
}
```

## Get single vulnerability export

Gets a single vulnerability export.

```plaintext
GET /security/vulnerability_exports/:id
```

| Attribute | Type | Required | Description |
| --------- | ---- | -------- | ----------- |
| `id` | integer or string | yes | The vulnerability export's ID |

```shell
curl --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/vulnerability_exports/2"
```

If the vulnerability export isn't finished, the response is `202 Accepted`.

Example response:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": 1,
  "group_id": null,
  "format": "csv",
  "status": "finished",
  "started_at": "2020-03-30T09:36:54.469Z",
  "finished_at": "2020-03-30T09:36:55.008Z",
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
  }
}
```

## Download vulnerability export

Downloads a single vulnerability export.

```plaintext
GET /security/vulnerability_exports/:id/download
```

| Attribute | Type | Required | Description |
| --------- | ---- | -------- | ----------- |
| `id` | integer or string | yes | The vulnerability export's ID |

```shell
curl --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/security/vulnerability_exports/2/download"
```

The response is `404 Not Found` if the vulnerability export is not finished yet or was not found.

Example response:

```csv
Group Name,Project Name,Tool,Scanner Name,Status,Vulnerability,Details,Additional Info,Severity,CVE,CWE,Other Identifiers,Detected At,Location,Activity,Comments,
Gitlab.org,Defend,container_scanning,Trivy,resolved,CVE-2019-14697 in musl-utils-1.1.20-r4,"musl libc through 1.1.23 has an x87 floating-point stack adjustment imbalance, related to the math/i386/ directory. In some cases, use of this library could introduce out-of-bounds writes that are not present in an application's source code.",CVE-2019-14697 in musl-utils-1.1.20-r4,critical,CVE-2019-14697,,"",2022-10-07 13:34:41 UTC,"{""image""=>""python:3.4-alpine"", ""dependency""=>{""package""=>{""name""=>""musl-utils""}, ""version""=>""1.1.20-r4""}, ""operating_system""=>""alpine 3.9.2""}",true,"2022-10-07 13:41:08 UTC|root|resolved|changed vulnerability status to resolved",
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2019-19242 in sqlite-libs-3.26.0-r3,"SQLite 3.30.1 mishandles pExpr->y.pTab, as demonstrated by the TK_COLUMN case in sqlite3ExprCodeTarget in expr.c.",CVE-2019-19242 in sqlite-libs-3.26.0-r3,medium,CVE-2019-19242,,"",2022-10-07 13:34:41 UTC,"{""image""=>""python:3.4-alpine"", ""dependency""=>{""package""=>{""name""=>""sqlite-libs""}, ""version""=>""3.26.0-r3""}, ""operating_system""=>""alpine 3.9.2""}",true,"",
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2020-28928 in musl-1.1.20-r4,"In musl libc through 1.2.1, wcsnrtombs mishandles particular combinations of destination buffer size and source character limit, as demonstrated by an invalid write access (buffer overflow).",CVE-2020-28928 in musl-1.1.20-r4,medium,CVE-2020-28928,,"",2022-10-07 13:34:41 UTC,"{""image""=>""python:3.4-alpine"", ""dependency""=>{""package""=>{""name""=>""musl""}, ""version""=>""1.1.20-r4""}, ""operating_system""=>""alpine 3.9.2""}",true,"",
Gitlab.org,Defend,dependency_scanning,Gemnasium,detected,Improper Neutralization of Special Elements used in an OS Command ('OS Command Injection') in rack,Carefully crafted requests can cause shell escape sequences to be written to the terminal via Rack's Lint middleware and CommonLogger middleware. These escape sequences can be leveraged to possibly execute commands in the victim's terminal.,Improper Neutralization of Special Elements used in an OS Command ('OS Command Injection') in rack,unknown,Gemfile.lock:rack:gemnasium:60b5a27f-4e4d-4ab4-8ae7-74b4b212e177,,Gemnasium-60b5a27f-4e4d-4ab4-8ae7-74b4b212e177; GHSA-wq4h-7r42-5hrr,2022-10-14 13:16:00 UTC,"{""file""=>""Gemfile.lock"", ""dependency""=>{""package""=>{""name""=>""rack""}, ""version""=>""2.2.3""}}",false,"",
Gitlab.org,Defend,dependency_scanning,Gemnasium,detected,Denial of Service Vulnerability in Rack Multipart Parsing in rack,"Carefully crafted multipart POST requests can cause Rack's multipart parser to take much longer than expected, leading to a possible denial of service vulnerability. Impacted code will use Rack's multipart parser to parse multipart posts.",Denial of Service Vulnerability in Rack Multipart Parsing in rack,unknown,Gemfile.lock:rack:gemnasium:20daa17a-47b5-4f79-80c2-cd8f2db9805c,,Gemnasium-20daa17a-47b5-4f79-80c2-cd8f2db9805c; GHSA-hxqx-xwvh-44m2,2022-10-14 13:16:00 UTC,"{""file""=>""Gemfile.lock"", ""dependency""=>{""package""=>{""name""=>""rack""}, ""version""=>""2.2.3""}}",false,"",
Gitlab.org,Defend,sast,Brakeman,detected,Possible SQL injection,,Possible SQL injection,medium,e52f23a259cd489168b4313317ac94a3f13bffde57b9635171c1a44a9f329e9a,,"""Brakeman Warning Code 0""",2022-10-13 15:16:36 UTC,"{""file""=>""main.rb"", ""class""=>""User"", ""method""=>""index"", ""start_line""=>3}",false,""
```
