---
stage: Manage
group: Import and Integrate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!---
  This documentation is auto generated by a script.

  Please do not edit this file directly, check compile_docs task on lib/tasks/gitlab/graphql.rake.
--->

# GraphQL API Resources

This documentation is self-generated based on GitLab current GraphQL schema.

The API can be explored interactively using the [GraphiQL IDE](../index.md#graphiql).

Each table below documents a GraphQL type. Types match loosely to models, but not all
fields and methods on a model are available via GraphQL.

WARNING:
Fields that are deprecated are marked with **{warning-solid}**.
Items (fields, enums, etc) that have been removed according to our [deprecation process](../index.md#deprecation-and-removal-process) can be found
in [Removed Items](../removed_items.md).

<!-- vale off -->
<!-- Vale linting disabled after this line. -->
<!-- See https://docs.gitlab.com/ee/development/documentation/testing.html#disable-vale-tests -->

<!-- markdownlint-disable MD044 -->
<!-- MD044/proper-names test disabled after this line to make page compatible with markdownlint-cli 0.29.0. -->
<!-- See https://docs.gitlab.com/ee/development/documentation/testing.html#disable-markdownlint-tests -->

## `Query` type

The `Query` type contains the API's top-level entry points for all executable queries.

### `Query.boardList`

Find an issue board list.

Returns [`BoardList`](#boardlist).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryboardlistid"></a>`id` | [`ListID!`](#listid) | Global ID of the list. |
| <a id="queryboardlistissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | Filters applied when getting issue metadata in the board list. |

### `Query.ciApplicationSettings`

CI related settings that apply to the entire instance.

Returns [`CiApplicationSettings`](#ciapplicationsettings).

### `Query.ciCatalogResources`

CI Catalog resources visible to the current user.

WARNING:
**Introduced** in 15.11.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`CiCatalogResourceConnection`](#cicatalogresourceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycicatalogresourcesprojectpath"></a>`projectPath` | [`ID`](#id) | Project with the namespace catalog. |

### `Query.ciConfig`

Linted and processed contents of a CI config.
Should not be requested more than once per request.

Returns [`CiConfig`](#ciconfig).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryciconfigcontent"></a>`content` | [`String!`](#string) | Contents of `.gitlab-ci.yml`. |
| <a id="queryciconfigdryrun"></a>`dryRun` | [`Boolean`](#boolean) | Run pipeline creation simulation, or only do static check. |
| <a id="queryciconfigprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the CI config. |
| <a id="queryciconfigsha"></a>`sha` | [`String`](#string) | Sha for the pipeline. |

### `Query.ciMinutesUsage`

CI/CD minutes usage data for a namespace.

Returns [`CiMinutesNamespaceMonthlyUsageConnection`](#ciminutesnamespacemonthlyusageconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryciminutesusagedate"></a>`date` | [`Date`](#date) | Date for which to retrieve the usage data, should be the first day of a month. |
| <a id="queryciminutesusagenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | Global ID of the Namespace for the monthly CI/CD minutes usage. |

### `Query.ciPipelineStage`

Stage belonging to a CI pipeline.

Returns [`CiStage`](#cistage).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycipipelinestageid"></a>`id` | [`CiStageID!`](#cistageid) | Global ID of the CI stage. |

### `Query.ciVariables`

List of the instance's CI/CD variables.

Returns [`CiInstanceVariableConnection`](#ciinstancevariableconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycivariablessort"></a>`sort` | [`CiVariableSort`](#civariablesort) | Sort order of results. |

### `Query.containerRepository`

Find a container repository.

Returns [`ContainerRepositoryDetails`](#containerrepositorydetails).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | Global ID of the container repository. |

### `Query.currentLicense`

Fields related to the current license.

Returns [`CurrentLicense`](#currentlicense).

### `Query.currentUser`

Get information about current user.

Returns [`UserCore`](#usercore).

### `Query.designManagement`

Fields related to design management.

Returns [`DesignManagement!`](#designmanagement).

### `Query.devopsAdoptionEnabledNamespaces`

Get configured DevOps adoption namespaces. **BETA** This endpoint is subject to change without notice.

Returns [`DevopsAdoptionEnabledNamespaceConnection`](#devopsadoptionenablednamespaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querydevopsadoptionenablednamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | Filter by display namespace. |

### `Query.echo`

Testing endpoint to validate the API with.

Returns [`String!`](#string).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryechotext"></a>`text` | [`String!`](#string) | Text to echo back. |

### `Query.epicBoardList`

Returns [`EpicList`](#epiclist).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryepicboardlistepicfilters"></a>`epicFilters` | [`EpicFilters`](#epicfilters) | Filters applied when getting epic metadata in the epic board list. |
| <a id="queryepicboardlistid"></a>`id` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the list. |

### `Query.geoNode`

Find a Geo node.

Returns [`GeoNode`](#geonode).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygeonodename"></a>`name` | [`String`](#string) | Name of the Geo node. Defaults to the current Geo node name. |

### `Query.gitpodEnabled`

Whether Gitpod is enabled in application settings.

Returns [`Boolean`](#boolean).

### `Query.group`

Find a group.

Returns [`Group`](#group).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygroupfullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the project, group, or namespace. For example, `gitlab-org/gitlab-foss`. |

### `Query.groups`

Find groups.

Returns [`GroupConnection`](#groupconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygroupssearch"></a>`search` | [`String`](#string) | Search query for group name or group full path. |

### `Query.instanceExternalAuditEventDestinations`

Instance level external audit event destinations.

Returns [`InstanceExternalAuditEventDestinationConnection`](#instanceexternalauditeventdestinationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

### `Query.instanceSecurityDashboard`

Fields related to Instance Security Dashboard.

Returns [`InstanceSecurityDashboard`](#instancesecuritydashboard).

### `Query.issue`

Find an issue.

Returns [`Issue`](#issue).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryissueid"></a>`id` | [`IssueID!`](#issueid) | Global ID of the issue. |

### `Query.issues`

Find issues visible to the current user. At least one filter must be provided.

WARNING:
**Introduced** in 15.6.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`IssueConnection`](#issueconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryissuesassigneeid"></a>`assigneeId` | [`String`](#string) | ID of a user assigned to the issues. Wildcard values "NONE" and "ANY" are supported. |
| <a id="queryissuesassigneeusername"></a>`assigneeUsername` **{warning-solid}** | [`String`](#string) | **Deprecated** in 13.11. Use `assigneeUsernames`. |
| <a id="queryissuesassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the issue. |
| <a id="queryissuesauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author of the issue. |
| <a id="queryissuesclosedafter"></a>`closedAfter` | [`Time`](#time) | Issues closed after this date. |
| <a id="queryissuesclosedbefore"></a>`closedBefore` | [`Time`](#time) | Issues closed before this date. |
| <a id="queryissuesconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter for confidential issues. If "false", excludes confidential issues. If "true", returns only confidential issues. |
| <a id="queryissuescreatedafter"></a>`createdAfter` | [`Time`](#time) | Issues created after this date. |
| <a id="queryissuescreatedbefore"></a>`createdBefore` | [`Time`](#time) | Issues created before this date. |
| <a id="queryissuescrmcontactid"></a>`crmContactId` | [`String`](#string) | ID of a contact assigned to the issues. |
| <a id="queryissuescrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | ID of an organization assigned to the issues. |
| <a id="queryissuesepicid"></a>`epicId` | [`String`](#string) | ID of an epic associated with the issues, "none" and "any" values are supported. |
| <a id="queryissueshealthstatusfilter"></a>`healthStatusFilter` | [`HealthStatusFilter`](#healthstatusfilter) | Health status of the issue, "none" and "any" values are supported. |
| <a id="queryissuesiid"></a>`iid` | [`String`](#string) | IID of the issue. For example, "1". |
| <a id="queryissuesiids"></a>`iids` | [`[String!]`](#string) | List of IIDs of issues. For example, `["1", "2"]`. |
| <a id="queryissuesin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="queryissuesincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | Whether to include issues from archived projects. Defaults to `false`. |
| <a id="queryissuesincludesubepics"></a>`includeSubepics` | [`Boolean`](#boolean) | Whether to include subepics when filtering issues by epicId. |
| <a id="queryissuesiterationid"></a>`iterationId` | [`[ID]`](#id) | List of iteration Global IDs applied to the issue. |
| <a id="queryissuesiterationwildcardid"></a>`iterationWildcardId` | [`IterationWildcardId`](#iterationwildcardid) | Filter by iteration ID wildcard. |
| <a id="queryissueslabelname"></a>`labelName` | [`[String]`](#string) | Labels applied to this issue. |
| <a id="queryissuesmilestonetitle"></a>`milestoneTitle` | [`[String]`](#string) | Milestone applied to this issue. |
| <a id="queryissuesmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | Filter issues by milestone ID wildcard. |
| <a id="queryissuesmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. Wildcard values "NONE" and "ANY" are supported. |
| <a id="queryissuesnot"></a>`not` | [`NegatedIssueFilterInput`](#negatedissuefilterinput) | Negated arguments. |
| <a id="queryissuesor"></a>`or` | [`UnionedIssueFilterInput`](#unionedissuefilterinput) | List of arguments with inclusive OR. |
| <a id="queryissuessearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="queryissuessort"></a>`sort` | [`IssueSort`](#issuesort) | Sort issues by this criteria. |
| <a id="queryissuesstate"></a>`state` | [`IssuableState`](#issuablestate) | Current state of this issue. |
| <a id="queryissuestypes"></a>`types` | [`[IssueType!]`](#issuetype) | Filter issues by the given issue types. |
| <a id="queryissuesupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Issues updated after this date. |
| <a id="queryissuesupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Issues updated before this date. |
| <a id="queryissuesweight"></a>`weight` | [`String`](#string) | Weight applied to the issue, "none" and "any" values are supported. |

### `Query.iteration`

Find an iteration.

Returns [`Iteration`](#iteration).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryiterationid"></a>`id` | [`IterationID!`](#iterationid) | Find an iteration by its ID. |

### `Query.jobs`

All jobs on this GitLab instance.

Returns [`CiJobConnection`](#cijobconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryjobsstatuses"></a>`statuses` | [`[CiJobStatus!]`](#cijobstatus) | Filter jobs by status. |

### `Query.licenseHistoryEntries`

Fields related to entries in the license history.

Returns [`LicenseHistoryEntryConnection`](#licensehistoryentryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

### `Query.mergeRequest`

Find a merge request.

Returns [`MergeRequest`](#mergerequest).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymergerequestid"></a>`id` | [`MergeRequestID!`](#mergerequestid) | Global ID of the merge request. |

### `Query.metadata`

Metadata about GitLab.

Returns [`Metadata`](#metadata).

### `Query.milestone`

Find a milestone.

Returns [`Milestone`](#milestone).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymilestoneid"></a>`id` | [`MilestoneID!`](#milestoneid) | Find a milestone by its ID. |

### `Query.namespace`

Find a namespace.

Returns [`Namespace`](#namespace).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querynamespacefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the project, group, or namespace. For example, `gitlab-org/gitlab-foss`. |

### `Query.note`

Find a note.

WARNING:
**Introduced** in 15.9.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`Note`](#note).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querynoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note. |

### `Query.package`

Find a package. This field can only be resolved for one query in any single request. Returns `null` if a package has no `default` status.

Returns [`PackageDetailsType`](#packagedetailstype).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | Global ID of the package. |

### `Query.project`

Find a project.

Returns [`Project`](#project).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectfullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the project, group, or namespace. For example, `gitlab-org/gitlab-foss`. |

### `Query.projects`

Find projects visible to the current user.

Returns [`ProjectConnection`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectsids"></a>`ids` | [`[ID!]`](#id) | Filter projects by IDs. |
| <a id="queryprojectsmembership"></a>`membership` | [`Boolean`](#boolean) | Return only projects that the current user is a member of. |
| <a id="queryprojectssearch"></a>`search` | [`String`](#string) | Search query, which can be for the project name, a path, or a description. |
| <a id="queryprojectssearchnamespaces"></a>`searchNamespaces` | [`Boolean`](#boolean) | Include namespace in project search. |
| <a id="queryprojectssort"></a>`sort` | [`String`](#string) | Sort order of results. Format: `<field_name>_<sort_direction>`, for example: `id_desc` or `name_asc`. |
| <a id="queryprojectstopics"></a>`topics` | [`[String!]`](#string) | Filter projects by topics. |
| <a id="queryprojectswithissuesenabled"></a>`withIssuesEnabled` | [`Boolean`](#boolean) | Return only projects with issues enabled. |
| <a id="queryprojectswithmergerequestsenabled"></a>`withMergeRequestsEnabled` | [`Boolean`](#boolean) | Return only projects with merge requests enabled. |

### `Query.queryComplexity`

Information about the complexity of the GraphQL query.

Returns [`QueryComplexity`](#querycomplexity).

### `Query.runner`

Find a runner.

Returns [`CiRunner`](#cirunner).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnerid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | Runner ID. |

### `Query.runnerPlatforms`

Supported runner platforms.

WARNING:
**Deprecated** in 15.9.
No longer used, use gitlab-runner documentation to learn about supported platforms.

Returns [`RunnerPlatformConnection`](#runnerplatformconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

### `Query.runnerSetup`

Runner setup instructions.

WARNING:
**Deprecated** in 15.9.
No longer used, use gitlab-runner documentation to learn about runner registration commands.

Returns [`RunnerSetup`](#runnersetup).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnersetuparchitecture"></a>`architecture` | [`String!`](#string) | Architecture to generate the instructions for. |
| <a id="queryrunnersetupgroupid"></a>`groupId` **{warning-solid}** | [`GroupID`](#groupid) | **Deprecated** in 13.11. No longer used. |
| <a id="queryrunnersetupplatform"></a>`platform` | [`String!`](#string) | Platform to generate the instructions for. |
| <a id="queryrunnersetupprojectid"></a>`projectId` **{warning-solid}** | [`ProjectID`](#projectid) | **Deprecated** in 13.11. No longer used. |

### `Query.runners`

Find runners visible to the current user.

Returns [`CiRunnerConnection`](#cirunnerconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnersactive"></a>`active` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated** in 14.8. This was renamed. Use: `paused`. |
| <a id="queryrunnerspaused"></a>`paused` | [`Boolean`](#boolean) | Filter runners by `paused` (true) or `active` (false) status. |
| <a id="queryrunnerssearch"></a>`search` | [`String`](#string) | Filter by full token or partial text in description field. |
| <a id="queryrunnerssort"></a>`sort` | [`CiRunnerSort`](#cirunnersort) | Sort order of results. |
| <a id="queryrunnersstatus"></a>`status` | [`CiRunnerStatus`](#cirunnerstatus) | Filter runners by status. |
| <a id="queryrunnerstaglist"></a>`tagList` | [`[String!]`](#string) | Filter by tags associated with the runner (comma-separated or array). |
| <a id="queryrunnerstype"></a>`type` | [`CiRunnerType`](#cirunnertype) | Filter runners by type. |
| <a id="queryrunnersupgradestatus"></a>`upgradeStatus` | [`CiRunnerUpgradeStatus`](#cirunnerupgradestatus) | Filter by upgrade status. |

### `Query.snippets`

Find Snippets visible to the current user.

Returns [`SnippetConnection`](#snippetconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querysnippetsauthorid"></a>`authorId` | [`UserID`](#userid) | ID of an author. |
| <a id="querysnippetsexplore"></a>`explore` | [`Boolean`](#boolean) | Explore personal snippets. |
| <a id="querysnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | Array of global snippet IDs. For example, `gid://gitlab/ProjectSnippet/1`. |
| <a id="querysnippetsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | ID of a project. |
| <a id="querysnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | Type of snippet. |
| <a id="querysnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | Visibility of the snippet. |

### `Query.subscriptionFutureEntries`

Fields related to entries in future subscriptions.

Returns [`SubscriptionFutureEntryConnection`](#subscriptionfutureentryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

### `Query.syntheticNote`

Find a synthetic note.

WARNING:
**Introduced** in 15.9.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`Note`](#note).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querysyntheticnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to search synthetic note on. |
| <a id="querysyntheticnotesha"></a>`sha` | [`String!`](#string) | Global ID of the note. |

### `Query.timelogs`

Find timelogs visible to the current user.

Returns [`TimelogConnection`](#timelogconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querytimelogsenddate"></a>`endDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or before endDate. |
| <a id="querytimelogsendtime"></a>`endTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or before endTime. |
| <a id="querytimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | List timelogs for a group. |
| <a id="querytimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | List timelogs for a project. |
| <a id="querytimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | List timelogs in a particular order. |
| <a id="querytimelogsstartdate"></a>`startDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or after startDate. |
| <a id="querytimelogsstarttime"></a>`startTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or after startTime. |
| <a id="querytimelogsusername"></a>`username` | [`String`](#string) | List timelogs for a user. |

### `Query.todo`

Retrieve a single to-do item.

Returns [`Todo`](#todo).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querytodoid"></a>`id` | [`TodoID!`](#todoid) | ID of the to-do item. |

### `Query.topics`

Find project topics.

Returns [`TopicConnection`](#topicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querytopicssearch"></a>`search` | [`String`](#string) | Search query for topic name. |

### `Query.usageTrendsMeasurements`

Get statistics on the instance.

Returns [`UsageTrendsMeasurementConnection`](#usagetrendsmeasurementconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryusagetrendsmeasurementsidentifier"></a>`identifier` | [`MeasurementIdentifier!`](#measurementidentifier) | Type of measurement or statistics to retrieve. |
| <a id="queryusagetrendsmeasurementsrecordedafter"></a>`recordedAfter` | [`Time`](#time) | Measurement recorded after this date. |
| <a id="queryusagetrendsmeasurementsrecordedbefore"></a>`recordedBefore` | [`Time`](#time) | Measurement recorded before this date. |

### `Query.user`

Find a user.

Returns [`UserCore`](#usercore).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryuserid"></a>`id` | [`UserID`](#userid) | ID of the User. |
| <a id="queryuserusername"></a>`username` | [`String`](#string) | Username of the User. |

### `Query.users`

Find users.

Returns [`UserCoreConnection`](#usercoreconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryusersadmins"></a>`admins` | [`Boolean`](#boolean) | Return only admin users. |
| <a id="queryusersids"></a>`ids` | [`[ID!]`](#id) | List of user Global IDs. |
| <a id="queryuserssearch"></a>`search` | [`String`](#string) | Query to search users by name, username, or primary email. |
| <a id="queryuserssort"></a>`sort` | [`Sort`](#sort) | Sort users by this criteria. |
| <a id="queryusersusernames"></a>`usernames` | [`[String!]`](#string) | List of usernames. |

### `Query.vulnerabilities`

Vulnerabilities reported on projects on the current user's instance security dashboard.

Returns [`VulnerabilityConnection`](#vulnerabilityconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiesclusteragentid"></a>`clusterAgentId` | [`[ClustersAgentID!]`](#clustersagentid) | Filter vulnerabilities by `cluster_agent_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="queryvulnerabilitiesclusterid"></a>`clusterId` | [`[ClustersClusterID!]`](#clustersclusterid) | Filter vulnerabilities by `cluster_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="queryvulnerabilitieshasissues"></a>`hasIssues` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have linked issues. |
| <a id="queryvulnerabilitieshasresolution"></a>`hasResolution` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have been resolved on default branch. |
| <a id="queryvulnerabilitiesimage"></a>`image` | [`[String!]`](#string) | Filter vulnerabilities by location image. When this filter is present, the response only matches entries for a `reportType` that includes `container_scanning`, `cluster_image_scanning`. |
| <a id="queryvulnerabilitiesprojectid"></a>`projectId` | [`[ID!]`](#id) | Filter vulnerabilities by project. |
| <a id="queryvulnerabilitiesreporttype"></a>`reportType` | [`[VulnerabilityReportType!]`](#vulnerabilityreporttype) | Filter vulnerabilities by report type. |
| <a id="queryvulnerabilitiesscanner"></a>`scanner` | [`[String!]`](#string) | Filter vulnerabilities by VulnerabilityScanner.externalId. |
| <a id="queryvulnerabilitiesscannerid"></a>`scannerId` | [`[VulnerabilitiesScannerID!]`](#vulnerabilitiesscannerid) | Filter vulnerabilities by scanner ID. |
| <a id="queryvulnerabilitiesseverity"></a>`severity` | [`[VulnerabilitySeverity!]`](#vulnerabilityseverity) | Filter vulnerabilities by severity. |
| <a id="queryvulnerabilitiessort"></a>`sort` | [`VulnerabilitySort`](#vulnerabilitysort) | List vulnerabilities by sort order. |
| <a id="queryvulnerabilitiesstate"></a>`state` | [`[VulnerabilityState!]`](#vulnerabilitystate) | Filter vulnerabilities by state. |

### `Query.vulnerabilitiesCountByDay`

The historical number of vulnerabilities per day for the projects on the current user's instance security dashboard.

Returns [`VulnerabilitiesCountByDayConnection`](#vulnerabilitiescountbydayconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiescountbydayenddate"></a>`endDate` | [`ISO8601Date!`](#iso8601date) | Last day for which to fetch vulnerability history. |
| <a id="queryvulnerabilitiescountbydaystartdate"></a>`startDate` | [`ISO8601Date!`](#iso8601date) | First day for which to fetch vulnerability history. |

### `Query.vulnerability`

Find a vulnerability.

Returns [`Vulnerability`](#vulnerability).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilityid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | Global ID of the Vulnerability. |

### `Query.workItem`

Find a work item.

WARNING:
**Introduced** in 15.1.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`WorkItem`](#workitem).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkitemid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |

### `Query.workspace`

Find a workspace.

WARNING:
**Introduced** in 16.0.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`Workspace`](#workspace).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkspaceid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | Find a workspace by its ID. |

### `Query.workspaces`

Find workspaces owned by the current user by their IDs.

WARNING:
**Introduced** in 16.0.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`WorkspaceConnection`](#workspaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | Array of global workspace IDs. For example, `["gid://gitlab/RemoteDevelopment::Workspace/1"]`. |

## `Mutation` type

The `Mutation` type contains all the mutations you can execute.

All mutations receive their arguments in a single input object named `input`, and all mutations
support at least a return field `errors` containing a list of error messages.

All input objects may have a `clientMutationId: String` field, identifying the mutation.

For example:

```graphql
mutation($id: NoteableID!, $body: String!) {
  createNote(input: { noteableId: $id, body: $body }) {
    errors
  }
}
```

### `Mutation.achievementsAward`

WARNING:
**Introduced** in 15.10.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `AchievementsAwardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | Global ID of the achievement being awarded. |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsawarduserid"></a>`userId` | [`UserID!`](#userid) | Global ID of the user being awarded the achievement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsawarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationachievementsawarduserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | Achievement award. |

### `Mutation.achievementsCreate`

WARNING:
**Introduced** in 15.8.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `AchievementsCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the achievement. |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementscreatedescription"></a>`description` | [`String`](#string) | Description of or notes for the achievement. |
| <a id="mutationachievementscreatename"></a>`name` | [`String!`](#string) | Name for the achievement. |
| <a id="mutationachievementscreatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Namespace for the achievement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateachievement"></a>`achievement` | [`Achievement`](#achievement) | Achievement created. |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.achievementsDelete`

WARNING:
**Introduced** in 15.11.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `AchievementsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | Global ID of the achievement being deleted. |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievement"></a>`achievement` | [`Achievement`](#achievement) | Achievement. |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.achievementsRevoke`

WARNING:
**Introduced** in 15.10.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `AchievementsRevokeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsrevokeuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | Global ID of the user achievement being revoked. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsrevokeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationachievementsrevokeuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | Achievement award. |

### `Mutation.achievementsUpdate`

WARNING:
**Introduced** in 15.11.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `AchievementsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | Global ID of the achievement being updated. |
| <a id="mutationachievementsupdateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the achievement. |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsupdatedescription"></a>`description` | [`String`](#string) | Description of or notes for the achievement. |
| <a id="mutationachievementsupdatename"></a>`name` | [`String`](#string) | Name for the achievement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievement"></a>`achievement` | [`Achievement`](#achievement) | Achievement. |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.addProjectToSecurityDashboard`

Input type: `AddProjectToSecurityDashboardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaddprojecttosecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | ID of the project to be added to Instance Security Dashboard. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaddprojecttosecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationaddprojecttosecuritydashboardproject"></a>`project` | [`Project`](#project) | Project that was added to the Instance Security Dashboard. |

### `Mutation.adminSidekiqQueuesDeleteJobs`

Input type: `AdminSidekiqQueuesDeleteJobsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsize"></a>`artifactSize` | [`String`](#string) | Delete jobs matching artifact_size in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactusedcdn"></a>`artifactUsedCdn` | [`String`](#string) | Delete jobs matching artifact_used_cdn in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciescount"></a>`artifactsDependenciesCount` | [`String`](#string) | Delete jobs matching artifacts_dependencies_count in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciessize"></a>`artifactsDependenciesSize` | [`String`](#string) | Delete jobs matching artifacts_dependencies_size in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobscallerid"></a>`callerId` | [`String`](#string) | Delete jobs matching caller_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsclientid"></a>`clientId` | [`String`](#string) | Delete jobs matching client_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationadminsidekiqqueuesdeletejobsfeaturecategory"></a>`featureCategory` | [`String`](#string) | Delete jobs matching feature_category in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsjobid"></a>`jobId` | [`String`](#string) | Delete jobs matching job_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsmergeactionstatus"></a>`mergeActionStatus` | [`String`](#string) | Delete jobs matching merge_action_status in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobspipelineid"></a>`pipelineId` | [`String`](#string) | Delete jobs matching pipeline_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsproject"></a>`project` | [`String`](#string) | Delete jobs matching project in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsqueuename"></a>`queueName` | [`String!`](#string) | Name of the queue to delete jobs from. |
| <a id="mutationadminsidekiqqueuesdeletejobsrelatedclass"></a>`relatedClass` | [`String`](#string) | Delete jobs matching related_class in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsremoteip"></a>`remoteIp` | [`String`](#string) | Delete jobs matching remote_ip in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsrootcallerid"></a>`rootCallerId` | [`String`](#string) | Delete jobs matching root_caller_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsrootnamespace"></a>`rootNamespace` | [`String`](#string) | Delete jobs matching root_namespace in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobssubscriptionplan"></a>`subscriptionPlan` | [`String`](#string) | Delete jobs matching subscription_plan in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsuser"></a>`user` | [`String`](#string) | Delete jobs matching user in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsuserid"></a>`userId` | [`String`](#string) | Delete jobs matching user_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsworkerclass"></a>`workerClass` | [`String`](#string) | Delete jobs with the given worker class. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationadminsidekiqqueuesdeletejobserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationadminsidekiqqueuesdeletejobsresult"></a>`result` | [`DeleteJobsResponse`](#deletejobsresponse) | Information about the status of the deletion request. |

### `Mutation.aiAction`

WARNING:
**Introduced** in 15.11.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `AiActionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiactionexplaincode"></a>`explainCode` | [`AiExplainCodeInput`](#aiexplaincodeinput) | Input for explain_code AI action. |
| <a id="mutationaiactionexplainvulnerability"></a>`explainVulnerability` | [`AiExplainVulnerabilityInput`](#aiexplainvulnerabilityinput) | Input for explain_vulnerability AI action. |
| <a id="mutationaiactiongeneratecommitmessage"></a>`generateCommitMessage` | [`AiGenerateCommitMessageInput`](#aigeneratecommitmessageinput) | Input for generate_commit_message AI action. |
| <a id="mutationaiactiongeneratedescription"></a>`generateDescription` | [`AiGenerateDescriptionInput`](#aigeneratedescriptioninput) | Input for generate_description AI action. |
| <a id="mutationaiactiongeneratetestfile"></a>`generateTestFile` | [`GenerateTestFileInput`](#generatetestfileinput) | Input for generate_test_file AI action. |
| <a id="mutationaiactionmarkupformat"></a>`markupFormat` | [`MarkupFormat`](#markupformat) | Indicates the response format. |
| <a id="mutationaiactionsummarizecomments"></a>`summarizeComments` | [`AiSummarizeCommentsInput`](#aisummarizecommentsinput) | Input for summarize_comments AI action. |
| <a id="mutationaiactiontanukibot"></a>`tanukiBot` | [`AiTanukiBotInput`](#aitanukibotinput) | Input for tanuki_bot AI action. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiactionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationaiactionrequestid"></a>`requestId` | [`String`](#string) | ID of the request. |

### `Mutation.alertSetAssignees`

Input type: `AlertSetAssigneesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | Usernames to assign to the alert. Replaces existing assignees by default. |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalertsetassigneesiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationalertsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationalertsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalertsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationalertsetassigneesissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationalertsetassigneestodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.alertTodoCreate`

Input type: `AlertTodoCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalerttodocreateiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationalerttodocreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreatealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalerttodocreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationalerttodocreateissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationalerttodocreatetodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.approveDeployment`

Input type: `ApproveDeploymentInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovedeploymentcomment"></a>`comment` | [`String`](#string) | Comment to go with the approval. |
| <a id="mutationapprovedeploymentid"></a>`id` | [`DeploymentID!`](#deploymentid) | ID of the deployment. |
| <a id="mutationapprovedeploymentrepresentedas"></a>`representedAs` | [`String`](#string) | Name of the User/Group/Role to use for the approval, when the user belongs to multiple approval rules. |
| <a id="mutationapprovedeploymentstatus"></a>`status` | [`DeploymentsApprovalStatus!`](#deploymentsapprovalstatus) | Status of the approval (either `APPROVED` or `REJECTED`). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovedeploymentdeploymentapproval"></a>`deploymentApproval` | [`DeploymentApproval!`](#deploymentapproval) | DeploymentApproval after mutation. |
| <a id="mutationapprovedeploymenterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.artifactDestroy`

Input type: `ArtifactDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationartifactdestroyid"></a>`id` | [`CiJobArtifactID!`](#cijobartifactid) | ID of the artifact to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyartifact"></a>`artifact` | [`CiJobArtifact`](#cijobartifact) | Deleted artifact. |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationartifactdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsStreamingDestinationEventsAdd`

Input type: `AuditEventsStreamingDestinationEventsAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination id. |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to add for streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | Event type filters present. |

### `Mutation.auditEventsStreamingDestinationEventsRemove`

Input type: `AuditEventsStreamingDestinationEventsRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsremovedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination URL. |
| <a id="mutationauditeventsstreamingdestinationeventsremoveeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to remove from streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsStreamingHeadersCreate`

Input type: `AuditEventsStreamingHeadersCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheaderscreatedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination to associate header with. |
| <a id="mutationauditeventsstreamingheaderscreatekey"></a>`key` | [`String!`](#string) | Header key. |
| <a id="mutationauditeventsstreamingheaderscreatevalue"></a>`value` | [`String!`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheaderscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreamingheaderscreateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | Created header. |

### `Mutation.auditEventsStreamingHeadersDestroy`

Input type: `AuditEventsStreamingHeadersDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersdestroyheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | Header to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsStreamingHeadersUpdate`

Input type: `AuditEventsStreamingHeadersUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersupdateheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | Header to update. |
| <a id="mutationauditeventsstreamingheadersupdatekey"></a>`key` | [`String!`](#string) | Header key. |
| <a id="mutationauditeventsstreamingheadersupdatevalue"></a>`value` | [`String!`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreamingheadersupdateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | Updates header. |

### `Mutation.awardEmojiAdd`

Input type: `AwardEmojiAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | Global ID of the awardable resource. |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiaddname"></a>`name` | [`String!`](#string) | Emoji name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | Award emoji after mutation. |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.awardEmojiRemove`

Input type: `AwardEmojiRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | Global ID of the awardable resource. |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiremovename"></a>`name` | [`String!`](#string) | Emoji name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | Award emoji after mutation. |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.awardEmojiToggle`

Input type: `AwardEmojiToggleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | Global ID of the awardable resource. |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojitogglename"></a>`name` | [`String!`](#string) | Emoji name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | Award emoji after mutation. |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojitoggleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationawardemojitoggletoggledon"></a>`toggledOn` | [`Boolean!`](#boolean) | Indicates the status of the emoji. True if the toggle awarded the emoji, and false if the toggle removed the emoji. |

### `Mutation.boardEpicCreate`

Input type: `BoardEpicCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the board that the epic is in. |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardepiccreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to create is in. |
| <a id="mutationboardepiccreatelistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the epic board list in which epic will be created. |
| <a id="mutationboardepiccreatetitle"></a>`title` | [`String!`](#string) | Title of the epic. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardepiccreateepic"></a>`epic` | [`Epic`](#epic) | Epic after creation. |
| <a id="mutationboardepiccreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.boardListCreate`

Input type: `BoardListCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateassigneeid"></a>`assigneeId` | [`UserID`](#userid) | Global ID of an existing user. |
| <a id="mutationboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | Create the backlog list. |
| <a id="mutationboardlistcreateboardid"></a>`boardId` | [`BoardID!`](#boardid) | Global ID of the issue board to mutate. |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistcreateiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Global ID of an existing iteration. |
| <a id="mutationboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | Global ID of an existing label. |
| <a id="mutationboardlistcreatemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | Global ID of an existing milestone. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationboardlistcreatelist"></a>`list` | [`BoardList`](#boardlist) | Issue list in the issue board. |

### `Mutation.boardListUpdateLimitMetrics`

Input type: `BoardListUpdateLimitMetricsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistupdatelimitmetricslimitmetric"></a>`limitMetric` | [`ListLimitMetric`](#listlimitmetric) | New limit metric type for the list. |
| <a id="mutationboardlistupdatelimitmetricslistid"></a>`listId` | [`ListID!`](#listid) | Global ID of the list. |
| <a id="mutationboardlistupdatelimitmetricsmaxissuecount"></a>`maxIssueCount` | [`Int`](#int) | New maximum issue count limit. |
| <a id="mutationboardlistupdatelimitmetricsmaxissueweight"></a>`maxIssueWeight` | [`Int`](#int) | New maximum issue weight limit. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistupdatelimitmetricserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationboardlistupdatelimitmetricslist"></a>`list` | [`BoardList`](#boardlist) | Updated list. |

### `Mutation.buildForecast`

WARNING:
**Introduced** in 16.0.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `BuildForecastInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbuildforecastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbuildforecastcontextid"></a>`contextId` | [`GlobalID!`](#globalid) | Global ID of the context for the forecast to pick an appropriate model. |
| <a id="mutationbuildforecasthorizon"></a>`horizon` | [`Int!`](#int) | Number of data points to forecast. |
| <a id="mutationbuildforecasttype"></a>`type` | [`String!`](#string) | Type of the forecast. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbuildforecastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbuildforecasterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationbuildforecastforecast"></a>`forecast` | [`Forecast!`](#forecast) | Created forecast. |

### `Mutation.bulkDestroyJobArtifacts`

WARNING:
**Introduced** in 15.10.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `BulkDestroyJobArtifactsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkdestroyjobartifactsids"></a>`ids` | [`[CiJobArtifactID!]!`](#cijobartifactid) | Global IDs of the job artifacts to destroy. |
| <a id="mutationbulkdestroyjobartifactsprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Global Project ID of the job artifacts to destroy. Incompatible with projectPath. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkdestroyjobartifactsdestroyedcount"></a>`destroyedCount` | [`Int`](#int) | Number of job artifacts deleted. |
| <a id="mutationbulkdestroyjobartifactsdestroyedids"></a>`destroyedIds` | [`[CiJobArtifactID!]`](#cijobartifactid) | IDs of job artifacts that were deleted. |
| <a id="mutationbulkdestroyjobartifactserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.bulkEnableDevopsAdoptionNamespaces`

**BETA** This endpoint is subject to change without notice.

Input type: `BulkEnableDevopsAdoptionNamespacesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkenabledevopsadoptionnamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | Display namespace ID. |
| <a id="mutationbulkenabledevopsadoptionnamespacesnamespaceids"></a>`namespaceIds` | [`[NamespaceID!]!`](#namespaceid) | List of Namespace IDs. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkenabledevopsadoptionnamespacesenablednamespaces"></a>`enabledNamespaces` | [`[DevopsAdoptionEnabledNamespace!]`](#devopsadoptionenablednamespace) | Enabled namespaces after mutation. |
| <a id="mutationbulkenabledevopsadoptionnamespaceserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.bulkRunnerDelete`

WARNING:
**Introduced** in 15.3.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `BulkRunnerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkrunnerdeleteids"></a>`ids` | [`[CiRunnerID!]`](#cirunnerid) | IDs of the runners to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkrunnerdeletedeletedcount"></a>`deletedCount` | [`Int`](#int) | Number of records effectively deleted. Only present if operation was performed synchronously. |
| <a id="mutationbulkrunnerdeletedeletedids"></a>`deletedIds` | [`[CiRunnerID!]`](#cirunnerid) | IDs of records effectively deleted. Only present if operation was performed synchronously. |
| <a id="mutationbulkrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.catalogResourcesCreate`

WARNING:
**Introduced** in 15.11.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `CatalogResourcesCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcescreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to convert to a catalog resource. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcescreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.ciAiGenerateConfig`

WARNING:
**Introduced** in 16.0.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `CiAiGenerateConfigInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationciaigenerateconfigclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationciaigenerateconfigprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path for the project related to the open config editor. |
| <a id="mutationciaigenerateconfigusercontent"></a>`userContent` | [`String!`](#string) | Content of the user message to be sent to the language model. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationciaigenerateconfigclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationciaigenerateconfigerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationciaigenerateconfigusermessage"></a>`userMessage` | [`AiMessageType`](#aimessagetype) | User chat message. |

### `Mutation.ciCdSettingsUpdate`

WARNING:
**Deprecated** in 15.0.
This was renamed.
Use: `ProjectCiCdSettingsUpdate`.

Input type: `CiCdSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full Path of the project the settings belong to. |
| <a id="mutationcicdsettingsupdateinboundjobtokenscopeenabled"></a>`inboundJobTokenScopeEnabled` | [`Boolean`](#boolean) | Indicates CI/CD job tokens generated in other projects have restricted access to this project. |
| <a id="mutationcicdsettingsupdatejobtokenscopeenabled"></a>`jobTokenScopeEnabled` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** Outbound job token scope is being removed. This field can now only be set to false. Deprecated in 16.0. |
| <a id="mutationcicdsettingsupdatekeeplatestartifact"></a>`keepLatestArtifact` | [`Boolean`](#boolean) | Indicates if the latest artifact should be kept for the project. |
| <a id="mutationcicdsettingsupdatemergepipelinesenabled"></a>`mergePipelinesEnabled` | [`Boolean`](#boolean) | Indicates if merge pipelines are enabled for the project. |
| <a id="mutationcicdsettingsupdatemergetrainsenabled"></a>`mergeTrainsEnabled` | [`Boolean`](#boolean) | Indicates if merge trains are enabled for the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`ProjectCiCdSetting!`](#projectcicdsetting) | CI/CD settings after mutation. |
| <a id="mutationcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.ciJobTokenScopeAddProject`

Input type: `CiJobTokenScopeAddProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddprojectdirection"></a>`direction` **{warning-solid}** | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | **Deprecated:** Outbound job token scope is being removed. This field can now only be set to INBOUND. Deprecated in 16.0. |
| <a id="mutationcijobtokenscopeaddprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscopeaddprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | Project to be added to the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's access scope. |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.ciJobTokenScopeRemoveProject`

Input type: `CiJobTokenScopeRemoveProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemoveprojectdirection"></a>`direction` | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | Direction of access, which defaults to outbound. |
| <a id="mutationcijobtokenscoperemoveprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscoperemoveprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | Project to be removed from the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's scope of access. |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemoveprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.clusterAgentDelete`

Input type: `ClusterAgentDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragentdeleteid"></a>`id` | [`ClustersAgentID!`](#clustersagentid) | Global ID of the cluster agent that will be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.clusterAgentTokenCreate`

Input type: `ClusterAgentTokenCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokencreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | Global ID of the cluster agent that will be associated with the new token. |
| <a id="mutationclusteragenttokencreatedescription"></a>`description` | [`String`](#string) | Description of the token. |
| <a id="mutationclusteragenttokencreatename"></a>`name` | [`String!`](#string) | Name of the token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokencreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationclusteragenttokencreatesecret"></a>`secret` | [`String`](#string) | Token secret value. Make sure you save it - you won't be able to access it again. |
| <a id="mutationclusteragenttokencreatetoken"></a>`token` | [`ClusterAgentToken`](#clusteragenttoken) | Token created after mutation. |

### `Mutation.clusterAgentTokenRevoke`

Input type: `ClusterAgentTokenRevokeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokenrevokeid"></a>`id` | [`ClustersAgentTokenID!`](#clustersagenttokenid) | Global ID of the agent token that will be revoked. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokenrevokeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.commitCreate`

Input type: `CommitCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateactions"></a>`actions` | [`[CommitAction!]!`](#commitaction) | Array of action hashes to commit as a batch. |
| <a id="mutationcommitcreatebranch"></a>`branch` | [`String!`](#string) | Name of the branch to commit into, it can be a new branch. |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcommitcreatemessage"></a>`message` | [`String!`](#string) | Raw commit message. |
| <a id="mutationcommitcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the branch is associated with. |
| <a id="mutationcommitcreatestartbranch"></a>`startBranch` | [`String`](#string) | If on a new branch, name of the original branch. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcommitcreatecommit"></a>`commit` | [`Commit`](#commit) | Commit after mutation. |
| <a id="mutationcommitcreatecommitpipelinepath"></a>`commitPipelinePath` | [`String`](#string) | ETag path for the commit's pipeline. |
| <a id="mutationcommitcreatecontent"></a>`content` | [`[String!]`](#string) | Contents of the commit. |
| <a id="mutationcommitcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.configureContainerScanning`

Configure Container Scanning for a project by enabling Container Scanning in a new or modified
`.gitlab-ci.yml` file in a new branch. The new branch and a URL to
create a merge request are part of the response.

Input type: `ConfigureContainerScanningInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfigurecontainerscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfigurecontainerscanningerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfigurecontainerscanningsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureDependencyScanning`

Configure Dependency Scanning for a project by enabling Dependency Scanning in a new or modified
`.gitlab-ci.yml` file in a new branch. The new branch and a URL to
create a Merge Request are a part of the response.

Input type: `ConfigureDependencyScanningInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguredependencyscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguredependencyscanningerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfiguredependencyscanningsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureSast`

Configure SAST for a project by enabling SAST in a new or modified
`.gitlab-ci.yml` file in a new branch. The new branch and a URL to
create a Merge Request are a part of the response.

Input type: `ConfigureSastInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresastconfiguration"></a>`configuration` | [`SastCiConfigurationInput!`](#sastciconfigurationinput) | SAST CI configuration for the project. |
| <a id="mutationconfiguresastprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresasterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfiguresastsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureSastIac`

Enable SAST IaC for a project in a new or
modified `.gitlab-ci.yml` file in a new branch. The new
branch and a URL to create a merge request are a part of the
response.

Input type: `ConfigureSastIacInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresastiacprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresastiacerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfiguresastiacsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureSecretDetection`

Configure Secret Detection for a project by enabling Secret Detection
in a new or modified `.gitlab-ci.yml` file in a new branch. The new
branch and a URL to create a Merge Request are a part of the
response.

Input type: `ConfigureSecretDetectionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresecretdetectionprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresecretdetectionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfiguresecretdetectionsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.corpusCreate`

Input type: `CorpusCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcorpuscreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the corpus belongs to. |
| <a id="mutationcorpuscreatepackageid"></a>`packageId` | [`PackagesPackageID!`](#packagespackageid) | ID of the corpus package. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcorpuscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createAlertIssue`

Input type: `CreateAlertIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatealertissueiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationcreatealertissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissuealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatealertissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatealertissueissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationcreatealertissuetodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.createAnnotation`

WARNING:
**Deprecated** in 16.0.
Underlying feature was removed in 16.0.

Input type: `CreateAnnotationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateannotationclusterid"></a>`clusterId` | [`ClustersClusterID`](#clustersclusterid) | Global ID of the cluster to add an annotation to. |
| <a id="mutationcreateannotationdashboardpath"></a>`dashboardPath` | [`String!`](#string) | Path to a file defining the dashboard on which the annotation should be added. |
| <a id="mutationcreateannotationdescription"></a>`description` | [`String!`](#string) | Description of the annotation. |
| <a id="mutationcreateannotationendingat"></a>`endingAt` | [`Time`](#time) | Timestamp indicating ending moment to which the annotation relates. |
| <a id="mutationcreateannotationenvironmentid"></a>`environmentId` | [`EnvironmentID`](#environmentid) | Global ID of the environment to add an annotation to. |
| <a id="mutationcreateannotationstartingat"></a>`startingAt` | [`Time!`](#time) | Timestamp indicating starting moment to which the annotation relates. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationannotation"></a>`annotation` | [`MetricsDashboardAnnotation`](#metricsdashboardannotation) | Created annotation. |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateannotationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createBoard`

Input type: `CreateBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ID of user to be assigned to the board. |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateboardgrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationcreateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationcreateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationcreateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ID of iteration cadence to be assigned to the board. |
| <a id="mutationcreateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ID of iteration to be assigned to the board. |
| <a id="mutationcreateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationcreateboardlabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationcreateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ID of milestone to be assigned to the board. |
| <a id="mutationcreateboardname"></a>`name` | [`String`](#string) | Board name. |
| <a id="mutationcreateboardprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationcreateboardweight"></a>`weight` | [`Int`](#int) | Weight value to be assigned to the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardboard"></a>`board` | [`Board`](#board) | Board after mutation. |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createBranch`

Input type: `CreateBranchInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatebranchname"></a>`name` | [`String!`](#string) | Name of the branch. |
| <a id="mutationcreatebranchprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the branch is associated with. |
| <a id="mutationcreatebranchref"></a>`ref` | [`String!`](#string) | Branch name or commit SHA to create branch from. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchbranch"></a>`branch` | [`Branch`](#branch) | Branch after mutation. |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatebrancherrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createClusterAgent`

Input type: `CreateClusterAgentInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateclusteragentname"></a>`name` | [`String!`](#string) | Name of the cluster agent. |
| <a id="mutationcreateclusteragentprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the associated project for the cluster agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateclusteragentclusteragent"></a>`clusterAgent` | [`ClusterAgent`](#clusteragent) | Cluster agent created after mutation. |
| <a id="mutationcreateclusteragenterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createComplianceFramework`

Input type: `CreateComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecomplianceframeworknamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace to add the compliance framework to. |
| <a id="mutationcreatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | Parameters to update the compliance framework with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatecomplianceframeworkframework"></a>`framework` | [`ComplianceFramework`](#complianceframework) | Created compliance framework. |

### `Mutation.createCustomEmoji`

WARNING:
**Introduced** in 13.6.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `CreateCustomEmojiInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecustomemojigrouppath"></a>`groupPath` | [`ID!`](#id) | Namespace full path the emoji is associated with. |
| <a id="mutationcreatecustomemojiname"></a>`name` | [`String!`](#string) | Name of the emoji. |
| <a id="mutationcreatecustomemojiurl"></a>`url` | [`String!`](#string) | Location of the emoji file. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | New custom emoji. |
| <a id="mutationcreatecustomemojierrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createDiffNote`

Input type: `CreateDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnotebody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediffnoteconfidential"></a>`confidential` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** This was renamed. Please use `internal`. Deprecated in 15.3. |
| <a id="mutationcreatediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreatediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |
| <a id="mutationcreatediffnoteposition"></a>`position` | [`DiffPositionInput!`](#diffpositioninput) | Position of this note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.createEpic`

Input type: `CreateEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | IDs of labels to be added to the epic. |
| <a id="mutationcreateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | Array of labels to be added to the epic. |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateepiccolor"></a>`color` | [`Color`](#color) | Color of the epic. Available only when feature flag `epic_color_highlight` is enabled. This flag is disabled by default, because the feature is experimental and is subject to change without notice. |
| <a id="mutationcreateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates if the epic is confidential. |
| <a id="mutationcreateepicdescription"></a>`description` | [`String`](#string) | Description of the epic. |
| <a id="mutationcreateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | End date of the epic. |
| <a id="mutationcreateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | Indicates end date should be sourced from due_date_fixed field not the issue milestones. |
| <a id="mutationcreateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate is in. |
| <a id="mutationcreateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | IDs of labels to be removed from the epic. |
| <a id="mutationcreateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | Start date of the epic. |
| <a id="mutationcreateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | Indicates start date should be sourced from start_date_fixed field not the issue milestones. |
| <a id="mutationcreateepictitle"></a>`title` | [`String`](#string) | Title of the epic. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateepicepic"></a>`epic` | [`Epic`](#epic) | Created epic. |
| <a id="mutationcreateepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createImageDiffNote`

Input type: `CreateImageDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnotebody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateimagediffnoteconfidential"></a>`confidential` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** This was renamed. Please use `internal`. Deprecated in 15.3. |
| <a id="mutationcreateimagediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreateimagediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |
| <a id="mutationcreateimagediffnoteposition"></a>`position` | [`DiffImagePositionInput!`](#diffimagepositioninput) | Position of this note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreateimagediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.createIssue`

Input type: `CreateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueassigneeids"></a>`assigneeIds` | [`[UserID!]`](#userid) | Array of user IDs to assign to the issue. |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates the issue is confidential. |
| <a id="mutationcreateissuecreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the issue was created. Available only for admins and project owners. |
| <a id="mutationcreateissuedescription"></a>`description` | [`String`](#string) | Description of the issue. |
| <a id="mutationcreateissuediscussiontoresolve"></a>`discussionToResolve` | [`String`](#string) | ID of a discussion to resolve. Also pass `merge_request_to_resolve_discussions_of`. |
| <a id="mutationcreateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | Due date of the issue. |
| <a id="mutationcreateissueepicid"></a>`epicId` | [`EpicID`](#epicid) | ID of an epic to associate the issue with. |
| <a id="mutationcreateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Desired health status. |
| <a id="mutationcreateissueiid"></a>`iid` | [`Int`](#int) | IID (internal ID) of a project issue. Only admins and project owners can modify. |
| <a id="mutationcreateissueiterationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | Global iteration cadence ID. Required when `iterationWildcardId` is provided. |
| <a id="mutationcreateissueiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Global iteration ID. Mutually exlusive argument with `iterationWildcardId`. |
| <a id="mutationcreateissueiterationwildcardid"></a>`iterationWildcardId` | [`IssueCreationIterationWildcardId`](#issuecreationiterationwildcardid) | Iteration wildcard ID. Supported values are: `CURRENT`. Mutually exclusive argument with `iterationId`. iterationCadenceId also required when this argument is provided. |
| <a id="mutationcreateissuelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the issue. |
| <a id="mutationcreateissuelabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationcreateissuelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates discussion is locked on the issue. |
| <a id="mutationcreateissuemergerequesttoresolvediscussionsof"></a>`mergeRequestToResolveDiscussionsOf` | [`MergeRequestID`](#mergerequestid) | IID of a merge request for which to resolve discussions. |
| <a id="mutationcreateissuemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ID of the milestone to assign to the issue. On update milestone will be removed if set to null. |
| <a id="mutationcreateissuemoveafterid"></a>`moveAfterId` | [`IssueID`](#issueid) | Global ID of issue that should be placed after the current issue. |
| <a id="mutationcreateissuemovebeforeid"></a>`moveBeforeId` | [`IssueID`](#issueid) | Global ID of issue that should be placed before the current issue. |
| <a id="mutationcreateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the issue is associated with. |
| <a id="mutationcreateissuetitle"></a>`title` | [`String!`](#string) | Title of the issue. |
| <a id="mutationcreateissuetype"></a>`type` | [`IssueType`](#issuetype) | Type of the issue. |
| <a id="mutationcreateissueweight"></a>`weight` | [`Int`](#int) | Weight of the issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreateissueissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.createIteration`

WARNING:
**Deprecated** in 14.0.
Use iterationCreate.

Input type: `CreateIterationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateiterationdescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="mutationcreateiterationduedate"></a>`dueDate` | [`String`](#string) | End date of the iteration. |
| <a id="mutationcreateiterationgrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationcreateiterationiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | Global ID of the iteration cadence to be assigned to the new iteration. |
| <a id="mutationcreateiterationprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationcreateiterationstartdate"></a>`startDate` | [`String`](#string) | Start date of the iteration. |
| <a id="mutationcreateiterationtitle"></a>`title` | [`String`](#string) | Title of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateiterationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | Created iteration. |

### `Mutation.createNote`

Creates a Note.
If the body of the Note contains only quick actions,
the Note will be destroyed during an update, and no Note will be
returned.

Input type: `CreateNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatenotebody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatenoteconfidential"></a>`confidential` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** This was renamed. Please use `internal`. Deprecated in 15.3. |
| <a id="mutationcreatenotediscussionid"></a>`discussionId` | [`DiscussionID`](#discussionid) | Global ID of the discussion the note is in reply to. |
| <a id="mutationcreatenoteinternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreatenotemergerequestdiffheadsha"></a>`mergeRequestDiffHeadSha` | [`String`](#string) | SHA of the head commit which is used to ensure that the merge request has not been updated since the request was sent. |
| <a id="mutationcreatenotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatenoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatenotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.createRequirement`

Input type: `CreateRequirementInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreaterequirementdescription"></a>`description` | [`String`](#string) | Description of the requirement. |
| <a id="mutationcreaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path the requirement is associated with. |
| <a id="mutationcreaterequirementtitle"></a>`title` | [`String`](#string) | Title of the requirement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | Requirement after mutation. |

### `Mutation.createSnippet`

Input type: `CreateSnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | Actions to perform over the snippet repository and blobs. |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatesnippetdescription"></a>`description` | [`String`](#string) | Description of the snippet. |
| <a id="mutationcreatesnippetprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project the snippet is associated with. |
| <a id="mutationcreatesnippettitle"></a>`title` | [`String!`](#string) | Title of the snippet. |
| <a id="mutationcreatesnippetuploadedfiles"></a>`uploadedFiles` | [`[String!]`](#string) | Paths to files uploaded in the snippet description. |
| <a id="mutationcreatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum!`](#visibilitylevelsenum) | Visibility level of the snippet. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.createTestCase`

Input type: `CreateTestCaseInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatetestcasedescription"></a>`description` | [`String`](#string) | Test case description. |
| <a id="mutationcreatetestcaselabelids"></a>`labelIds` | [`[ID!]`](#id) | IDs of labels to be added to the test case. |
| <a id="mutationcreatetestcaseprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path to create the test case in. |
| <a id="mutationcreatetestcasetitle"></a>`title` | [`String!`](#string) | Test case title. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatetestcaseerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatetestcasetestcase"></a>`testCase` | [`Issue`](#issue) | Test case created. |

### `Mutation.customerRelationsContactCreate`

Input type: `CustomerRelationsContactCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactcreatedescription"></a>`description` | [`String`](#string) | Description of or notes for the contact. |
| <a id="mutationcustomerrelationscontactcreateemail"></a>`email` | [`String`](#string) | Email address of the contact. |
| <a id="mutationcustomerrelationscontactcreatefirstname"></a>`firstName` | [`String!`](#string) | First name of the contact. |
| <a id="mutationcustomerrelationscontactcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the contact. |
| <a id="mutationcustomerrelationscontactcreatelastname"></a>`lastName` | [`String!`](#string) | Last name of the contact. |
| <a id="mutationcustomerrelationscontactcreateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | Organization for the contact. |
| <a id="mutationcustomerrelationscontactcreatephone"></a>`phone` | [`String`](#string) | Phone number of the contact. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactcreatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | Contact after the mutation. |
| <a id="mutationcustomerrelationscontactcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.customerRelationsContactUpdate`

Input type: `CustomerRelationsContactUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateactive"></a>`active` | [`Boolean`](#boolean) | State of the contact. |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactupdatedescription"></a>`description` | [`String`](#string) | Description of or notes for the contact. |
| <a id="mutationcustomerrelationscontactupdateemail"></a>`email` | [`String`](#string) | Email address of the contact. |
| <a id="mutationcustomerrelationscontactupdatefirstname"></a>`firstName` | [`String`](#string) | First name of the contact. |
| <a id="mutationcustomerrelationscontactupdateid"></a>`id` | [`CustomerRelationsContactID!`](#customerrelationscontactid) | Global ID of the contact. |
| <a id="mutationcustomerrelationscontactupdatelastname"></a>`lastName` | [`String`](#string) | Last name of the contact. |
| <a id="mutationcustomerrelationscontactupdateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | Organization of the contact. |
| <a id="mutationcustomerrelationscontactupdatephone"></a>`phone` | [`String`](#string) | Phone number of the contact. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactupdatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | Contact after the mutation. |
| <a id="mutationcustomerrelationscontactupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.customerRelationsOrganizationCreate`

Input type: `CustomerRelationsOrganizationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationcreatedefaultrate"></a>`defaultRate` | [`Float`](#float) | Standard billing rate for the organization. |
| <a id="mutationcustomerrelationsorganizationcreatedescription"></a>`description` | [`String`](#string) | Description of or notes for the organization. |
| <a id="mutationcustomerrelationsorganizationcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the organization. |
| <a id="mutationcustomerrelationsorganizationcreatename"></a>`name` | [`String!`](#string) | Name of the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcustomerrelationsorganizationcreateorganization"></a>`organization` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | Organization after the mutation. |

### `Mutation.customerRelationsOrganizationUpdate`

Input type: `CustomerRelationsOrganizationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateactive"></a>`active` | [`Boolean`](#boolean) | State of the organization. |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationupdatedefaultrate"></a>`defaultRate` | [`Float`](#float) | Standard billing rate for the organization. |
| <a id="mutationcustomerrelationsorganizationupdatedescription"></a>`description` | [`String`](#string) | Description of or notes for the organization. |
| <a id="mutationcustomerrelationsorganizationupdateid"></a>`id` | [`CustomerRelationsOrganizationID!`](#customerrelationsorganizationid) | Global ID of the organization. |
| <a id="mutationcustomerrelationsorganizationupdatename"></a>`name` | [`String`](#string) | Name of the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcustomerrelationsorganizationupdateorganization"></a>`organization` | [`CustomerRelationsOrganization!`](#customerrelationsorganization) | Organization after the mutation. |

### `Mutation.dastOnDemandScanCreate`

Input type: `DastOnDemandScanCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastondemandscancreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | ID of the scanner profile to be used for the scan. |
| <a id="mutationdastondemandscancreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be used for the scan. |
| <a id="mutationdastondemandscancreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site profile belongs to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastondemandscancreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastondemandscancreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | URL of the pipeline that was created. |

### `Mutation.dastProfileCreate`

Input type: `DastProfileCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreatebranchname"></a>`branchName` | [`String`](#string) | Associated branch. |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilecreatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | Represents a DAST Profile Schedule. |
| <a id="mutationdastprofilecreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the scanner profile to be associated. |
| <a id="mutationdastprofilecreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be associated. |
| <a id="mutationdastprofilecreatedescription"></a>`description` | [`String`](#string) | Description of the profile. Defaults to an empty string. |
| <a id="mutationdastprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the profile belongs to. |
| <a id="mutationdastprofilecreatename"></a>`name` | [`String!`](#string) | Name of the profile. |
| <a id="mutationdastprofilecreaterunaftercreate"></a>`runAfterCreate` | [`Boolean`](#boolean) | Run scan using profile after creation. Defaults to false. |
| <a id="mutationdastprofilecreatetaglist"></a>`tagList` | [`[String!]`](#string) | Indicates the runner tags associated with the profile. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilecreatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | Created profile. |
| <a id="mutationdastprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastprofilecreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | URL of the pipeline that was created. Requires `runAfterCreate` to be set to `true`. |

### `Mutation.dastProfileDelete`

Input type: `DastProfileDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofiledeleteid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.dastProfileRun`

Input type: `DastProfileRunInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilerunfullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in 14.5. |
| <a id="mutationdastprofilerunid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile to be used for the scan. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilerunerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastprofilerunpipelineurl"></a>`pipelineUrl` | [`String`](#string) | URL of the pipeline that was created. |

### `Mutation.dastProfileUpdate`

Input type: `DastProfileUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdatebranchname"></a>`branchName` | [`String`](#string) | Associated branch. |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofileupdatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | Represents a DAST profile schedule. |
| <a id="mutationdastprofileupdatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | ID of the scanner profile to be associated. |
| <a id="mutationdastprofileupdatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID`](#dastsiteprofileid) | ID of the site profile to be associated. |
| <a id="mutationdastprofileupdatedescription"></a>`description` | [`String`](#string) | Description of the profile. Defaults to an empty string. |
| <a id="mutationdastprofileupdatefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in 14.5. |
| <a id="mutationdastprofileupdateid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile to be deleted. |
| <a id="mutationdastprofileupdatename"></a>`name` | [`String`](#string) | Name of the profile. |
| <a id="mutationdastprofileupdaterunafterupdate"></a>`runAfterUpdate` | [`Boolean`](#boolean) | Run scan using profile after update. Defaults to false. |
| <a id="mutationdastprofileupdatetaglist"></a>`tagList` | [`[String!]`](#string) | Indicates the runner tags associated with the profile. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofileupdatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | Updated profile. |
| <a id="mutationdastprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastprofileupdatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | The URL of the pipeline that was created. Requires the input argument `runAfterUpdate` to be set to `true` when calling the mutation, otherwise no pipeline will be created. |

### `Mutation.dastScannerProfileCreate`

Input type: `DastScannerProfileCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the scanner profile belongs to. |
| <a id="mutationdastscannerprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | Name of the scanner profile. |
| <a id="mutationdastscannerprofilecreatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | Indicates the type of DAST scan that will run. Either a Passive Scan or an Active Scan. |
| <a id="mutationdastscannerprofilecreateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | Indicates if debug messages should be included in DAST console output. True to include the debug messages. |
| <a id="mutationdastscannerprofilecreatespidertimeout"></a>`spiderTimeout` | [`Int`](#int) | Maximum number of minutes allowed for the spider to traverse the site. |
| <a id="mutationdastscannerprofilecreatetaglist"></a>`tagList` **{warning-solid}** | [`[String!]`](#string) | **Deprecated:** Moved to DastProfile. Deprecated in 15.8. |
| <a id="mutationdastscannerprofilecreatetargettimeout"></a>`targetTimeout` | [`Int`](#int) | Maximum number of seconds allowed for the site under test to respond to a request. |
| <a id="mutationdastscannerprofilecreateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | Indicates if the AJAX spider should be used to crawl the target site. True to run the AJAX spider in addition to the traditional spider, and false to run only the traditional spider. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofilecreatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | Created scanner profile. |
| <a id="mutationdastscannerprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastscannerprofilecreateid"></a>`id` **{warning-solid}** | [`DastScannerProfileID`](#dastscannerprofileid) | **Deprecated:** use `dastScannerProfile` field. Deprecated in 14.10. |

### `Mutation.dastScannerProfileDelete`

Input type: `DastScannerProfileDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofiledeletefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in 14.5. |
| <a id="mutationdastscannerprofiledeleteid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the scanner profile to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.dastScannerProfileUpdate`

Input type: `DastScannerProfileUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofileupdatefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in 14.5. |
| <a id="mutationdastscannerprofileupdateid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the scanner profile to be updated. |
| <a id="mutationdastscannerprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | Name of the scanner profile. |
| <a id="mutationdastscannerprofileupdatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | Indicates the type of DAST scan that will run. Either a Passive Scan or an Active Scan. |
| <a id="mutationdastscannerprofileupdateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | Indicates if debug messages should be included in DAST console output. True to include the debug messages. |
| <a id="mutationdastscannerprofileupdatespidertimeout"></a>`spiderTimeout` | [`Int!`](#int) | Maximum number of minutes allowed for the spider to traverse the site. |
| <a id="mutationdastscannerprofileupdatetaglist"></a>`tagList` **{warning-solid}** | [`[String!]`](#string) | **Deprecated:** Moved to DastProfile. Deprecated in 15.8. |
| <a id="mutationdastscannerprofileupdatetargettimeout"></a>`targetTimeout` | [`Int!`](#int) | Maximum number of seconds allowed for the site under test to respond to a request. |
| <a id="mutationdastscannerprofileupdateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | Indicates if the AJAX spider should be used to crawl the target site. True to run the AJAX spider in addition to the traditional spider, and false to run only the traditional spider. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofileupdatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | Updated scanner profile. |
| <a id="mutationdastscannerprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastscannerprofileupdateid"></a>`id` **{warning-solid}** | [`DastScannerProfileID`](#dastscannerprofileid) | **Deprecated:** use `dastScannerProfile` field. Deprecated in 14.10. |

### `Mutation.dastSiteProfileCreate`

Input type: `DastSiteProfileCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | Parameters for authentication. |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofilecreateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | URLs to skip during an authenticated scan. Defaults to `[]`. |
| <a id="mutationdastsiteprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site profile belongs to. |
| <a id="mutationdastsiteprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | Name of the site profile. |
| <a id="mutationdastsiteprofilecreaterequestheaders"></a>`requestHeaders` | [`String`](#string) | Comma-separated list of request header names and values to be added to every request made by DAST. |
| <a id="mutationdastsiteprofilecreatescanfilepath"></a>`scanFilePath` | [`String`](#string) | File Path or URL used as input for the scan method. |
| <a id="mutationdastsiteprofilecreatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | Scan method by the scanner. |
| <a id="mutationdastsiteprofilecreatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | Type of target to be scanned. |
| <a id="mutationdastsiteprofilecreatetargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be scanned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofilecreatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | Site Profile object. |
| <a id="mutationdastsiteprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastsiteprofilecreateid"></a>`id` **{warning-solid}** | [`DastSiteProfileID`](#dastsiteprofileid) | **Deprecated:** use `dastSiteProfile.id` field. Deprecated in 14.10. |

### `Mutation.dastSiteProfileDelete`

Input type: `DastSiteProfileDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofiledeletefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in 14.5. |
| <a id="mutationdastsiteprofiledeleteid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.dastSiteProfileUpdate`

Input type: `DastSiteProfileUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | Parameters for authentication. |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofileupdateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | URLs to skip during an authenticated scan. |
| <a id="mutationdastsiteprofileupdatefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in 14.5. |
| <a id="mutationdastsiteprofileupdateid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be updated. |
| <a id="mutationdastsiteprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | Name of the site profile. |
| <a id="mutationdastsiteprofileupdaterequestheaders"></a>`requestHeaders` | [`String`](#string) | Comma-separated list of request header names and values to be added to every request made by DAST. |
| <a id="mutationdastsiteprofileupdatescanfilepath"></a>`scanFilePath` | [`String`](#string) | File Path or URL used as input for the scan method. |
| <a id="mutationdastsiteprofileupdatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | Scan method by the scanner. |
| <a id="mutationdastsiteprofileupdatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | Type of target to be scanned. |
| <a id="mutationdastsiteprofileupdatetargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be scanned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofileupdatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | Site profile object. |
| <a id="mutationdastsiteprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastsiteprofileupdateid"></a>`id` **{warning-solid}** | [`DastSiteProfileID`](#dastsiteprofileid) | **Deprecated:** use `dastSiteProfile.id` field. Deprecated in 14.10. |

### `Mutation.dastSiteTokenCreate`

Input type: `DastSiteTokenCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitetokencreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site token belongs to. |
| <a id="mutationdastsitetokencreatetargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be validated. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitetokencreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastsitetokencreateid"></a>`id` | [`DastSiteTokenID`](#dastsitetokenid) | ID of the site token. |
| <a id="mutationdastsitetokencreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | Current validation status of the target. |
| <a id="mutationdastsitetokencreatetoken"></a>`token` | [`String`](#string) | Token string. |

### `Mutation.dastSiteValidationCreate`

Input type: `DastSiteValidationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationcreatedastsitetokenid"></a>`dastSiteTokenId` | [`DastSiteTokenID!`](#dastsitetokenid) | ID of the site token. |
| <a id="mutationdastsitevalidationcreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site profile belongs to. |
| <a id="mutationdastsitevalidationcreatestrategy"></a>`strategy` | [`DastSiteValidationStrategyEnum`](#dastsitevalidationstrategyenum) | Validation strategy to be used. |
| <a id="mutationdastsitevalidationcreatevalidationpath"></a>`validationPath` | [`String!`](#string) | Path to be requested during validation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastsitevalidationcreateid"></a>`id` | [`DastSiteValidationID`](#dastsitevalidationid) | ID of the site validation. |
| <a id="mutationdastsitevalidationcreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | Current validation status. |

### `Mutation.dastSiteValidationRevoke`

Input type: `DastSiteValidationRevokeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationrevokefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site validation belongs to. |
| <a id="mutationdastsitevalidationrevokenormalizedtargeturl"></a>`normalizedTargetUrl` | [`String!`](#string) | Normalized URL of the target to be revoked. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationrevokeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.deleteAnnotation`

WARNING:
**Deprecated** in 16.0.
Underlying feature was removed in 16.0.

Input type: `DeleteAnnotationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteannotationid"></a>`id` | [`MetricsDashboardAnnotationID!`](#metricsdashboardannotationid) | Global ID of the annotation to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteannotationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.designManagementDelete`

Input type: `DesignManagementDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementdeletefilenames"></a>`filenames` | [`[String!]!`](#string) | Filenames of the designs to delete. |
| <a id="mutationdesignmanagementdeleteiid"></a>`iid` | [`ID!`](#id) | IID of the issue to modify designs for. |
| <a id="mutationdesignmanagementdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Project where the issue is to upload designs for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdesignmanagementdeleteversion"></a>`version` | [`DesignVersion`](#designversion) | New version in which the designs are deleted. |

### `Mutation.designManagementMove`

Input type: `DesignManagementMoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementmoveid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | ID of the design to move. |
| <a id="mutationdesignmanagementmovenext"></a>`next` | [`DesignManagementDesignID`](#designmanagementdesignid) | ID of the immediately following design. |
| <a id="mutationdesignmanagementmoveprevious"></a>`previous` | [`DesignManagementDesignID`](#designmanagementdesignid) | ID of the immediately preceding design. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementmovedesigncollection"></a>`designCollection` | [`DesignCollection`](#designcollection) | Current state of the collection. |
| <a id="mutationdesignmanagementmoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.designManagementUpdate`

Input type: `DesignManagementUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementupdatedescription"></a>`description` | [`String`](#string) | Description of the design. |
| <a id="mutationdesignmanagementupdateid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | ID of the design to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementupdatedesign"></a>`design` | [`Design!`](#design) | Updated design. |
| <a id="mutationdesignmanagementupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.designManagementUpload`

Input type: `DesignManagementUploadInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementuploadfiles"></a>`files` | [`[Upload!]!`](#upload) | Files to upload. |
| <a id="mutationdesignmanagementuploadiid"></a>`iid` | [`ID!`](#id) | IID of the issue to modify designs for. |
| <a id="mutationdesignmanagementuploadprojectpath"></a>`projectPath` | [`ID!`](#id) | Project where the issue is to upload designs for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementuploaddesigns"></a>`designs` | [`[Design!]!`](#design) | Designs that were uploaded by the mutation. |
| <a id="mutationdesignmanagementuploaderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdesignmanagementuploadskippeddesigns"></a>`skippedDesigns` | [`[Design!]!`](#design) | Any designs that were skipped from the upload due to there being no change to their content since their last version. |

### `Mutation.destroyBoard`

Input type: `DestroyBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboardid"></a>`id` | [`BoardID!`](#boardid) | Global ID of the board to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardboard"></a>`board` | [`Board`](#board) | Board after mutation. |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyBoardList`

Input type: `DestroyBoardListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboardlistlistid"></a>`listId` | [`ListID!`](#listid) | Global ID of the list to destroy. Only label lists are accepted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboardlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdestroyboardlistlist"></a>`list` | [`BoardList`](#boardlist) | List after mutation. |

### `Mutation.destroyComplianceFramework`

Input type: `DestroyComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | Global ID of the compliance framework to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyContainerRepository`

Input type: `DestroyContainerRepositoryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | ID of the container repository. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositorycontainerrepository"></a>`containerRepository` | [`ContainerRepository!`](#containerrepository) | Container repository policy after scheduling the deletion. |
| <a id="mutationdestroycontainerrepositoryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyContainerRepositoryTags`

Input type: `DestroyContainerRepositoryTagsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositorytagsid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | ID of the container repository. |
| <a id="mutationdestroycontainerrepositorytagstagnames"></a>`tagNames` | [`[String!]!`](#string) | Container repository tag(s) to delete. Total number can't be greater than 20. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositorytagsdeletedtagnames"></a>`deletedTagNames` | [`[String!]!`](#string) | Deleted container repository tags. |
| <a id="mutationdestroycontainerrepositorytagserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyCustomEmoji`

WARNING:
**Introduced** in 13.6.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `DestroyCustomEmojiInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycustomemojiid"></a>`id` | [`CustomEmojiID!`](#customemojiid) | Global ID of the custom emoji to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | Deleted custom emoji. |
| <a id="mutationdestroycustomemojierrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyEpicBoard`

Input type: `DestroyEpicBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyepicboardid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the board to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyepicboardepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | Epic board after mutation. |
| <a id="mutationdestroyepicboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyNote`

Input type: `DestroyNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroynoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroynoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdestroynotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.destroyPackage`

Input type: `DestroyPackageInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | ID of the Package. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackageerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyPackageFile`

Input type: `DestroyPackageFileInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefileid"></a>`id` | [`PackagesPackageFileID!`](#packagespackagefileid) | ID of the Package file. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefileerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyPackageFiles`

Input type: `DestroyPackageFilesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefilesids"></a>`ids` | [`[PackagesPackageFileID!]!`](#packagespackagefileid) | IDs of the Package file. |
| <a id="mutationdestroypackagefilesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path where the packages cleanup policy is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefileserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyPackages`

Input type: `DestroyPackagesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagesids"></a>`ids` | [`[PackagesPackageID!]!`](#packagespackageid) | Global IDs of the Packages. Max 20. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackageserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroySnippet`

Input type: `DestroySnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroysnippetid"></a>`id` | [`SnippetID!`](#snippetid) | Global ID of the snippet to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroysnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdestroysnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.disableDevopsAdoptionNamespace`

**BETA** This endpoint is subject to change without notice.

Input type: `DisableDevopsAdoptionNamespaceInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdisabledevopsadoptionnamespaceid"></a>`id` | [`[AnalyticsDevopsAdoptionEnabledNamespaceID!]!`](#analyticsdevopsadoptionenablednamespaceid) | One or many IDs of the enabled namespaces to disable. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdisabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.discussionToggleResolve`

Toggles the resolved state of a discussion.

Input type: `DiscussionToggleResolveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdiscussiontoggleresolveid"></a>`id` | [`DiscussionID!`](#discussionid) | Global ID of the discussion. |
| <a id="mutationdiscussiontoggleresolveresolve"></a>`resolve` | [`Boolean!`](#boolean) | Will resolve the discussion when true, and unresolve the discussion when false. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdiscussiontoggleresolvediscussion"></a>`discussion` | [`Discussion`](#discussion) | Discussion after mutation. |
| <a id="mutationdiscussiontoggleresolveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.echoCreate`

A mutation that does not perform any changes.

This is expected to be used for testing of endpoints, to verify
that a user has mutation access.

Input type: `EchoCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]`](#string) | Errors to return to the user. |
| <a id="mutationechocreatemessages"></a>`messages` | [`[String!]`](#string) | Messages to return to the user. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationechocreateechoes"></a>`echoes` | [`[String!]`](#string) | Messages returned to the user. |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.enableDevopsAdoptionNamespace`

**BETA** This endpoint is subject to change without notice.

Input type: `EnableDevopsAdoptionNamespaceInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenabledevopsadoptionnamespacedisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | Display namespace ID. |
| <a id="mutationenabledevopsadoptionnamespacenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Namespace ID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenabledevopsadoptionnamespaceenablednamespace"></a>`enabledNamespace` | [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace) | Enabled namespace after mutation. |
| <a id="mutationenabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentCreate`

Create an environment.

Input type: `EnvironmentCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentcreateexternalurl"></a>`externalUrl` | [`String`](#string) | External URL of the environment. |
| <a id="mutationenvironmentcreatename"></a>`name` | [`String!`](#string) | Name of the environment. |
| <a id="mutationenvironmentcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |
| <a id="mutationenvironmentcreatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | Tier of the environment. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentcreateenvironment"></a>`environment` | [`Environment`](#environment) | Created environment. |
| <a id="mutationenvironmentcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentDelete`

Delete an environment.

Input type: `EnvironmentDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentdeleteid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to Delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentStop`

Stop an environment.

Input type: `EnvironmentStopInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentstopforce"></a>`force` | [`Boolean`](#boolean) | Force environment to stop without executing on_stop actions. |
| <a id="mutationenvironmentstopid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to stop. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentstopenvironment"></a>`environment` | [`Environment`](#environment) | Environment after attempt to stop. |
| <a id="mutationenvironmentstoperrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentUpdate`

Update an environment.

Input type: `EnvironmentUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentupdateexternalurl"></a>`externalUrl` | [`String`](#string) | External URL of the environment. |
| <a id="mutationenvironmentupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to update. |
| <a id="mutationenvironmentupdatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | Tier of the environment. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentupdateenvironment"></a>`environment` | [`Environment`](#environment) | Environment after attempt to update. |
| <a id="mutationenvironmentupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentsCanaryIngressUpdate`

**Deprecated** This endpoint is planned to be removed along with certificate-based clusters. [See this epic](https://gitlab.com/groups/gitlab-org/configure/-/epics/8) for more information.

Input type: `EnvironmentsCanaryIngressUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentscanaryingressupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to update. |
| <a id="mutationenvironmentscanaryingressupdateweight"></a>`weight` | [`Int!`](#int) | Weight of the Canary Ingress. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentscanaryingressupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicAddIssue`

Input type: `EpicAddIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicaddissuegrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate belongs to. |
| <a id="mutationepicaddissueiid"></a>`iid` | [`ID!`](#id) | IID of the epic to mutate. |
| <a id="mutationepicaddissueissueiid"></a>`issueIid` | [`String!`](#string) | IID of the issue to be added. |
| <a id="mutationepicaddissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the issue belongs to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicaddissueepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationepicaddissueepicissue"></a>`epicIssue` | [`EpicIssue`](#epicissue) | Epic-issue relationship. |
| <a id="mutationepicaddissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicBoardCreate`

Input type: `EpicBoardCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardcreatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | Whether or not display epic colors. Ignored unless `epic_color_highlight` flag is enabled. |
| <a id="mutationepicboardcreategrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationepicboardcreatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationepicboardcreatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationepicboardcreatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationepicboardcreatelabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationepicboardcreatename"></a>`name` | [`String`](#string) | Board name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardcreateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | Created epic board. |
| <a id="mutationepicboardcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicBoardListCreate`

Input type: `EpicBoardListCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | Create the backlog list. |
| <a id="mutationepicboardlistcreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the issue board to mutate. |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | Global ID of an existing label. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationepicboardlistcreatelist"></a>`list` | [`EpicList`](#epiclist) | Epic list in the epic board. |

### `Mutation.epicBoardListDestroy`

Destroys an epic board list.

Input type: `EpicBoardListDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistdestroylistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the epic board list to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationepicboardlistdestroylist"></a>`list` | [`EpicList`](#epiclist) | Epic board list. `null` if the board was destroyed successfully. |

### `Mutation.epicBoardUpdate`

Input type: `EpicBoardUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardupdatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | Whether or not display epic colors. Ignored unless `epic_color_highlight` flag is enabled. |
| <a id="mutationepicboardupdatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationepicboardupdatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationepicboardupdateid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Epic board global ID. |
| <a id="mutationepicboardupdatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationepicboardupdatelabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationepicboardupdatename"></a>`name` | [`String`](#string) | Board name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardupdateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | Updated epic board. |
| <a id="mutationepicboardupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicMoveList`

Input type: `EpicMoveListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the board that the epic is in. |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicmovelistepicid"></a>`epicId` | [`EpicID!`](#epicid) | ID of the epic to mutate. |
| <a id="mutationepicmovelistfromlistid"></a>`fromListId` | [`BoardsEpicListID`](#boardsepiclistid) | ID of the board list that the epic will be moved from. Required if moving between lists. |
| <a id="mutationepicmovelistmoveafterid"></a>`moveAfterId` | [`EpicID`](#epicid) | ID of epic that should be placed after the current epic. |
| <a id="mutationepicmovelistmovebeforeid"></a>`moveBeforeId` | [`EpicID`](#epicid) | ID of epic that should be placed before the current epic. |
| <a id="mutationepicmovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | Position of epics within the board list. Positions start at 0. Use -1 to move to the end of the list. |
| <a id="mutationepicmovelisttolistid"></a>`toListId` | [`BoardsEpicListID!`](#boardsepiclistid) | ID of the list the epic will be in after mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicmovelistepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationepicmovelisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicSetSubscription`

Input type: `EpicSetSubscriptionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicsetsubscriptiongrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate belongs to. |
| <a id="mutationepicsetsubscriptioniid"></a>`iid` | [`ID!`](#id) | IID of the epic to mutate. |
| <a id="mutationepicsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicsetsubscriptionepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationepicsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicTreeReorder`

Input type: `EpicTreeReorderInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderbaseepicid"></a>`baseEpicId` | [`EpicID!`](#epicid) | ID of the base epic of the tree. |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepictreereordermoved"></a>`moved` | [`EpicTreeNodeFieldsInputType!`](#epictreenodefieldsinputtype) | Parameters for updating the tree positions. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepictreereordererrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.escalationPolicyCreate`

Input type: `EscalationPolicyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicycreatedescription"></a>`description` | [`String`](#string) | Description of the escalation policy. |
| <a id="mutationescalationpolicycreatename"></a>`name` | [`String!`](#string) | Name of the escalation policy. |
| <a id="mutationescalationpolicycreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the escalation policy for. |
| <a id="mutationescalationpolicycreaterules"></a>`rules` | [`[EscalationRuleInput!]!`](#escalationruleinput) | Steps of the escalation policy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationescalationpolicycreateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy. |

### `Mutation.escalationPolicyDestroy`

Input type: `EscalationPolicyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicydestroyid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | Escalation policy internal ID to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationescalationpolicydestroyescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy. |

### `Mutation.escalationPolicyUpdate`

Input type: `EscalationPolicyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicyupdatedescription"></a>`description` | [`String`](#string) | Description of the escalation policy. |
| <a id="mutationescalationpolicyupdateid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | ID of the on-call schedule to create the on-call rotation in. |
| <a id="mutationescalationpolicyupdatename"></a>`name` | [`String`](#string) | Name of the escalation policy. |
| <a id="mutationescalationpolicyupdaterules"></a>`rules` | [`[EscalationRuleInput!]`](#escalationruleinput) | Steps of the escalation policy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationescalationpolicyupdateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy. |

### `Mutation.exportRequirements`

Input type: `ExportRequirementsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsauthorusername"></a>`authorUsername` | [`[String!]`](#string) | Filter requirements by author username. |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexportrequirementsprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path the requirements are associated with. |
| <a id="mutationexportrequirementssearch"></a>`search` | [`String`](#string) | Search query for requirement title. |
| <a id="mutationexportrequirementsselectedfields"></a>`selectedFields` | [`[String!]`](#string) | List of selected requirements fields to be exported. |
| <a id="mutationexportrequirementssort"></a>`sort` | [`Sort`](#sort) | List requirements by sort order. |
| <a id="mutationexportrequirementsstate"></a>`state` | [`RequirementState`](#requirementstate) | Filter requirements by state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexportrequirementserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.externalAuditEventDestinationCreate`

Input type: `ExternalAuditEventDestinationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | Destination URL. |
| <a id="mutationexternalauditeventdestinationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationexternalauditeventdestinationcreateverificationtoken"></a>`verificationToken` | [`String`](#string) | Verification token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationexternalauditeventdestinationcreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | Destination created. |

### `Mutation.externalAuditEventDestinationDestroy`

Input type: `ExternalAuditEventDestinationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | ID of external audit event destination to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.externalAuditEventDestinationUpdate`

Input type: `ExternalAuditEventDestinationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | Destination URL to change. |
| <a id="mutationexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | ID of external audit event destination to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationexternalauditeventdestinationupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | Updated destination. |

### `Mutation.geoRegistriesUpdate`

Mutates a Geo registry. Does not mutate the registry entry if `geo_registries_update_mutation` feature flag is disabled.

WARNING:
**Introduced** in 16.1.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `GeoRegistriesUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateaction"></a>`action` | [`GeoRegistryAction!`](#georegistryaction) | Action to be executed on a Geo registry. |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass!`](#georegistryclass) | Class of the Geo registry to be updated. |
| <a id="mutationgeoregistriesupdateregistryid"></a>`registryId` | [`GeoBaseRegistryID!`](#geobaseregistryid) | ID of the Geo registry entry to be updated. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgeoregistriesupdateregistry"></a>`registry` | [`Registrable`](#registrable) | Updated Geo registry entry. |

### `Mutation.gitlabSubscriptionActivate`

Input type: `GitlabSubscriptionActivateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateactivationcode"></a>`activationCode` | [`String!`](#string) | Activation code received after purchasing a GitLab subscription. |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgitlabsubscriptionactivateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgitlabsubscriptionactivatefuturesubscriptions"></a>`futureSubscriptions` | [`[SubscriptionFutureEntry!]`](#subscriptionfutureentry) | Array of future subscriptions. |
| <a id="mutationgitlabsubscriptionactivatelicense"></a>`license` | [`CurrentLicense`](#currentlicense) | Current license. |

### `Mutation.googleCloudLoggingConfigurationCreate`

Input type: `GoogleCloudLoggingConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientemail"></a>`clientEmail` | [`String!`](#string) | Client email. |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationcreategoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | Google project ID. |
| <a id="mutationgooglecloudloggingconfigurationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationgooglecloudloggingconfigurationcreatelogidname"></a>`logIdName` | [`String`](#string) | Log ID. (defaults to `audit_events`). |
| <a id="mutationgooglecloudloggingconfigurationcreateprivatekey"></a>`privateKey` | [`String!`](#string) | Private key. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgooglecloudloggingconfigurationcreategooglecloudloggingconfiguration"></a>`googleCloudLoggingConfiguration` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | configuration created. |

### `Mutation.groupMemberBulkUpdate`

Input type: `GroupMemberBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | Access level to update the members to. |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | Date and time the membership expires. |
| <a id="mutationgroupmemberbulkupdategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Global ID of the group. |
| <a id="mutationgroupmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of the members. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgroupmemberbulkupdategroupmembers"></a>`groupMembers` | [`[GroupMember!]`](#groupmember) | Group members after mutation. |

### `Mutation.groupUpdate`

Input type: `GroupUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the group that will be updated. |
| <a id="mutationgroupupdatesharedrunnerssetting"></a>`sharedRunnersSetting` | [`SharedRunnersSetting!`](#sharedrunnerssetting) | Shared runners availability for the namespace and its descendants. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgroupupdategroup"></a>`group` | [`Group`](#group) | Group after update. |

### `Mutation.httpIntegrationCreate`

Input type: `HttpIntegrationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationcreatename"></a>`name` | [`String!`](#string) | Name of the integration. |
| <a id="mutationhttpintegrationcreatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | Custom mapping of GitLab alert attributes to fields from the payload example. |
| <a id="mutationhttpintegrationcreatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |
| <a id="mutationhttpintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the integration in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationhttpintegrationcreateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTP integration. |

### `Mutation.httpIntegrationDestroy`

Input type: `HttpIntegrationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationdestroyid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ID of the integration to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationhttpintegrationdestroyintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTP integration. |

### `Mutation.httpIntegrationResetToken`

Input type: `HttpIntegrationResetTokenInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationresettokenid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ID of the integration to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationhttpintegrationresettokenintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTP integration. |

### `Mutation.httpIntegrationUpdate`

Input type: `HttpIntegrationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationupdateid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ID of the integration to mutate. |
| <a id="mutationhttpintegrationupdatename"></a>`name` | [`String`](#string) | Name of the integration. |
| <a id="mutationhttpintegrationupdatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | Custom mapping of GitLab alert attributes to fields from the payload example. |
| <a id="mutationhttpintegrationupdatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationhttpintegrationupdateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTP integration. |

### `Mutation.instanceExternalAuditEventDestinationCreate`

Input type: `InstanceExternalAuditEventDestinationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | Destination URL. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationcreateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | Destination created. |

### `Mutation.instanceExternalAuditEventDestinationDestroy`

Input type: `InstanceExternalAuditEventDestinationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | ID of the external instance audit event destination to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.instanceExternalAuditEventDestinationUpdate`

Input type: `InstanceExternalAuditEventDestinationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | Destination URL to change. |
| <a id="mutationinstanceexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | ID of the external instance audit event destination to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationupdateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | Updated destination. |

### `Mutation.issuableResourceLinkCreate`

Input type: `IssuableResourceLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkcreateid"></a>`id` | [`IssueID!`](#issueid) | Incident id to associate the resource link with. |
| <a id="mutationissuableresourcelinkcreatelink"></a>`link` | [`String!`](#string) | Link of the resource. |
| <a id="mutationissuableresourcelinkcreatelinktext"></a>`linkText` | [`String`](#string) | Link text of the resource. |
| <a id="mutationissuableresourcelinkcreatelinktype"></a>`linkType` | [`IssuableResourceLinkType`](#issuableresourcelinktype) | Link type of the resource. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuableresourcelinkcreateissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | Issuable resource link. |

### `Mutation.issuableResourceLinkDestroy`

Input type: `IssuableResourceLinkDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkdestroyid"></a>`id` | [`IncidentManagementIssuableResourceLinkID!`](#incidentmanagementissuableresourcelinkid) | Issuable resource link ID to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuableresourcelinkdestroyissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | Issuable resource link. |

### `Mutation.issueLinkAlerts`

Input type: `IssueLinkAlertsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsalertreferences"></a>`alertReferences` | [`[String!]!`](#string) | Alerts references to be linked to the incident. |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuelinkalertsiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuelinkalertsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuelinkalertserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuelinkalertsissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueMove`

Input type: `IssueMoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemoveiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuemoveprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuemovetargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | Project to move the issue to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuemoveissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueMoveList`

Input type: `IssueMoveListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistboardid"></a>`boardId` | [`BoardID!`](#boardid) | Global ID of the board that the issue is in. |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemovelistepicid"></a>`epicId` | [`EpicID`](#epicid) | ID of the parent epic. NULL when removing the association. |
| <a id="mutationissuemovelistfromlistid"></a>`fromListId` | [`ID`](#id) | ID of the board list that the issue will be moved from. |
| <a id="mutationissuemovelistiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuemovelistmoveafterid"></a>`moveAfterId` | [`ID`](#id) | ID of issue that should be placed after the current issue. |
| <a id="mutationissuemovelistmovebeforeid"></a>`moveBeforeId` | [`ID`](#id) | ID of issue that should be placed before the current issue. |
| <a id="mutationissuemovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | Position of issue within the board list. Positions start at 0. Use -1 to move to the end of the list. |
| <a id="mutationissuemovelistprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuemovelisttolistid"></a>`toListId` | [`ID`](#id) | ID of the board list that the issue will be moved to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemovelisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuemovelistissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetAssignees`

Input type: `IssueSetAssigneesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | Usernames to assign to the resource. Replaces existing assignees by default. |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetassigneesiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationissuesetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetassigneesissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetConfidential`

Input type: `IssueSetConfidentialInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetconfidentialconfidential"></a>`confidential` | [`Boolean!`](#boolean) | Whether or not to set the issue as a confidential. |
| <a id="mutationissuesetconfidentialiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetconfidentialprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetconfidentialerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetconfidentialissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetCrmContacts`

Input type: `IssueSetCrmContactsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetcrmcontactscontactids"></a>`contactIds` | [`[CustomerRelationsContactID!]!`](#customerrelationscontactid) | Customer relations contact IDs to set. Replaces existing contacts by default. |
| <a id="mutationissuesetcrmcontactsiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetcrmcontactsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Changes the operation mode. Defaults to REPLACE. |
| <a id="mutationissuesetcrmcontactsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetcrmcontactserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetcrmcontactsissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetDueDate`

Input type: `IssueSetDueDateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetduedateduedate"></a>`dueDate` | [`Time`](#time) | Desired due date for the issue. Due date is removed if null. |
| <a id="mutationissuesetduedateiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetduedateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetduedateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetduedateissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetEpic`

Input type: `IssueSetEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetepicepicid"></a>`epicId` | [`EpicID`](#epicid) | Global ID of the epic to be assigned to the issue, epic will be removed if absent or set to null. |
| <a id="mutationissuesetepiciid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetepicprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetepicissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetEscalationPolicy`

Input type: `IssueSetEscalationPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationpolicyescalationpolicyid"></a>`escalationPolicyId` | [`IncidentManagementEscalationPolicyID`](#incidentmanagementescalationpolicyid) | Global ID of the escalation policy to assign to the issue. Policy will be removed if absent or set to null. |
| <a id="mutationissuesetescalationpolicyiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetescalationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetescalationpolicyissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetEscalationStatus`

Input type: `IssueSetEscalationStatusInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationstatusiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetescalationstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetescalationstatusstatus"></a>`status` | [`IssueEscalationStatus!`](#issueescalationstatus) | Set the escalation status. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationstatuserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetescalationstatusissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetIteration`

Input type: `IssueSetIterationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetiterationiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetiterationiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Iteration to assign to the issue. |
| <a id="mutationissuesetiterationprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetiterationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetiterationissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetLocked`

Input type: `IssueSetLockedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetlockediid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | Whether or not to lock discussion on the issue. |
| <a id="mutationissuesetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetlockederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetlockedissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetSeverity`

Input type: `IssueSetSeverityInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetseverityiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetseverityprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetseverityseverity"></a>`severity` | [`IssuableSeverity!`](#issuableseverity) | Set the incident severity level. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetseverityerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetseverityissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetSubscription`

Input type: `IssueSetSubscriptionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetsubscriptioniid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetsubscriptionissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetWeight`

Input type: `IssueSetWeightInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetweightiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetweightprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetweightweight"></a>`weight` | [`Int`](#int) | The desired weight for the issue. If set to null, weight is removed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetweighterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetweightissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueUnlinkAlert`

Input type: `IssueUnlinkAlertInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertalertid"></a>`alertId` | [`AlertManagementAlertID!`](#alertmanagementalertid) | Global ID of the alert to unlink from the incident. |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissueunlinkalertiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissueunlinkalertprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissueunlinkalerterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissueunlinkalertissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issuesBulkUpdate`

Allows updating several properties for a set of issues. Does nothing if the `bulk_update_issues_mutation` feature flag is disabled.

WARNING:
**Introduced** in 15.9.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `IssuesBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesbulkupdateaddlabelids"></a>`addLabelIds` | [`[LabelID!]`](#labelid) | Global ID array of the labels that will be added to the issues. |
| <a id="mutationissuesbulkupdateassigneeids"></a>`assigneeIds` | [`[UserID!]`](#userid) | Global ID array of the users that will be assigned to the given issues. Existing assignees will be replaced with the ones on this list. |
| <a id="mutationissuesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesbulkupdateepicid"></a>`epicId` | [`EpicID`](#epicid) | Global ID of the epic that will be assigned to the issues. |
| <a id="mutationissuesbulkupdatehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Health status that will be assigned to the issues. |
| <a id="mutationissuesbulkupdateids"></a>`ids` | [`[IssueID!]!`](#issueid) | Global ID array of the issues that will be updated. IDs that the user can't update will be ignored. A max of 100 can be provided. |
| <a id="mutationissuesbulkupdateiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Global ID of the iteration that will be assigned to the issues. |
| <a id="mutationissuesbulkupdatemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | Global ID of the milestone that will be assigned to the issues. |
| <a id="mutationissuesbulkupdateparentid"></a>`parentId` | [`IssueParentID!`](#issueparentid) | Global ID of the parent to which the bulk update will be scoped. The parent can be a project **(FREE)** or a group **(PREMIUM)**. Example `IssueParentID` are `"gid://gitlab/Project/1"` and `"gid://gitlab/Group/1"`. |
| <a id="mutationissuesbulkupdateremovelabelids"></a>`removeLabelIds` | [`[LabelID!]`](#labelid) | Global ID array of the labels that will be removed from the issues. |
| <a id="mutationissuesbulkupdatestateevent"></a>`stateEvent` | [`IssueStateEvent`](#issuestateevent) | Close or reopen an issue. |
| <a id="mutationissuesbulkupdatesubscriptionevent"></a>`subscriptionEvent` | [`IssuableSubscriptionEvent`](#issuablesubscriptionevent) | Subscribe to or unsubscribe from issue notifications. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesbulkupdateupdatedissuecount"></a>`updatedIssueCount` | [`Int`](#int) | Number of issues that were successfully updated. |

### `Mutation.iterationCadenceCreate`

Input type: `IterationCadenceCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the iteration cadence is active. |
| <a id="mutationiterationcadencecreateautomatic"></a>`automatic` | [`Boolean!`](#boolean) | Whether the iteration cadence should automatically generate upcoming iterations. |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencecreatedescription"></a>`description` | [`String`](#string) | Description of the iteration cadence. Maximum length is 5000 characters. |
| <a id="mutationiterationcadencecreatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | Duration in weeks of the iterations within this cadence. |
| <a id="mutationiterationcadencecreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group where the iteration cadence is created. |
| <a id="mutationiterationcadencecreateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | Upcoming iterations to be created when iteration cadence is set to automatic. |
| <a id="mutationiterationcadencecreaterollover"></a>`rollOver` | [`Boolean`](#boolean) | Whether the iteration cadence should roll over issues to the next iteration or not. |
| <a id="mutationiterationcadencecreatestartdate"></a>`startDate` | [`Time`](#time) | Timestamp of the automation start date. |
| <a id="mutationiterationcadencecreatetitle"></a>`title` | [`String`](#string) | Title of the iteration cadence. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationcadencecreateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | Created iteration cadence. |

### `Mutation.iterationCadenceDestroy`

Input type: `IterationCadenceDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencedestroyid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | Global ID of the iteration cadence. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencedestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationcadencedestroygroup"></a>`group` | [`Group!`](#group) | Group the iteration cadence belongs to. |

### `Mutation.iterationCadenceUpdate`

Input type: `IterationCadenceUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the iteration cadence is active. |
| <a id="mutationiterationcadenceupdateautomatic"></a>`automatic` | [`Boolean`](#boolean) | Whether the iteration cadence should automatically generate upcoming iterations. |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadenceupdatedescription"></a>`description` | [`String`](#string) | Description of the iteration cadence. Maximum length is 5000 characters. |
| <a id="mutationiterationcadenceupdatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | Duration in weeks of the iterations within this cadence. |
| <a id="mutationiterationcadenceupdateid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | Global ID of the iteration cadence. |
| <a id="mutationiterationcadenceupdateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | Upcoming iterations to be created when iteration cadence is set to automatic. |
| <a id="mutationiterationcadenceupdaterollover"></a>`rollOver` | [`Boolean`](#boolean) | Whether the iteration cadence should roll over issues to the next iteration or not. |
| <a id="mutationiterationcadenceupdatestartdate"></a>`startDate` | [`Time`](#time) | Timestamp of the automation start date. |
| <a id="mutationiterationcadenceupdatetitle"></a>`title` | [`String`](#string) | Title of the iteration cadence. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadenceupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationcadenceupdateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | Updated iteration cadence. |

### `Mutation.iterationCreate`

Input type: `iterationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcreatedescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="mutationiterationcreateduedate"></a>`dueDate` | [`String`](#string) | End date of the iteration. |
| <a id="mutationiterationcreategrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationiterationcreateiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | Global ID of the iteration cadence to be assigned to the new iteration. |
| <a id="mutationiterationcreateprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationiterationcreatestartdate"></a>`startDate` | [`String`](#string) | Start date of the iteration. |
| <a id="mutationiterationcreatetitle"></a>`title` | [`String`](#string) | Title of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationcreateiteration"></a>`iteration` | [`Iteration`](#iteration) | Created iteration. |

### `Mutation.iterationDelete`

Input type: `IterationDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationdeleteid"></a>`id` | [`IterationID!`](#iterationid) | ID of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationdeletegroup"></a>`group` | [`Group!`](#group) | Group the iteration belongs to. |

### `Mutation.jiraImportStart`

Input type: `JiraImportStartInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportstartjiraprojectkey"></a>`jiraProjectKey` | [`String!`](#string) | Project key of the importer Jira project. |
| <a id="mutationjiraimportstartjiraprojectname"></a>`jiraProjectName` | [`String`](#string) | Project name of the importer Jira project. |
| <a id="mutationjiraimportstartprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to import the Jira project into. |
| <a id="mutationjiraimportstartusersmapping"></a>`usersMapping` | [`[JiraUsersMappingInputType!]`](#jirausersmappinginputtype) | Mapping of Jira to GitLab users. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportstarterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjiraimportstartjiraimport"></a>`jiraImport` | [`JiraImport`](#jiraimport) | Jira import data after mutation. |

### `Mutation.jiraImportUsers`

Input type: `JiraImportUsersInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportusersprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to import the Jira users into. |
| <a id="mutationjiraimportusersstartat"></a>`startAt` | [`Int`](#int) | Index of the record the import should started at, default 0 (50 records returned). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportuserserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjiraimportusersjirausers"></a>`jiraUsers` | [`[JiraUser!]`](#jirauser) | Users returned from Jira, matched by email and name if possible. |

### `Mutation.jobArtifactsDestroy`

Input type: `JobArtifactsDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobartifactsdestroyid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobartifactsdestroydestroyedartifactscount"></a>`destroyedArtifactsCount` | [`Int!`](#int) | Number of artifacts deleted. |
| <a id="mutationjobartifactsdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobartifactsdestroyjob"></a>`job` | [`CiJob`](#cijob) | Job with artifacts to be deleted. |

### `Mutation.jobCancel`

Input type: `JobCancelInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobcancelid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobcancelerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobcanceljob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.jobPlay`

Input type: `JobPlayInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobplayid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |
| <a id="mutationjobplayvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | Variables to use when playing a manual job. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobplayerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobplayjob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.jobRetry`

Input type: `JobRetryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobretryid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |
| <a id="mutationjobretryvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | Variables to use when retrying a manual job. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobretryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobretryjob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.jobUnschedule`

Input type: `JobUnscheduleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobunscheduleid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobunscheduleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobunschedulejob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.labelCreate`

Input type: `LabelCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlabelcreatecolor"></a>`color` | [`String`](#string) | The color of the label given in 6-digit hex notation with leading '#' sign (for example, `#FFAABB`) or one of the CSS color names. |
| <a id="mutationlabelcreatedescription"></a>`description` | [`String`](#string) | Description of the label. |
| <a id="mutationlabelcreategrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationlabelcreateprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationlabelcreatetitle"></a>`title` | [`String!`](#string) | Title of the label. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlabelcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationlabelcreatelabel"></a>`label` | [`Label`](#label) | Label after mutation. |

### `Mutation.markAsSpamSnippet`

Input type: `MarkAsSpamSnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmarkasspamsnippetid"></a>`id` | [`SnippetID!`](#snippetid) | Global ID of the snippet to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmarkasspamsnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmarkasspamsnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.mergeRequestAccept`

Accepts a merge request.
When accepted, the source branch will be merged into the target branch, either
immediately if possible, or using one of the automatic merge strategies.

Input type: `MergeRequestAcceptInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestacceptcommitmessage"></a>`commitMessage` | [`String`](#string) | Custom merge commit message. |
| <a id="mutationmergerequestacceptiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestacceptprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestacceptsha"></a>`sha` | [`String!`](#string) | HEAD SHA at the time when the merge was requested. |
| <a id="mutationmergerequestacceptshouldremovesourcebranch"></a>`shouldRemoveSourceBranch` | [`Boolean`](#boolean) | Should the source branch be removed. |
| <a id="mutationmergerequestacceptsquash"></a>`squash` | [`Boolean`](#boolean) | Squash commits on the source branch before merge. |
| <a id="mutationmergerequestacceptsquashcommitmessage"></a>`squashCommitMessage` | [`String`](#string) | Custom squash commit message (if squash is true). |
| <a id="mutationmergerequestacceptstrategy"></a>`strategy` | [`MergeStrategyEnum`](#mergestrategyenum) | How to merge the merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestaccepterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestacceptmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestCreate`

Input type: `MergeRequestCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestcreatedescription"></a>`description` | [`String`](#string) | Description of the merge request (Markdown rendered as HTML for caching). |
| <a id="mutationmergerequestcreatelabels"></a>`labels` | [`[String!]`](#string) | Labels of the merge request. |
| <a id="mutationmergerequestcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the merge request is associated with. |
| <a id="mutationmergerequestcreatesourcebranch"></a>`sourceBranch` | [`String!`](#string) | Source branch of the merge request. |
| <a id="mutationmergerequestcreatetargetbranch"></a>`targetBranch` | [`String!`](#string) | Target branch of the merge request. |
| <a id="mutationmergerequestcreatetitle"></a>`title` | [`String!`](#string) | Title of the merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestcreatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestReviewerRereview`

Input type: `MergeRequestReviewerRereviewInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestreviewerrereviewiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestreviewerrereviewprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestreviewerrereviewuserid"></a>`userId` | [`UserID!`](#userid) | User ID for the user that has been requested for a new review. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestreviewerrereviewerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestreviewerrereviewmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetAssignees`

Input type: `MergeRequestSetAssigneesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | Usernames to assign to the resource. Replaces existing assignees by default. |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetassigneesiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationmergerequestsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetassigneesmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetDraft`

Input type: `MergeRequestSetDraftInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetdraftdraft"></a>`draft` | [`Boolean!`](#boolean) | Whether or not to set the merge request as a draft. |
| <a id="mutationmergerequestsetdraftiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetdraftprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetdrafterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetdraftmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetLabels`

Input type: `MergeRequestSetLabelsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlabelsiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetlabelslabelids"></a>`labelIds` | [`[LabelID!]!`](#labelid) | Label IDs to set. Replaces existing labels by default. |
| <a id="mutationmergerequestsetlabelsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Changes the operation mode. Defaults to REPLACE. |
| <a id="mutationmergerequestsetlabelsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlabelserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetlabelsmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetLocked`

Input type: `MergeRequestSetLockedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlockediid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | Whether or not to lock the merge request. |
| <a id="mutationmergerequestsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlockederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetlockedmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetMilestone`

Input type: `MergeRequestSetMilestoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetmilestoneiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetmilestonemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | Milestone to assign to the merge request. |
| <a id="mutationmergerequestsetmilestoneprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetmilestoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetmilestonemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetReviewers`

Input type: `MergeRequestSetReviewersInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetreviewersiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetreviewersoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationmergerequestsetreviewersprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestsetreviewersreviewerusernames"></a>`reviewerUsernames` | [`[String!]!`](#string) | Usernames of reviewers to assign. Replaces existing reviewers by default. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetreviewerserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetreviewersmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetSubscription`

Input type: `MergeRequestSetSubscriptionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetsubscriptioniid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetsubscriptionmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestUpdate`

Update attributes of a merge request.

Input type: `MergeRequestUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdatedescription"></a>`description` | [`String`](#string) | Description of the merge request (Markdown rendered as HTML for caching). |
| <a id="mutationmergerequestupdateiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestupdatestate"></a>`state` | [`MergeRequestNewState`](#mergerequestnewstate) | Action to perform to change the state. |
| <a id="mutationmergerequestupdatetargetbranch"></a>`targetBranch` | [`String`](#string) | Target branch of the merge request. |
| <a id="mutationmergerequestupdatetimeestimate"></a>`timeEstimate` | [`String`](#string) | Estimated time to complete the merge request, or `0` to remove the current estimate. |
| <a id="mutationmergerequestupdatetitle"></a>`title` | [`String`](#string) | Title of the merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestupdatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestUpdateApprovalRule`

Input type: `MergeRequestUpdateApprovalRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleapprovalruleid"></a>`approvalRuleId` | [`Int!`](#int) | ID of an approval rule. |
| <a id="mutationmergerequestupdateapprovalruleapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | Number of required approvals for a given rule. |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdateapprovalrulegroupids"></a>`groupIds` | [`[String!]`](#string) | IDs of groups as approvers. |
| <a id="mutationmergerequestupdateapprovalruleiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestupdateapprovalrulename"></a>`name` | [`String!`](#string) | Name of the approval rule. |
| <a id="mutationmergerequestupdateapprovalruleprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestupdateapprovalruleremovehiddengroups"></a>`removeHiddenGroups` | [`[Boolean!]`](#boolean) | Whether hidden groups should be removed. |
| <a id="mutationmergerequestupdateapprovalruleuserids"></a>`userIds` | [`[String!]`](#string) | IDs of users as approvers. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdateapprovalruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestupdateapprovalrulemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.namespaceBanDestroy`

Input type: `NamespaceBanDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacebandestroyid"></a>`id` | [`NamespacesNamespaceBanID!`](#namespacesnamespacebanid) | Global ID of the namespace ban to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacebandestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationnamespacebandestroynamespaceban"></a>`namespaceBan` | [`NamespaceBan`](#namespaceban) | Namespace Ban. |

### `Mutation.namespaceCiCdSettingsUpdate`

Input type: `NamespaceCiCdSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdateallowstalerunnerpruning"></a>`allowStaleRunnerPruning` | [`Boolean`](#boolean) | Indicates if stale runners directly belonging to this namespace should be periodically pruned. |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the namespace the settings belong to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`NamespaceCiCdSetting!`](#namespacecicdsetting) | CI/CD settings after mutation. |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.namespaceIncreaseStorageTemporarily`

Input type: `NamespaceIncreaseStorageTemporarilyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespaceincreasestoragetemporarilyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespaceincreasestoragetemporarilyid"></a>`id` | [`NamespaceID!`](#namespaceid) | Global ID of the namespace to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespaceincreasestoragetemporarilyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespaceincreasestoragetemporarilyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationnamespaceincreasestoragetemporarilynamespace"></a>`namespace` | [`Namespace`](#namespace) | Namespace after mutation. |

### `Mutation.oncallRotationCreate`

Input type: `OncallRotationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | Active period of time that the on-call rotation should take place. |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationcreateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | End date and time of the on-call rotation, in the timezone of the on-call schedule. |
| <a id="mutationoncallrotationcreatename"></a>`name` | [`String!`](#string) | Name of the on-call rotation. |
| <a id="mutationoncallrotationcreateparticipants"></a>`participants` | [`[OncallUserInputType!]!`](#oncalluserinputtype) | Usernames of users participating in the on-call rotation. A maximum limit of 100 participants applies. |
| <a id="mutationoncallrotationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the on-call schedule in. |
| <a id="mutationoncallrotationcreaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType!`](#oncallrotationlengthinputtype) | Rotation length of the on-call rotation. |
| <a id="mutationoncallrotationcreatescheduleiid"></a>`scheduleIid` | [`String!`](#string) | IID of the on-call schedule to create the on-call rotation in. |
| <a id="mutationoncallrotationcreatestartsat"></a>`startsAt` | [`OncallRotationDateInputType!`](#oncallrotationdateinputtype) | Start date and time of the on-call rotation, in the timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallrotationcreateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | On-call rotation. |

### `Mutation.oncallRotationDestroy`

Input type: `OncallRotationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationdestroyid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | ID of the on-call rotation to remove. |
| <a id="mutationoncallrotationdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to remove the on-call schedule from. |
| <a id="mutationoncallrotationdestroyscheduleiid"></a>`scheduleIid` | [`String!`](#string) | IID of the on-call schedule to the on-call rotation belongs to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallrotationdestroyoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | On-call rotation. |

### `Mutation.oncallRotationUpdate`

Input type: `OncallRotationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | Active period of time that the on-call rotation should take place. |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationupdateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | End date and time of the on-call rotation, in the timezone of the on-call schedule. |
| <a id="mutationoncallrotationupdateid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | ID of the on-call schedule to create the on-call rotation in. |
| <a id="mutationoncallrotationupdatename"></a>`name` | [`String`](#string) | Name of the on-call rotation. |
| <a id="mutationoncallrotationupdateparticipants"></a>`participants` | [`[OncallUserInputType!]`](#oncalluserinputtype) | Usernames of users participating in the on-call rotation. A maximum limit of 100 participants applies. |
| <a id="mutationoncallrotationupdaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType`](#oncallrotationlengthinputtype) | Rotation length of the on-call rotation. |
| <a id="mutationoncallrotationupdatestartsat"></a>`startsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | Start date and time of the on-call rotation, in the timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallrotationupdateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | On-call rotation. |

### `Mutation.oncallScheduleCreate`

Input type: `OncallScheduleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallschedulecreatedescription"></a>`description` | [`String`](#string) | Description of the on-call schedule. |
| <a id="mutationoncallschedulecreatename"></a>`name` | [`String!`](#string) | Name of the on-call schedule. |
| <a id="mutationoncallschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the on-call schedule in. |
| <a id="mutationoncallschedulecreatetimezone"></a>`timezone` | [`String!`](#string) | Timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallschedulecreateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule. |

### `Mutation.oncallScheduleDestroy`

Input type: `OncallScheduleDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduledestroyiid"></a>`iid` | [`String!`](#string) | On-call schedule internal ID to remove. |
| <a id="mutationoncallscheduledestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to remove the on-call schedule from. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduledestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallscheduledestroyoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule. |

### `Mutation.oncallScheduleUpdate`

Input type: `OncallScheduleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduleupdatedescription"></a>`description` | [`String`](#string) | Description of the on-call schedule. |
| <a id="mutationoncallscheduleupdateiid"></a>`iid` | [`String!`](#string) | On-call schedule internal ID to update. |
| <a id="mutationoncallscheduleupdatename"></a>`name` | [`String`](#string) | Name of the on-call schedule. |
| <a id="mutationoncallscheduleupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to update the on-call schedule in. |
| <a id="mutationoncallscheduleupdatetimezone"></a>`timezone` | [`String`](#string) | Timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallscheduleupdateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule. |

### `Mutation.pagesMarkOnboardingComplete`

Input type: `PagesMarkOnboardingCompleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpagesmarkonboardingcompleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpagesmarkonboardingcompleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpagesmarkonboardingcompleteonboardingcomplete"></a>`onboardingComplete` | [`Boolean!`](#boolean) | Indicates the new onboarding_complete state of the project's Pages metadata. |

### `Mutation.pipelineCancel`

Input type: `PipelineCancelInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinecancelid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ID of the pipeline to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinecancelerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.pipelineDestroy`

Input type: `PipelineDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinedestroyid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ID of the pipeline to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinedestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.pipelineRetry`

Input type: `PipelineRetryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineretryid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ID of the pipeline to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineretryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelineretrypipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | Pipeline after mutation. |

### `Mutation.pipelineScheduleCreate`

Input type: `PipelineScheduleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateactive"></a>`active` | [`Boolean`](#boolean) | Indicates if the pipeline schedule should be active or not. |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineschedulecreatecron"></a>`cron` | [`String!`](#string) | Cron expression of the pipeline schedule. |
| <a id="mutationpipelineschedulecreatecrontimezone"></a>`cronTimezone` | [`String`](#string) | Cron time zone supported by ActiveSupport::TimeZone. For example: "Pacific Time (US & Canada)" (default: "UTC"). |
| <a id="mutationpipelineschedulecreatedescription"></a>`description` | [`String!`](#string) | Description of the pipeline schedule. |
| <a id="mutationpipelineschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the pipeline schedule is associated with. |
| <a id="mutationpipelineschedulecreateref"></a>`ref` | [`String!`](#string) | Ref of the pipeline schedule. |
| <a id="mutationpipelineschedulecreatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | Variables for the pipeline schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelineschedulecreatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Created pipeline schedule. |

### `Mutation.pipelineScheduleDelete`

Input type: `PipelineScheduleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduledeleteid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.pipelineSchedulePlay`

Input type: `PipelineSchedulePlayInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleplayid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleplayerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelinescheduleplaypipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Pipeline schedule after mutation. |

### `Mutation.pipelineScheduleTakeOwnership`

Input type: `PipelineScheduleTakeOwnershipInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduletakeownershipid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduletakeownershiperrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelinescheduletakeownershippipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Updated pipeline schedule ownership. |

### `Mutation.pipelineScheduleUpdate`

Input type: `PipelineScheduleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateactive"></a>`active` | [`Boolean`](#boolean) | Indicates if the pipeline schedule should be active or not. |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleupdatecron"></a>`cron` | [`String`](#string) | Cron expression of the pipeline schedule. |
| <a id="mutationpipelinescheduleupdatecrontimezone"></a>`cronTimezone` | [`String`](#string) | Cron time zone supported by ActiveSupport::TimeZone. For example: "Pacific Time (US & Canada)" (default: "UTC"). |
| <a id="mutationpipelinescheduleupdatedescription"></a>`description` | [`String`](#string) | Description of the pipeline schedule. |
| <a id="mutationpipelinescheduleupdateid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |
| <a id="mutationpipelinescheduleupdateref"></a>`ref` | [`String`](#string) | Ref of the pipeline schedule. |
| <a id="mutationpipelinescheduleupdatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | Variables for the pipeline schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelinescheduleupdatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Updated pipeline schedule. |

### `Mutation.projectCiCdSettingsUpdate`

Input type: `ProjectCiCdSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectcicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full Path of the project the settings belong to. |
| <a id="mutationprojectcicdsettingsupdateinboundjobtokenscopeenabled"></a>`inboundJobTokenScopeEnabled` | [`Boolean`](#boolean) | Indicates CI/CD job tokens generated in other projects have restricted access to this project. |
| <a id="mutationprojectcicdsettingsupdatejobtokenscopeenabled"></a>`jobTokenScopeEnabled` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** Outbound job token scope is being removed. This field can now only be set to false. Deprecated in 16.0. |
| <a id="mutationprojectcicdsettingsupdatekeeplatestartifact"></a>`keepLatestArtifact` | [`Boolean`](#boolean) | Indicates if the latest artifact should be kept for the project. |
| <a id="mutationprojectcicdsettingsupdatemergepipelinesenabled"></a>`mergePipelinesEnabled` | [`Boolean`](#boolean) | Indicates if merge pipelines are enabled for the project. |
| <a id="mutationprojectcicdsettingsupdatemergetrainsenabled"></a>`mergeTrainsEnabled` | [`Boolean`](#boolean) | Indicates if merge trains are enabled for the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`ProjectCiCdSetting!`](#projectcicdsetting) | CI/CD settings after mutation. |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectcicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.projectInitializeProductAnalytics`

Input type: `ProjectInitializeProductAnalyticsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectinitializeproductanalyticsprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to initialize. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectinitializeproductanalyticserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectinitializeproductanalyticsproject"></a>`project` | [`Project`](#project) | Project on which the initialization took place. |

### `Mutation.projectMemberBulkUpdate`

Updates multiple members of a project. To use this mutation, you must have at least the Maintainer role.

Input type: `ProjectMemberBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | Access level to update the members to. |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | Date and time the membership expires. |
| <a id="mutationprojectmemberbulkupdateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Global ID of the project. |
| <a id="mutationprojectmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of the members. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectmemberbulkupdateprojectmembers"></a>`projectMembers` | [`[ProjectMember!]`](#projectmember) | Project members after mutation. |

### `Mutation.projectSetComplianceFramework`

Assign (or unset) a compliance framework to a project.

Input type: `ProjectSetComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcomplianceframeworkcomplianceframeworkid"></a>`complianceFrameworkId` | [`ComplianceManagementFrameworkID`](#compliancemanagementframeworkid) | ID of the compliance framework to assign to the project. Set to `null` to unset. |
| <a id="mutationprojectsetcomplianceframeworkprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ID of the project to change the compliance framework of. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsetcomplianceframeworkproject"></a>`project` | [`Project`](#project) | Project after mutation. |

### `Mutation.projectSetLocked`

Input type: `ProjectSetLockedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetlockedfilepath"></a>`filePath` | [`String!`](#string) | Full path to the file. |
| <a id="mutationprojectsetlockedlock"></a>`lock` | [`Boolean!`](#boolean) | Whether or not to lock the file path. |
| <a id="mutationprojectsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetlockederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsetlockedproject"></a>`project` | [`Project`](#project) | Project after mutation. |

### `Mutation.projectSyncFork`

WARNING:
**Introduced** in 15.9.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `ProjectSyncForkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsyncforkprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to initialize. |
| <a id="mutationprojectsyncforktargetbranch"></a>`targetBranch` | [`String!`](#string) | Ref of the fork to fetch into. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsyncforkdetails"></a>`details` | [`ForkDetails`](#forkdetails) | Updated fork details. |
| <a id="mutationprojectsyncforkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.prometheusIntegrationCreate`

Input type: `PrometheusIntegrationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationprometheusintegrationcreateapiurl"></a>`apiUrl` | [`String!`](#string) | Endpoint at which Prometheus can be queried. |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the integration in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprometheusintegrationcreateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | Newly created integration. |

### `Mutation.prometheusIntegrationResetToken`

Input type: `PrometheusIntegrationResetTokenInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationresettokenid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | ID of the integration to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprometheusintegrationresettokenintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | Newly created integration. |

### `Mutation.prometheusIntegrationUpdate`

Input type: `PrometheusIntegrationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationprometheusintegrationupdateapiurl"></a>`apiUrl` | [`String`](#string) | Endpoint at which Prometheus can be queried. |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationupdateid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | ID of the integration to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprometheusintegrationupdateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | Newly created integration. |

### `Mutation.promoteToEpic`

Input type: `PromoteToEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpromotetoepicgrouppath"></a>`groupPath` | [`ID`](#id) | Group the promoted epic will belong to. |
| <a id="mutationpromotetoepiciid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationpromotetoepicprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpromotetoepicepic"></a>`epic` | [`Epic`](#epic) | Epic after issue promotion. |
| <a id="mutationpromotetoepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpromotetoepicissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.releaseAssetLinkCreate`

Input type: `ReleaseAssetLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkcreatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | Relative path for a direct asset link. |
| <a id="mutationreleaseassetlinkcreatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | Type of the asset link. |
| <a id="mutationreleaseassetlinkcreatename"></a>`name` | [`String!`](#string) | Name of the asset link. |
| <a id="mutationreleaseassetlinkcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the asset link is associated with. |
| <a id="mutationreleaseassetlinkcreatetagname"></a>`tagName` | [`String!`](#string) | Name of the associated release's tag. |
| <a id="mutationreleaseassetlinkcreateurl"></a>`url` | [`String!`](#string) | URL of the asset link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleaseassetlinkcreatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | Asset link after mutation. |

### `Mutation.releaseAssetLinkDelete`

Input type: `ReleaseAssetLinkDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkdeleteid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | ID of the release asset link to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleaseassetlinkdeletelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | Deleted release asset link. |

### `Mutation.releaseAssetLinkUpdate`

Input type: `ReleaseAssetLinkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkupdatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | Relative path for a direct asset link. |
| <a id="mutationreleaseassetlinkupdateid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | ID of the release asset link to update. |
| <a id="mutationreleaseassetlinkupdatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | Type of the asset link. |
| <a id="mutationreleaseassetlinkupdatename"></a>`name` | [`String`](#string) | Name of the asset link. |
| <a id="mutationreleaseassetlinkupdateurl"></a>`url` | [`String`](#string) | URL of the asset link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleaseassetlinkupdatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | Asset link after mutation. |

### `Mutation.releaseCreate`

Input type: `ReleaseCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateassets"></a>`assets` | [`ReleaseAssetsInput`](#releaseassetsinput) | Assets associated to the release. |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasecreatedescription"></a>`description` | [`String`](#string) | Description (also known as "release notes") of the release. |
| <a id="mutationreleasecreatemilestones"></a>`milestones` | [`[String!]`](#string) | Title of each milestone the release is associated with. GitLab Premium customers can specify group milestones. |
| <a id="mutationreleasecreatename"></a>`name` | [`String`](#string) | Name of the release. |
| <a id="mutationreleasecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the release is associated with. |
| <a id="mutationreleasecreateref"></a>`ref` | [`String`](#string) | Commit SHA or branch name to use if creating a new tag. |
| <a id="mutationreleasecreatereleasedat"></a>`releasedAt` | [`Time`](#time) | Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (`2019-03-15T08:00:00Z`). Only provide this field if creating an upcoming or historical release. |
| <a id="mutationreleasecreatetagmessage"></a>`tagMessage` | [`String`](#string) | Message to use if creating a new annotated tag. |
| <a id="mutationreleasecreatetagname"></a>`tagName` | [`String!`](#string) | Name of the tag to associate with the release. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleasecreaterelease"></a>`release` | [`Release`](#release) | Release after mutation. |

### `Mutation.releaseDelete`

Input type: `ReleaseDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasedeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the release is associated with. |
| <a id="mutationreleasedeletetagname"></a>`tagName` | [`String!`](#string) | Name of the tag associated with the release to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasedeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleasedeleterelease"></a>`release` | [`Release`](#release) | Deleted release. |

### `Mutation.releaseUpdate`

Input type: `ReleaseUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseupdatedescription"></a>`description` | [`String`](#string) | Description (release notes) of the release. |
| <a id="mutationreleaseupdatemilestones"></a>`milestones` | [`[String!]`](#string) | Title of each milestone the release is associated with. GitLab Premium customers can specify group milestones. |
| <a id="mutationreleaseupdatename"></a>`name` | [`String`](#string) | Name of the release. |
| <a id="mutationreleaseupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the release is associated with. |
| <a id="mutationreleaseupdatereleasedat"></a>`releasedAt` | [`Time`](#time) | Release date. |
| <a id="mutationreleaseupdatetagname"></a>`tagName` | [`String!`](#string) | Name of the tag associated with the release. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleaseupdaterelease"></a>`release` | [`Release`](#release) | Release after mutation. |

### `Mutation.removeProjectFromSecurityDashboard`

Input type: `RemoveProjectFromSecurityDashboardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationremoveprojectfromsecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | ID of the project to remove from the Instance Security Dashboard. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationremoveprojectfromsecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.repositionImageDiffNote`

Repositions a DiffNote on an image (a `Note` where the `position.positionType` is `"image"`).

Input type: `RepositionImageDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrepositionimagediffnoteid"></a>`id` | [`DiffNoteID!`](#diffnoteid) | Global ID of the DiffNote to update. |
| <a id="mutationrepositionimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput!`](#updatediffimagepositioninput) | Position of this note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrepositionimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationrepositionimagediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.runnerCreate`

WARNING:
**Introduced** in 15.10.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `RunnerCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Access level of the runner. |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercreatedescription"></a>`description` | [`String`](#string) | Description of the runner. |
| <a id="mutationrunnercreategroupid"></a>`groupId` | [`GroupID`](#groupid) | Global ID of the group that the runner is created in (valid only for group runner). |
| <a id="mutationrunnercreatelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates the runner is locked. |
| <a id="mutationrunnercreatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runner's maintenance notes. |
| <a id="mutationrunnercreatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Maximum timeout (in seconds) for jobs processed by the runner. |
| <a id="mutationrunnercreatepaused"></a>`paused` | [`Boolean`](#boolean) | Indicates the runner is not allowed to receive jobs. |
| <a id="mutationrunnercreateprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Global ID of the project that the runner is created in (valid only for project runner). |
| <a id="mutationrunnercreaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Indicates the runner is able to run untagged jobs. |
| <a id="mutationrunnercreaterunnertype"></a>`runnerType` | [`CiRunnerType!`](#cirunnertype) | Type of the runner to create. |
| <a id="mutationrunnercreatetaglist"></a>`tagList` | [`[String!]`](#string) | Tags associated with the runner. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationrunnercreaterunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner after mutation. |

### `Mutation.runnerDelete`

Input type: `RunnerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerdeleteid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | ID of the runner to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.runnerUpdate`

Input type: `RunnerUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Access level of the runner. |
| <a id="mutationrunnerupdateactive"></a>`active` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** This was renamed. Please use `paused`. Deprecated in 14.8. |
| <a id="mutationrunnerupdateassociatedprojects"></a>`associatedProjects` | [`[ProjectID!]`](#projectid) | Projects associated with the runner. Available only for project runners. |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerupdatedescription"></a>`description` | [`String`](#string) | Description of the runner. |
| <a id="mutationrunnerupdateid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | ID of the runner to update. |
| <a id="mutationrunnerupdatelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates the runner is locked. |
| <a id="mutationrunnerupdatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runner's maintenance notes. |
| <a id="mutationrunnerupdatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Maximum timeout (in seconds) for jobs processed by the runner. |
| <a id="mutationrunnerupdatepaused"></a>`paused` | [`Boolean`](#boolean) | Indicates the runner is not allowed to receive jobs. |
| <a id="mutationrunnerupdateprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` | [`Float`](#float) | Private projects' "minutes cost factor" associated with the runner (GitLab.com only). |
| <a id="mutationrunnerupdatepublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` | [`Float`](#float) | Public projects' "minutes cost factor" associated with the runner (GitLab.com only). |
| <a id="mutationrunnerupdaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Indicates the runner is able to run untagged jobs. |
| <a id="mutationrunnerupdatetaglist"></a>`tagList` | [`[String!]`](#string) | Tags associated with the runner. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationrunnerupdaterunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner after mutation. |

### `Mutation.runnersRegistrationTokenReset`

Input type: `RunnersRegistrationTokenResetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersregistrationtokenresetid"></a>`id` | [`ID`](#id) | ID of the project or group to reset the token for. Omit if resetting instance runner token. |
| <a id="mutationrunnersregistrationtokenresettype"></a>`type` | [`CiRunnerType!`](#cirunnertype) | Scope of the object to reset the token for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersregistrationtokenreseterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationrunnersregistrationtokenresettoken"></a>`token` | [`String`](#string) | Runner token after mutation. |

### `Mutation.savedReplyCreate`

Input type: `SavedReplyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplycreatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationsavedreplycreatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsavedreplycreatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | Saved reply after mutation. |

### `Mutation.savedReplyDestroy`

Input type: `SavedReplyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplydestroyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | Global ID of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsavedreplydestroysavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | Saved reply after mutation. |

### `Mutation.savedReplyUpdate`

Input type: `SavedReplyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationsavedreplyupdateid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | Global ID of the saved reply. |
| <a id="mutationsavedreplyupdatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsavedreplyupdatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | Saved reply after mutation. |

### `Mutation.scanExecutionPolicyCommit`

Commits the `policy_yaml` content to the assigned security policy project for the given project (`full_path`).

Input type: `ScanExecutionPolicyCommitInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationscanexecutionpolicycommitfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project. |
| <a id="mutationscanexecutionpolicycommitname"></a>`name` | [`String!`](#string) | Name of the policy. If the name is null, the `name` field from `policy_yaml` is used. |
| <a id="mutationscanexecutionpolicycommitoperationmode"></a>`operationMode` | [`MutationOperationMode!`](#mutationoperationmode) | Changes the operation mode. |
| <a id="mutationscanexecutionpolicycommitpolicyyaml"></a>`policyYaml` | [`String!`](#string) | YAML snippet of the policy. |
| <a id="mutationscanexecutionpolicycommitprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Use `fullPath`. Deprecated in 14.10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitbranch"></a>`branch` | [`String`](#string) | Name of the branch to which the policy changes are committed. |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationscanexecutionpolicycommiterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.securityFindingCreateIssue`

Input type: `SecurityFindingCreateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreateissueproject"></a>`project` | [`ProjectID!`](#projectid) | ID of the project to attach the issue to. |
| <a id="mutationsecurityfindingcreateissueuuid"></a>`uuid` | [`String!`](#string) | UUID of the security finding to be used to create an issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecurityfindingcreateissueissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |

### `Mutation.securityFindingCreateMergeRequest`

Input type: `SecurityFindingCreateMergeRequestInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreatemergerequestuuid"></a>`uuid` | [`String!`](#string) | UUID of the security finding to be used to create a merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreatemergerequesterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecurityfindingcreatemergerequestmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge Request created after mutation. |

### `Mutation.securityFindingDismiss`

Input type: `SecurityFindingDismissInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingdismisscomment"></a>`comment` | [`String`](#string) | Comment why finding should be dismissed. |
| <a id="mutationsecurityfindingdismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | Reason why finding should be dismissed. |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String!`](#string) | UUID of the finding to be dismissed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingdismisserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecurityfindingdismisssecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | Dismissed finding. |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String`](#string) | UUID of dismissed finding. |

### `Mutation.securityFindingRevertToDetected`

Input type: `SecurityFindingRevertToDetectedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingreverttodetecteduuid"></a>`uuid` | [`String!`](#string) | UUID of the finding to be dismissed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecurityfindingreverttodetectedsecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | Finding reverted to detected. |

### `Mutation.securityPolicyProjectAssign`

Assigns the specified project(`security_policy_project_id`) as security policy project for the given project(`full_path`). If the project already has a security policy project, this reassigns the project's security policy project with the given `security_policy_project_id`.

Input type: `SecurityPolicyProjectAssignInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectassignfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group. |
| <a id="mutationsecuritypolicyprojectassignprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Use `fullPath`. Deprecated in 14.10. |
| <a id="mutationsecuritypolicyprojectassignsecuritypolicyprojectid"></a>`securityPolicyProjectId` | [`ProjectID!`](#projectid) | ID of the security policy project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectassignerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.securityPolicyProjectCreate`

Creates and assigns a security policy project for the given project (`full_path`).

Input type: `SecurityPolicyProjectCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectcreatefullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group. |
| <a id="mutationsecuritypolicyprojectcreateprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Use `fullPath`. Deprecated in 14.10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecuritypolicyprojectcreateproject"></a>`project` | [`Project`](#project) | Security Policy Project that was created. |

### `Mutation.securityPolicyProjectUnassign`

Unassigns the security policy project for the given project (`full_path`).

Input type: `SecurityPolicyProjectUnassignInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectunassignfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group. |
| <a id="mutationsecuritypolicyprojectunassignprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Use `fullPath`. Deprecated in 14.10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectunassignerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.securityTrainingUpdate`

Input type: `SecurityTrainingUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritytrainingupdateisenabled"></a>`isEnabled` | [`Boolean!`](#boolean) | Sets the training provider as enabled for the project. |
| <a id="mutationsecuritytrainingupdateisprimary"></a>`isPrimary` | [`Boolean`](#boolean) | Sets the training provider as primary for the project. |
| <a id="mutationsecuritytrainingupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |
| <a id="mutationsecuritytrainingupdateproviderid"></a>`providerId` | [`SecurityTrainingProviderID!`](#securitytrainingproviderid) | ID of the provider. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritytrainingupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecuritytrainingupdatetraining"></a>`training` | [`ProjectSecurityTraining`](#projectsecuritytraining) | Represents the training entity subject to mutation. |

### `Mutation.terraformStateDelete`

Input type: `TerraformStateDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatedeleteid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Global ID of the Terraform state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatedeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.terraformStateLock`

Input type: `TerraformStateLockInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatelockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Global ID of the Terraform state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatelockerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.terraformStateUnlock`

Input type: `TerraformStateUnlockInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstateunlockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Global ID of the Terraform state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstateunlockerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.timelineEventCreate`

WARNING:
**Introduced** in 15.6.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `TimelineEventCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventcreateincidentid"></a>`incidentId` | [`IssueID!`](#issueid) | Incident ID of the timeline event. |
| <a id="mutationtimelineeventcreatenote"></a>`note` | [`String!`](#string) | Text note of the timeline event. |
| <a id="mutationtimelineeventcreateoccurredat"></a>`occurredAt` | [`Time!`](#time) | Timestamp of when the event occurred. |
| <a id="mutationtimelineeventcreatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | Tags for the incident timeline event. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventcreatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelineEventDestroy`

Input type: `TimelineEventDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventdestroyid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | Timeline event ID to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventdestroytimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelineEventPromoteFromNote`

Input type: `TimelineEventPromoteFromNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventpromotefromnotenoteid"></a>`noteId` | [`NoteID!`](#noteid) | Note ID from which the timeline event promoted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventpromotefromnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventpromotefromnotetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelineEventTagCreate`

Input type: `TimelineEventTagCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventtagcreatename"></a>`name` | [`String!`](#string) | Name of the tag. |
| <a id="mutationtimelineeventtagcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the timeline event tag in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventtagcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventtagcreatetimelineeventtag"></a>`timelineEventTag` | [`TimelineEventTagType`](#timelineeventtagtype) | Timeline event tag. |

### `Mutation.timelineEventUpdate`

Input type: `TimelineEventUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventupdateid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | ID of the timeline event to update. |
| <a id="mutationtimelineeventupdatenote"></a>`note` | [`String`](#string) | Text note of the timeline event. |
| <a id="mutationtimelineeventupdateoccurredat"></a>`occurredAt` | [`Time`](#time) | Timestamp when the event occurred. |
| <a id="mutationtimelineeventupdatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | Tags for the incident timeline event. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventupdatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelogCreate`

Input type: `TimelogCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogcreateissuableid"></a>`issuableId` | [`IssuableID!`](#issuableid) | Global ID of the issuable (Issue, WorkItem or MergeRequest). |
| <a id="mutationtimelogcreatespentat"></a>`spentAt` | [`Time!`](#time) | When the time was spent. |
| <a id="mutationtimelogcreatesummary"></a>`summary` | [`String!`](#string) | Summary of time spent. |
| <a id="mutationtimelogcreatetimespent"></a>`timeSpent` | [`String!`](#string) | Amount of time spent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelogcreatetimelog"></a>`timelog` | [`Timelog`](#timelog) | Timelog. |

### `Mutation.timelogDelete`

Input type: `TimelogDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogdeleteid"></a>`id` | [`TimelogID!`](#timelogid) | Global ID of the timelog. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelogdeletetimelog"></a>`timelog` | [`Timelog`](#timelog) | Timelog. |

### `Mutation.todoCreate`

Input type: `TodoCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodocreatetargetid"></a>`targetId` | [`TodoableID!`](#todoableid) | Global ID of the to-do item's parent. Issues, merge requests, designs, and epics are supported. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodocreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodocreatetodo"></a>`todo` | [`Todo`](#todo) | To-do item created. |

### `Mutation.todoMarkDone`

Input type: `TodoMarkDoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodomarkdoneid"></a>`id` | [`TodoID!`](#todoid) | Global ID of the to-do item to mark as done. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodomarkdoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodomarkdonetodo"></a>`todo` | [`Todo!`](#todo) | Requested to-do item. |

### `Mutation.todoRestore`

Input type: `TodoRestoreInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoreid"></a>`id` | [`TodoID!`](#todoid) | Global ID of the to-do item to restore. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoreerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodorestoretodo"></a>`todo` | [`Todo!`](#todo) | Requested to-do item. |

### `Mutation.todoRestoreMany`

Input type: `TodoRestoreManyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoremanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | Global IDs of the to-do items to restore (a maximum of 50 is supported at once). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoremanyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodorestoremanytodos"></a>`todos` | [`[Todo!]!`](#todo) | Updated to-do items. |

### `Mutation.todosMarkAllDone`

Input type: `TodosMarkAllDoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosmarkalldonetargetid"></a>`targetId` | [`TodoableID`](#todoableid) | Global ID of the to-do item's parent. Issues, merge requests, designs, and epics are supported. If argument is omitted, all pending to-do items of the current user are marked as done. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosmarkalldoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodosmarkalldonetodos"></a>`todos` | [`[Todo!]!`](#todo) | Updated to-do items. |

### `Mutation.updateAlertStatus`

Input type: `UpdateAlertStatusInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatealertstatusiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationupdatealertstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |
| <a id="mutationupdatealertstatusstatus"></a>`status` | [`AlertManagementStatus!`](#alertmanagementstatus) | Status to set the alert. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatealertstatuserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatealertstatusissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationupdatealertstatustodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.updateBoard`

Input type: `UpdateBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ID of user to be assigned to the board. |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationupdateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationupdateboardid"></a>`id` | [`BoardID!`](#boardid) | Board global ID. |
| <a id="mutationupdateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ID of iteration cadence to be assigned to the board. |
| <a id="mutationupdateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ID of iteration to be assigned to the board. |
| <a id="mutationupdateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationupdateboardlabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationupdateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ID of milestone to be assigned to the board. |
| <a id="mutationupdateboardname"></a>`name` | [`String`](#string) | Board name. |
| <a id="mutationupdateboardweight"></a>`weight` | [`Int`](#int) | Weight value to be assigned to the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardboard"></a>`board` | [`Board`](#board) | Board after mutation. |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateBoardEpicUserPreferences`

Input type: `UpdateBoardEpicUserPreferencesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesboardid"></a>`boardId` | [`BoardID!`](#boardid) | Board global ID. |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardepicuserpreferencescollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | Whether the epic should be collapsed in the board. |
| <a id="mutationupdateboardepicuserpreferencesepicid"></a>`epicId` | [`EpicID!`](#epicid) | ID of an epic to set preferences for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardepicuserpreferencesepicuserpreferences"></a>`epicUserPreferences` | [`BoardEpicUserPreferences`](#boardepicuserpreferences) | User preferences for the epic in the board after mutation. |
| <a id="mutationupdateboardepicuserpreferenceserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateBoardList`

Input type: `UpdateBoardListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | Indicates if the list is collapsed for the user. |
| <a id="mutationupdateboardlistlistid"></a>`listId` | [`ListID!`](#listid) | Global ID of the list. |
| <a id="mutationupdateboardlistposition"></a>`position` | [`Int`](#int) | Position of list within the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateboardlistlist"></a>`list` | [`BoardList`](#boardlist) | Mutated list. |

### `Mutation.updateComplianceFramework`

Input type: `UpdateComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | Global ID of the compliance framework to update. |
| <a id="mutationupdatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | Parameters to update the compliance framework with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecomplianceframeworkcomplianceframework"></a>`complianceFramework` | [`ComplianceFramework`](#complianceframework) | Compliance framework after mutation. |
| <a id="mutationupdatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateContainerExpirationPolicy`

Input type: `UpdateContainerExpirationPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicycadence"></a>`cadence` | [`ContainerExpirationPolicyCadenceEnum`](#containerexpirationpolicycadenceenum) | This container expiration policy schedule. |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerexpirationpolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether this container expiration policy is enabled. |
| <a id="mutationupdatecontainerexpirationpolicykeepn"></a>`keepN` | [`ContainerExpirationPolicyKeepEnum`](#containerexpirationpolicykeepenum) | Number of tags to retain. |
| <a id="mutationupdatecontainerexpirationpolicynameregex"></a>`nameRegex` | [`UntrustedRegexp`](#untrustedregexp) | Tags with names matching this regex pattern will expire. |
| <a id="mutationupdatecontainerexpirationpolicynameregexkeep"></a>`nameRegexKeep` | [`UntrustedRegexp`](#untrustedregexp) | Tags with names matching this regex pattern will be preserved. |
| <a id="mutationupdatecontainerexpirationpolicyolderthan"></a>`olderThan` | [`ContainerExpirationPolicyOlderThanEnum`](#containerexpirationpolicyolderthanenum) | Tags older that this will expire. |
| <a id="mutationupdatecontainerexpirationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path where the container expiration policy is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerexpirationpolicycontainerexpirationpolicy"></a>`containerExpirationPolicy` | [`ContainerExpirationPolicy`](#containerexpirationpolicy) | Container expiration policy after mutation. |
| <a id="mutationupdatecontainerexpirationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateDependencyProxyImageTtlGroupPolicy`

Input type: `UpdateDependencyProxyImageTtlGroupPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether the policy is enabled or disabled. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicygrouppath"></a>`groupPath` | [`ID!`](#id) | Group path for the group dependency proxy image TTL policy. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyttl"></a>`ttl` | [`Int`](#int) | Number of days to retain a cached image file. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicydependencyproxyimagettlpolicy"></a>`dependencyProxyImageTtlPolicy` | [`DependencyProxyImageTtlGroupPolicy`](#dependencyproxyimagettlgrouppolicy) | Group image TTL policy after mutation. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateDependencyProxySettings`

These settings can be adjusted by the group Owner or Maintainer. However, in GitLab 16.0, we will be limiting this to the Owner role. [GitLab-#364441](https://gitlab.com/gitlab-org/gitlab/-/issues/364441) proposes making this change to match the permissions level in the user interface.

Input type: `UpdateDependencyProxySettingsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxysettingsenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether the policy is enabled or disabled. |
| <a id="mutationupdatedependencyproxysettingsgrouppath"></a>`groupPath` | [`ID!`](#id) | Group path for the group dependency proxy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxysettingsdependencyproxysetting"></a>`dependencyProxySetting` | [`DependencyProxySetting`](#dependencyproxysetting) | Group dependency proxy settings after mutation. |
| <a id="mutationupdatedependencyproxysettingserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateEpic`

Input type: `UpdateEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | IDs of labels to be added to the epic. |
| <a id="mutationupdateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | Array of labels to be added to the epic. |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepiccolor"></a>`color` | [`Color`](#color) | Color of the epic. Available only when feature flag `epic_color_highlight` is enabled. This flag is disabled by default, because the feature is experimental and is subject to change without notice. |
| <a id="mutationupdateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates if the epic is confidential. |
| <a id="mutationupdateepicdescription"></a>`description` | [`String`](#string) | Description of the epic. |
| <a id="mutationupdateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | End date of the epic. |
| <a id="mutationupdateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | Indicates end date should be sourced from due_date_fixed field not the issue milestones. |
| <a id="mutationupdateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate is in. |
| <a id="mutationupdateepiciid"></a>`iid` | [`ID!`](#id) | IID of the epic to mutate. |
| <a id="mutationupdateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | IDs of labels to be removed from the epic. |
| <a id="mutationupdateepicremovelabels"></a>`removeLabels` | [`[String!]`](#string) | Array of labels to be removed from the epic. |
| <a id="mutationupdateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | Start date of the epic. |
| <a id="mutationupdateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | Indicates start date should be sourced from start_date_fixed field not the issue milestones. |
| <a id="mutationupdateepicstateevent"></a>`stateEvent` | [`EpicStateEvent`](#epicstateevent) | State event for the epic. |
| <a id="mutationupdateepictitle"></a>`title` | [`String`](#string) | Title of the epic. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepicepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationupdateepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateEpicBoardList`

Input type: `UpdateEpicBoardListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepicboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | Indicates if the list is collapsed for the user. |
| <a id="mutationupdateepicboardlistlistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the epic list. |
| <a id="mutationupdateepicboardlistposition"></a>`position` | [`Int`](#int) | Position of list within the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepicboardlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateepicboardlistlist"></a>`list` | [`EpicList`](#epiclist) | Mutated epic list. |

### `Mutation.updateImageDiffNote`

Updates a DiffNote on an image (a `Note` where the `position.positionType` is `"image"`).
If the body of the Note contains only quick actions,
the Note will be destroyed during an update, and no Note will be
returned.

Input type: `UpdateImageDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnotebody"></a>`body` | [`String`](#string) | Content of the note. |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateimagediffnoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note to update. |
| <a id="mutationupdateimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput`](#updatediffimagepositioninput) | Position of this note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateimagediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.updateIssue`

Input type: `UpdateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | IDs of labels to be added to the issue. |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates the issue is confidential. |
| <a id="mutationupdateissuedescription"></a>`description` | [`String`](#string) | Description of the issue. |
| <a id="mutationupdateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | Due date of the issue. |
| <a id="mutationupdateissueepicid"></a>`epicId` | [`EpicID`](#epicid) | ID of the parent epic. NULL when removing the association. |
| <a id="mutationupdateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Desired health status. |
| <a id="mutationupdateissueiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationupdateissuelabelids"></a>`labelIds` | [`[ID!]`](#id) | IDs of labels to be set. Replaces existing issue labels. |
| <a id="mutationupdateissuelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates discussion is locked on the issue. |
| <a id="mutationupdateissuemilestoneid"></a>`milestoneId` | [`ID`](#id) | ID of the milestone to assign to the issue. On update milestone will be removed if set to null. |
| <a id="mutationupdateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationupdateissueremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | IDs of labels to be removed from the issue. |
| <a id="mutationupdateissuestateevent"></a>`stateEvent` | [`IssueStateEvent`](#issuestateevent) | Close or reopen an issue. |
| <a id="mutationupdateissuetimeestimate"></a>`timeEstimate` | [`String`](#string) | Estimated time to complete the issue, or `0` to remove the current estimate. |
| <a id="mutationupdateissuetitle"></a>`title` | [`String`](#string) | Title of the issue. |
| <a id="mutationupdateissuetype"></a>`type` | [`IssueType`](#issuetype) | Type of the issue. |
| <a id="mutationupdateissueweight"></a>`weight` | [`Int`](#int) | Weight of the issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateissueissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.updateIteration`

Input type: `UpdateIterationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateiterationdescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="mutationupdateiterationduedate"></a>`dueDate` | [`String`](#string) | End date of the iteration. |
| <a id="mutationupdateiterationgrouppath"></a>`groupPath` | [`ID!`](#id) | Group of the iteration. |
| <a id="mutationupdateiterationid"></a>`id` | [`ID!`](#id) | Global ID of the iteration. |
| <a id="mutationupdateiterationstartdate"></a>`startDate` | [`String`](#string) | Start date of the iteration. |
| <a id="mutationupdateiterationtitle"></a>`title` | [`String`](#string) | Title of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateiterationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | Updated iteration. |

### `Mutation.updateNamespacePackageSettings`

Input type: `UpdateNamespacePackageSettingsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicateexceptionregex"></a>`genericDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When generic_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicatesallowed"></a>`genericDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate generic packages are allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingslockmavenpackagerequestsforwarding"></a>`lockMavenPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether Maven package forwarding is locked for all descendent namespaces. |
| <a id="mutationupdatenamespacepackagesettingslocknpmpackagerequestsforwarding"></a>`lockNpmPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether npm package forwarding is locked for all descendent namespaces. |
| <a id="mutationupdatenamespacepackagesettingslockpypipackagerequestsforwarding"></a>`lockPypiPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether PyPI package forwarding is locked for all descendent namespaces. |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicateexceptionregex"></a>`mavenDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When maven_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicatesallowed"></a>`mavenDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate Maven packages are allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingsmavenpackagerequestsforwarding"></a>`mavenPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether Maven package forwarding is allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingsnamespacepath"></a>`namespacePath` | [`ID!`](#id) | Namespace path where the namespace package setting is located. |
| <a id="mutationupdatenamespacepackagesettingsnpmpackagerequestsforwarding"></a>`npmPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether npm package forwarding is allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingspypipackagerequestsforwarding"></a>`pypiPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether PyPI package forwarding is allowed for this namespace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenamespacepackagesettingserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatenamespacepackagesettingspackagesettings"></a>`packageSettings` | [`PackageSettings`](#packagesettings) | Namespace package setting after mutation. |

### `Mutation.updateNote`

Updates a Note.
If the body of the Note contains only quick actions,
the Note will be destroyed during an update, and no Note will be
returned.

Input type: `UpdateNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenotebody"></a>`body` | [`String`](#string) | Content of the note. |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenoteconfidential"></a>`confidential` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** No longer allowed to update confidentiality of notes. Deprecated in 14.10. |
| <a id="mutationupdatenoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatenotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.updatePackagesCleanupPolicy`

Input type: `UpdatePackagesCleanupPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagescleanuppolicykeepnduplicatedpackagefiles"></a>`keepNDuplicatedPackageFiles` | [`PackagesCleanupKeepDuplicatedPackageFilesEnum`](#packagescleanupkeepduplicatedpackagefilesenum) | Number of duplicated package files to retain. |
| <a id="mutationupdatepackagescleanuppolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path where the packages cleanup policy is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagescleanuppolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatepackagescleanuppolicypackagescleanuppolicy"></a>`packagesCleanupPolicy` | [`PackagesCleanupPolicy`](#packagescleanuppolicy) | Packages cleanup policy after mutation. |

### `Mutation.updateRequirement`

Input type: `UpdateRequirementInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdaterequirementdescription"></a>`description` | [`String`](#string) | Description of the requirement. |
| <a id="mutationupdaterequirementiid"></a>`iid` **{warning-solid}** | [`String`](#string) | **Deprecated:** Use work_item_iid instead. Deprecated in 15.8. |
| <a id="mutationupdaterequirementlasttestreportstate"></a>`lastTestReportState` | [`TestReportState`](#testreportstate) | Creates a test report for the requirement with the given state. |
| <a id="mutationupdaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path the requirement is associated with. |
| <a id="mutationupdaterequirementstate"></a>`state` | [`RequirementState`](#requirementstate) | State of the requirement. |
| <a id="mutationupdaterequirementtitle"></a>`title` | [`String`](#string) | Title of the requirement. |
| <a id="mutationupdaterequirementworkitemiid"></a>`workItemIid` | [`String`](#string) | IID of the requirement work item to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | Requirement after mutation. |

### `Mutation.updateSnippet`

Input type: `UpdateSnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | Actions to perform over the snippet repository and blobs. |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatesnippetdescription"></a>`description` | [`String`](#string) | Description of the snippet. |
| <a id="mutationupdatesnippetid"></a>`id` | [`SnippetID!`](#snippetid) | Global ID of the snippet to update. |
| <a id="mutationupdatesnippettitle"></a>`title` | [`String`](#string) | Title of the snippet. |
| <a id="mutationupdatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | Visibility level of the snippet. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.uploadDelete`

Deletes an upload.

Input type: `UploadDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuploaddeletefilename"></a>`filename` | [`String!`](#string) | Upload filename. |
| <a id="mutationuploaddeletegrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationuploaddeleteprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationuploaddeletesecret"></a>`secret` | [`String!`](#string) | Secret part of upload path. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuploaddeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationuploaddeleteupload"></a>`upload` | [`FileUpload`](#fileupload) | Deleted upload. |

### `Mutation.userCalloutCreate`

Input type: `UserCalloutCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusercalloutcreatefeaturename"></a>`featureName` | [`String!`](#string) | Feature name you want to dismiss the callout for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusercalloutcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationusercalloutcreateusercallout"></a>`userCallout` | [`UserCallout!`](#usercallout) | User callout dismissed. |

### `Mutation.userPreferencesUpdate`

Input type: `UserPreferencesUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserpreferencesupdateissuessort"></a>`issuesSort` | [`IssueSort`](#issuesort) | Sort order for issue lists. |
| <a id="mutationuserpreferencesupdatevisibilitypipelineidtype"></a>`visibilityPipelineIdType` | [`VisibilityPipelineIdType`](#visibilitypipelineidtype) | Determines whether the pipeline list shows ID or IID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserpreferencesupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationuserpreferencesupdateuserpreferences"></a>`userPreferences` | [`UserPreferences`](#userpreferences) | User preferences after mutation. |

### `Mutation.vulnerabilityConfirm`

Input type: `VulnerabilityConfirmInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityconfirmcomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was confirmed (maximum 50,000 characters). |
| <a id="mutationvulnerabilityconfirmid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be confirmed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityconfirmerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityconfirmvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityCreate`

Input type: `VulnerabilityCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitycreateconfidence"></a>`confidence` **{warning-solid}** | [`VulnerabilityConfidence`](#vulnerabilityconfidence) | **Deprecated:** This field will be removed from the Vulnerability domain model. Deprecated in 15.4. |
| <a id="mutationvulnerabilitycreateconfirmedat"></a>`confirmedAt` | [`Time`](#time) | Timestamp of when the vulnerability state changed to confirmed (defaults to creation time if status is `confirmed`). |
| <a id="mutationvulnerabilitycreatedescription"></a>`description` | [`String!`](#string) | Long text section that describes the vulnerability in more detail. |
| <a id="mutationvulnerabilitycreatedetectedat"></a>`detectedAt` | [`Time`](#time) | Timestamp of when the vulnerability was first detected (defaults to creation time). |
| <a id="mutationvulnerabilitycreatedismissedat"></a>`dismissedAt` | [`Time`](#time) | Timestamp of when the vulnerability state changed to dismissed (defaults to creation time if status is `dismissed`). |
| <a id="mutationvulnerabilitycreateidentifiers"></a>`identifiers` | [`[VulnerabilityIdentifierInput!]!`](#vulnerabilityidentifierinput) | Array of CVE or CWE identifiers for the vulnerability. |
| <a id="mutationvulnerabilitycreatemessage"></a>`message` **{warning-solid}** | [`String`](#string) | **Deprecated:** message field has been removed from security reports schema. Deprecated in 16.1. |
| <a id="mutationvulnerabilitycreatename"></a>`name` | [`String!`](#string) | Name of the vulnerability. |
| <a id="mutationvulnerabilitycreateproject"></a>`project` | [`ProjectID!`](#projectid) | ID of the project to attach the vulnerability to. |
| <a id="mutationvulnerabilitycreateresolvedat"></a>`resolvedAt` | [`Time`](#time) | Timestamp of when the vulnerability state changed to resolved (defaults to creation time if status is `resolved`). |
| <a id="mutationvulnerabilitycreatescanner"></a>`scanner` | [`VulnerabilityScannerInput!`](#vulnerabilityscannerinput) | Information about the scanner used to discover the vulnerability. |
| <a id="mutationvulnerabilitycreateseverity"></a>`severity` | [`VulnerabilitySeverity`](#vulnerabilityseverity) | Severity of the vulnerability (defaults to `unknown`). |
| <a id="mutationvulnerabilitycreatesolution"></a>`solution` | [`String`](#string) | Instructions for how to fix the vulnerability. |
| <a id="mutationvulnerabilitycreatestate"></a>`state` | [`VulnerabilityState`](#vulnerabilitystate) | State of the vulnerability (defaults to `detected`). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilitycreatevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability created. |

### `Mutation.vulnerabilityDismiss`

Input type: `VulnerabilityDismissInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitydismisscomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was dismissed (maximum 50,000 characters). |
| <a id="mutationvulnerabilitydismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | Reason why vulnerability should be dismissed. |
| <a id="mutationvulnerabilitydismissid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be dismissed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitydismisserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilitydismissvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityExternalIssueLinkCreate`

Input type: `VulnerabilityExternalIssueLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternaltracker"></a>`externalTracker` | [`VulnerabilityExternalIssueLinkExternalTracker!`](#vulnerabilityexternalissuelinkexternaltracker) | External tracker type of the external issue link. |
| <a id="mutationvulnerabilityexternalissuelinkcreateid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability. |
| <a id="mutationvulnerabilityexternalissuelinkcreatelinktype"></a>`linkType` | [`VulnerabilityExternalIssueLinkType!`](#vulnerabilityexternalissuelinktype) | Type of the external issue link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternalissuelink"></a>`externalIssueLink` | [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink) | Created external issue link. |

### `Mutation.vulnerabilityExternalIssueLinkDestroy`

Input type: `VulnerabilityExternalIssueLinkDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkdestroyid"></a>`id` | [`VulnerabilitiesExternalIssueLinkID!`](#vulnerabilitiesexternalissuelinkid) | Global ID of the vulnerability external issue link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.vulnerabilityIssueLinkCreate`

Input type: `VulnerabilityIssueLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityissuelinkcreateissueid"></a>`issueId` | [`IssueID!`](#issueid) | ID of the issue to link to. |
| <a id="mutationvulnerabilityissuelinkcreatevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | IDs of vulnerabilities to link to the given issue. Up to 100 can be provided. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityissuelinkcreateissuelinks"></a>`issueLinks` | [`[VulnerabilityIssueLink!]`](#vulnerabilityissuelink) | Created issue links. |

### `Mutation.vulnerabilityResolve`

Input type: `VulnerabilityResolveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityresolvecomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was resolved (maximum 50,000 characters). |
| <a id="mutationvulnerabilityresolveid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be resolved. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityresolveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityresolvevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityRevertToDetected`

Input type: `VulnerabilityRevertToDetectedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityreverttodetectedcomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was reverted to detected (maximum 50,000 characters). |
| <a id="mutationvulnerabilityreverttodetectedid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be reverted to detected. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityreverttodetectedvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.workItemConvert`

Converts the work item to a new type.

WARNING:
**Introduced** in 15.11.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkItemConvertInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemconvertid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemconvertworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | Global ID of the new work item type. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemconverterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemconvertworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemCreate`

Creates a work item.

WARNING:
**Introduced** in 15.1.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkItemCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreateconfidential"></a>`confidential` | [`Boolean`](#boolean) | Sets the work item confidentiality. |
| <a id="mutationworkitemcreatedescription"></a>`description` | [`String`](#string) | Description of the work item. |
| <a id="mutationworkitemcreatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyCreateInput`](#workitemwidgethierarchycreateinput) | Input for hierarchy widget. |
| <a id="mutationworkitemcreateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | Iteration widget of the work item. |
| <a id="mutationworkitemcreatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | Input for milestone widget. |
| <a id="mutationworkitemcreatenamespacepath"></a>`namespacePath` | [`ID`](#id) | Full path of the namespace(project or group) the work item is created in. |
| <a id="mutationworkitemcreateprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Please use namespace_path instead. That will cover for both projects and groups. Deprecated in 15.10. |
| <a id="mutationworkitemcreatetitle"></a>`title` | [`String!`](#string) | Title of the work item. |
| <a id="mutationworkitemcreateworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | Global ID of a work item type. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemcreateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Created work item. |

### `Mutation.workItemCreateFromTask`

Creates a work item from a task in another work item's description.

WARNING:
**Introduced** in 15.1.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkItemCreateFromTaskInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreatefromtaskid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemcreatefromtaskworkitemdata"></a>`workItemData` | [`WorkItemConvertTaskInput!`](#workitemconverttaskinput) | Arguments necessary to convert a task into a work item. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreatefromtaskerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemcreatefromtasknewworkitem"></a>`newWorkItem` | [`WorkItem`](#workitem) | New work item created from task. |
| <a id="mutationworkitemcreatefromtaskworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemDelete`

Deletes a work item.

WARNING:
**Introduced** in 15.1.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkItemDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemdeleteid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemdeleteproject"></a>`project` | [`Project`](#project) | Project the deleted work item belonged to. |

### `Mutation.workItemDeleteTask`

Deletes a task in a work item's description.

WARNING:
**Introduced** in 15.1.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkItemDeleteTaskInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeletetaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemdeletetaskid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemdeletetasklockversion"></a>`lockVersion` | [`Int!`](#int) | Current lock version of the work item containing the task in the description. |
| <a id="mutationworkitemdeletetasktaskdata"></a>`taskData` | [`WorkItemDeletedTaskInput!`](#workitemdeletedtaskinput) | Arguments necessary to delete a task from a work item's description. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeletetaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemdeletetaskerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemdeletetaskworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemExport`

WARNING:
**Introduced** in 15.10.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkItemExportInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportauthorusername"></a>`authorUsername` **{warning-solid}** | [`String`](#string) | **Deprecated:** This feature is an Experiment. It can be changed or removed at any time. Introduced in 15.9. |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemexportiids"></a>`iids` | [`[String!]`](#string) | List of IIDs of work items. For example, `["1", "2"]`. |
| <a id="mutationworkitemexportin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="mutationworkitemexportprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path. |
| <a id="mutationworkitemexportsearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="mutationworkitemexportselectedfields"></a>`selectedFields` | [`[AvailableExportFields!]`](#availableexportfields) | List of selected fields to be exported. Omit to export all available fields. |
| <a id="mutationworkitemexportstate"></a>`state` | [`IssuableState`](#issuablestate) | Current state of the work item. |
| <a id="mutationworkitemexporttypes"></a>`types` | [`[IssueType!]`](#issuetype) | Filter work items by the given work item types. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemexporterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemexportmessage"></a>`message` | [`String`](#string) | Export request result message. |

### `Mutation.workItemUpdate`

Updates a work item by Global ID.

WARNING:
**Introduced** in 15.1.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkItemUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateassigneeswidget"></a>`assigneesWidget` | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | Input for assignees widget. |
| <a id="mutationworkitemupdateawardemojiwidget"></a>`awardEmojiWidget` | [`WorkItemWidgetAwardEmojiUpdateInput`](#workitemwidgetawardemojiupdateinput) | Input for award emoji widget. |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemupdateconfidential"></a>`confidential` | [`Boolean`](#boolean) | Sets the work item confidentiality. |
| <a id="mutationworkitemupdatecurrentusertodoswidget"></a>`currentUserTodosWidget` | [`WorkItemWidgetCurrentUserTodosInput`](#workitemwidgetcurrentusertodosinput) | Input for to-dos widget. |
| <a id="mutationworkitemupdatedescriptionwidget"></a>`descriptionWidget` | [`WorkItemWidgetDescriptionInput`](#workitemwidgetdescriptioninput) | Input for description widget. |
| <a id="mutationworkitemupdatehealthstatuswidget"></a>`healthStatusWidget` | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | Input for health status widget. |
| <a id="mutationworkitemupdatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyUpdateInput`](#workitemwidgethierarchyupdateinput) | Input for hierarchy widget. |
| <a id="mutationworkitemupdateid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemupdateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | Input for iteration widget. |
| <a id="mutationworkitemupdatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsUpdateInput`](#workitemwidgetlabelsupdateinput) | Input for labels widget. |
| <a id="mutationworkitemupdatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | Input for milestone widget. |
| <a id="mutationworkitemupdatenotificationswidget"></a>`notificationsWidget` | [`WorkItemWidgetNotificationsUpdateInput`](#workitemwidgetnotificationsupdateinput) | Input for notifications widget. |
| <a id="mutationworkitemupdateprogresswidget"></a>`progressWidget` | [`WorkItemWidgetProgressInput`](#workitemwidgetprogressinput) | Input for progress widget. |
| <a id="mutationworkitemupdatestartandduedatewidget"></a>`startAndDueDateWidget` | [`WorkItemWidgetStartAndDueDateUpdateInput`](#workitemwidgetstartandduedateupdateinput) | Input for start and due date widget. |
| <a id="mutationworkitemupdatestateevent"></a>`stateEvent` | [`WorkItemStateEvent`](#workitemstateevent) | Close or reopen a work item. |
| <a id="mutationworkitemupdatestatuswidget"></a>`statusWidget` | [`StatusInput`](#statusinput) | Input for status widget. |
| <a id="mutationworkitemupdatetitle"></a>`title` | [`String`](#string) | Title of the work item. |
| <a id="mutationworkitemupdateweightwidget"></a>`weightWidget` | [`WorkItemWidgetWeightInput`](#workitemwidgetweightinput) | Input for weight widget. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemupdateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemUpdateTask`

Updates a work item's task by Global ID.

WARNING:
**Introduced** in 15.1.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkItemUpdateTaskInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdatetaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemupdatetaskid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemupdatetasktaskdata"></a>`taskData` | [`WorkItemUpdatedTaskInput!`](#workitemupdatedtaskinput) | Arguments necessary to update a task. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdatetaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemupdatetaskerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemupdatetasktask"></a>`task` | [`WorkItem`](#workitem) | Updated task. |
| <a id="mutationworkitemupdatetaskworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workspaceCreate`

WARNING:
**Introduced** in 16.0.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkspaceCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspacecreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | ID of the cluster agent the created workspace will be associated with. |
| <a id="mutationworkspacecreatedesiredstate"></a>`desiredState` | [`String!`](#string) | Desired state of the created workspace. |
| <a id="mutationworkspacecreatedevfilepath"></a>`devfilePath` | [`String!`](#string) | Project repo git path containing the devfile used to configure the workspace. |
| <a id="mutationworkspacecreatedevfileref"></a>`devfileRef` | [`String!`](#string) | Project repo git ref containing the devfile used to configure the workspace. |
| <a id="mutationworkspacecreateeditor"></a>`editor` | [`String!`](#string) | Editor to inject into the created workspace. Must match a configured template. |
| <a id="mutationworkspacecreatemaxhoursbeforetermination"></a>`maxHoursBeforeTermination` | [`Int!`](#int) | Maximum hours the workspace can exist before it is automatically terminated. |
| <a id="mutationworkspacecreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ID of the project that will provide the Devfile for the created workspace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspacecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkspacecreateworkspace"></a>`workspace` | [`Workspace`](#workspace) | Created workspace. |

### `Mutation.workspaceUpdate`

WARNING:
**Introduced** in 16.0.
This feature is an Experiment. It can be changed or removed at any time.

Input type: `WorkspaceUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspaceupdatedesiredstate"></a>`desiredState` | [`String!`](#string) | Desired state of the created workspace. |
| <a id="mutationworkspaceupdateid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | Global ID of the workspace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspaceupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkspaceupdateworkspace"></a>`workspace` | [`Workspace`](#workspace) | Created workspace. |

## Connections

Some types in our schema are `Connection` types - they represent a paginated
collection of edges between two nodes in the graph. These follow the
[Relay cursor connections specification](https://relay.dev/graphql/connections.htm).

### Pagination arguments {#connection-pagination-arguments}

All connection fields support the following pagination arguments:

| Name | Type | Description |
|------|------|-------------|
| `after` | [`String`](#string) | Returns the elements in the list that come after the specified cursor. |
| `before` | [`String`](#string) | Returns the elements in the list that come before the specified cursor. |
| `first` | [`Int`](#int) | Returns the first _n_ elements from the list. |
| `last` | [`Int`](#int) | Returns the last _n_ elements from the list. |

Since these arguments are common to all connection fields, they are not repeated for each connection.

### Connection fields

All connections have at least the following fields:

| Name | Type | Description |
|------|------|-------------|
| `pageInfo` | [`PageInfo!`](#pageinfo) | Pagination information. |
| `edges` | `[edge!]` | The edges. |
| `nodes` | `[item!]` | The items in the current page. |

The precise type of `Edge` and `Item` depends on the kind of connection. A
[`ProjectConnection`](#projectconnection) will have nodes that have the type
[`[Project!]`](#project), and edges that have the type [`ProjectEdge`](#projectedge).

### Connection types

Some of the types in the schema exist solely to model connections. Each connection
has a distinct, named type, with a distinct named edge type. These are listed separately
below.

#### `AchievementConnection`

The connection type for [`Achievement`](#achievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="achievementconnectionedges"></a>`edges` | [`[AchievementEdge]`](#achievementedge) | A list of edges. |
| <a id="achievementconnectionnodes"></a>`nodes` | [`[Achievement]`](#achievement) | A list of nodes. |
| <a id="achievementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AchievementEdge`

The edge type for [`Achievement`](#achievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="achievementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="achievementedgenode"></a>`node` | [`Achievement`](#achievement) | The item at the end of the edge. |

#### `AgentConfigurationConnection`

The connection type for [`AgentConfiguration`](#agentconfiguration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentconfigurationconnectionedges"></a>`edges` | [`[AgentConfigurationEdge]`](#agentconfigurationedge) | A list of edges. |
| <a id="agentconfigurationconnectionnodes"></a>`nodes` | [`[AgentConfiguration]`](#agentconfiguration) | A list of nodes. |
| <a id="agentconfigurationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AgentConfigurationEdge`

The edge type for [`AgentConfiguration`](#agentconfiguration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentconfigurationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="agentconfigurationedgenode"></a>`node` | [`AgentConfiguration`](#agentconfiguration) | The item at the end of the edge. |

#### `AiMessageTypeConnection`

The connection type for [`AiMessageType`](#aimessagetype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimessagetypeconnectionedges"></a>`edges` | [`[AiMessageTypeEdge]`](#aimessagetypeedge) | A list of edges. |
| <a id="aimessagetypeconnectionnodes"></a>`nodes` | [`[AiMessageType]`](#aimessagetype) | A list of nodes. |
| <a id="aimessagetypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiMessageTypeEdge`

The edge type for [`AiMessageType`](#aimessagetype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimessagetypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aimessagetypeedgenode"></a>`node` | [`AiMessageType`](#aimessagetype) | The item at the end of the edge. |

#### `AlertManagementAlertConnection`

The connection type for [`AlertManagementAlert`](#alertmanagementalert).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertconnectionedges"></a>`edges` | [`[AlertManagementAlertEdge]`](#alertmanagementalertedge) | A list of edges. |
| <a id="alertmanagementalertconnectionnodes"></a>`nodes` | [`[AlertManagementAlert]`](#alertmanagementalert) | A list of nodes. |
| <a id="alertmanagementalertconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AlertManagementAlertEdge`

The edge type for [`AlertManagementAlert`](#alertmanagementalert).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="alertmanagementalertedgenode"></a>`node` | [`AlertManagementAlert`](#alertmanagementalert) | The item at the end of the edge. |

#### `AlertManagementHttpIntegrationConnection`

The connection type for [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationconnectionedges"></a>`edges` | [`[AlertManagementHttpIntegrationEdge]`](#alertmanagementhttpintegrationedge) | A list of edges. |
| <a id="alertmanagementhttpintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementHttpIntegration]`](#alertmanagementhttpintegration) | A list of nodes. |
| <a id="alertmanagementhttpintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AlertManagementHttpIntegrationEdge`

The edge type for [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="alertmanagementhttpintegrationedgenode"></a>`node` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | The item at the end of the edge. |

#### `AlertManagementIntegrationConnection`

The connection type for [`AlertManagementIntegration`](#alertmanagementintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationconnectionedges"></a>`edges` | [`[AlertManagementIntegrationEdge]`](#alertmanagementintegrationedge) | A list of edges. |
| <a id="alertmanagementintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementIntegration]`](#alertmanagementintegration) | A list of nodes. |
| <a id="alertmanagementintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AlertManagementIntegrationEdge`

The edge type for [`AlertManagementIntegration`](#alertmanagementintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="alertmanagementintegrationedgenode"></a>`node` | [`AlertManagementIntegration`](#alertmanagementintegration) | The item at the end of the edge. |

#### `ApprovalProjectRuleConnection`

The connection type for [`ApprovalProjectRule`](#approvalprojectrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleconnectionedges"></a>`edges` | [`[ApprovalProjectRuleEdge]`](#approvalprojectruleedge) | A list of edges. |
| <a id="approvalprojectruleconnectionnodes"></a>`nodes` | [`[ApprovalProjectRule]`](#approvalprojectrule) | A list of nodes. |
| <a id="approvalprojectruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ApprovalProjectRuleEdge`

The edge type for [`ApprovalProjectRule`](#approvalprojectrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="approvalprojectruleedgenode"></a>`node` | [`ApprovalProjectRule`](#approvalprojectrule) | The item at the end of the edge. |

#### `AuditEventStreamingHeaderConnection`

The connection type for [`AuditEventStreamingHeader`](#auditeventstreamingheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderconnectionedges"></a>`edges` | [`[AuditEventStreamingHeaderEdge]`](#auditeventstreamingheaderedge) | A list of edges. |
| <a id="auditeventstreamingheaderconnectionnodes"></a>`nodes` | [`[AuditEventStreamingHeader]`](#auditeventstreamingheader) | A list of nodes. |
| <a id="auditeventstreamingheaderconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AuditEventStreamingHeaderEdge`

The edge type for [`AuditEventStreamingHeader`](#auditeventstreamingheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="auditeventstreamingheaderedgenode"></a>`node` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | The item at the end of the edge. |

#### `AwardEmojiConnection`

The connection type for [`AwardEmoji`](#awardemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="awardemojiconnectionedges"></a>`edges` | [`[AwardEmojiEdge]`](#awardemojiedge) | A list of edges. |
| <a id="awardemojiconnectionnodes"></a>`nodes` | [`[AwardEmoji]`](#awardemoji) | A list of nodes. |
| <a id="awardemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AwardEmojiEdge`

The edge type for [`AwardEmoji`](#awardemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="awardemojiedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="awardemojiedgenode"></a>`node` | [`AwardEmoji`](#awardemoji) | The item at the end of the edge. |

#### `BlobConnection`

The connection type for [`Blob`](#blob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobconnectionedges"></a>`edges` | [`[BlobEdge]`](#blobedge) | A list of edges. |
| <a id="blobconnectionnodes"></a>`nodes` | [`[Blob]`](#blob) | A list of nodes. |
| <a id="blobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BlobEdge`

The edge type for [`Blob`](#blob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="blobedgenode"></a>`node` | [`Blob`](#blob) | The item at the end of the edge. |

#### `BoardConnection`

The connection type for [`Board`](#board).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardconnectionedges"></a>`edges` | [`[BoardEdge]`](#boardedge) | A list of edges. |
| <a id="boardconnectionnodes"></a>`nodes` | [`[Board]`](#board) | A list of nodes. |
| <a id="boardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BoardEdge`

The edge type for [`Board`](#board).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="boardedgenode"></a>`node` | [`Board`](#board) | The item at the end of the edge. |

#### `BoardEpicConnection`

The connection type for [`BoardEpic`](#boardepic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="boardepicconnectionedges"></a>`edges` | [`[BoardEpicEdge]`](#boardepicedge) | A list of edges. |
| <a id="boardepicconnectionnodes"></a>`nodes` | [`[BoardEpic]`](#boardepic) | A list of nodes. |
| <a id="boardepicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BoardEpicEdge`

The edge type for [`BoardEpic`](#boardepic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="boardepicedgenode"></a>`node` | [`BoardEpic`](#boardepic) | The item at the end of the edge. |

#### `BoardListConnection`

The connection type for [`BoardList`](#boardlist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistconnectionedges"></a>`edges` | [`[BoardListEdge]`](#boardlistedge) | A list of edges. |
| <a id="boardlistconnectionnodes"></a>`nodes` | [`[BoardList]`](#boardlist) | A list of nodes. |
| <a id="boardlistconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BoardListEdge`

The edge type for [`BoardList`](#boardlist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="boardlistedgenode"></a>`node` | [`BoardList`](#boardlist) | The item at the end of the edge. |

#### `BranchRuleConnection`

The connection type for [`BranchRule`](#branchrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchruleconnectionedges"></a>`edges` | [`[BranchRuleEdge]`](#branchruleedge) | A list of edges. |
| <a id="branchruleconnectionnodes"></a>`nodes` | [`[BranchRule]`](#branchrule) | A list of nodes. |
| <a id="branchruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BranchRuleEdge`

The edge type for [`BranchRule`](#branchrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="branchruleedgenode"></a>`node` | [`BranchRule`](#branchrule) | The item at the end of the edge. |

#### `CiBuildNeedConnection`

The connection type for [`CiBuildNeed`](#cibuildneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cibuildneedconnectionedges"></a>`edges` | [`[CiBuildNeedEdge]`](#cibuildneededge) | A list of edges. |
| <a id="cibuildneedconnectionnodes"></a>`nodes` | [`[CiBuildNeed]`](#cibuildneed) | A list of nodes. |
| <a id="cibuildneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiBuildNeedEdge`

The edge type for [`CiBuildNeed`](#cibuildneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cibuildneededgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cibuildneededgenode"></a>`node` | [`CiBuildNeed`](#cibuildneed) | The item at the end of the edge. |

#### `CiCatalogResourceConnection`

The connection type for [`CiCatalogResource`](#cicatalogresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cicatalogresourceconnectionedges"></a>`edges` | [`[CiCatalogResourceEdge]`](#cicatalogresourceedge) | A list of edges. |
| <a id="cicatalogresourceconnectionnodes"></a>`nodes` | [`[CiCatalogResource]`](#cicatalogresource) | A list of nodes. |
| <a id="cicatalogresourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiCatalogResourceEdge`

The edge type for [`CiCatalogResource`](#cicatalogresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cicatalogresourceedgenode"></a>`node` | [`CiCatalogResource`](#cicatalogresource) | The item at the end of the edge. |

#### `CiConfigGroupConnection`

The connection type for [`CiConfigGroup`](#ciconfiggroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupconnectionedges"></a>`edges` | [`[CiConfigGroupEdge]`](#ciconfiggroupedge) | A list of edges. |
| <a id="ciconfiggroupconnectionnodes"></a>`nodes` | [`[CiConfigGroup]`](#ciconfiggroup) | A list of nodes. |
| <a id="ciconfiggroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigGroupEdge`

The edge type for [`CiConfigGroup`](#ciconfiggroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfiggroupedgenode"></a>`node` | [`CiConfigGroup`](#ciconfiggroup) | The item at the end of the edge. |

#### `CiConfigJobConnection`

The connection type for [`CiConfigJob`](#ciconfigjob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobconnectionedges"></a>`edges` | [`[CiConfigJobEdge]`](#ciconfigjobedge) | A list of edges. |
| <a id="ciconfigjobconnectionnodes"></a>`nodes` | [`[CiConfigJob]`](#ciconfigjob) | A list of nodes. |
| <a id="ciconfigjobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigJobEdge`

The edge type for [`CiConfigJob`](#ciconfigjob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfigjobedgenode"></a>`node` | [`CiConfigJob`](#ciconfigjob) | The item at the end of the edge. |

#### `CiConfigNeedConnection`

The connection type for [`CiConfigNeed`](#ciconfigneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigneedconnectionedges"></a>`edges` | [`[CiConfigNeedEdge]`](#ciconfigneededge) | A list of edges. |
| <a id="ciconfigneedconnectionnodes"></a>`nodes` | [`[CiConfigNeed]`](#ciconfigneed) | A list of nodes. |
| <a id="ciconfigneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigNeedEdge`

The edge type for [`CiConfigNeed`](#ciconfigneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigneededgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfigneededgenode"></a>`node` | [`CiConfigNeed`](#ciconfigneed) | The item at the end of the edge. |

#### `CiConfigStageConnection`

The connection type for [`CiConfigStage`](#ciconfigstage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigstageconnectionedges"></a>`edges` | [`[CiConfigStageEdge]`](#ciconfigstageedge) | A list of edges. |
| <a id="ciconfigstageconnectionnodes"></a>`nodes` | [`[CiConfigStage]`](#ciconfigstage) | A list of nodes. |
| <a id="ciconfigstageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigStageEdge`

The edge type for [`CiConfigStage`](#ciconfigstage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigstageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfigstageedgenode"></a>`node` | [`CiConfigStage`](#ciconfigstage) | The item at the end of the edge. |

#### `CiGroupConnection`

The connection type for [`CiGroup`](#cigroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupconnectionedges"></a>`edges` | [`[CiGroupEdge]`](#cigroupedge) | A list of edges. |
| <a id="cigroupconnectionnodes"></a>`nodes` | [`[CiGroup]`](#cigroup) | A list of nodes. |
| <a id="cigroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiGroupEdge`

The edge type for [`CiGroup`](#cigroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cigroupedgenode"></a>`node` | [`CiGroup`](#cigroup) | The item at the end of the edge. |

#### `CiGroupVariableConnection`

The connection type for [`CiGroupVariable`](#cigroupvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupvariableconnectionedges"></a>`edges` | [`[CiGroupVariableEdge]`](#cigroupvariableedge) | A list of edges. |
| <a id="cigroupvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | Maximum amount of group CI/CD variables. |
| <a id="cigroupvariableconnectionnodes"></a>`nodes` | [`[CiGroupVariable]`](#cigroupvariable) | A list of nodes. |
| <a id="cigroupvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiGroupVariableEdge`

The edge type for [`CiGroupVariable`](#cigroupvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupvariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cigroupvariableedgenode"></a>`node` | [`CiGroupVariable`](#cigroupvariable) | The item at the end of the edge. |

#### `CiInstanceVariableConnection`

The connection type for [`CiInstanceVariable`](#ciinstancevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableconnectionedges"></a>`edges` | [`[CiInstanceVariableEdge]`](#ciinstancevariableedge) | A list of edges. |
| <a id="ciinstancevariableconnectionnodes"></a>`nodes` | [`[CiInstanceVariable]`](#ciinstancevariable) | A list of nodes. |
| <a id="ciinstancevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiInstanceVariableEdge`

The edge type for [`CiInstanceVariable`](#ciinstancevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciinstancevariableedgenode"></a>`node` | [`CiInstanceVariable`](#ciinstancevariable) | The item at the end of the edge. |

#### `CiJobArtifactConnection`

The connection type for [`CiJobArtifact`](#cijobartifact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobartifactconnectionedges"></a>`edges` | [`[CiJobArtifactEdge]`](#cijobartifactedge) | A list of edges. |
| <a id="cijobartifactconnectionnodes"></a>`nodes` | [`[CiJobArtifact]`](#cijobartifact) | A list of nodes. |
| <a id="cijobartifactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiJobArtifactEdge`

The edge type for [`CiJobArtifact`](#cijobartifact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobartifactedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobartifactedgenode"></a>`node` | [`CiJobArtifact`](#cijobartifact) | The item at the end of the edge. |

#### `CiJobConnection`

The connection type for [`CiJob`](#cijob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobconnectionedges"></a>`edges` | [`[CiJobEdge]`](#cijobedge) | A list of edges. |
| <a id="cijobconnectionnodes"></a>`nodes` | [`[CiJob]`](#cijob) | A list of nodes. |
| <a id="cijobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `CiJobConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `CiJobEdge`

The edge type for [`CiJob`](#cijob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobedgenode"></a>`node` | [`CiJob`](#cijob) | The item at the end of the edge. |

#### `CiManualVariableConnection`

The connection type for [`CiManualVariable`](#cimanualvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cimanualvariableconnectionedges"></a>`edges` | [`[CiManualVariableEdge]`](#cimanualvariableedge) | A list of edges. |
| <a id="cimanualvariableconnectionnodes"></a>`nodes` | [`[CiManualVariable]`](#cimanualvariable) | A list of nodes. |
| <a id="cimanualvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiManualVariableEdge`

The edge type for [`CiManualVariable`](#cimanualvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cimanualvariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cimanualvariableedgenode"></a>`node` | [`CiManualVariable`](#cimanualvariable) | The item at the end of the edge. |

#### `CiMinutesNamespaceMonthlyUsageConnection`

The connection type for [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesNamespaceMonthlyUsageEdge]`](#ciminutesnamespacemonthlyusageedge) | A list of edges. |
| <a id="ciminutesnamespacemonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesNamespaceMonthlyUsage]`](#ciminutesnamespacemonthlyusage) | A list of nodes. |
| <a id="ciminutesnamespacemonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiMinutesNamespaceMonthlyUsageEdge`

The edge type for [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciminutesnamespacemonthlyusageedgenode"></a>`node` | [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage) | The item at the end of the edge. |

#### `CiMinutesProjectMonthlyUsageConnection`

The connection type for [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesProjectMonthlyUsageEdge]`](#ciminutesprojectmonthlyusageedge) | A list of edges. |
| <a id="ciminutesprojectmonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesProjectMonthlyUsage]`](#ciminutesprojectmonthlyusage) | A list of nodes. |
| <a id="ciminutesprojectmonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiMinutesProjectMonthlyUsageEdge`

The edge type for [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciminutesprojectmonthlyusageedgenode"></a>`node` | [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage) | The item at the end of the edge. |

#### `CiProjectVariableConnection`

The connection type for [`CiProjectVariable`](#ciprojectvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableconnectionedges"></a>`edges` | [`[CiProjectVariableEdge]`](#ciprojectvariableedge) | A list of edges. |
| <a id="ciprojectvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | Maximum amount of project CI/CD variables. |
| <a id="ciprojectvariableconnectionnodes"></a>`nodes` | [`[CiProjectVariable]`](#ciprojectvariable) | A list of nodes. |
| <a id="ciprojectvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiProjectVariableEdge`

The edge type for [`CiProjectVariable`](#ciprojectvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciprojectvariableedgenode"></a>`node` | [`CiProjectVariable`](#ciprojectvariable) | The item at the end of the edge. |

#### `CiRunnerConnection`

The connection type for [`CiRunner`](#cirunner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cirunnerconnectionedges"></a>`edges` | [`[CiRunnerEdge]`](#cirunneredge) | A list of edges. |
| <a id="cirunnerconnectionjobsstatistics"></a>`jobsStatistics` | [`CiJobsStatistics`](#cijobsstatistics) | Jobs statistics for jobs executed by a collection of runners. Available only to admins. |
| <a id="cirunnerconnectionnodes"></a>`nodes` | [`[CiRunner]`](#cirunner) | A list of nodes. |
| <a id="cirunnerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiRunnerEdge`

The edge type for [`CiRunner`](#cirunner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunneredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cirunneredgeediturl"></a>`editUrl` | [`String`](#string) | Web URL of the runner edit page. The value depends on where you put this field in the query. You can use it for projects or groups. |
| <a id="cirunneredgenode"></a>`node` | [`CiRunner`](#cirunner) | The item at the end of the edge. |
| <a id="cirunneredgeweburl"></a>`webUrl` | [`String`](#string) | Web URL of the runner. The value depends on where you put this field in the query. You can use it for projects or groups. |

#### `CiRunnerManagerConnection`

The connection type for [`CiRunnerManager`](#cirunnermanager).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnermanagerconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cirunnermanagerconnectionedges"></a>`edges` | [`[CiRunnerManagerEdge]`](#cirunnermanageredge) | A list of edges. |
| <a id="cirunnermanagerconnectionnodes"></a>`nodes` | [`[CiRunnerManager]`](#cirunnermanager) | A list of nodes. |
| <a id="cirunnermanagerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiRunnerManagerEdge`

The edge type for [`CiRunnerManager`](#cirunnermanager).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnermanageredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cirunnermanageredgenode"></a>`node` | [`CiRunnerManager`](#cirunnermanager) | The item at the end of the edge. |

#### `CiSecureFileRegistryConnection`

The connection type for [`CiSecureFileRegistry`](#cisecurefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryconnectionedges"></a>`edges` | [`[CiSecureFileRegistryEdge]`](#cisecurefileregistryedge) | A list of edges. |
| <a id="cisecurefileregistryconnectionnodes"></a>`nodes` | [`[CiSecureFileRegistry]`](#cisecurefileregistry) | A list of nodes. |
| <a id="cisecurefileregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiSecureFileRegistryEdge`

The edge type for [`CiSecureFileRegistry`](#cisecurefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cisecurefileregistryedgenode"></a>`node` | [`CiSecureFileRegistry`](#cisecurefileregistry) | The item at the end of the edge. |

#### `CiStageConnection`

The connection type for [`CiStage`](#cistage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cistageconnectionedges"></a>`edges` | [`[CiStageEdge]`](#cistageedge) | A list of edges. |
| <a id="cistageconnectionnodes"></a>`nodes` | [`[CiStage]`](#cistage) | A list of nodes. |
| <a id="cistageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiStageEdge`

The edge type for [`CiStage`](#cistage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cistageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cistageedgenode"></a>`node` | [`CiStage`](#cistage) | The item at the end of the edge. |

#### `ClusterAgentActivityEventConnection`

The connection type for [`ClusterAgentActivityEvent`](#clusteragentactivityevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragentactivityeventconnectionedges"></a>`edges` | [`[ClusterAgentActivityEventEdge]`](#clusteragentactivityeventedge) | A list of edges. |
| <a id="clusteragentactivityeventconnectionnodes"></a>`nodes` | [`[ClusterAgentActivityEvent]`](#clusteragentactivityevent) | A list of nodes. |
| <a id="clusteragentactivityeventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentActivityEventEdge`

The edge type for [`ClusterAgentActivityEvent`](#clusteragentactivityevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentactivityeventedgenode"></a>`node` | [`ClusterAgentActivityEvent`](#clusteragentactivityevent) | The item at the end of the edge. |

#### `ClusterAgentAuthorizationCiAccessConnection`

The connection type for [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationCiAccessEdge]`](#clusteragentauthorizationciaccessedge) | A list of edges. |
| <a id="clusteragentauthorizationciaccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationCiAccess]`](#clusteragentauthorizationciaccess) | A list of nodes. |
| <a id="clusteragentauthorizationciaccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentAuthorizationCiAccessEdge`

The edge type for [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentauthorizationciaccessedgenode"></a>`node` | [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess) | The item at the end of the edge. |

#### `ClusterAgentAuthorizationUserAccessConnection`

The connection type for [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationUserAccessEdge]`](#clusteragentauthorizationuseraccessedge) | A list of edges. |
| <a id="clusteragentauthorizationuseraccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationUserAccess]`](#clusteragentauthorizationuseraccess) | A list of nodes. |
| <a id="clusteragentauthorizationuseraccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentAuthorizationUserAccessEdge`

The edge type for [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentauthorizationuseraccessedgenode"></a>`node` | [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess) | The item at the end of the edge. |

#### `ClusterAgentConnection`

The connection type for [`ClusterAgent`](#clusteragent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragentconnectionedges"></a>`edges` | [`[ClusterAgentEdge]`](#clusteragentedge) | A list of edges. |
| <a id="clusteragentconnectionnodes"></a>`nodes` | [`[ClusterAgent]`](#clusteragent) | A list of nodes. |
| <a id="clusteragentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentEdge`

The edge type for [`ClusterAgent`](#clusteragent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentedgenode"></a>`node` | [`ClusterAgent`](#clusteragent) | The item at the end of the edge. |

#### `ClusterAgentTokenConnection`

The connection type for [`ClusterAgentToken`](#clusteragenttoken).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragenttokenconnectionedges"></a>`edges` | [`[ClusterAgentTokenEdge]`](#clusteragenttokenedge) | A list of edges. |
| <a id="clusteragenttokenconnectionnodes"></a>`nodes` | [`[ClusterAgentToken]`](#clusteragenttoken) | A list of nodes. |
| <a id="clusteragenttokenconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentTokenEdge`

The edge type for [`ClusterAgentToken`](#clusteragenttoken).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragenttokenedgenode"></a>`node` | [`ClusterAgentToken`](#clusteragenttoken) | The item at the end of the edge. |

#### `CodeCoverageActivityConnection`

The connection type for [`CodeCoverageActivity`](#codecoverageactivity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityconnectionedges"></a>`edges` | [`[CodeCoverageActivityEdge]`](#codecoverageactivityedge) | A list of edges. |
| <a id="codecoverageactivityconnectionnodes"></a>`nodes` | [`[CodeCoverageActivity]`](#codecoverageactivity) | A list of nodes. |
| <a id="codecoverageactivityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CodeCoverageActivityEdge`

The edge type for [`CodeCoverageActivity`](#codecoverageactivity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="codecoverageactivityedgenode"></a>`node` | [`CodeCoverageActivity`](#codecoverageactivity) | The item at the end of the edge. |

#### `CodeQualityDegradationConnection`

The connection type for [`CodeQualityDegradation`](#codequalitydegradation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="codequalitydegradationconnectionedges"></a>`edges` | [`[CodeQualityDegradationEdge]`](#codequalitydegradationedge) | A list of edges. |
| <a id="codequalitydegradationconnectionnodes"></a>`nodes` | [`[CodeQualityDegradation]`](#codequalitydegradation) | A list of nodes. |
| <a id="codequalitydegradationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CodeQualityDegradationEdge`

The edge type for [`CodeQualityDegradation`](#codequalitydegradation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="codequalitydegradationedgenode"></a>`node` | [`CodeQualityDegradation`](#codequalitydegradation) | The item at the end of the edge. |

#### `CommitConnection`

The connection type for [`Commit`](#commit).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitconnectionedges"></a>`edges` | [`[CommitEdge]`](#commitedge) | A list of edges. |
| <a id="commitconnectionnodes"></a>`nodes` | [`[Commit]`](#commit) | A list of nodes. |
| <a id="commitconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CommitEdge`

The edge type for [`Commit`](#commit).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="commitedgenode"></a>`node` | [`Commit`](#commit) | The item at the end of the edge. |

#### `ComplianceFrameworkConnection`

The connection type for [`ComplianceFramework`](#complianceframework).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworkconnectionedges"></a>`edges` | [`[ComplianceFrameworkEdge]`](#complianceframeworkedge) | A list of edges. |
| <a id="complianceframeworkconnectionnodes"></a>`nodes` | [`[ComplianceFramework]`](#complianceframework) | A list of nodes. |
| <a id="complianceframeworkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceFrameworkEdge`

The edge type for [`ComplianceFramework`](#complianceframework).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="complianceframeworkedgenode"></a>`node` | [`ComplianceFramework`](#complianceframework) | The item at the end of the edge. |

#### `ComplianceViolationConnection`

The connection type for [`ComplianceViolation`](#complianceviolation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceviolationconnectionedges"></a>`edges` | [`[ComplianceViolationEdge]`](#complianceviolationedge) | A list of edges. |
| <a id="complianceviolationconnectionnodes"></a>`nodes` | [`[ComplianceViolation]`](#complianceviolation) | A list of nodes. |
| <a id="complianceviolationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceViolationEdge`

The edge type for [`ComplianceViolation`](#complianceviolation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceviolationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="complianceviolationedgenode"></a>`node` | [`ComplianceViolation`](#complianceviolation) | The item at the end of the edge. |

#### `ConnectedAgentConnection`

The connection type for [`ConnectedAgent`](#connectedagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="connectedagentconnectionedges"></a>`edges` | [`[ConnectedAgentEdge]`](#connectedagentedge) | A list of edges. |
| <a id="connectedagentconnectionnodes"></a>`nodes` | [`[ConnectedAgent]`](#connectedagent) | A list of nodes. |
| <a id="connectedagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ConnectedAgentEdge`

The edge type for [`ConnectedAgent`](#connectedagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="connectedagentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="connectedagentedgenode"></a>`node` | [`ConnectedAgent`](#connectedagent) | The item at the end of the edge. |

#### `ContainerRepositoryConnection`

The connection type for [`ContainerRepository`](#containerrepository).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryconnectionedges"></a>`edges` | [`[ContainerRepositoryEdge]`](#containerrepositoryedge) | A list of edges. |
| <a id="containerrepositoryconnectionnodes"></a>`nodes` | [`[ContainerRepository]`](#containerrepository) | A list of nodes. |
| <a id="containerrepositoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerRepositoryEdge`

The edge type for [`ContainerRepository`](#containerrepository).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerrepositoryedgenode"></a>`node` | [`ContainerRepository`](#containerrepository) | The item at the end of the edge. |

#### `ContainerRepositoryRegistryConnection`

The connection type for [`ContainerRepositoryRegistry`](#containerrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryconnectionedges"></a>`edges` | [`[ContainerRepositoryRegistryEdge]`](#containerrepositoryregistryedge) | A list of edges. |
| <a id="containerrepositoryregistryconnectionnodes"></a>`nodes` | [`[ContainerRepositoryRegistry]`](#containerrepositoryregistry) | A list of nodes. |
| <a id="containerrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerRepositoryRegistryEdge`

The edge type for [`ContainerRepositoryRegistry`](#containerrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerrepositoryregistryedgenode"></a>`node` | [`ContainerRepositoryRegistry`](#containerrepositoryregistry) | The item at the end of the edge. |

#### `ContainerRepositoryTagConnection`

The connection type for [`ContainerRepositoryTag`](#containerrepositorytag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagconnectionedges"></a>`edges` | [`[ContainerRepositoryTagEdge]`](#containerrepositorytagedge) | A list of edges. |
| <a id="containerrepositorytagconnectionnodes"></a>`nodes` | [`[ContainerRepositoryTag]`](#containerrepositorytag) | A list of nodes. |
| <a id="containerrepositorytagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerRepositoryTagEdge`

The edge type for [`ContainerRepositoryTag`](#containerrepositorytag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerrepositorytagedgenode"></a>`node` | [`ContainerRepositoryTag`](#containerrepositorytag) | The item at the end of the edge. |

#### `ContributionAnalyticsContributionConnection`

The connection type for [`ContributionAnalyticsContribution`](#contributionanalyticscontribution).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionconnectionedges"></a>`edges` | [`[ContributionAnalyticsContributionEdge]`](#contributionanalyticscontributionedge) | A list of edges. |
| <a id="contributionanalyticscontributionconnectionnodes"></a>`nodes` | [`[ContributionAnalyticsContribution]`](#contributionanalyticscontribution) | A list of nodes. |
| <a id="contributionanalyticscontributionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContributionAnalyticsContributionEdge`

The edge type for [`ContributionAnalyticsContribution`](#contributionanalyticscontribution).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="contributionanalyticscontributionedgenode"></a>`node` | [`ContributionAnalyticsContribution`](#contributionanalyticscontribution) | The item at the end of the edge. |

#### `CoverageFuzzingCorpusConnection`

The connection type for [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusconnectionedges"></a>`edges` | [`[CoverageFuzzingCorpusEdge]`](#coveragefuzzingcorpusedge) | A list of edges. |
| <a id="coveragefuzzingcorpusconnectionnodes"></a>`nodes` | [`[CoverageFuzzingCorpus]`](#coveragefuzzingcorpus) | A list of nodes. |
| <a id="coveragefuzzingcorpusconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CoverageFuzzingCorpusEdge`

The edge type for [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="coveragefuzzingcorpusedgenode"></a>`node` | [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus) | The item at the end of the edge. |

#### `CustomEmojiConnection`

The connection type for [`CustomEmoji`](#customemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customemojiconnectionedges"></a>`edges` | [`[CustomEmojiEdge]`](#customemojiedge) | A list of edges. |
| <a id="customemojiconnectionnodes"></a>`nodes` | [`[CustomEmoji]`](#customemoji) | A list of nodes. |
| <a id="customemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomEmojiEdge`

The edge type for [`CustomEmoji`](#customemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customemojiedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customemojiedgenode"></a>`node` | [`CustomEmoji`](#customemoji) | The item at the end of the edge. |

#### `CustomerRelationsContactConnection`

The connection type for [`CustomerRelationsContact`](#customerrelationscontact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactconnectionedges"></a>`edges` | [`[CustomerRelationsContactEdge]`](#customerrelationscontactedge) | A list of edges. |
| <a id="customerrelationscontactconnectionnodes"></a>`nodes` | [`[CustomerRelationsContact]`](#customerrelationscontact) | A list of nodes. |
| <a id="customerrelationscontactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomerRelationsContactEdge`

The edge type for [`CustomerRelationsContact`](#customerrelationscontact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customerrelationscontactedgenode"></a>`node` | [`CustomerRelationsContact`](#customerrelationscontact) | The item at the end of the edge. |

#### `CustomerRelationsOrganizationConnection`

The connection type for [`CustomerRelationsOrganization`](#customerrelationsorganization).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationconnectionedges"></a>`edges` | [`[CustomerRelationsOrganizationEdge]`](#customerrelationsorganizationedge) | A list of edges. |
| <a id="customerrelationsorganizationconnectionnodes"></a>`nodes` | [`[CustomerRelationsOrganization]`](#customerrelationsorganization) | A list of nodes. |
| <a id="customerrelationsorganizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomerRelationsOrganizationEdge`

The edge type for [`CustomerRelationsOrganization`](#customerrelationsorganization).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customerrelationsorganizationedgenode"></a>`node` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | The item at the end of the edge. |

#### `DastProfileConnection`

The connection type for [`DastProfile`](#dastprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprofileconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="dastprofileconnectionedges"></a>`edges` | [`[DastProfileEdge]`](#dastprofileedge) | A list of edges. |
| <a id="dastprofileconnectionnodes"></a>`nodes` | [`[DastProfile]`](#dastprofile) | A list of nodes. |
| <a id="dastprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DastProfileEdge`

The edge type for [`DastProfile`](#dastprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprofileedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dastprofileedgenode"></a>`node` | [`DastProfile`](#dastprofile) | The item at the end of the edge. |

#### `DastScannerProfileConnection`

The connection type for [`DastScannerProfile`](#dastscannerprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastscannerprofileconnectionedges"></a>`edges` | [`[DastScannerProfileEdge]`](#dastscannerprofileedge) | A list of edges. |
| <a id="dastscannerprofileconnectionnodes"></a>`nodes` | [`[DastScannerProfile]`](#dastscannerprofile) | A list of nodes. |
| <a id="dastscannerprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DastScannerProfileEdge`

The edge type for [`DastScannerProfile`](#dastscannerprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastscannerprofileedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dastscannerprofileedgenode"></a>`node` | [`DastScannerProfile`](#dastscannerprofile) | The item at the end of the edge. |

#### `DastSiteProfileConnection`

The connection type for [`DastSiteProfile`](#dastsiteprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileconnectionedges"></a>`edges` | [`[DastSiteProfileEdge]`](#dastsiteprofileedge) | A list of edges. |
| <a id="dastsiteprofileconnectionnodes"></a>`nodes` | [`[DastSiteProfile]`](#dastsiteprofile) | A list of nodes. |
| <a id="dastsiteprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DastSiteProfileEdge`

The edge type for [`DastSiteProfile`](#dastsiteprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dastsiteprofileedgenode"></a>`node` | [`DastSiteProfile`](#dastsiteprofile) | The item at the end of the edge. |

#### `DastSiteValidationConnection`

The connection type for [`DastSiteValidation`](#dastsitevalidation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsitevalidationconnectionedges"></a>`edges` | [`[DastSiteValidationEdge]`](#dastsitevalidationedge) | A list of edges. |
| <a id="dastsitevalidationconnectionnodes"></a>`nodes` | [`[DastSiteValidation]`](#dastsitevalidation) | A list of nodes. |
| <a id="dastsitevalidationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DastSiteValidationEdge`

The edge type for [`DastSiteValidation`](#dastsitevalidation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsitevalidationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dastsitevalidationedgenode"></a>`node` | [`DastSiteValidation`](#dastsitevalidation) | The item at the end of the edge. |

#### `DependencyConnection`

The connection type for [`Dependency`](#dependency).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyconnectionedges"></a>`edges` | [`[DependencyEdge]`](#dependencyedge) | A list of edges. |
| <a id="dependencyconnectionnodes"></a>`nodes` | [`[Dependency]`](#dependency) | A list of nodes. |
| <a id="dependencyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyEdge`

The edge type for [`Dependency`](#dependency).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyedgenode"></a>`node` | [`Dependency`](#dependency) | The item at the end of the edge. |

#### `DependencyProxyBlobConnection`

The connection type for [`DependencyProxyBlob`](#dependencyproxyblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobconnectionedges"></a>`edges` | [`[DependencyProxyBlobEdge]`](#dependencyproxyblobedge) | A list of edges. |
| <a id="dependencyproxyblobconnectionnodes"></a>`nodes` | [`[DependencyProxyBlob]`](#dependencyproxyblob) | A list of nodes. |
| <a id="dependencyproxyblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyProxyBlobEdge`

The edge type for [`DependencyProxyBlob`](#dependencyproxyblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyproxyblobedgenode"></a>`node` | [`DependencyProxyBlob`](#dependencyproxyblob) | The item at the end of the edge. |

#### `DependencyProxyBlobRegistryConnection`

The connection type for [`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryconnectionedges"></a>`edges` | [`[DependencyProxyBlobRegistryEdge]`](#dependencyproxyblobregistryedge) | A list of edges. |
| <a id="dependencyproxyblobregistryconnectionnodes"></a>`nodes` | [`[DependencyProxyBlobRegistry]`](#dependencyproxyblobregistry) | A list of nodes. |
| <a id="dependencyproxyblobregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyProxyBlobRegistryEdge`

The edge type for [`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyproxyblobregistryedgenode"></a>`node` | [`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry) | The item at the end of the edge. |

#### `DependencyProxyManifestConnection`

The connection type for [`DependencyProxyManifest`](#dependencyproxymanifest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestconnectionedges"></a>`edges` | [`[DependencyProxyManifestEdge]`](#dependencyproxymanifestedge) | A list of edges. |
| <a id="dependencyproxymanifestconnectionnodes"></a>`nodes` | [`[DependencyProxyManifest]`](#dependencyproxymanifest) | A list of nodes. |
| <a id="dependencyproxymanifestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyProxyManifestEdge`

The edge type for [`DependencyProxyManifest`](#dependencyproxymanifest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyproxymanifestedgenode"></a>`node` | [`DependencyProxyManifest`](#dependencyproxymanifest) | The item at the end of the edge. |

#### `DependencyProxyManifestRegistryConnection`

The connection type for [`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryconnectionedges"></a>`edges` | [`[DependencyProxyManifestRegistryEdge]`](#dependencyproxymanifestregistryedge) | A list of edges. |
| <a id="dependencyproxymanifestregistryconnectionnodes"></a>`nodes` | [`[DependencyProxyManifestRegistry]`](#dependencyproxymanifestregistry) | A list of nodes. |
| <a id="dependencyproxymanifestregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyProxyManifestRegistryEdge`

The edge type for [`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyproxymanifestregistryedgenode"></a>`node` | [`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry) | The item at the end of the edge. |

#### `DeploymentConnection`

The connection type for [`Deployment`](#deployment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deploymentconnectionedges"></a>`edges` | [`[DeploymentEdge]`](#deploymentedge) | A list of edges. |
| <a id="deploymentconnectionnodes"></a>`nodes` | [`[Deployment]`](#deployment) | A list of nodes. |
| <a id="deploymentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DeploymentEdge`

The edge type for [`Deployment`](#deployment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deploymentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="deploymentedgenode"></a>`node` | [`Deployment`](#deployment) | The item at the end of the edge. |

#### `DesignAtVersionConnection`

The connection type for [`DesignAtVersion`](#designatversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designatversionconnectionedges"></a>`edges` | [`[DesignAtVersionEdge]`](#designatversionedge) | A list of edges. |
| <a id="designatversionconnectionnodes"></a>`nodes` | [`[DesignAtVersion]`](#designatversion) | A list of nodes. |
| <a id="designatversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DesignAtVersionEdge`

The edge type for [`DesignAtVersion`](#designatversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designatversionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="designatversionedgenode"></a>`node` | [`DesignAtVersion`](#designatversion) | The item at the end of the edge. |

#### `DesignConnection`

The connection type for [`Design`](#design).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designconnectionedges"></a>`edges` | [`[DesignEdge]`](#designedge) | A list of edges. |
| <a id="designconnectionnodes"></a>`nodes` | [`[Design]`](#design) | A list of nodes. |
| <a id="designconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DesignEdge`

The edge type for [`Design`](#design).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="designedgenode"></a>`node` | [`Design`](#design) | The item at the end of the edge. |

#### `DesignManagementRepositoryRegistryConnection`

The connection type for [`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryconnectionedges"></a>`edges` | [`[DesignManagementRepositoryRegistryEdge]`](#designmanagementrepositoryregistryedge) | A list of edges. |
| <a id="designmanagementrepositoryregistryconnectionnodes"></a>`nodes` | [`[DesignManagementRepositoryRegistry]`](#designmanagementrepositoryregistry) | A list of nodes. |
| <a id="designmanagementrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DesignManagementRepositoryRegistryEdge`

The edge type for [`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="designmanagementrepositoryregistryedgenode"></a>`node` | [`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry) | The item at the end of the edge. |

#### `DesignVersionConnection`

The connection type for [`DesignVersion`](#designversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designversionconnectionedges"></a>`edges` | [`[DesignVersionEdge]`](#designversionedge) | A list of edges. |
| <a id="designversionconnectionnodes"></a>`nodes` | [`[DesignVersion]`](#designversion) | A list of nodes. |
| <a id="designversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DesignVersionEdge`

The edge type for [`DesignVersion`](#designversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designversionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="designversionedgenode"></a>`node` | [`DesignVersion`](#designversion) | The item at the end of the edge. |

#### `DevopsAdoptionEnabledNamespaceConnection`

The connection type for [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespaceconnectionedges"></a>`edges` | [`[DevopsAdoptionEnabledNamespaceEdge]`](#devopsadoptionenablednamespaceedge) | A list of edges. |
| <a id="devopsadoptionenablednamespaceconnectionnodes"></a>`nodes` | [`[DevopsAdoptionEnabledNamespace]`](#devopsadoptionenablednamespace) | A list of nodes. |
| <a id="devopsadoptionenablednamespaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DevopsAdoptionEnabledNamespaceEdge`

The edge type for [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespaceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="devopsadoptionenablednamespaceedgenode"></a>`node` | [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace) | The item at the end of the edge. |

#### `DevopsAdoptionSnapshotConnection`

The connection type for [`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionsnapshotconnectionedges"></a>`edges` | [`[DevopsAdoptionSnapshotEdge]`](#devopsadoptionsnapshotedge) | A list of edges. |
| <a id="devopsadoptionsnapshotconnectionnodes"></a>`nodes` | [`[DevopsAdoptionSnapshot]`](#devopsadoptionsnapshot) | A list of nodes. |
| <a id="devopsadoptionsnapshotconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DevopsAdoptionSnapshotEdge`

The edge type for [`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionsnapshotedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="devopsadoptionsnapshotedgenode"></a>`node` | [`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot) | The item at the end of the edge. |

#### `DiscussionConnection`

The connection type for [`Discussion`](#discussion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="discussionconnectionedges"></a>`edges` | [`[DiscussionEdge]`](#discussionedge) | A list of edges. |
| <a id="discussionconnectionnodes"></a>`nodes` | [`[Discussion]`](#discussion) | A list of nodes. |
| <a id="discussionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DiscussionEdge`

The edge type for [`Discussion`](#discussion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="discussionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="discussionedgenode"></a>`node` | [`Discussion`](#discussion) | The item at the end of the edge. |

#### `EgressNodeConnection`

The connection type for [`EgressNode`](#egressnode).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="egressnodeconnectionedges"></a>`edges` | [`[EgressNodeEdge]`](#egressnodeedge) | A list of edges. |
| <a id="egressnodeconnectionnodes"></a>`nodes` | [`[EgressNode]`](#egressnode) | A list of nodes. |
| <a id="egressnodeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EgressNodeEdge`

The edge type for [`EgressNode`](#egressnode).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="egressnodeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="egressnodeedgenode"></a>`node` | [`EgressNode`](#egressnode) | The item at the end of the edge. |

#### `EmailConnection`

The connection type for [`Email`](#email).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="emailconnectionedges"></a>`edges` | [`[EmailEdge]`](#emailedge) | A list of edges. |
| <a id="emailconnectionnodes"></a>`nodes` | [`[Email]`](#email) | A list of nodes. |
| <a id="emailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EmailEdge`

The edge type for [`Email`](#email).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="emailedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="emailedgenode"></a>`node` | [`Email`](#email) | The item at the end of the edge. |

#### `EnvironmentConnection`

The connection type for [`Environment`](#environment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="environmentconnectionedges"></a>`edges` | [`[EnvironmentEdge]`](#environmentedge) | A list of edges. |
| <a id="environmentconnectionnodes"></a>`nodes` | [`[Environment]`](#environment) | A list of nodes. |
| <a id="environmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EnvironmentEdge`

The edge type for [`Environment`](#environment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="environmentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="environmentedgenode"></a>`node` | [`Environment`](#environment) | The item at the end of the edge. |

#### `EpicBoardConnection`

The connection type for [`EpicBoard`](#epicboard).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicboardconnectionedges"></a>`edges` | [`[EpicBoardEdge]`](#epicboardedge) | A list of edges. |
| <a id="epicboardconnectionnodes"></a>`nodes` | [`[EpicBoard]`](#epicboard) | A list of nodes. |
| <a id="epicboardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EpicBoardEdge`

The edge type for [`EpicBoard`](#epicboard).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicboardedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="epicboardedgenode"></a>`node` | [`EpicBoard`](#epicboard) | The item at the end of the edge. |

#### `EpicConnection`

The connection type for [`Epic`](#epic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="epicconnectionedges"></a>`edges` | [`[EpicEdge]`](#epicedge) | A list of edges. |
| <a id="epicconnectionnodes"></a>`nodes` | [`[Epic]`](#epic) | A list of nodes. |
| <a id="epicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EpicEdge`

The edge type for [`Epic`](#epic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="epicedgenode"></a>`node` | [`Epic`](#epic) | The item at the end of the edge. |

#### `EpicIssueConnection`

The connection type for [`EpicIssue`](#epicissue).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicissueconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="epicissueconnectionedges"></a>`edges` | [`[EpicIssueEdge]`](#epicissueedge) | A list of edges. |
| <a id="epicissueconnectionnodes"></a>`nodes` | [`[EpicIssue]`](#epicissue) | A list of nodes. |
| <a id="epicissueconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="epicissueconnectionweight"></a>`weight` | [`Int!`](#int) | Total weight of issues collection. |

#### `EpicIssueEdge`

The edge type for [`EpicIssue`](#epicissue).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicissueedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="epicissueedgenode"></a>`node` | [`EpicIssue`](#epicissue) | The item at the end of the edge. |

#### `EpicListConnection`

The connection type for [`EpicList`](#epiclist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epiclistconnectionedges"></a>`edges` | [`[EpicListEdge]`](#epiclistedge) | A list of edges. |
| <a id="epiclistconnectionnodes"></a>`nodes` | [`[EpicList]`](#epiclist) | A list of nodes. |
| <a id="epiclistconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EpicListEdge`

The edge type for [`EpicList`](#epiclist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epiclistedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="epiclistedgenode"></a>`node` | [`EpicList`](#epiclist) | The item at the end of the edge. |

#### `EscalationPolicyTypeConnection`

The connection type for [`EscalationPolicyType`](#escalationpolicytype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="escalationpolicytypeconnectionedges"></a>`edges` | [`[EscalationPolicyTypeEdge]`](#escalationpolicytypeedge) | A list of edges. |
| <a id="escalationpolicytypeconnectionnodes"></a>`nodes` | [`[EscalationPolicyType]`](#escalationpolicytype) | A list of nodes. |
| <a id="escalationpolicytypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EscalationPolicyTypeEdge`

The edge type for [`EscalationPolicyType`](#escalationpolicytype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="escalationpolicytypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="escalationpolicytypeedgenode"></a>`node` | [`EscalationPolicyType`](#escalationpolicytype) | The item at the end of the edge. |

#### `EventConnection`

The connection type for [`Event`](#event).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="eventconnectionedges"></a>`edges` | [`[EventEdge]`](#eventedge) | A list of edges. |
| <a id="eventconnectionnodes"></a>`nodes` | [`[Event]`](#event) | A list of nodes. |
| <a id="eventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EventEdge`

The edge type for [`Event`](#event).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="eventedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="eventedgenode"></a>`node` | [`Event`](#event) | The item at the end of the edge. |

#### `ExternalAuditEventDestinationConnection`

The connection type for [`ExternalAuditEventDestination`](#externalauditeventdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalauditeventdestinationconnectionedges"></a>`edges` | [`[ExternalAuditEventDestinationEdge]`](#externalauditeventdestinationedge) | A list of edges. |
| <a id="externalauditeventdestinationconnectionnodes"></a>`nodes` | [`[ExternalAuditEventDestination]`](#externalauditeventdestination) | A list of nodes. |
| <a id="externalauditeventdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ExternalAuditEventDestinationEdge`

The edge type for [`ExternalAuditEventDestination`](#externalauditeventdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalauditeventdestinationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="externalauditeventdestinationedgenode"></a>`node` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | The item at the end of the edge. |

#### `ExternalStatusCheckConnection`

The connection type for [`ExternalStatusCheck`](#externalstatuscheck).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalstatuscheckconnectionedges"></a>`edges` | [`[ExternalStatusCheckEdge]`](#externalstatuscheckedge) | A list of edges. |
| <a id="externalstatuscheckconnectionnodes"></a>`nodes` | [`[ExternalStatusCheck]`](#externalstatuscheck) | A list of nodes. |
| <a id="externalstatuscheckconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ExternalStatusCheckEdge`

The edge type for [`ExternalStatusCheck`](#externalstatuscheck).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalstatuscheckedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="externalstatuscheckedgenode"></a>`node` | [`ExternalStatusCheck`](#externalstatuscheck) | The item at the end of the edge. |

#### `ForecastDatapointConnection`

The connection type for [`ForecastDatapoint`](#forecastdatapoint).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="forecastdatapointconnectionedges"></a>`edges` | [`[ForecastDatapointEdge]`](#forecastdatapointedge) | A list of edges. |
| <a id="forecastdatapointconnectionnodes"></a>`nodes` | [`[ForecastDatapoint]`](#forecastdatapoint) | A list of nodes. |
| <a id="forecastdatapointconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ForecastDatapointEdge`

The edge type for [`ForecastDatapoint`](#forecastdatapoint).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="forecastdatapointedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="forecastdatapointedgenode"></a>`node` | [`ForecastDatapoint`](#forecastdatapoint) | The item at the end of the edge. |

#### `GroupConnection`

The connection type for [`Group`](#group).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupconnectionedges"></a>`edges` | [`[GroupEdge]`](#groupedge) | A list of edges. |
| <a id="groupconnectionnodes"></a>`nodes` | [`[Group]`](#group) | A list of nodes. |
| <a id="groupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GroupEdge`

The edge type for [`Group`](#group).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="groupedgenode"></a>`node` | [`Group`](#group) | The item at the end of the edge. |

#### `GroupMemberConnection`

The connection type for [`GroupMember`](#groupmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupmemberconnectionedges"></a>`edges` | [`[GroupMemberEdge]`](#groupmemberedge) | A list of edges. |
| <a id="groupmemberconnectionnodes"></a>`nodes` | [`[GroupMember]`](#groupmember) | A list of nodes. |
| <a id="groupmemberconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GroupMemberEdge`

The edge type for [`GroupMember`](#groupmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupmemberedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="groupmemberedgenode"></a>`node` | [`GroupMember`](#groupmember) | The item at the end of the edge. |

#### `GroupWikiRepositoryRegistryConnection`

The connection type for [`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryconnectionedges"></a>`edges` | [`[GroupWikiRepositoryRegistryEdge]`](#groupwikirepositoryregistryedge) | A list of edges. |
| <a id="groupwikirepositoryregistryconnectionnodes"></a>`nodes` | [`[GroupWikiRepositoryRegistry]`](#groupwikirepositoryregistry) | A list of nodes. |
| <a id="groupwikirepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GroupWikiRepositoryRegistryEdge`

The edge type for [`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="groupwikirepositoryregistryedgenode"></a>`node` | [`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry) | The item at the end of the edge. |

#### `IncidentManagementOncallRotationConnection`

The connection type for [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationconnectionedges"></a>`edges` | [`[IncidentManagementOncallRotationEdge]`](#incidentmanagementoncallrotationedge) | A list of edges. |
| <a id="incidentmanagementoncallrotationconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallRotation]`](#incidentmanagementoncallrotation) | A list of nodes. |
| <a id="incidentmanagementoncallrotationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IncidentManagementOncallRotationEdge`

The edge type for [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="incidentmanagementoncallrotationedgenode"></a>`node` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | The item at the end of the edge. |

#### `IncidentManagementOncallScheduleConnection`

The connection type for [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallscheduleconnectionedges"></a>`edges` | [`[IncidentManagementOncallScheduleEdge]`](#incidentmanagementoncallscheduleedge) | A list of edges. |
| <a id="incidentmanagementoncallscheduleconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallSchedule]`](#incidentmanagementoncallschedule) | A list of nodes. |
| <a id="incidentmanagementoncallscheduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IncidentManagementOncallScheduleEdge`

The edge type for [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallscheduleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="incidentmanagementoncallscheduleedgenode"></a>`node` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | The item at the end of the edge. |

#### `IncidentManagementOncallShiftConnection`

The connection type for [`IncidentManagementOncallShift`](#incidentmanagementoncallshift).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallshiftconnectionedges"></a>`edges` | [`[IncidentManagementOncallShiftEdge]`](#incidentmanagementoncallshiftedge) | A list of edges. |
| <a id="incidentmanagementoncallshiftconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallShift]`](#incidentmanagementoncallshift) | A list of nodes. |
| <a id="incidentmanagementoncallshiftconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IncidentManagementOncallShiftEdge`

The edge type for [`IncidentManagementOncallShift`](#incidentmanagementoncallshift).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallshiftedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="incidentmanagementoncallshiftedgenode"></a>`node` | [`IncidentManagementOncallShift`](#incidentmanagementoncallshift) | The item at the end of the edge. |

#### `InheritedCiVariableConnection`

The connection type for [`InheritedCiVariable`](#inheritedcivariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="inheritedcivariableconnectionedges"></a>`edges` | [`[InheritedCiVariableEdge]`](#inheritedcivariableedge) | A list of edges. |
| <a id="inheritedcivariableconnectionnodes"></a>`nodes` | [`[InheritedCiVariable]`](#inheritedcivariable) | A list of nodes. |
| <a id="inheritedcivariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `InheritedCiVariableEdge`

The edge type for [`InheritedCiVariable`](#inheritedcivariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="inheritedcivariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="inheritedcivariableedgenode"></a>`node` | [`InheritedCiVariable`](#inheritedcivariable) | The item at the end of the edge. |

#### `InstanceExternalAuditEventDestinationConnection`

The connection type for [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instanceexternalauditeventdestinationconnectionedges"></a>`edges` | [`[InstanceExternalAuditEventDestinationEdge]`](#instanceexternalauditeventdestinationedge) | A list of edges. |
| <a id="instanceexternalauditeventdestinationconnectionnodes"></a>`nodes` | [`[InstanceExternalAuditEventDestination]`](#instanceexternalauditeventdestination) | A list of nodes. |
| <a id="instanceexternalauditeventdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `InstanceExternalAuditEventDestinationEdge`

The edge type for [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instanceexternalauditeventdestinationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="instanceexternalauditeventdestinationedgenode"></a>`node` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | The item at the end of the edge. |

#### `IssuableResourceLinkConnection`

The connection type for [`IssuableResourceLink`](#issuableresourcelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuableresourcelinkconnectionedges"></a>`edges` | [`[IssuableResourceLinkEdge]`](#issuableresourcelinkedge) | A list of edges. |
| <a id="issuableresourcelinkconnectionnodes"></a>`nodes` | [`[IssuableResourceLink]`](#issuableresourcelink) | A list of nodes. |
| <a id="issuableresourcelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IssuableResourceLinkEdge`

The edge type for [`IssuableResourceLink`](#issuableresourcelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuableresourcelinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="issuableresourcelinkedgenode"></a>`node` | [`IssuableResourceLink`](#issuableresourcelink) | The item at the end of the edge. |

#### `IssueConnection`

The connection type for [`Issue`](#issue).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issueconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="issueconnectionedges"></a>`edges` | [`[IssueEdge]`](#issueedge) | A list of edges. |
| <a id="issueconnectionnodes"></a>`nodes` | [`[Issue]`](#issue) | A list of nodes. |
| <a id="issueconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="issueconnectionweight"></a>`weight` | [`Int!`](#int) | Total weight of issues collection. |

#### `IssueEdge`

The edge type for [`Issue`](#issue).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issueedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="issueedgenode"></a>`node` | [`Issue`](#issue) | The item at the end of the edge. |

#### `IterationCadenceConnection`

The connection type for [`IterationCadence`](#iterationcadence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationcadenceconnectionedges"></a>`edges` | [`[IterationCadenceEdge]`](#iterationcadenceedge) | A list of edges. |
| <a id="iterationcadenceconnectionnodes"></a>`nodes` | [`[IterationCadence]`](#iterationcadence) | A list of nodes. |
| <a id="iterationcadenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IterationCadenceEdge`

The edge type for [`IterationCadence`](#iterationcadence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationcadenceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="iterationcadenceedgenode"></a>`node` | [`IterationCadence`](#iterationcadence) | The item at the end of the edge. |

#### `IterationConnection`

The connection type for [`Iteration`](#iteration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationconnectionedges"></a>`edges` | [`[IterationEdge]`](#iterationedge) | A list of edges. |
| <a id="iterationconnectionnodes"></a>`nodes` | [`[Iteration]`](#iteration) | A list of nodes. |
| <a id="iterationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IterationEdge`

The edge type for [`Iteration`](#iteration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="iterationedgenode"></a>`node` | [`Iteration`](#iteration) | The item at the end of the edge. |

#### `JiraImportConnection`

The connection type for [`JiraImport`](#jiraimport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraimportconnectionedges"></a>`edges` | [`[JiraImportEdge]`](#jiraimportedge) | A list of edges. |
| <a id="jiraimportconnectionnodes"></a>`nodes` | [`[JiraImport]`](#jiraimport) | A list of nodes. |
| <a id="jiraimportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `JiraImportEdge`

The edge type for [`JiraImport`](#jiraimport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraimportedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="jiraimportedgenode"></a>`node` | [`JiraImport`](#jiraimport) | The item at the end of the edge. |

#### `JiraProjectConnection`

The connection type for [`JiraProject`](#jiraproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraprojectconnectionedges"></a>`edges` | [`[JiraProjectEdge]`](#jiraprojectedge) | A list of edges. |
| <a id="jiraprojectconnectionnodes"></a>`nodes` | [`[JiraProject]`](#jiraproject) | A list of nodes. |
| <a id="jiraprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `JiraProjectEdge`

The edge type for [`JiraProject`](#jiraproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraprojectedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="jiraprojectedgenode"></a>`node` | [`JiraProject`](#jiraproject) | The item at the end of the edge. |

#### `JobArtifactRegistryConnection`

The connection type for [`JobArtifactRegistry`](#jobartifactregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryconnectionedges"></a>`edges` | [`[JobArtifactRegistryEdge]`](#jobartifactregistryedge) | A list of edges. |
| <a id="jobartifactregistryconnectionnodes"></a>`nodes` | [`[JobArtifactRegistry]`](#jobartifactregistry) | A list of nodes. |
| <a id="jobartifactregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `JobArtifactRegistryEdge`

The edge type for [`JobArtifactRegistry`](#jobartifactregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="jobartifactregistryedgenode"></a>`node` | [`JobArtifactRegistry`](#jobartifactregistry) | The item at the end of the edge. |

#### `JobNeedUnionConnection`

The connection type for [`JobNeedUnion`](#jobneedunion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobneedunionconnectionedges"></a>`edges` | [`[JobNeedUnionEdge]`](#jobneedunionedge) | A list of edges. |
| <a id="jobneedunionconnectionnodes"></a>`nodes` | [`[JobNeedUnion]`](#jobneedunion) | A list of nodes. |
| <a id="jobneedunionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `JobNeedUnionEdge`

The edge type for [`JobNeedUnion`](#jobneedunion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobneedunionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="jobneedunionedgenode"></a>`node` | [`JobNeedUnion`](#jobneedunion) | The item at the end of the edge. |

#### `LabelConnection`

The connection type for [`Label`](#label).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="labelconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="labelconnectionedges"></a>`edges` | [`[LabelEdge]`](#labeledge) | A list of edges. |
| <a id="labelconnectionnodes"></a>`nodes` | [`[Label]`](#label) | A list of nodes. |
| <a id="labelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `LabelEdge`

The edge type for [`Label`](#label).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="labeledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="labeledgenode"></a>`node` | [`Label`](#label) | The item at the end of the edge. |

#### `LfsObjectRegistryConnection`

The connection type for [`LfsObjectRegistry`](#lfsobjectregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryconnectionedges"></a>`edges` | [`[LfsObjectRegistryEdge]`](#lfsobjectregistryedge) | A list of edges. |
| <a id="lfsobjectregistryconnectionnodes"></a>`nodes` | [`[LfsObjectRegistry]`](#lfsobjectregistry) | A list of nodes. |
| <a id="lfsobjectregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `LfsObjectRegistryEdge`

The edge type for [`LfsObjectRegistry`](#lfsobjectregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="lfsobjectregistryedgenode"></a>`node` | [`LfsObjectRegistry`](#lfsobjectregistry) | The item at the end of the edge. |

#### `LicenseHistoryEntryConnection`

The connection type for [`LicenseHistoryEntry`](#licensehistoryentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="licensehistoryentryconnectionedges"></a>`edges` | [`[LicenseHistoryEntryEdge]`](#licensehistoryentryedge) | A list of edges. |
| <a id="licensehistoryentryconnectionnodes"></a>`nodes` | [`[LicenseHistoryEntry]`](#licensehistoryentry) | A list of nodes. |
| <a id="licensehistoryentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `LicenseHistoryEntryEdge`

The edge type for [`LicenseHistoryEntry`](#licensehistoryentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="licensehistoryentryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="licensehistoryentryedgenode"></a>`node` | [`LicenseHistoryEntry`](#licensehistoryentry) | The item at the end of the edge. |

#### `MemberInterfaceConnection`

The connection type for [`MemberInterface`](#memberinterface).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="memberinterfaceconnectionedges"></a>`edges` | [`[MemberInterfaceEdge]`](#memberinterfaceedge) | A list of edges. |
| <a id="memberinterfaceconnectionnodes"></a>`nodes` | [`[MemberInterface]`](#memberinterface) | A list of nodes. |
| <a id="memberinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MemberInterfaceEdge`

The edge type for [`MemberInterface`](#memberinterface).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="memberinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="memberinterfaceedgenode"></a>`node` | [`MemberInterface`](#memberinterface) | The item at the end of the edge. |

#### `MergeAccessLevelConnection`

The connection type for [`MergeAccessLevel`](#mergeaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergeaccesslevelconnectionedges"></a>`edges` | [`[MergeAccessLevelEdge]`](#mergeaccessleveledge) | A list of edges. |
| <a id="mergeaccesslevelconnectionnodes"></a>`nodes` | [`[MergeAccessLevel]`](#mergeaccesslevel) | A list of nodes. |
| <a id="mergeaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeAccessLevelEdge`

The edge type for [`MergeAccessLevel`](#mergeaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergeaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergeaccessleveledgenode"></a>`node` | [`MergeAccessLevel`](#mergeaccesslevel) | The item at the end of the edge. |

#### `MergeRequestAssigneeConnection`

The connection type for [`MergeRequestAssignee`](#mergerequestassignee).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeconnectionedges"></a>`edges` | [`[MergeRequestAssigneeEdge]`](#mergerequestassigneeedge) | A list of edges. |
| <a id="mergerequestassigneeconnectionnodes"></a>`nodes` | [`[MergeRequestAssignee]`](#mergerequestassignee) | A list of nodes. |
| <a id="mergerequestassigneeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestAssigneeEdge`

The edge type for [`MergeRequestAssignee`](#mergerequestassignee).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestassigneeedgenode"></a>`node` | [`MergeRequestAssignee`](#mergerequestassignee) | The item at the end of the edge. |

#### `MergeRequestConnection`

The connection type for [`MergeRequest`](#mergerequest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="mergerequestconnectionedges"></a>`edges` | [`[MergeRequestEdge]`](#mergerequestedge) | A list of edges. |
| <a id="mergerequestconnectionnodes"></a>`nodes` | [`[MergeRequest]`](#mergerequest) | A list of nodes. |
| <a id="mergerequestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="mergerequestconnectiontotaltimetomerge"></a>`totalTimeToMerge` | [`Float`](#float) | Total sum of time to merge, in seconds, for the collection of merge requests. |

#### `MergeRequestDiffRegistryConnection`

The connection type for [`MergeRequestDiffRegistry`](#mergerequestdiffregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryconnectionedges"></a>`edges` | [`[MergeRequestDiffRegistryEdge]`](#mergerequestdiffregistryedge) | A list of edges. |
| <a id="mergerequestdiffregistryconnectionnodes"></a>`nodes` | [`[MergeRequestDiffRegistry]`](#mergerequestdiffregistry) | A list of nodes. |
| <a id="mergerequestdiffregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestDiffRegistryEdge`

The edge type for [`MergeRequestDiffRegistry`](#mergerequestdiffregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestdiffregistryedgenode"></a>`node` | [`MergeRequestDiffRegistry`](#mergerequestdiffregistry) | The item at the end of the edge. |

#### `MergeRequestEdge`

The edge type for [`MergeRequest`](#mergerequest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestedgenode"></a>`node` | [`MergeRequest`](#mergerequest) | The item at the end of the edge. |

#### `MergeRequestParticipantConnection`

The connection type for [`MergeRequestParticipant`](#mergerequestparticipant).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestparticipantconnectionedges"></a>`edges` | [`[MergeRequestParticipantEdge]`](#mergerequestparticipantedge) | A list of edges. |
| <a id="mergerequestparticipantconnectionnodes"></a>`nodes` | [`[MergeRequestParticipant]`](#mergerequestparticipant) | A list of nodes. |
| <a id="mergerequestparticipantconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestParticipantEdge`

The edge type for [`MergeRequestParticipant`](#mergerequestparticipant).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestparticipantedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestparticipantedgenode"></a>`node` | [`MergeRequestParticipant`](#mergerequestparticipant) | The item at the end of the edge. |

#### `MergeRequestReviewerConnection`

The connection type for [`MergeRequestReviewer`](#mergerequestreviewer).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestreviewerconnectionedges"></a>`edges` | [`[MergeRequestReviewerEdge]`](#mergerequestrevieweredge) | A list of edges. |
| <a id="mergerequestreviewerconnectionnodes"></a>`nodes` | [`[MergeRequestReviewer]`](#mergerequestreviewer) | A list of nodes. |
| <a id="mergerequestreviewerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestReviewerEdge`

The edge type for [`MergeRequestReviewer`](#mergerequestreviewer).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestrevieweredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestrevieweredgenode"></a>`node` | [`MergeRequestReviewer`](#mergerequestreviewer) | The item at the end of the edge. |

#### `MetricsDashboardAnnotationConnection`

The connection type for [`MetricsDashboardAnnotation`](#metricsdashboardannotation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="metricsdashboardannotationconnectionedges"></a>`edges` | [`[MetricsDashboardAnnotationEdge]`](#metricsdashboardannotationedge) | A list of edges. |
| <a id="metricsdashboardannotationconnectionnodes"></a>`nodes` | [`[MetricsDashboardAnnotation]`](#metricsdashboardannotation) | A list of nodes. |
| <a id="metricsdashboardannotationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MetricsDashboardAnnotationEdge`

The edge type for [`MetricsDashboardAnnotation`](#metricsdashboardannotation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="metricsdashboardannotationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="metricsdashboardannotationedgenode"></a>`node` | [`MetricsDashboardAnnotation`](#metricsdashboardannotation) | The item at the end of the edge. |

#### `MilestoneConnection`

The connection type for [`Milestone`](#milestone).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="milestoneconnectionedges"></a>`edges` | [`[MilestoneEdge]`](#milestoneedge) | A list of edges. |
| <a id="milestoneconnectionnodes"></a>`nodes` | [`[Milestone]`](#milestone) | A list of nodes. |
| <a id="milestoneconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MilestoneEdge`

The edge type for [`Milestone`](#milestone).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="milestoneedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="milestoneedgenode"></a>`node` | [`Milestone`](#milestone) | The item at the end of the edge. |

#### `NamespaceCommitEmailConnection`

The connection type for [`NamespaceCommitEmail`](#namespacecommitemail).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="namespacecommitemailconnectionedges"></a>`edges` | [`[NamespaceCommitEmailEdge]`](#namespacecommitemailedge) | A list of edges. |
| <a id="namespacecommitemailconnectionnodes"></a>`nodes` | [`[NamespaceCommitEmail]`](#namespacecommitemail) | A list of nodes. |
| <a id="namespacecommitemailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `NamespaceCommitEmailEdge`

The edge type for [`NamespaceCommitEmail`](#namespacecommitemail).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="namespacecommitemailedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="namespacecommitemailedgenode"></a>`node` | [`NamespaceCommitEmail`](#namespacecommitemail) | The item at the end of the edge. |

#### `NamespaceConnection`

The connection type for [`Namespace`](#namespace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="namespaceconnectionedges"></a>`edges` | [`[NamespaceEdge]`](#namespaceedge) | A list of edges. |
| <a id="namespaceconnectionnodes"></a>`nodes` | [`[Namespace]`](#namespace) | A list of nodes. |
| <a id="namespaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `NamespaceEdge`

The edge type for [`Namespace`](#namespace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="namespaceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="namespaceedgenode"></a>`node` | [`Namespace`](#namespace) | The item at the end of the edge. |

#### `NestedEnvironmentConnection`

The connection type for [`NestedEnvironment`](#nestedenvironment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="nestedenvironmentconnectionedges"></a>`edges` | [`[NestedEnvironmentEdge]`](#nestedenvironmentedge) | A list of edges. |
| <a id="nestedenvironmentconnectionnodes"></a>`nodes` | [`[NestedEnvironment]`](#nestedenvironment) | A list of nodes. |
| <a id="nestedenvironmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `NestedEnvironmentEdge`

The edge type for [`NestedEnvironment`](#nestedenvironment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="nestedenvironmentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="nestedenvironmentedgenode"></a>`node` | [`NestedEnvironment`](#nestedenvironment) | The item at the end of the edge. |

#### `NetworkPolicyConnection`

The connection type for [`NetworkPolicy`](#networkpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="networkpolicyconnectionedges"></a>`edges` | [`[NetworkPolicyEdge]`](#networkpolicyedge) | A list of edges. |
| <a id="networkpolicyconnectionnodes"></a>`nodes` | [`[NetworkPolicy]`](#networkpolicy) | A list of nodes. |
| <a id="networkpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `NetworkPolicyEdge`

The edge type for [`NetworkPolicy`](#networkpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="networkpolicyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="networkpolicyedgenode"></a>`node` | [`NetworkPolicy`](#networkpolicy) | The item at the end of the edge. |

#### `NoteConnection`

The connection type for [`Note`](#note).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="noteconnectionedges"></a>`edges` | [`[NoteEdge]`](#noteedge) | A list of edges. |
| <a id="noteconnectionnodes"></a>`nodes` | [`[Note]`](#note) | A list of nodes. |
| <a id="noteconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `NoteEdge`

The edge type for [`Note`](#note).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="noteedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="noteedgenode"></a>`node` | [`Note`](#note) | The item at the end of the edge. |

#### `OncallParticipantTypeConnection`

The connection type for [`OncallParticipantType`](#oncallparticipanttype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="oncallparticipanttypeconnectionedges"></a>`edges` | [`[OncallParticipantTypeEdge]`](#oncallparticipanttypeedge) | A list of edges. |
| <a id="oncallparticipanttypeconnectionnodes"></a>`nodes` | [`[OncallParticipantType]`](#oncallparticipanttype) | A list of nodes. |
| <a id="oncallparticipanttypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `OncallParticipantTypeEdge`

The edge type for [`OncallParticipantType`](#oncallparticipanttype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="oncallparticipanttypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="oncallparticipanttypeedgenode"></a>`node` | [`OncallParticipantType`](#oncallparticipanttype) | The item at the end of the edge. |

#### `PackageBaseConnection`

The connection type for [`PackageBase`](#packagebase).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagebaseconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="packagebaseconnectionedges"></a>`edges` | [`[PackageBaseEdge]`](#packagebaseedge) | A list of edges. |
| <a id="packagebaseconnectionnodes"></a>`nodes` | [`[PackageBase]`](#packagebase) | A list of nodes. |
| <a id="packagebaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageBaseEdge`

The edge type for [`PackageBase`](#packagebase).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagebaseedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagebaseedgenode"></a>`node` | [`PackageBase`](#packagebase) | The item at the end of the edge. |

#### `PackageConnection`

The connection type for [`Package`](#package).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packageconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="packageconnectionedges"></a>`edges` | [`[PackageEdge]`](#packageedge) | A list of edges. |
| <a id="packageconnectionnodes"></a>`nodes` | [`[Package]`](#package) | A list of nodes. |
| <a id="packageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageDependencyLinkConnection`

The connection type for [`PackageDependencyLink`](#packagedependencylink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagedependencylinkconnectionedges"></a>`edges` | [`[PackageDependencyLinkEdge]`](#packagedependencylinkedge) | A list of edges. |
| <a id="packagedependencylinkconnectionnodes"></a>`nodes` | [`[PackageDependencyLink]`](#packagedependencylink) | A list of nodes. |
| <a id="packagedependencylinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageDependencyLinkEdge`

The edge type for [`PackageDependencyLink`](#packagedependencylink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagedependencylinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagedependencylinkedgenode"></a>`node` | [`PackageDependencyLink`](#packagedependencylink) | The item at the end of the edge. |

#### `PackageEdge`

The edge type for [`Package`](#package).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packageedgenode"></a>`node` | [`Package`](#package) | The item at the end of the edge. |

#### `PackageFileConnection`

The connection type for [`PackageFile`](#packagefile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagefileconnectionedges"></a>`edges` | [`[PackageFileEdge]`](#packagefileedge) | A list of edges. |
| <a id="packagefileconnectionnodes"></a>`nodes` | [`[PackageFile]`](#packagefile) | A list of nodes. |
| <a id="packagefileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageFileEdge`

The edge type for [`PackageFile`](#packagefile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagefileedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagefileedgenode"></a>`node` | [`PackageFile`](#packagefile) | The item at the end of the edge. |

#### `PackageFileRegistryConnection`

The connection type for [`PackageFileRegistry`](#packagefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagefileregistryconnectionedges"></a>`edges` | [`[PackageFileRegistryEdge]`](#packagefileregistryedge) | A list of edges. |
| <a id="packagefileregistryconnectionnodes"></a>`nodes` | [`[PackageFileRegistry]`](#packagefileregistry) | A list of nodes. |
| <a id="packagefileregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageFileRegistryEdge`

The edge type for [`PackageFileRegistry`](#packagefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagefileregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagefileregistryedgenode"></a>`node` | [`PackageFileRegistry`](#packagefileregistry) | The item at the end of the edge. |

#### `PackageTagConnection`

The connection type for [`PackageTag`](#packagetag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagetagconnectionedges"></a>`edges` | [`[PackageTagEdge]`](#packagetagedge) | A list of edges. |
| <a id="packagetagconnectionnodes"></a>`nodes` | [`[PackageTag]`](#packagetag) | A list of nodes. |
| <a id="packagetagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageTagEdge`

The edge type for [`PackageTag`](#packagetag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagetagedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagetagedgenode"></a>`node` | [`PackageTag`](#packagetag) | The item at the end of the edge. |

#### `PagesDeploymentRegistryConnection`

The connection type for [`PagesDeploymentRegistry`](#pagesdeploymentregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryconnectionedges"></a>`edges` | [`[PagesDeploymentRegistryEdge]`](#pagesdeploymentregistryedge) | A list of edges. |
| <a id="pagesdeploymentregistryconnectionnodes"></a>`nodes` | [`[PagesDeploymentRegistry]`](#pagesdeploymentregistry) | A list of nodes. |
| <a id="pagesdeploymentregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PagesDeploymentRegistryEdge`

The edge type for [`PagesDeploymentRegistry`](#pagesdeploymentregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pagesdeploymentregistryedgenode"></a>`node` | [`PagesDeploymentRegistry`](#pagesdeploymentregistry) | The item at the end of the edge. |

#### `PathLockConnection`

The connection type for [`PathLock`](#pathlock).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pathlockconnectionedges"></a>`edges` | [`[PathLockEdge]`](#pathlockedge) | A list of edges. |
| <a id="pathlockconnectionnodes"></a>`nodes` | [`[PathLock]`](#pathlock) | A list of nodes. |
| <a id="pathlockconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PathLockEdge`

The edge type for [`PathLock`](#pathlock).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pathlockedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pathlockedgenode"></a>`node` | [`PathLock`](#pathlock) | The item at the end of the edge. |

#### `PipelineArtifactRegistryConnection`

The connection type for [`PipelineArtifactRegistry`](#pipelineartifactregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryconnectionedges"></a>`edges` | [`[PipelineArtifactRegistryEdge]`](#pipelineartifactregistryedge) | A list of edges. |
| <a id="pipelineartifactregistryconnectionnodes"></a>`nodes` | [`[PipelineArtifactRegistry]`](#pipelineartifactregistry) | A list of nodes. |
| <a id="pipelineartifactregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineArtifactRegistryEdge`

The edge type for [`PipelineArtifactRegistry`](#pipelineartifactregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelineartifactregistryedgenode"></a>`node` | [`PipelineArtifactRegistry`](#pipelineartifactregistry) | The item at the end of the edge. |

#### `PipelineConnection`

The connection type for [`Pipeline`](#pipeline).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="pipelineconnectionedges"></a>`edges` | [`[PipelineEdge]`](#pipelineedge) | A list of edges. |
| <a id="pipelineconnectionnodes"></a>`nodes` | [`[Pipeline]`](#pipeline) | A list of nodes. |
| <a id="pipelineconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineEdge`

The edge type for [`Pipeline`](#pipeline).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelineedgenode"></a>`node` | [`Pipeline`](#pipeline) | The item at the end of the edge. |

#### `PipelineScheduleConnection`

The connection type for [`PipelineSchedule`](#pipelineschedule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinescheduleconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="pipelinescheduleconnectionedges"></a>`edges` | [`[PipelineScheduleEdge]`](#pipelinescheduleedge) | A list of edges. |
| <a id="pipelinescheduleconnectionnodes"></a>`nodes` | [`[PipelineSchedule]`](#pipelineschedule) | A list of nodes. |
| <a id="pipelinescheduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineScheduleEdge`

The edge type for [`PipelineSchedule`](#pipelineschedule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinescheduleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelinescheduleedgenode"></a>`node` | [`PipelineSchedule`](#pipelineschedule) | The item at the end of the edge. |

#### `PipelineScheduleVariableConnection`

The connection type for [`PipelineScheduleVariable`](#pipelineschedulevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineschedulevariableconnectionedges"></a>`edges` | [`[PipelineScheduleVariableEdge]`](#pipelineschedulevariableedge) | A list of edges. |
| <a id="pipelineschedulevariableconnectionnodes"></a>`nodes` | [`[PipelineScheduleVariable]`](#pipelineschedulevariable) | A list of nodes. |
| <a id="pipelineschedulevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineScheduleVariableEdge`

The edge type for [`PipelineScheduleVariable`](#pipelineschedulevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineschedulevariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelineschedulevariableedgenode"></a>`node` | [`PipelineScheduleVariable`](#pipelineschedulevariable) | The item at the end of the edge. |

#### `PipelineSecurityReportFindingConnection`

The connection type for [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinesecurityreportfindingconnectionedges"></a>`edges` | [`[PipelineSecurityReportFindingEdge]`](#pipelinesecurityreportfindingedge) | A list of edges. |
| <a id="pipelinesecurityreportfindingconnectionnodes"></a>`nodes` | [`[PipelineSecurityReportFinding]`](#pipelinesecurityreportfinding) | A list of nodes. |
| <a id="pipelinesecurityreportfindingconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineSecurityReportFindingEdge`

The edge type for [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinesecurityreportfindingedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelinesecurityreportfindingedgenode"></a>`node` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | The item at the end of the edge. |

#### `ProductAnalyticsDashboardConnection`

The connection type for [`ProductAnalyticsDashboard`](#productanalyticsdashboard).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="productanalyticsdashboardconnectionedges"></a>`edges` | [`[ProductAnalyticsDashboardEdge]`](#productanalyticsdashboardedge) | A list of edges. |
| <a id="productanalyticsdashboardconnectionnodes"></a>`nodes` | [`[ProductAnalyticsDashboard]`](#productanalyticsdashboard) | A list of nodes. |
| <a id="productanalyticsdashboardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProductAnalyticsDashboardEdge`

The edge type for [`ProductAnalyticsDashboard`](#productanalyticsdashboard).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="productanalyticsdashboardedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="productanalyticsdashboardedgenode"></a>`node` | [`ProductAnalyticsDashboard`](#productanalyticsdashboard) | The item at the end of the edge. |

#### `ProductAnalyticsDashboardPanelConnection`

The connection type for [`ProductAnalyticsDashboardPanel`](#productanalyticsdashboardpanel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="productanalyticsdashboardpanelconnectionedges"></a>`edges` | [`[ProductAnalyticsDashboardPanelEdge]`](#productanalyticsdashboardpaneledge) | A list of edges. |
| <a id="productanalyticsdashboardpanelconnectionnodes"></a>`nodes` | [`[ProductAnalyticsDashboardPanel]`](#productanalyticsdashboardpanel) | A list of nodes. |
| <a id="productanalyticsdashboardpanelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProductAnalyticsDashboardPanelEdge`

The edge type for [`ProductAnalyticsDashboardPanel`](#productanalyticsdashboardpanel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="productanalyticsdashboardpaneledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="productanalyticsdashboardpaneledgenode"></a>`node` | [`ProductAnalyticsDashboardPanel`](#productanalyticsdashboardpanel) | The item at the end of the edge. |

#### `ProjectConnection`

The connection type for [`Project`](#project).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="projectconnectionedges"></a>`edges` | [`[ProjectEdge]`](#projectedge) | A list of edges. |
| <a id="projectconnectionnodes"></a>`nodes` | [`[Project]`](#project) | A list of nodes. |
| <a id="projectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProjectEdge`

The edge type for [`Project`](#project).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="projectedgenode"></a>`node` | [`Project`](#project) | The item at the end of the edge. |

#### `ProjectMemberConnection`

The connection type for [`ProjectMember`](#projectmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectmemberconnectionedges"></a>`edges` | [`[ProjectMemberEdge]`](#projectmemberedge) | A list of edges. |
| <a id="projectmemberconnectionnodes"></a>`nodes` | [`[ProjectMember]`](#projectmember) | A list of nodes. |
| <a id="projectmemberconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProjectMemberEdge`

The edge type for [`ProjectMember`](#projectmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectmemberedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="projectmemberedgenode"></a>`node` | [`ProjectMember`](#projectmember) | The item at the end of the edge. |

#### `ProjectWikiRepositoryRegistryConnection`

The connection type for [`ProjectWikiRepositoryRegistry`](#projectwikirepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectwikirepositoryregistryconnectionedges"></a>`edges` | [`[ProjectWikiRepositoryRegistryEdge]`](#projectwikirepositoryregistryedge) | A list of edges. |
| <a id="projectwikirepositoryregistryconnectionnodes"></a>`nodes` | [`[ProjectWikiRepositoryRegistry]`](#projectwikirepositoryregistry) | A list of nodes. |
| <a id="projectwikirepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProjectWikiRepositoryRegistryEdge`

The edge type for [`ProjectWikiRepositoryRegistry`](#projectwikirepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectwikirepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="projectwikirepositoryregistryedgenode"></a>`node` | [`ProjectWikiRepositoryRegistry`](#projectwikirepositoryregistry) | The item at the end of the edge. |

#### `ProtectedEnvironmentApprovalRuleConnection`

The connection type for [`ProtectedEnvironmentApprovalRule`](#protectedenvironmentapprovalrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentapprovalruleconnectionedges"></a>`edges` | [`[ProtectedEnvironmentApprovalRuleEdge]`](#protectedenvironmentapprovalruleedge) | A list of edges. |
| <a id="protectedenvironmentapprovalruleconnectionnodes"></a>`nodes` | [`[ProtectedEnvironmentApprovalRule]`](#protectedenvironmentapprovalrule) | A list of nodes. |
| <a id="protectedenvironmentapprovalruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProtectedEnvironmentApprovalRuleEdge`

The edge type for [`ProtectedEnvironmentApprovalRule`](#protectedenvironmentapprovalrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentapprovalruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="protectedenvironmentapprovalruleedgenode"></a>`node` | [`ProtectedEnvironmentApprovalRule`](#protectedenvironmentapprovalrule) | The item at the end of the edge. |

#### `ProtectedEnvironmentConnection`

The connection type for [`ProtectedEnvironment`](#protectedenvironment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentconnectionedges"></a>`edges` | [`[ProtectedEnvironmentEdge]`](#protectedenvironmentedge) | A list of edges. |
| <a id="protectedenvironmentconnectionnodes"></a>`nodes` | [`[ProtectedEnvironment]`](#protectedenvironment) | A list of nodes. |
| <a id="protectedenvironmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProtectedEnvironmentDeployAccessLevelConnection`

The connection type for [`ProtectedEnvironmentDeployAccessLevel`](#protectedenvironmentdeployaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentdeployaccesslevelconnectionedges"></a>`edges` | [`[ProtectedEnvironmentDeployAccessLevelEdge]`](#protectedenvironmentdeployaccessleveledge) | A list of edges. |
| <a id="protectedenvironmentdeployaccesslevelconnectionnodes"></a>`nodes` | [`[ProtectedEnvironmentDeployAccessLevel]`](#protectedenvironmentdeployaccesslevel) | A list of nodes. |
| <a id="protectedenvironmentdeployaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProtectedEnvironmentDeployAccessLevelEdge`

The edge type for [`ProtectedEnvironmentDeployAccessLevel`](#protectedenvironmentdeployaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentdeployaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="protectedenvironmentdeployaccessleveledgenode"></a>`node` | [`ProtectedEnvironmentDeployAccessLevel`](#protectedenvironmentdeployaccesslevel) | The item at the end of the edge. |

#### `ProtectedEnvironmentEdge`

The edge type for [`ProtectedEnvironment`](#protectedenvironment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="protectedenvironmentedgenode"></a>`node` | [`ProtectedEnvironment`](#protectedenvironment) | The item at the end of the edge. |

#### `PushAccessLevelConnection`

The connection type for [`PushAccessLevel`](#pushaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pushaccesslevelconnectionedges"></a>`edges` | [`[PushAccessLevelEdge]`](#pushaccessleveledge) | A list of edges. |
| <a id="pushaccesslevelconnectionnodes"></a>`nodes` | [`[PushAccessLevel]`](#pushaccesslevel) | A list of nodes. |
| <a id="pushaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PushAccessLevelEdge`

The edge type for [`PushAccessLevel`](#pushaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pushaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pushaccessleveledgenode"></a>`node` | [`PushAccessLevel`](#pushaccesslevel) | The item at the end of the edge. |

#### `ReleaseAssetLinkConnection`

The connection type for [`ReleaseAssetLink`](#releaseassetlink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseassetlinkconnectionedges"></a>`edges` | [`[ReleaseAssetLinkEdge]`](#releaseassetlinkedge) | A list of edges. |
| <a id="releaseassetlinkconnectionnodes"></a>`nodes` | [`[ReleaseAssetLink]`](#releaseassetlink) | A list of nodes. |
| <a id="releaseassetlinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ReleaseAssetLinkEdge`

The edge type for [`ReleaseAssetLink`](#releaseassetlink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseassetlinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="releaseassetlinkedgenode"></a>`node` | [`ReleaseAssetLink`](#releaseassetlink) | The item at the end of the edge. |

#### `ReleaseConnection`

The connection type for [`Release`](#release).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="releaseconnectionedges"></a>`edges` | [`[ReleaseEdge]`](#releaseedge) | A list of edges. |
| <a id="releaseconnectionnodes"></a>`nodes` | [`[Release]`](#release) | A list of nodes. |
| <a id="releaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ReleaseEdge`

The edge type for [`Release`](#release).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="releaseedgenode"></a>`node` | [`Release`](#release) | The item at the end of the edge. |

#### `ReleaseEvidenceConnection`

The connection type for [`ReleaseEvidence`](#releaseevidence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseevidenceconnectionedges"></a>`edges` | [`[ReleaseEvidenceEdge]`](#releaseevidenceedge) | A list of edges. |
| <a id="releaseevidenceconnectionnodes"></a>`nodes` | [`[ReleaseEvidence]`](#releaseevidence) | A list of nodes. |
| <a id="releaseevidenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ReleaseEvidenceEdge`

The edge type for [`ReleaseEvidence`](#releaseevidence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseevidenceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="releaseevidenceedgenode"></a>`node` | [`ReleaseEvidence`](#releaseevidence) | The item at the end of the edge. |

#### `ReleaseSourceConnection`

The connection type for [`ReleaseSource`](#releasesource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releasesourceconnectionedges"></a>`edges` | [`[ReleaseSourceEdge]`](#releasesourceedge) | A list of edges. |
| <a id="releasesourceconnectionnodes"></a>`nodes` | [`[ReleaseSource]`](#releasesource) | A list of nodes. |
| <a id="releasesourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ReleaseSourceEdge`

The edge type for [`ReleaseSource`](#releasesource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releasesourceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="releasesourceedgenode"></a>`node` | [`ReleaseSource`](#releasesource) | The item at the end of the edge. |

#### `RepositoryBlobConnection`

The connection type for [`RepositoryBlob`](#repositoryblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="repositoryblobconnectionedges"></a>`edges` | [`[RepositoryBlobEdge]`](#repositoryblobedge) | A list of edges. |
| <a id="repositoryblobconnectionnodes"></a>`nodes` | [`[RepositoryBlob]`](#repositoryblob) | A list of nodes. |
| <a id="repositoryblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `RepositoryBlobEdge`

The edge type for [`RepositoryBlob`](#repositoryblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="repositoryblobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="repositoryblobedgenode"></a>`node` | [`RepositoryBlob`](#repositoryblob) | The item at the end of the edge. |

#### `RequirementConnection`

The connection type for [`Requirement`](#requirement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="requirementconnectionedges"></a>`edges` | [`[RequirementEdge]`](#requirementedge) | A list of edges. |
| <a id="requirementconnectionnodes"></a>`nodes` | [`[Requirement]`](#requirement) | A list of nodes. |
| <a id="requirementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `RequirementEdge`

The edge type for [`Requirement`](#requirement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="requirementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="requirementedgenode"></a>`node` | [`Requirement`](#requirement) | The item at the end of the edge. |

#### `RunnerArchitectureConnection`

The connection type for [`RunnerArchitecture`](#runnerarchitecture).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="runnerarchitectureconnectionedges"></a>`edges` | [`[RunnerArchitectureEdge]`](#runnerarchitectureedge) | A list of edges. |
| <a id="runnerarchitectureconnectionnodes"></a>`nodes` | [`[RunnerArchitecture]`](#runnerarchitecture) | A list of nodes. |
| <a id="runnerarchitectureconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `RunnerArchitectureEdge`

The edge type for [`RunnerArchitecture`](#runnerarchitecture).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="runnerarchitectureedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="runnerarchitectureedgenode"></a>`node` | [`RunnerArchitecture`](#runnerarchitecture) | The item at the end of the edge. |

#### `RunnerPlatformConnection`

The connection type for [`RunnerPlatform`](#runnerplatform).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="runnerplatformconnectionedges"></a>`edges` | [`[RunnerPlatformEdge]`](#runnerplatformedge) | A list of edges. |
| <a id="runnerplatformconnectionnodes"></a>`nodes` | [`[RunnerPlatform]`](#runnerplatform) | A list of nodes. |
| <a id="runnerplatformconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `RunnerPlatformEdge`

The edge type for [`RunnerPlatform`](#runnerplatform).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="runnerplatformedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="runnerplatformedgenode"></a>`node` | [`RunnerPlatform`](#runnerplatform) | The item at the end of the edge. |

#### `SastCiConfigurationAnalyzersEntityConnection`

The connection type for [`SastCiConfigurationAnalyzersEntity`](#sastciconfigurationanalyzersentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationanalyzersentityconnectionedges"></a>`edges` | [`[SastCiConfigurationAnalyzersEntityEdge]`](#sastciconfigurationanalyzersentityedge) | A list of edges. |
| <a id="sastciconfigurationanalyzersentityconnectionnodes"></a>`nodes` | [`[SastCiConfigurationAnalyzersEntity]`](#sastciconfigurationanalyzersentity) | A list of nodes. |
| <a id="sastciconfigurationanalyzersentityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SastCiConfigurationAnalyzersEntityEdge`

The edge type for [`SastCiConfigurationAnalyzersEntity`](#sastciconfigurationanalyzersentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationanalyzersentityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="sastciconfigurationanalyzersentityedgenode"></a>`node` | [`SastCiConfigurationAnalyzersEntity`](#sastciconfigurationanalyzersentity) | The item at the end of the edge. |

#### `SastCiConfigurationEntityConnection`

The connection type for [`SastCiConfigurationEntity`](#sastciconfigurationentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationentityconnectionedges"></a>`edges` | [`[SastCiConfigurationEntityEdge]`](#sastciconfigurationentityedge) | A list of edges. |
| <a id="sastciconfigurationentityconnectionnodes"></a>`nodes` | [`[SastCiConfigurationEntity]`](#sastciconfigurationentity) | A list of nodes. |
| <a id="sastciconfigurationentityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SastCiConfigurationEntityEdge`

The edge type for [`SastCiConfigurationEntity`](#sastciconfigurationentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationentityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="sastciconfigurationentityedgenode"></a>`node` | [`SastCiConfigurationEntity`](#sastciconfigurationentity) | The item at the end of the edge. |

#### `SastCiConfigurationOptionsEntityConnection`

The connection type for [`SastCiConfigurationOptionsEntity`](#sastciconfigurationoptionsentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationoptionsentityconnectionedges"></a>`edges` | [`[SastCiConfigurationOptionsEntityEdge]`](#sastciconfigurationoptionsentityedge) | A list of edges. |
| <a id="sastciconfigurationoptionsentityconnectionnodes"></a>`nodes` | [`[SastCiConfigurationOptionsEntity]`](#sastciconfigurationoptionsentity) | A list of nodes. |
| <a id="sastciconfigurationoptionsentityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SastCiConfigurationOptionsEntityEdge`

The edge type for [`SastCiConfigurationOptionsEntity`](#sastciconfigurationoptionsentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationoptionsentityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="sastciconfigurationoptionsentityedgenode"></a>`node` | [`SastCiConfigurationOptionsEntity`](#sastciconfigurationoptionsentity) | The item at the end of the edge. |

#### `SavedReplyConnection`

The connection type for [`SavedReply`](#savedreply).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="savedreplyconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="savedreplyconnectionedges"></a>`edges` | [`[SavedReplyEdge]`](#savedreplyedge) | A list of edges. |
| <a id="savedreplyconnectionnodes"></a>`nodes` | [`[SavedReply]`](#savedreply) | A list of nodes. |
| <a id="savedreplyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SavedReplyEdge`

The edge type for [`SavedReply`](#savedreply).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="savedreplyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="savedreplyedgenode"></a>`node` | [`SavedReply`](#savedreply) | The item at the end of the edge. |

#### `ScanConnection`

The connection type for [`Scan`](#scan).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanconnectionedges"></a>`edges` | [`[ScanEdge]`](#scanedge) | A list of edges. |
| <a id="scanconnectionnodes"></a>`nodes` | [`[Scan]`](#scan) | A list of nodes. |
| <a id="scanconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ScanEdge`

The edge type for [`Scan`](#scan).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="scanedgenode"></a>`node` | [`Scan`](#scan) | The item at the end of the edge. |

#### `ScanExecutionPolicyConnection`

The connection type for [`ScanExecutionPolicy`](#scanexecutionpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanexecutionpolicyconnectionedges"></a>`edges` | [`[ScanExecutionPolicyEdge]`](#scanexecutionpolicyedge) | A list of edges. |
| <a id="scanexecutionpolicyconnectionnodes"></a>`nodes` | [`[ScanExecutionPolicy]`](#scanexecutionpolicy) | A list of nodes. |
| <a id="scanexecutionpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ScanExecutionPolicyEdge`

The edge type for [`ScanExecutionPolicy`](#scanexecutionpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanexecutionpolicyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="scanexecutionpolicyedgenode"></a>`node` | [`ScanExecutionPolicy`](#scanexecutionpolicy) | The item at the end of the edge. |

#### `ScanResultPolicyConnection`

The connection type for [`ScanResultPolicy`](#scanresultpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanresultpolicyconnectionedges"></a>`edges` | [`[ScanResultPolicyEdge]`](#scanresultpolicyedge) | A list of edges. |
| <a id="scanresultpolicyconnectionnodes"></a>`nodes` | [`[ScanResultPolicy]`](#scanresultpolicy) | A list of nodes. |
| <a id="scanresultpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ScanResultPolicyEdge`

The edge type for [`ScanResultPolicy`](#scanresultpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanresultpolicyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="scanresultpolicyedgenode"></a>`node` | [`ScanResultPolicy`](#scanresultpolicy) | The item at the end of the edge. |

#### `ScannedResourceConnection`

The connection type for [`ScannedResource`](#scannedresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scannedresourceconnectionedges"></a>`edges` | [`[ScannedResourceEdge]`](#scannedresourceedge) | A list of edges. |
| <a id="scannedresourceconnectionnodes"></a>`nodes` | [`[ScannedResource]`](#scannedresource) | A list of nodes. |
| <a id="scannedresourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ScannedResourceEdge`

The edge type for [`ScannedResource`](#scannedresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scannedresourceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="scannedresourceedgenode"></a>`node` | [`ScannedResource`](#scannedresource) | The item at the end of the edge. |

#### `SentryErrorConnection`

The connection type for [`SentryError`](#sentryerror).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sentryerrorconnectionedges"></a>`edges` | [`[SentryErrorEdge]`](#sentryerroredge) | A list of edges. |
| <a id="sentryerrorconnectionnodes"></a>`nodes` | [`[SentryError]`](#sentryerror) | A list of nodes. |
| <a id="sentryerrorconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SentryErrorEdge`

The edge type for [`SentryError`](#sentryerror).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sentryerroredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="sentryerroredgenode"></a>`node` | [`SentryError`](#sentryerror) | The item at the end of the edge. |

#### `ServiceConnection`

The connection type for [`Service`](#service).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="serviceconnectionedges"></a>`edges` | [`[ServiceEdge]`](#serviceedge) | A list of edges. |
| <a id="serviceconnectionnodes"></a>`nodes` | [`[Service]`](#service) | A list of nodes. |
| <a id="serviceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ServiceEdge`

The edge type for [`Service`](#service).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="serviceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="serviceedgenode"></a>`node` | [`Service`](#service) | The item at the end of the edge. |

#### `SnippetBlobConnection`

The connection type for [`SnippetBlob`](#snippetblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetblobconnectionedges"></a>`edges` | [`[SnippetBlobEdge]`](#snippetblobedge) | A list of edges. |
| <a id="snippetblobconnectionhasunretrievableblobs"></a>`hasUnretrievableBlobs` | [`Boolean!`](#boolean) | Indicates if the snippet has unretrievable blobs. |
| <a id="snippetblobconnectionnodes"></a>`nodes` | [`[SnippetBlob]`](#snippetblob) | A list of nodes. |
| <a id="snippetblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SnippetBlobEdge`

The edge type for [`SnippetBlob`](#snippetblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetblobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="snippetblobedgenode"></a>`node` | [`SnippetBlob`](#snippetblob) | The item at the end of the edge. |

#### `SnippetConnection`

The connection type for [`Snippet`](#snippet).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetconnectionedges"></a>`edges` | [`[SnippetEdge]`](#snippetedge) | A list of edges. |
| <a id="snippetconnectionnodes"></a>`nodes` | [`[Snippet]`](#snippet) | A list of nodes. |
| <a id="snippetconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SnippetEdge`

The edge type for [`Snippet`](#snippet).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="snippetedgenode"></a>`node` | [`Snippet`](#snippet) | The item at the end of the edge. |

#### `SnippetRepositoryRegistryConnection`

The connection type for [`SnippetRepositoryRegistry`](#snippetrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetrepositoryregistryconnectionedges"></a>`edges` | [`[SnippetRepositoryRegistryEdge]`](#snippetrepositoryregistryedge) | A list of edges. |
| <a id="snippetrepositoryregistryconnectionnodes"></a>`nodes` | [`[SnippetRepositoryRegistry]`](#snippetrepositoryregistry) | A list of nodes. |
| <a id="snippetrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SnippetRepositoryRegistryEdge`

The edge type for [`SnippetRepositoryRegistry`](#snippetrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="snippetrepositoryregistryedgenode"></a>`node` | [`SnippetRepositoryRegistry`](#snippetrepositoryregistry) | The item at the end of the edge. |

#### `SubmoduleConnection`

The connection type for [`Submodule`](#submodule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="submoduleconnectionedges"></a>`edges` | [`[SubmoduleEdge]`](#submoduleedge) | A list of edges. |
| <a id="submoduleconnectionnodes"></a>`nodes` | [`[Submodule]`](#submodule) | A list of nodes. |
| <a id="submoduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SubmoduleEdge`

The edge type for [`Submodule`](#submodule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="submoduleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="submoduleedgenode"></a>`node` | [`Submodule`](#submodule) | The item at the end of the edge. |

#### `SubscriptionFutureEntryConnection`

The connection type for [`SubscriptionFutureEntry`](#subscriptionfutureentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="subscriptionfutureentryconnectionedges"></a>`edges` | [`[SubscriptionFutureEntryEdge]`](#subscriptionfutureentryedge) | A list of edges. |
| <a id="subscriptionfutureentryconnectionnodes"></a>`nodes` | [`[SubscriptionFutureEntry]`](#subscriptionfutureentry) | A list of nodes. |
| <a id="subscriptionfutureentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SubscriptionFutureEntryEdge`

The edge type for [`SubscriptionFutureEntry`](#subscriptionfutureentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="subscriptionfutureentryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="subscriptionfutureentryedgenode"></a>`node` | [`SubscriptionFutureEntry`](#subscriptionfutureentry) | The item at the end of the edge. |

#### `TerraformStateConnection`

The connection type for [`TerraformState`](#terraformstate).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="terraformstateconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="terraformstateconnectionedges"></a>`edges` | [`[TerraformStateEdge]`](#terraformstateedge) | A list of edges. |
| <a id="terraformstateconnectionnodes"></a>`nodes` | [`[TerraformState]`](#terraformstate) | A list of nodes. |
| <a id="terraformstateconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TerraformStateEdge`

The edge type for [`TerraformState`](#terraformstate).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="terraformstateedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="terraformstateedgenode"></a>`node` | [`TerraformState`](#terraformstate) | The item at the end of the edge. |

#### `TerraformStateVersionRegistryConnection`

The connection type for [`TerraformStateVersionRegistry`](#terraformstateversionregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="terraformstateversionregistryconnectionedges"></a>`edges` | [`[TerraformStateVersionRegistryEdge]`](#terraformstateversionregistryedge) | A list of edges. |
| <a id="terraformstateversionregistryconnectionnodes"></a>`nodes` | [`[TerraformStateVersionRegistry]`](#terraformstateversionregistry) | A list of nodes. |
| <a id="terraformstateversionregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TerraformStateVersionRegistryEdge`

The edge type for [`TerraformStateVersionRegistry`](#terraformstateversionregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="terraformstateversionregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="terraformstateversionregistryedgenode"></a>`node` | [`TerraformStateVersionRegistry`](#terraformstateversionregistry) | The item at the end of the edge. |

#### `TestCaseConnection`

The connection type for [`TestCase`](#testcase).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testcaseconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="testcaseconnectionedges"></a>`edges` | [`[TestCaseEdge]`](#testcaseedge) | A list of edges. |
| <a id="testcaseconnectionnodes"></a>`nodes` | [`[TestCase]`](#testcase) | A list of nodes. |
| <a id="testcaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TestCaseEdge`

The edge type for [`TestCase`](#testcase).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testcaseedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="testcaseedgenode"></a>`node` | [`TestCase`](#testcase) | The item at the end of the edge. |

#### `TestReportConnection`

The connection type for [`TestReport`](#testreport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testreportconnectionedges"></a>`edges` | [`[TestReportEdge]`](#testreportedge) | A list of edges. |
| <a id="testreportconnectionnodes"></a>`nodes` | [`[TestReport]`](#testreport) | A list of nodes. |
| <a id="testreportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TestReportEdge`

The edge type for [`TestReport`](#testreport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testreportedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="testreportedgenode"></a>`node` | [`TestReport`](#testreport) | The item at the end of the edge. |

#### `TestSuiteSummaryConnection`

The connection type for [`TestSuiteSummary`](#testsuitesummary).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testsuitesummaryconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="testsuitesummaryconnectionedges"></a>`edges` | [`[TestSuiteSummaryEdge]`](#testsuitesummaryedge) | A list of edges. |
| <a id="testsuitesummaryconnectionnodes"></a>`nodes` | [`[TestSuiteSummary]`](#testsuitesummary) | A list of nodes. |
| <a id="testsuitesummaryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TestSuiteSummaryEdge`

The edge type for [`TestSuiteSummary`](#testsuitesummary).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testsuitesummaryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="testsuitesummaryedgenode"></a>`node` | [`TestSuiteSummary`](#testsuitesummary) | The item at the end of the edge. |

#### `TimeTrackingTimelogCategoryConnection`

The connection type for [`TimeTrackingTimelogCategory`](#timetrackingtimelogcategory).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timetrackingtimelogcategoryconnectionedges"></a>`edges` | [`[TimeTrackingTimelogCategoryEdge]`](#timetrackingtimelogcategoryedge) | A list of edges. |
| <a id="timetrackingtimelogcategoryconnectionnodes"></a>`nodes` | [`[TimeTrackingTimelogCategory]`](#timetrackingtimelogcategory) | A list of nodes. |
| <a id="timetrackingtimelogcategoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TimeTrackingTimelogCategoryEdge`

The edge type for [`TimeTrackingTimelogCategory`](#timetrackingtimelogcategory).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timetrackingtimelogcategoryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="timetrackingtimelogcategoryedgenode"></a>`node` | [`TimeTrackingTimelogCategory`](#timetrackingtimelogcategory) | The item at the end of the edge. |

#### `TimelineEventTagTypeConnection`

The connection type for [`TimelineEventTagType`](#timelineeventtagtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelineeventtagtypeconnectionedges"></a>`edges` | [`[TimelineEventTagTypeEdge]`](#timelineeventtagtypeedge) | A list of edges. |
| <a id="timelineeventtagtypeconnectionnodes"></a>`nodes` | [`[TimelineEventTagType]`](#timelineeventtagtype) | A list of nodes. |
| <a id="timelineeventtagtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TimelineEventTagTypeEdge`

The edge type for [`TimelineEventTagType`](#timelineeventtagtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelineeventtagtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="timelineeventtagtypeedgenode"></a>`node` | [`TimelineEventTagType`](#timelineeventtagtype) | The item at the end of the edge. |

#### `TimelineEventTypeConnection`

The connection type for [`TimelineEventType`](#timelineeventtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelineeventtypeconnectionedges"></a>`edges` | [`[TimelineEventTypeEdge]`](#timelineeventtypeedge) | A list of edges. |
| <a id="timelineeventtypeconnectionnodes"></a>`nodes` | [`[TimelineEventType]`](#timelineeventtype) | A list of nodes. |
| <a id="timelineeventtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TimelineEventTypeEdge`

The edge type for [`TimelineEventType`](#timelineeventtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelineeventtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="timelineeventtypeedgenode"></a>`node` | [`TimelineEventType`](#timelineeventtype) | The item at the end of the edge. |

#### `TimelogConnection`

The connection type for [`Timelog`](#timelog).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelogconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="timelogconnectionedges"></a>`edges` | [`[TimelogEdge]`](#timelogedge) | A list of edges. |
| <a id="timelogconnectionnodes"></a>`nodes` | [`[Timelog]`](#timelog) | A list of nodes. |
| <a id="timelogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="timelogconnectiontotalspenttime"></a>`totalSpentTime` | [`BigInt!`](#bigint) | Total time spent in seconds. |

#### `TimelogEdge`

The edge type for [`Timelog`](#timelog).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelogedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="timelogedgenode"></a>`node` | [`Timelog`](#timelog) | The item at the end of the edge. |

#### `TodoConnection`

The connection type for [`Todo`](#todo).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="todoconnectionedges"></a>`edges` | [`[TodoEdge]`](#todoedge) | A list of edges. |
| <a id="todoconnectionnodes"></a>`nodes` | [`[Todo]`](#todo) | A list of nodes. |
| <a id="todoconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TodoEdge`

The edge type for [`Todo`](#todo).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="todoedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="todoedgenode"></a>`node` | [`Todo`](#todo) | The item at the end of the edge. |

#### `TopicConnection`

The connection type for [`Topic`](#topic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="topicconnectionedges"></a>`edges` | [`[TopicEdge]`](#topicedge) | A list of edges. |
| <a id="topicconnectionnodes"></a>`nodes` | [`[Topic]`](#topic) | A list of nodes. |
| <a id="topicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TopicEdge`

The edge type for [`Topic`](#topic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="topicedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="topicedgenode"></a>`node` | [`Topic`](#topic) | The item at the end of the edge. |

#### `TreeConnection`

The connection type for [`Tree`](#tree).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="treeconnectionedges"></a>`edges` | [`[TreeEdge]`](#treeedge) | A list of edges. |
| <a id="treeconnectionnodes"></a>`nodes` | [`[Tree]`](#tree) | A list of nodes. |
| <a id="treeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TreeEdge`

The edge type for [`Tree`](#tree).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="treeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="treeedgenode"></a>`node` | [`Tree`](#tree) | The item at the end of the edge. |

#### `TreeEntryConnection`

The connection type for [`TreeEntry`](#treeentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="treeentryconnectionedges"></a>`edges` | [`[TreeEntryEdge]`](#treeentryedge) | A list of edges. |
| <a id="treeentryconnectionnodes"></a>`nodes` | [`[TreeEntry]`](#treeentry) | A list of nodes. |
| <a id="treeentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TreeEntryEdge`

The edge type for [`TreeEntry`](#treeentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="treeentryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="treeentryedgenode"></a>`node` | [`TreeEntry`](#treeentry) | The item at the end of the edge. |

#### `UnprotectAccessLevelConnection`

The connection type for [`UnprotectAccessLevel`](#unprotectaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="unprotectaccesslevelconnectionedges"></a>`edges` | [`[UnprotectAccessLevelEdge]`](#unprotectaccessleveledge) | A list of edges. |
| <a id="unprotectaccesslevelconnectionnodes"></a>`nodes` | [`[UnprotectAccessLevel]`](#unprotectaccesslevel) | A list of nodes. |
| <a id="unprotectaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UnprotectAccessLevelEdge`

The edge type for [`UnprotectAccessLevel`](#unprotectaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="unprotectaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="unprotectaccessleveledgenode"></a>`node` | [`UnprotectAccessLevel`](#unprotectaccesslevel) | The item at the end of the edge. |

#### `UploadRegistryConnection`

The connection type for [`UploadRegistry`](#uploadregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="uploadregistryconnectionedges"></a>`edges` | [`[UploadRegistryEdge]`](#uploadregistryedge) | A list of edges. |
| <a id="uploadregistryconnectionnodes"></a>`nodes` | [`[UploadRegistry]`](#uploadregistry) | A list of nodes. |
| <a id="uploadregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UploadRegistryEdge`

The edge type for [`UploadRegistry`](#uploadregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="uploadregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="uploadregistryedgenode"></a>`node` | [`UploadRegistry`](#uploadregistry) | The item at the end of the edge. |

#### `UsageTrendsMeasurementConnection`

The connection type for [`UsageTrendsMeasurement`](#usagetrendsmeasurement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usagetrendsmeasurementconnectionedges"></a>`edges` | [`[UsageTrendsMeasurementEdge]`](#usagetrendsmeasurementedge) | A list of edges. |
| <a id="usagetrendsmeasurementconnectionnodes"></a>`nodes` | [`[UsageTrendsMeasurement]`](#usagetrendsmeasurement) | A list of nodes. |
| <a id="usagetrendsmeasurementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UsageTrendsMeasurementEdge`

The edge type for [`UsageTrendsMeasurement`](#usagetrendsmeasurement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usagetrendsmeasurementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="usagetrendsmeasurementedgenode"></a>`node` | [`UsageTrendsMeasurement`](#usagetrendsmeasurement) | The item at the end of the edge. |

#### `UserAchievementConnection`

The connection type for [`UserAchievement`](#userachievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="userachievementconnectionedges"></a>`edges` | [`[UserAchievementEdge]`](#userachievementedge) | A list of edges. |
| <a id="userachievementconnectionnodes"></a>`nodes` | [`[UserAchievement]`](#userachievement) | A list of nodes. |
| <a id="userachievementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UserAchievementEdge`

The edge type for [`UserAchievement`](#userachievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="userachievementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="userachievementedgenode"></a>`node` | [`UserAchievement`](#userachievement) | The item at the end of the edge. |

#### `UserCalloutConnection`

The connection type for [`UserCallout`](#usercallout).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usercalloutconnectionedges"></a>`edges` | [`[UserCalloutEdge]`](#usercalloutedge) | A list of edges. |
| <a id="usercalloutconnectionnodes"></a>`nodes` | [`[UserCallout]`](#usercallout) | A list of nodes. |
| <a id="usercalloutconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UserCalloutEdge`

The edge type for [`UserCallout`](#usercallout).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usercalloutedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="usercalloutedgenode"></a>`node` | [`UserCallout`](#usercallout) | The item at the end of the edge. |

#### `UserCoreConnection`

The connection type for [`UserCore`](#usercore).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usercoreconnectionedges"></a>`edges` | [`[UserCoreEdge]`](#usercoreedge) | A list of edges. |
| <a id="usercoreconnectionnodes"></a>`nodes` | [`[UserCore]`](#usercore) | A list of nodes. |
| <a id="usercoreconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UserCoreEdge`

The edge type for [`UserCore`](#usercore).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usercoreedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="usercoreedgenode"></a>`node` | [`UserCore`](#usercore) | The item at the end of the edge. |

#### `VulnerabilitiesCountByDayConnection`

The connection type for [`VulnerabilitiesCountByDay`](#vulnerabilitiescountbyday).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitiescountbydayconnectionedges"></a>`edges` | [`[VulnerabilitiesCountByDayEdge]`](#vulnerabilitiescountbydayedge) | A list of edges. |
| <a id="vulnerabilitiescountbydayconnectionnodes"></a>`nodes` | [`[VulnerabilitiesCountByDay]`](#vulnerabilitiescountbyday) | A list of nodes. |
| <a id="vulnerabilitiescountbydayconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilitiesCountByDayEdge`

The edge type for [`VulnerabilitiesCountByDay`](#vulnerabilitiescountbyday).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitiescountbydayedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilitiescountbydayedgenode"></a>`node` | [`VulnerabilitiesCountByDay`](#vulnerabilitiescountbyday) | The item at the end of the edge. |

#### `VulnerabilityConnection`

The connection type for [`Vulnerability`](#vulnerability).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityconnectionedges"></a>`edges` | [`[VulnerabilityEdge]`](#vulnerabilityedge) | A list of edges. |
| <a id="vulnerabilityconnectionnodes"></a>`nodes` | [`[Vulnerability]`](#vulnerability) | A list of nodes. |
| <a id="vulnerabilityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityContainerImageConnection`

The connection type for [`VulnerabilityContainerImage`](#vulnerabilitycontainerimage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitycontainerimageconnectionedges"></a>`edges` | [`[VulnerabilityContainerImageEdge]`](#vulnerabilitycontainerimageedge) | A list of edges. |
| <a id="vulnerabilitycontainerimageconnectionnodes"></a>`nodes` | [`[VulnerabilityContainerImage]`](#vulnerabilitycontainerimage) | A list of nodes. |
| <a id="vulnerabilitycontainerimageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityContainerImageEdge`

The edge type for [`VulnerabilityContainerImage`](#vulnerabilitycontainerimage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitycontainerimageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilitycontainerimageedgenode"></a>`node` | [`VulnerabilityContainerImage`](#vulnerabilitycontainerimage) | The item at the end of the edge. |

#### `VulnerabilityEdge`

The edge type for [`Vulnerability`](#vulnerability).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilityedgenode"></a>`node` | [`Vulnerability`](#vulnerability) | The item at the end of the edge. |

#### `VulnerabilityExternalIssueLinkConnection`

The connection type for [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityexternalissuelinkconnectionedges"></a>`edges` | [`[VulnerabilityExternalIssueLinkEdge]`](#vulnerabilityexternalissuelinkedge) | A list of edges. |
| <a id="vulnerabilityexternalissuelinkconnectionnodes"></a>`nodes` | [`[VulnerabilityExternalIssueLink]`](#vulnerabilityexternalissuelink) | A list of nodes. |
| <a id="vulnerabilityexternalissuelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityExternalIssueLinkEdge`

The edge type for [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityexternalissuelinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilityexternalissuelinkedgenode"></a>`node` | [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink) | The item at the end of the edge. |

#### `VulnerabilityIssueLinkConnection`

The connection type for [`VulnerabilityIssueLink`](#vulnerabilityissuelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityissuelinkconnectionedges"></a>`edges` | [`[VulnerabilityIssueLinkEdge]`](#vulnerabilityissuelinkedge) | A list of edges. |
| <a id="vulnerabilityissuelinkconnectionnodes"></a>`nodes` | [`[VulnerabilityIssueLink]`](#vulnerabilityissuelink) | A list of nodes. |
| <a id="vulnerabilityissuelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityIssueLinkEdge`

The edge type for [`VulnerabilityIssueLink`](#vulnerabilityissuelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityissuelinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilityissuelinkedgenode"></a>`node` | [`VulnerabilityIssueLink`](#vulnerabilityissuelink) | The item at the end of the edge. |

#### `VulnerabilityScannerConnection`

The connection type for [`VulnerabilityScanner`](#vulnerabilityscanner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityscannerconnectionedges"></a>`edges` | [`[VulnerabilityScannerEdge]`](#vulnerabilityscanneredge) | A list of edges. |
| <a id="vulnerabilityscannerconnectionnodes"></a>`nodes` | [`[VulnerabilityScanner]`](#vulnerabilityscanner) | A list of nodes. |
| <a id="vulnerabilityscannerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityScannerEdge`

The edge type for [`VulnerabilityScanner`](#vulnerabilityscanner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityscanneredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilityscanneredgenode"></a>`node` | [`VulnerabilityScanner`](#vulnerabilityscanner) | The item at the end of the edge. |

#### `VulnerabilityStateTransitionTypeConnection`

The connection type for [`VulnerabilityStateTransitionType`](#vulnerabilitystatetransitiontype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitystatetransitiontypeconnectionedges"></a>`edges` | [`[VulnerabilityStateTransitionTypeEdge]`](#vulnerabilitystatetransitiontypeedge) | A list of edges. |
| <a id="vulnerabilitystatetransitiontypeconnectionnodes"></a>`nodes` | [`[VulnerabilityStateTransitionType]`](#vulnerabilitystatetransitiontype) | A list of nodes. |
| <a id="vulnerabilitystatetransitiontypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityStateTransitionTypeEdge`

The edge type for [`VulnerabilityStateTransitionType`](#vulnerabilitystatetransitiontype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitystatetransitiontypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilitystatetransitiontypeedgenode"></a>`node` | [`VulnerabilityStateTransitionType`](#vulnerabilitystatetransitiontype) | The item at the end of the edge. |

#### `WorkItemConnection`

The connection type for [`WorkItem`](#workitem).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemconnectionedges"></a>`edges` | [`[WorkItemEdge]`](#workitemedge) | A list of edges. |
| <a id="workitemconnectionnodes"></a>`nodes` | [`[WorkItem]`](#workitem) | A list of nodes. |
| <a id="workitemconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `WorkItemEdge`

The edge type for [`WorkItem`](#workitem).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="workitemedgenode"></a>`node` | [`WorkItem`](#workitem) | The item at the end of the edge. |

#### `WorkItemTypeConnection`

The connection type for [`WorkItemType`](#workitemtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemtypeconnectionedges"></a>`edges` | [`[WorkItemTypeEdge]`](#workitemtypeedge) | A list of edges. |
| <a id="workitemtypeconnectionnodes"></a>`nodes` | [`[WorkItemType]`](#workitemtype) | A list of nodes. |
| <a id="workitemtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `WorkItemTypeEdge`

The edge type for [`WorkItemType`](#workitemtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="workitemtypeedgenode"></a>`node` | [`WorkItemType`](#workitemtype) | The item at the end of the edge. |

#### `WorkspaceConnection`

The connection type for [`Workspace`](#workspace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workspaceconnectionedges"></a>`edges` | [`[WorkspaceEdge]`](#workspaceedge) | A list of edges. |
| <a id="workspaceconnectionnodes"></a>`nodes` | [`[Workspace]`](#workspace) | A list of nodes. |
| <a id="workspaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `WorkspaceEdge`

The edge type for [`Workspace`](#workspace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workspaceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="workspaceedgenode"></a>`node` | [`Workspace`](#workspace) | The item at the end of the edge. |

## Object types

Object types represent the resources that the GitLab GraphQL API can return.
They contain _fields_. Each field has its own type, which will either be one of the
basic GraphQL [scalar types](https://graphql.org/learn/schema/#scalar-types)
(e.g.: `String` or `Boolean`) or other object types. Fields may have arguments.
Fields with arguments are exactly like top-level queries, and are listed beneath
the table of fields for each object type.

For more information, see
[Object Types and Fields](https://graphql.org/learn/schema/#object-types-and-fields)
on `graphql.org`.

### `AccessLevel`

Represents the access level of a relationship between a User and object that it is related to.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accesslevelintegervalue"></a>`integerValue` | [`Int`](#int) | Integer representation of access level. |
| <a id="accesslevelstringvalue"></a>`stringValue` | [`AccessLevelEnum`](#accesslevelenum) | String representation of access level. |

### `AccessLevelGroup`

Representation of a GitLab group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accesslevelgroupavatarurl"></a>`avatarUrl` | [`String`](#string) | Avatar URL of the group. |
| <a id="accesslevelgroupid"></a>`id` | [`ID!`](#id) | ID of the group. |
| <a id="accesslevelgroupname"></a>`name` | [`String!`](#string) | Name of the group. |
| <a id="accesslevelgroupparent"></a>`parent` | [`AccessLevelGroup`](#accesslevelgroup) | Parent group. |
| <a id="accesslevelgroupweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the group. |

### `AccessLevelUser`

Representation of a GitLab user.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accessleveluseravatarurl"></a>`avatarUrl` | [`String`](#string) | URL of the user's avatar. |
| <a id="accessleveluserid"></a>`id` | [`ID!`](#id) | ID of the user. |
| <a id="accesslevelusername"></a>`name` | [`String!`](#string) | Human-readable name of the user. Returns `****` if the user is a project bot and the requester does not have permission to view the project. |
| <a id="accessleveluserpublicemail"></a>`publicEmail` | [`String`](#string) | User's public email. |
| <a id="accessleveluserusername"></a>`username` | [`String!`](#string) | Username of the user. Unique within this instance of GitLab. |
| <a id="accessleveluserwebpath"></a>`webPath` | [`String!`](#string) | Web path of the user. |
| <a id="accessleveluserweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the user. |

### `Achievement`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="achievementavatarurl"></a>`avatarUrl` | [`String`](#string) | URL to avatar of the achievement. |
| <a id="achievementcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp the achievement was created. |
| <a id="achievementdescription"></a>`description` | [`String`](#string) | Description or notes for the achievement. |
| <a id="achievementid"></a>`id` | [`AchievementsAchievementID!`](#achievementsachievementid) | ID of the achievement. |
| <a id="achievementname"></a>`name` | [`String!`](#string) | Name of the achievement. |
| <a id="achievementnamespace"></a>`namespace` | [`Namespace`](#namespace) | Namespace of the achievement. |
| <a id="achievementupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp the achievement was last updated. |
| <a id="achievementuserachievements"></a>`userAchievements` **{warning-solid}** | [`UserAchievementConnection`](#userachievementconnection) | **Introduced** in 15.10. This feature is an Experiment. It can be changed or removed at any time. Recipients for the achievement. |

### `AgentConfiguration`

Configuration details for an Agent.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentconfigurationagentname"></a>`agentName` | [`String`](#string) | Name of the agent. |

### `AgentMetadata`

Information about a connected Agent.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentmetadatacommit"></a>`commit` | [`String`](#string) | Agent version commit. |
| <a id="agentmetadatapodname"></a>`podName` | [`String`](#string) | Name of the pod running the Agent. |
| <a id="agentmetadatapodnamespace"></a>`podNamespace` | [`String`](#string) | Namespace of the pod running the Agent. |
| <a id="agentmetadataversion"></a>`version` | [`String`](#string) | Agent version tag. |

### `AiMessageType`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimessagetypecontent"></a>`content` | [`String`](#string) | Content of the message or null if loading. |
| <a id="aimessagetypeerrors"></a>`errors` | [`[String!]!`](#string) | Errors that occurred while asynchronously fetching an AI(assistant) response. |
| <a id="aimessagetypeid"></a>`id` | [`ID`](#id) | Global ID of the message. |
| <a id="aimessagetypeisfetching"></a>`isFetching` | [`Boolean`](#boolean) | Whether the content is still being fetched, for a message with the assistant role. |
| <a id="aimessagetyperole"></a>`role` | [`String!`](#string) | Role of the message (system, user, assistant). |

### `AiResponse`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="airesponseerrors"></a>`errors` | [`[String!]`](#string) | Errors return by AI API as response. |
| <a id="airesponserequestid"></a>`requestId` | [`String`](#string) | ID of the original request. |
| <a id="airesponseresponsebody"></a>`responseBody` | [`String`](#string) | Response body from AI API. |

### `AlertManagementAlert`

Describes an alert from the project's Alert Management.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertassignees"></a>`assignees` | [`UserCoreConnection`](#usercoreconnection) | Assignees of the alert. (see [Connections](#connections)) |
| <a id="alertmanagementalertcommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="alertmanagementalertcreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp the alert was created. |
| <a id="alertmanagementalertdescription"></a>`description` | [`String`](#string) | Description of the alert. |
| <a id="alertmanagementalertdetails"></a>`details` | [`JSON`](#json) | Alert details. |
| <a id="alertmanagementalertdetailsurl"></a>`detailsUrl` | [`String!`](#string) | URL of the alert detail page. |
| <a id="alertmanagementalertdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="alertmanagementalertendedat"></a>`endedAt` | [`Time`](#time) | Timestamp the alert ended. |
| <a id="alertmanagementalertenvironment"></a>`environment` | [`Environment`](#environment) | Environment for the alert. |
| <a id="alertmanagementalerteventcount"></a>`eventCount` | [`Int`](#int) | Number of events of this alert. |
| <a id="alertmanagementalerthosts"></a>`hosts` | [`[String!]`](#string) | List of hosts the alert came from. |
| <a id="alertmanagementalertid"></a>`id` | [`ID!`](#id) | ID of the alert. |
| <a id="alertmanagementalertiid"></a>`iid` | [`ID!`](#id) | Internal ID of the alert. |
| <a id="alertmanagementalertissue"></a>`issue` | [`Issue`](#issue) | Issue attached to the alert. |
| <a id="alertmanagementalertissueiid"></a>`issueIid` **{warning-solid}** | [`ID`](#id) | **Deprecated** in 13.10. Use issue field. |
| <a id="alertmanagementalertmetricsdashboardurl"></a>`metricsDashboardUrl` **{warning-solid}** | [`String`](#string) | **Deprecated** in 16.0. Returns no data. Underlying feature was removed in 16.0. |
| <a id="alertmanagementalertmonitoringtool"></a>`monitoringTool` | [`String`](#string) | Monitoring tool the alert came from. |
| <a id="alertmanagementalertnotes"></a>`notes` | [`NoteConnection!`](#noteconnection) | All notes on this noteable. (see [Connections](#connections)) |
| <a id="alertmanagementalertprometheusalert"></a>`prometheusAlert` | [`PrometheusAlert`](#prometheusalert) | Alert condition for Prometheus. |
| <a id="alertmanagementalertrunbook"></a>`runbook` | [`String`](#string) | Runbook for the alert as defined in alert details. |
| <a id="alertmanagementalertservice"></a>`service` | [`String`](#string) | Service the alert came from. |
| <a id="alertmanagementalertseverity"></a>`severity` | [`AlertManagementSeverity`](#alertmanagementseverity) | Severity of the alert. |
| <a id="alertmanagementalertstartedat"></a>`startedAt` | [`Time`](#time) | Timestamp the alert was raised. |
| <a id="alertmanagementalertstatus"></a>`status` | [`AlertManagementStatus`](#alertmanagementstatus) | Status of the alert. |
| <a id="alertmanagementalerttitle"></a>`title` | [`String`](#string) | Title of the alert. |
| <a id="alertmanagementalertupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp the alert was last updated. |
| <a id="alertmanagementalertweburl"></a>`webUrl` | [`String!`](#string) | URL of the alert. |

#### Fields with arguments

##### `AlertManagementAlert.todos`

To-do items of the current user for the alert.

Returns [`TodoConnection`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalerttodosaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | Action to be filtered. |
| <a id="alertmanagementalerttodosauthorid"></a>`authorId` | [`[ID!]`](#id) | ID of an author. |
| <a id="alertmanagementalerttodosgroupid"></a>`groupId` | [`[ID!]`](#id) | ID of a group. |
| <a id="alertmanagementalerttodosprojectid"></a>`projectId` | [`[ID!]`](#id) | ID of a project. |
| <a id="alertmanagementalerttodosstate"></a>`state` | [`[TodoStateEnum!]`](#todostateenum) | State of the todo. |
| <a id="alertmanagementalerttodostype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | Type of the todo. |

### `AlertManagementAlertStatusCountsType`

Represents total number of alerts for the represented categories.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertstatuscountstypeacknowledged"></a>`acknowledged` | [`Int`](#int) | Number of alerts with status ACKNOWLEDGED for the project. |
| <a id="alertmanagementalertstatuscountstypeall"></a>`all` | [`Int`](#int) | Total number of alerts for the project. |
| <a id="alertmanagementalertstatuscountstypeignored"></a>`ignored` | [`Int`](#int) | Number of alerts with status IGNORED for the project. |
| <a id="alertmanagementalertstatuscountstypeopen"></a>`open` | [`Int`](#int) | Number of alerts with status TRIGGERED or ACKNOWLEDGED for the project. |
| <a id="alertmanagementalertstatuscountstyperesolved"></a>`resolved` | [`Int`](#int) | Number of alerts with status RESOLVED for the project. |
| <a id="alertmanagementalertstatuscountstypetriggered"></a>`triggered` | [`Int`](#int) | Number of alerts with status TRIGGERED for the project. |

### `AlertManagementHttpIntegration`

An endpoint and credentials used to accept alerts for a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationactive"></a>`active` | [`Boolean`](#boolean) | Whether the endpoint is currently accepting alerts. |
| <a id="alertmanagementhttpintegrationapiurl"></a>`apiUrl` | [`String`](#string) | URL at which Prometheus metrics can be queried to populate the metrics dashboard. |
| <a id="alertmanagementhttpintegrationid"></a>`id` | [`ID!`](#id) | ID of the integration. |
| <a id="alertmanagementhttpintegrationname"></a>`name` | [`String`](#string) | Name of the integration. |
| <a id="alertmanagementhttpintegrationpayloadalertfields"></a>`payloadAlertFields` | [`[AlertManagementPayloadAlertField!]`](#alertmanagementpayloadalertfield) | Extract alert fields from payload example for custom mapping. |
| <a id="alertmanagementhttpintegrationpayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertMappingField!]`](#alertmanagementpayloadalertmappingfield) | The custom mapping of GitLab alert attributes to fields from the payload_example. |
| <a id="alertmanagementhttpintegrationpayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |
| <a id="alertmanagementhttpintegrationtoken"></a>`token` | [`String`](#string) | Token used to authenticate alert notification requests. |
| <a id="alertmanagementhttpintegrationtype"></a>`type` | [`AlertManagementIntegrationType!`](#alertmanagementintegrationtype) | Type of integration. |
| <a id="alertmanagementhttpintegrationurl"></a>`url` | [`String`](#string) | Endpoint which accepts alert notifications. |

### `AlertManagementPayloadAlertField`

Parsed field from an alert used for custom mappings.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementpayloadalertfieldlabel"></a>`label` | [`String`](#string) | Human-readable label of the payload path. |
| <a id="alertmanagementpayloadalertfieldpath"></a>`path` | [`[PayloadAlertFieldPathSegment!]`](#payloadalertfieldpathsegment) | Path to value inside payload JSON. |
| <a id="alertmanagementpayloadalertfieldtype"></a>`type` | [`AlertManagementPayloadAlertFieldType`](#alertmanagementpayloadalertfieldtype) | Type of the parsed value. |

### `AlertManagementPayloadAlertMappingField`

Parsed field (with its name) from an alert used for custom mappings.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementpayloadalertmappingfieldfieldname"></a>`fieldName` | [`AlertManagementPayloadAlertFieldName`](#alertmanagementpayloadalertfieldname) | GitLab alert field name. |
| <a id="alertmanagementpayloadalertmappingfieldlabel"></a>`label` | [`String`](#string) | Human-readable label of the payload path. |
| <a id="alertmanagementpayloadalertmappingfieldpath"></a>`path` | [`[PayloadAlertFieldPathSegment!]`](#payloadalertfieldpathsegment) | Path to value inside payload JSON. |
| <a id="alertmanagementpayloadalertmappingfieldtype"></a>`type` | [`AlertManagementPayloadAlertFieldType`](#alertmanagementpayloadalertfieldtype) | Type of the parsed value. |

### `AlertManagementPrometheusIntegration`

An endpoint and credentials used to accept Prometheus alerts for a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementprometheusintegrationactive"></a>`active` | [`Boolean`](#boolean) | Whether the endpoint is currently accepting alerts. |
| <a id="alertmanagementprometheusintegrationapiurl"></a>`apiUrl` | [`String`](#string) | URL at which Prometheus metrics can be queried to populate the metrics dashboard. |
| <a id="alertmanagementprometheusintegrationid"></a>`id` | [`ID!`](#id) | ID of the integration. |
| <a id="alertmanagementprometheusintegrationname"></a>`name` | [`String`](#string) | Name of the integration. |
| <a id="alertmanagementprometheusintegrationtoken"></a>`token` | [`String`](#string) | Token used to authenticate alert notification requests. |
| <a id="alertmanagementprometheusintegrationtype"></a>`type` | [`AlertManagementIntegrationType!`](#alertmanagementintegrationtype) | Type of integration. |
| <a id="alertmanagementprometheusintegrationurl"></a>`url` | [`String`](#string) | Endpoint which accepts alert notifications. |

### `ApiFuzzingCiConfiguration`

Data associated with configuring API fuzzing scans in GitLab CI.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="apifuzzingciconfigurationscanmodes"></a>`scanModes` | [`[ApiFuzzingScanMode!]`](#apifuzzingscanmode) | All available scan modes. |
| <a id="apifuzzingciconfigurationscanprofiles"></a>`scanProfiles` | [`[ApiFuzzingScanProfile!]`](#apifuzzingscanprofile) | All default scan profiles. |

### `ApiFuzzingScanProfile`

An API Fuzzing scan profile.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="apifuzzingscanprofiledescription"></a>`description` | [`String`](#string) | Short description of the profile. |
| <a id="apifuzzingscanprofilename"></a>`name` | [`String`](#string) | Unique name of the profile. |
| <a id="apifuzzingscanprofileyaml"></a>`yaml` | [`String`](#string) | Syntax highlighted HTML representation of the YAML. |

### `ApprovalProjectRule`

Describes a project approval rule regarding who can approve merge requests.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleapprovalsrequired"></a>`approvalsRequired` | [`Int`](#int) | Number of required approvals. |
| <a id="approvalprojectruleeligibleapprovers"></a>`eligibleApprovers` | [`UserCoreConnection`](#usercoreconnection) | List of users eligible to approve merge requests for this approval rule. (see [Connections](#connections)) |
| <a id="approvalprojectruleid"></a>`id` | [`GlobalID!`](#globalid) | ID of the rule. |
| <a id="approvalprojectrulename"></a>`name` | [`String`](#string) | Name of the rule. |
| <a id="approvalprojectruletype"></a>`type` | [`ApprovalRuleType`](#approvalruletype) | Type of the rule. |

### `ApprovalRule`

Describes a rule for who can approve merge requests.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalruleallowmergewheninvalid"></a>`allowMergeWhenInvalid` | [`Boolean`](#boolean) | Indicates if the rule can be ignored if it is invalid. |
| <a id="approvalruleapprovalsrequired"></a>`approvalsRequired` | [`Int`](#int) | Number of required approvals. |
| <a id="approvalruleapproved"></a>`approved` | [`Boolean`](#boolean) | Indicates if the rule is satisfied. |
| <a id="approvalruleapprovedby"></a>`approvedBy` | [`UserCoreConnection`](#usercoreconnection) | List of users defined in the rule that approved the merge request. (see [Connections](#connections)) |
| <a id="approvalrulecommentedby"></a>`commentedBy` | [`UserCoreConnection`](#usercoreconnection) | List of users, defined in the rule, who commented on the merge request. (see [Connections](#connections)) |
| <a id="approvalrulecontainshiddengroups"></a>`containsHiddenGroups` | [`Boolean`](#boolean) | Indicates if the rule contains approvers from a hidden group. |
| <a id="approvalruleeligibleapprovers"></a>`eligibleApprovers` | [`[UserCore!]`](#usercore) | List of all users eligible to approve the merge request (defined explicitly and from associated groups). |
| <a id="approvalrulegroups"></a>`groups` | [`GroupConnection`](#groupconnection) | List of groups added as approvers for the rule. (see [Connections](#connections)) |
| <a id="approvalruleid"></a>`id` | [`GlobalID!`](#globalid) | ID of the rule. |
| <a id="approvalruleinvalid"></a>`invalid` | [`Boolean`](#boolean) | Indicates if the rule is invalid and cannot be approved. |
| <a id="approvalrulename"></a>`name` | [`String`](#string) | Name of the rule. |
| <a id="approvalruleoverridden"></a>`overridden` | [`Boolean`](#boolean) | Indicates if the rule was overridden for the merge request. |
| <a id="approvalrulesection"></a>`section` | [`String`](#string) | Named section of the Code Owners file that the rule applies to. |
| <a id="approvalrulesourcerule"></a>`sourceRule` | [`ApprovalRule`](#approvalrule) | Source rule used to create the rule. |
| <a id="approvalruletype"></a>`type` | [`ApprovalRuleType`](#approvalruletype) | Type of the rule. |
| <a id="approvalruleusers"></a>`users` | [`UserCoreConnection`](#usercoreconnection) | List of users added as approvers for the rule. (see [Connections](#connections)) |

### `AssetType`

Represents a vulnerability asset type.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="assettypename"></a>`name` | [`String!`](#string) | Name of the asset. |
| <a id="assettypetype"></a>`type` | [`String!`](#string) | Type of the asset. |
| <a id="assettypeurl"></a>`url` | [`String!`](#string) | URL of the asset. |

### `AuditEventStreamingHeader`

Represents a HTTP header key/value that belongs to an audit streaming destination.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderid"></a>`id` | [`ID!`](#id) | ID of the header. |
| <a id="auditeventstreamingheaderkey"></a>`key` | [`String!`](#string) | Key of the header. |
| <a id="auditeventstreamingheadervalue"></a>`value` | [`String!`](#string) | Value of the header. |

### `AwardEmoji`

An emoji awarded by a user.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="awardemojidescription"></a>`description` | [`String!`](#string) | Emoji description. |
| <a id="awardemojiemoji"></a>`emoji` | [`String!`](#string) | Emoji as an icon. |
| <a id="awardemojiname"></a>`name` | [`String!`](#string) | Emoji name. |
| <a id="awardemojiunicode"></a>`unicode` | [`String!`](#string) | Emoji in Unicode. |
| <a id="awardemojiunicodeversion"></a>`unicodeVersion` | [`String!`](#string) | Unicode version for this emoji. |
| <a id="awardemojiuser"></a>`user` | [`UserCore!`](#usercore) | User who awarded the emoji. |

### `BaseService`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="baseserviceactive"></a>`active` | [`Boolean`](#boolean) | Indicates if the service is active. |
| <a id="baseserviceservicetype"></a>`serviceType` | [`ServiceType`](#servicetype) | Type of the service. |
| <a id="baseservicetype"></a>`type` | [`String`](#string) | Class name of the service. |

### `Blob`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobflatpath"></a>`flatPath` | [`String!`](#string) | Flat path of the entry. |
| <a id="blobid"></a>`id` | [`ID!`](#id) | ID of the entry. |
| <a id="bloblfsoid"></a>`lfsOid` | [`String`](#string) | LFS ID of the blob. |
| <a id="blobmode"></a>`mode` | [`String`](#string) | Blob mode in numeric format. |
| <a id="blobname"></a>`name` | [`String!`](#string) | Name of the entry. |
| <a id="blobpath"></a>`path` | [`String!`](#string) | Path of the entry. |
| <a id="blobsha"></a>`sha` | [`String!`](#string) | Last commit SHA for the entry. |
| <a id="blobtype"></a>`type` | [`EntryType!`](#entrytype) | Type of tree entry. |
| <a id="blobwebpath"></a>`webPath` | [`String`](#string) | Web path of the blob. |
| <a id="blobweburl"></a>`webUrl` | [`String`](#string) | Web URL of the blob. |

### `BlobViewer`

Represents how the blob content should be displayed.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobviewercollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | Shows whether the blob should be displayed collapsed. |
| <a id="blobviewerfiletype"></a>`fileType` | [`String!`](#string) | Content file type. |
| <a id="blobviewerloadasync"></a>`loadAsync` | [`Boolean!`](#boolean) | Shows whether the blob content is loaded asynchronously. |
| <a id="blobviewerloadingpartialname"></a>`loadingPartialName` | [`String!`](#string) | Loading partial name. |
| <a id="blobviewerrendererror"></a>`renderError` | [`String`](#string) | Error rendering the blob content. |
| <a id="blobviewertoolarge"></a>`tooLarge` | [`Boolean!`](#boolean) | Shows whether the blob is too large to be displayed. |
| <a id="blobviewertype"></a>`type` | [`BlobViewersType!`](#blobviewerstype) | Type of blob viewer. |

### `Board`

Represents a project or group issue board.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardassignee"></a>`assignee` | [`UserCore`](#usercore) | Board assignee. |
| <a id="boardcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of when the board was created. |
| <a id="boardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="boardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="boardid"></a>`id` | [`ID!`](#id) | ID (global ID) of the board. |
| <a id="boarditeration"></a>`iteration` | [`Iteration`](#iteration) | Board iteration. |
| <a id="boarditerationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | Board iteration cadence. |
| <a id="boardlabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels of the board. (see [Connections](#connections)) |
| <a id="boardmilestone"></a>`milestone` | [`Milestone`](#milestone) | Board milestone. |
| <a id="boardname"></a>`name` | [`String`](#string) | Name of the board. |
| <a id="boardupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of when the board was last updated. |
| <a id="boardwebpath"></a>`webPath` | [`String!`](#string) | Web path of the board. |
| <a id="boardweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the board. |
| <a id="boardweight"></a>`weight` | [`Int`](#int) | Weight of the board. |

#### Fields with arguments

##### `Board.epics`

Epics associated with board issues.

Returns [`BoardEpicConnection`](#boardepicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicsissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | Filters applied when selecting issues on the board. |

##### `Board.lists`

Lists of the board.

Returns [`BoardListConnection`](#boardlistconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistsid"></a>`id` | [`ListID`](#listid) | Find a list by its global ID. |
| <a id="boardlistsissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | Filters applied when getting issue metadata in the board list. |

### `BoardEpic`

Represents an epic on an issue board.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicauthor"></a>`author` | [`UserCore!`](#usercore) | Author of the epic. |
| <a id="boardepicawardemoji"></a>`awardEmoji` | [`AwardEmojiConnection`](#awardemojiconnection) | List of award emojis associated with the epic. (see [Connections](#connections)) |
| <a id="boardepicblocked"></a>`blocked` | [`Boolean`](#boolean) | Indicates the epic is blocked. |
| <a id="boardepicblockedbycount"></a>`blockedByCount` | [`Int`](#int) | Count of epics blocking this epic. |
| <a id="boardepicblockedbyepics"></a>`blockedByEpics` | [`EpicConnection`](#epicconnection) | Epics blocking this epic. (see [Connections](#connections)) |
| <a id="boardepicblockingcount"></a>`blockingCount` | [`Int`](#int) | Count of epics that this epic is blocking. |
| <a id="boardepicclosedat"></a>`closedAt` | [`Time`](#time) | Timestamp of when the epic was closed. |
| <a id="boardepiccolor"></a>`color` | [`String`](#string) | Color of the epic. Returns `null` if `epic_color_highlight` feature flag is disabled. |
| <a id="boardepiccommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="boardepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates if the epic is confidential. |
| <a id="boardepiccreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of when the epic was created. |
| <a id="boardepicdefaultprojectforissuecreation"></a>`defaultProjectForIssueCreation` | [`Project`](#project) | Default Project for issue creation. Based on the project the user created the last issue in. |
| <a id="boardepicdescendantcounts"></a>`descendantCounts` | [`EpicDescendantCount`](#epicdescendantcount) | Number of open and closed descendant epics and issues. |
| <a id="boardepicdescendantweightsum"></a>`descendantWeightSum` | [`EpicDescendantWeights`](#epicdescendantweights) | Total weight of open and closed issues in the epic and its descendants. |
| <a id="boardepicdescription"></a>`description` | [`String`](#string) | Description of the epic. |
| <a id="boardepicdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="boardepicdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="boardepicdownvotes"></a>`downvotes` | [`Int!`](#int) | Number of downvotes the epic has received. |
| <a id="boardepicduedate"></a>`dueDate` | [`Time`](#time) | Due date of the epic. |
| <a id="boardepicduedatefixed"></a>`dueDateFixed` | [`Time`](#time) | Fixed due date of the epic. |
| <a id="boardepicduedatefrominheritedsource"></a>`dueDateFromInheritedSource` | [`Time`](#time) | Inherited due date of the epic from child epics or milestones. |
| <a id="boardepicduedatefrommilestones"></a>`dueDateFromMilestones` | [`Time`](#time) | Inherited due date of the epic from milestones. |
| <a id="boardepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | Indicates if the due date has been manually set. |
| <a id="boardepicevents"></a>`events` | [`EventConnection`](#eventconnection) | List of events associated with the object. (see [Connections](#connections)) |
| <a id="boardepicgroup"></a>`group` | [`Group!`](#group) | Group to which the epic belongs. |
| <a id="boardepichaschildren"></a>`hasChildren` | [`Boolean!`](#boolean) | Indicates if the epic has children. |
| <a id="boardepichasissues"></a>`hasIssues` | [`Boolean!`](#boolean) | Indicates if the epic has direct issues. |
| <a id="boardepichasparent"></a>`hasParent` | [`Boolean!`](#boolean) | Indicates if the epic has a parent epic. |
| <a id="boardepichealthstatus"></a>`healthStatus` | [`EpicHealthStatus`](#epichealthstatus) | Current health status of the epic. |
| <a id="boardepicid"></a>`id` | [`ID!`](#id) | ID of the epic. |
| <a id="boardepiciid"></a>`iid` | [`ID!`](#id) | Internal ID of the epic. |
| <a id="boardepicissues"></a>`issues` | [`EpicIssueConnection`](#epicissueconnection) | A list of issues associated with the epic. (see [Connections](#connections)) |
| <a id="boardepiclabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels assigned to the epic. (see [Connections](#connections)) |
| <a id="boardepicnotes"></a>`notes` | [`NoteConnection!`](#noteconnection) | All notes on this noteable. (see [Connections](#connections)) |
| <a id="boardepicparent"></a>`parent` | [`Epic`](#epic) | Parent epic of the epic. |
| <a id="boardepicparticipants"></a>`participants` | [`UserCoreConnection`](#usercoreconnection) | List of participants for the epic. (see [Connections](#connections)) |
| <a id="boardepicrelationpath"></a>`relationPath` | [`String`](#string) | URI path of the epic-issue relationship. |
| <a id="boardepicrelativeposition"></a>`relativePosition` | [`Int`](#int) | Relative position of the epic in the epic tree. |
| <a id="boardepicstartdate"></a>`startDate` | [`Time`](#time) | Start date of the epic. |
| <a id="boardepicstartdatefixed"></a>`startDateFixed` | [`Time`](#time) | Fixed start date of the epic. |
| <a id="boardepicstartdatefrominheritedsource"></a>`startDateFromInheritedSource` | [`Time`](#time) | Inherited start date of the epic from child epics or milestones. |
| <a id="boardepicstartdatefrommilestones"></a>`startDateFromMilestones` | [`Time`](#time) | Inherited start date of the epic from milestones. |
| <a id="boardepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | Indicates if the start date has been manually set. |
| <a id="boardepicstate"></a>`state` | [`EpicState!`](#epicstate) | State of the epic. |
| <a id="boardepicsubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | Indicates the currently logged in user is subscribed to the epic. |
| <a id="boardepictextcolor"></a>`textColor` | [`String`](#string) | Text color generated for the epic. Returns `null` if `epic_color_highlight` feature flag is disabled. |
| <a id="boardepictitle"></a>`title` | [`String`](#string) | Title of the epic. |
| <a id="boardepictitlehtml"></a>`titleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `title`. |
| <a id="boardepicupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp of when the epic was updated. |
| <a id="boardepicupvotes"></a>`upvotes` | [`Int!`](#int) | Number of upvotes the epic has received. |
| <a id="boardepicuserdiscussionscount"></a>`userDiscussionsCount` | [`Int!`](#int) | Number of user discussions in the epic. |
| <a id="boardepicusernotescount"></a>`userNotesCount` | [`Int!`](#int) | Number of user notes of the epic. |
| <a id="boardepicuserpermissions"></a>`userPermissions` | [`EpicPermissions!`](#epicpermissions) | Permissions for the current user on the resource. |
| <a id="boardepicuserpreferences"></a>`userPreferences` | [`BoardEpicUserPreferences`](#boardepicuserpreferences) | User preferences for the epic on the issue board. |
| <a id="boardepicwebpath"></a>`webPath` | [`String!`](#string) | Web path of the epic. |
| <a id="boardepicweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the epic. |

#### Fields with arguments

##### `BoardEpic.ancestors`

Ancestors (parents) of the epic.

Returns [`EpicConnection`](#epicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicancestorsauthorusername"></a>`authorUsername` | [`String`](#string) | Filter epics by author. |
| <a id="boardepicancestorsconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter epics by given confidentiality. |
| <a id="boardepicancestorscreatedafter"></a>`createdAfter` | [`Time`](#time) | Epics created after this date. |
| <a id="boardepicancestorscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Epics created before this date. |
| <a id="boardepicancestorsiid"></a>`iid` | [`ID`](#id) | IID of the epic, e.g., "1". |
| <a id="boardepicancestorsiidstartswith"></a>`iidStartsWith` | [`String`](#string) | Filter epics by IID for autocomplete. |
| <a id="boardepicancestorsiids"></a>`iids` | [`[ID!]`](#id) | List of IIDs of epics, e.g., `[1, 2]`. |
| <a id="boardepicancestorsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="boardepicancestorsincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Include epics from ancestor groups. |
| <a id="boardepicancestorsincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | Include epics from descendant groups. |
| <a id="boardepicancestorslabelname"></a>`labelName` | [`[String!]`](#string) | Filter epics by labels. |
| <a id="boardepicancestorsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Filter epics by milestone title, computed from epic's issues. |
| <a id="boardepicancestorsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. |
| <a id="boardepicancestorsnot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | Negated epic arguments. |
| <a id="boardepicancestorsor"></a>`or` **{warning-solid}** | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | **Introduced** in 15.9. This feature is an Experiment. It can be changed or removed at any time. List of arguments with inclusive OR. Ignored unless `or_issuable_queries` flag is enabled. |
| <a id="boardepicancestorssearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="boardepicancestorssort"></a>`sort` | [`EpicSort`](#epicsort) | List epics by sort order. |
| <a id="boardepicancestorsstate"></a>`state` | [`EpicState`](#epicstate) | Filter epics by state. |
| <a id="boardepicancestorstimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="boardepicancestorstoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | Filter epics with a top-level hierarchy. |
| <a id="boardepicancestorsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Epics updated after this date. |
| <a id="boardepicancestorsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Epics updated before this date. |

##### `BoardEpic.children`

Children (sub-epics) of the epic.

Returns [`EpicConnection`](#epicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicchildrenauthorusername"></a>`authorUsername` | [`String`](#string) | Filter epics by author. |
| <a id="boardepicchildrenconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter epics by given confidentiality. |
| <a id="boardepicchildrencreatedafter"></a>`createdAfter` | [`Time`](#time) | Epics created after this date. |
| <a id="boardepicchildrencreatedbefore"></a>`createdBefore` | [`Time`](#time) | Epics created before this date. |
| <a id="boardepicchildreniid"></a>`iid` | [`ID`](#id) | IID of the epic, e.g., "1". |
| <a id="boardepicchildreniidstartswith"></a>`iidStartsWith` | [`String`](#string) | Filter epics by IID for autocomplete. |
| <a id="boardepicchildreniids"></a>`iids` | [`[ID!]`](#id) | List of IIDs of epics, e.g., `[1, 2]`. |
| <a id="boardepicchildrenin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="boardepicchildrenincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Include child epics from ancestor groups. |
| <a id="boardepicchildrenincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | Include epics from descendant groups. |
| <a id="boardepicchildrenlabelname"></a>`labelName` | [`[String!]`](#string) | Filter epics by labels. |
| <a id="boardepicchildrenmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Filter epics by milestone title, computed from epic's issues. |
| <a id="boardepicchildrenmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. |
| <a id="boardepicchildrennot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | Negated epic arguments. |
| <a id="boardepicchildrenor"></a>`or` **{warning-solid}** | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | **Introduced** in 15.9. This feature is an Experiment. It can be changed or removed at any time. List of arguments with inclusive OR. Ignored unless `or_issuable_queries` flag is enabled. |
| <a id="boardepicchildrensearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="boardepicchildrensort"></a>`sort` | [`EpicSort`](#epicsort) | List epics by sort order. |
| <a id="boardepicchildrenstate"></a>`state` | [`EpicState`](#epicstate) | Filter epics by state. |
| <a id="boardepicchildrentimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="boardepicchildrentoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | Filter epics with a top-level hierarchy. |
| <a id="boardepicchildrenupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Epics updated after this date. |
| <a id="boardepicchildrenupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Epics updated before this date. |

##### `BoardEpic.currentUserTodos`

To-do items for the current user.

Returns [`TodoConnection!`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepiccurrentusertodosstate"></a>`state` | [`TodoStateEnum`](#todostateenum) | State of the to-do items. |

##### `BoardEpic.reference`

Internal reference of the epic. Returned in shortened format by default.

Returns [`String!`](#string).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicreferencefull"></a>`full` | [`Boolean`](#boolean) | Indicates if the reference should be returned in full. |

### `BoardEpicUserPreferences`

Represents user preferences for a board epic.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicuserpreferencescollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | Indicates epic should be displayed as collapsed. |

### `BoardList`

Represents a list for an issue board.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistassignee"></a>`assignee` | [`UserCore`](#usercore) | Assignee in the list. |
| <a id="boardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | Indicates if the list is collapsed for this user. |
| <a id="boardlistid"></a>`id` | [`ID!`](#id) | ID (global ID) of the list. |
| <a id="boardlistissuescount"></a>`issuesCount` | [`Int`](#int) | Count of issues in the list. |
| <a id="boardlistiteration"></a>`iteration` | [`Iteration`](#iteration) | Iteration of the list. |
| <a id="boardlistlabel"></a>`label` | [`Label`](#label) | Label of the list. |
| <a id="boardlistlimitmetric"></a>`limitMetric` | [`ListLimitMetric`](#listlimitmetric) | Current limit metric for the list. |
| <a id="boardlistlisttype"></a>`listType` | [`String!`](#string) | Type of the list. |
| <a id="boardlistmaxissuecount"></a>`maxIssueCount` | [`Int`](#int) | Maximum number of issues in the list. |
| <a id="boardlistmaxissueweight"></a>`maxIssueWeight` | [`Int`](#int) | Maximum weight of issues in the list. |
| <a id="boardlistmilestone"></a>`milestone` | [`Milestone`](#milestone) | Milestone of the list. |
| <a id="boardlistposition"></a>`position` | [`Int`](#int) | Position of list within the board. |
| <a id="boardlisttitle"></a>`title` | [`String!`](#string) | Title of the list. |
| <a id="boardlisttotalweight"></a>`totalWeight` | [`Int`](#int) | Total weight of all issues in the list. |

#### Fields with arguments

##### `BoardList.issues`

Board issues.

Returns [`IssueConnection`](#issueconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistissuesfilters"></a>`filters` | [`BoardIssueInput`](#boardissueinput) | Filters applied when selecting issues in the board list. |

### `Branch`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchcommit"></a>`commit` | [`Commit`](#commit) | Commit for the branch. |
| <a id="branchname"></a>`name` | [`String!`](#string) | Name of the branch. |

### `BranchProtection`

Branch protection details for a branch rule.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchprotectionallowforcepush"></a>`allowForcePush` | [`Boolean!`](#boolean) | Toggle force push to the branch for users with write access. |
| <a id="branchprotectioncodeownerapprovalrequired"></a>`codeOwnerApprovalRequired` | [`Boolean!`](#boolean) | Enforce code owner approvals before allowing a merge. |
| <a id="branchprotectionmergeaccesslevels"></a>`mergeAccessLevels` | [`MergeAccessLevelConnection`](#mergeaccesslevelconnection) | Details about who can merge when this branch is the source branch. (see [Connections](#connections)) |
| <a id="branchprotectionpushaccesslevels"></a>`pushAccessLevels` | [`PushAccessLevelConnection`](#pushaccesslevelconnection) | Details about who can push when this branch is the source branch. (see [Connections](#connections)) |
| <a id="branchprotectionunprotectaccesslevels"></a>`unprotectAccessLevels` | [`UnprotectAccessLevelConnection`](#unprotectaccesslevelconnection) | Details about who can unprotect this branch. (see [Connections](#connections)) |

### `BranchRule`

List of branch rules for a project, grouped by branch name.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchruleapprovalrules"></a>`approvalRules` | [`ApprovalProjectRuleConnection`](#approvalprojectruleconnection) | Merge request approval rules configured for this branch rule. (see [Connections](#connections)) |
| <a id="branchrulebranchprotection"></a>`branchProtection` | [`BranchProtection`](#branchprotection) | Branch protections configured for this branch rule. |
| <a id="branchrulecreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of when the branch rule was created. |
| <a id="branchruleexternalstatuschecks"></a>`externalStatusChecks` | [`ExternalStatusCheckConnection`](#externalstatuscheckconnection) | External status checks configured for this branch rule. (see [Connections](#connections)) |
| <a id="branchruleisdefault"></a>`isDefault` | [`Boolean!`](#boolean) | Check if this branch rule protects the project's default branch. |
| <a id="branchruleisprotected"></a>`isProtected` | [`Boolean!`](#boolean) | Check if this branch rule protects access for the branch. |
| <a id="branchrulematchingbranchescount"></a>`matchingBranchesCount` | [`Int!`](#int) | Number of existing branches that match this branch rule. |
| <a id="branchrulename"></a>`name` | [`String!`](#string) | Branch name, with wildcards, for the branch rules. |
| <a id="branchruleupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of when the branch rule was last updated. |

### `BurnupChartDailyTotals`

Represents the total number of issues and their weights for a particular day.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="burnupchartdailytotalscompletedcount"></a>`completedCount` | [`Int!`](#int) | Number of closed issues as of this day. |
| <a id="burnupchartdailytotalscompletedweight"></a>`completedWeight` | [`Int!`](#int) | Total weight of closed issues as of this day. |
| <a id="burnupchartdailytotalsdate"></a>`date` | [`ISO8601Date!`](#iso8601date) | Date for burnup totals. |
| <a id="burnupchartdailytotalsscopecount"></a>`scopeCount` | [`Int!`](#int) | Number of issues as of this day. |
| <a id="burnupchartdailytotalsscopeweight"></a>`scopeWeight` | [`Int!`](#int) | Total weight of issues as of this day. |

### `CiApplicationSettings`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciapplicationsettingskeeplatestartifact"></a>`keepLatestArtifact` | [`Boolean`](#boolean) | Whether to keep the latest jobs artifacts. |

### `CiBuildNeed`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cibuildneedid"></a>`id` | [`ID!`](#id) | ID of the BuildNeed. |
| <a id="cibuildneedname"></a>`name` | [`String`](#string) | Name of the job we need to complete. |

### `CiCatalogResource`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcedescription"></a>`description` **{warning-solid}** | [`String`](#string) | **Introduced** in 15.11. This feature is an Experiment. It can be changed or removed at any time. Description of the catalog resource. |
| <a id="cicatalogresourceicon"></a>`icon` **{warning-solid}** | [`String`](#string) | **Introduced** in 15.11. This feature is an Experiment. It can be changed or removed at any time. Icon for the catalog resource. |
| <a id="cicatalogresourceid"></a>`id` **{warning-solid}** | [`ID!`](#id) | **Introduced** in 15.11. This feature is an Experiment. It can be changed or removed at any time. ID of the catalog resource. |
| <a id="cicatalogresourcename"></a>`name` **{warning-solid}** | [`String`](#string) | **Introduced** in 15.11. This feature is an Experiment. It can be changed or removed at any time. Name of the catalog resource. |

### `CiConfig`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigerrors"></a>`errors` | [`[String!]`](#string) | Linting errors. |
| <a id="ciconfigincludes"></a>`includes` | [`[CiConfigInclude!]`](#ciconfiginclude) | List of included files. |
| <a id="ciconfigmergedyaml"></a>`mergedYaml` | [`String`](#string) | Merged CI configuration YAML. |
| <a id="ciconfigstages"></a>`stages` | [`CiConfigStageConnection`](#ciconfigstageconnection) | Stages of the pipeline. (see [Connections](#connections)) |
| <a id="ciconfigstatus"></a>`status` | [`CiConfigStatus`](#ciconfigstatus) | Status of linting, can be either valid or invalid. |
| <a id="ciconfigwarnings"></a>`warnings` | [`[String!]`](#string) | Linting warnings. |

### `CiConfigGroup`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupjobs"></a>`jobs` | [`CiConfigJobConnection`](#ciconfigjobconnection) | Jobs in group. (see [Connections](#connections)) |
| <a id="ciconfiggroupname"></a>`name` | [`String`](#string) | Name of the job group. |
| <a id="ciconfiggroupsize"></a>`size` | [`Int`](#int) | Size of the job group. |

### `CiConfigInclude`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigincludeblob"></a>`blob` | [`String`](#string) | File blob location. It can be masked if it contains masked variables, e.g., "https://gitlab.com/gitlab-org/gitlab/-/blob/e52d6d0246d7375291850e61f0abc101fbda9dc2/.gitlab/ci/build-images.gitlab-ci.yml". |
| <a id="ciconfigincludecontextproject"></a>`contextProject` | [`String`](#string) | Current project scope, e.g., "gitlab-org/gitlab". |
| <a id="ciconfigincludecontextsha"></a>`contextSha` | [`String`](#string) | Current sha scope. |
| <a id="ciconfigincludeextra"></a>`extra` | [`JSON`](#json) | Extra information for the `include`, which can contain `job_name`, `project`, and `ref`. Values can be masked if they contain masked variables. |
| <a id="ciconfigincludelocation"></a>`location` | [`String`](#string) | File location. It can be masked if it contains masked variables, e.g., ".gitlab/ci/build-images.gitlab-ci.yml". |
| <a id="ciconfigincluderaw"></a>`raw` | [`String`](#string) | File raw location. It can be masked if it contains masked variables, e.g., "https://gitlab.com/gitlab-org/gitlab/-/raw/e52d6d0246d7375291850e61f0abc101fbda9dc2/.gitlab/ci/build-images.gitlab-ci.yml". |
| <a id="ciconfigincludetype"></a>`type` | [`CiConfigIncludeType`](#ciconfigincludetype) | Include type. |

### `CiConfigJob`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobafterscript"></a>`afterScript` | [`[String!]`](#string) | Override a set of commands that are executed after the job. |
| <a id="ciconfigjoballowfailure"></a>`allowFailure` | [`Boolean`](#boolean) | Allow job to fail. |
| <a id="ciconfigjobbeforescript"></a>`beforeScript` | [`[String!]`](#string) | Override a set of commands that are executed before the job. |
| <a id="ciconfigjobenvironment"></a>`environment` | [`String`](#string) | Name of an environment to which the job deploys. |
| <a id="ciconfigjobexcept"></a>`except` | [`CiConfigJobRestriction`](#ciconfigjobrestriction) | Limit when jobs are not created. |
| <a id="ciconfigjobgroupname"></a>`groupName` | [`String`](#string) | Name of the job group. |
| <a id="ciconfigjobname"></a>`name` | [`String`](#string) | Name of the job. |
| <a id="ciconfigjobneeds"></a>`needs` | [`CiConfigNeedConnection`](#ciconfigneedconnection) | Builds that must complete before the jobs run. (see [Connections](#connections)) |
| <a id="ciconfigjobonly"></a>`only` | [`CiConfigJobRestriction`](#ciconfigjobrestriction) | Jobs are created when these conditions do not apply. |
| <a id="ciconfigjobscript"></a>`script` | [`[String!]`](#string) | Shell script that is executed by a runner. |
| <a id="ciconfigjobstage"></a>`stage` | [`String`](#string) | Name of the job stage. |
| <a id="ciconfigjobtags"></a>`tags` | [`[String!]`](#string) | List of tags that are used to select a runner. |
| <a id="ciconfigjobwhen"></a>`when` | [`String`](#string) | When to run the job. |

### `CiConfigJobRestriction`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobrestrictionrefs"></a>`refs` | [`[String!]`](#string) | Git refs the job restriction applies to. |

### `CiConfigNeed`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigneedname"></a>`name` | [`String`](#string) | Name of the need. |

### `CiConfigStage`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigstagegroups"></a>`groups` | [`CiConfigGroupConnection`](#ciconfiggroupconnection) | Groups of jobs for the stage. (see [Connections](#connections)) |
| <a id="ciconfigstagename"></a>`name` | [`String`](#string) | Name of the stage. |

### `CiConfigVariable`

CI/CD config variables.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigvariabledescription"></a>`description` | [`String`](#string) | Description for the CI/CD config variable. |
| <a id="ciconfigvariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="ciconfigvariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="ciconfigvariablevalueoptions"></a>`valueOptions` | [`[String!]`](#string) | Value options for the variable. |

### `CiFreezePeriod`

Represents a deployment freeze window of a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cifreezeperiodcrontimezone"></a>`cronTimezone` | [`String`](#string) | Time zone for the cron fields, defaults to UTC if not provided. |
| <a id="cifreezeperiodendcron"></a>`endCron` | [`String!`](#string) | End of the freeze period in cron format. |
| <a id="cifreezeperiodendtime"></a>`endTime` | [`Time`](#time) | Timestamp (UTC) of when the current/next active period ends. |
| <a id="cifreezeperiodstartcron"></a>`startCron` | [`String!`](#string) | Start of the freeze period in cron format. |
| <a id="cifreezeperiodstarttime"></a>`startTime` | [`Time`](#time) | Timestamp (UTC) of when the current/next active period starts. |
| <a id="cifreezeperiodstatus"></a>`status` | [`CiFreezePeriodStatus!`](#cifreezeperiodstatus) | Freeze period status. |

### `CiGroup`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupdetailedstatus"></a>`detailedStatus` | [`DetailedStatus`](#detailedstatus) | Detailed status of the group. |
| <a id="cigroupid"></a>`id` | [`String!`](#string) | ID for a group. |
| <a id="cigroupjobs"></a>`jobs` | [`CiJobConnection`](#cijobconnection) | Jobs in group. (see [Connections](#connections)) |
| <a id="cigroupname"></a>`name` | [`String`](#string) | Name of the job group. |
| <a id="cigroupsize"></a>`size` | [`Int`](#int) | Size of the group. |

### `CiGroupVariable`

CI/CD variables for a group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupvariableenvironmentscope"></a>`environmentScope` | [`String`](#string) | Scope defining the environments that can use the variable. |
| <a id="cigroupvariableid"></a>`id` | [`ID!`](#id) | ID of the variable. |
| <a id="cigroupvariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="cigroupvariablemasked"></a>`masked` | [`Boolean`](#boolean) | Indicates whether the variable is masked. |
| <a id="cigroupvariableprotected"></a>`protected` | [`Boolean`](#boolean) | Indicates whether the variable is protected. |
| <a id="cigroupvariableraw"></a>`raw` | [`Boolean`](#boolean) | Indicates whether the variable is raw. |
| <a id="cigroupvariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="cigroupvariablevariabletype"></a>`variableType` | [`CiVariableType`](#civariabletype) | Type of the variable. |

### `CiInstanceVariable`

CI/CD variables for a GitLab instance.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableenvironmentscope"></a>`environmentScope` **{warning-solid}** | [`String`](#string) | **Deprecated** in 15.3. No longer used, only available for GroupVariableType and ProjectVariableType. |
| <a id="ciinstancevariableid"></a>`id` | [`ID!`](#id) | ID of the variable. |
| <a id="ciinstancevariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="ciinstancevariablemasked"></a>`masked` | [`Boolean`](#boolean) | Indicates whether the variable is masked. |
| <a id="ciinstancevariableprotected"></a>`protected` | [`Boolean`](#boolean) | Indicates whether the variable is protected. |
| <a id="ciinstancevariableraw"></a>`raw` | [`Boolean`](#boolean) | Indicates whether the variable is raw. |
| <a id="ciinstancevariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="ciinstancevariablevariabletype"></a>`variableType` | [`CiVariableType`](#civariabletype) | Type of the variable. |

### `CiJob`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobactive"></a>`active` | [`Boolean!`](#boolean) | Indicates the job is active. |
| <a id="cijoballowfailure"></a>`allowFailure` | [`Boolean!`](#boolean) | Whether the job is allowed to fail. |
| <a id="cijobartifacts"></a>`artifacts` | [`CiJobArtifactConnection`](#cijobartifactconnection) | Artifacts generated by the job. (see [Connections](#connections)) |
| <a id="cijobbrowseartifactspath"></a>`browseArtifactsPath` | [`String`](#string) | URL for browsing the artifact's archive. |
| <a id="cijobcanplayjob"></a>`canPlayJob` | [`Boolean!`](#boolean) | Indicates whether the current user can play the job. |
| <a id="cijobcancelable"></a>`cancelable` | [`Boolean!`](#boolean) | Indicates the job can be canceled. |
| <a id="cijobcommitpath"></a>`commitPath` | [`String`](#string) | Path to the commit that triggered the job. |
| <a id="cijobcoverage"></a>`coverage` | [`Float`](#float) | Coverage level of the job. |
| <a id="cijobcreatedat"></a>`createdAt` | [`Time!`](#time) | When the job was created. |
| <a id="cijobcreatedbytag"></a>`createdByTag` | [`Boolean!`](#boolean) | Whether the job was created by a tag. |
| <a id="cijobdetailedstatus"></a>`detailedStatus` | [`DetailedStatus`](#detailedstatus) | Detailed status of the job. |
| <a id="cijobdownstreampipeline"></a>`downstreamPipeline` | [`Pipeline`](#pipeline) | Downstream pipeline for a bridge. |
| <a id="cijobduration"></a>`duration` | [`Int`](#int) | Duration of the job in seconds. |
| <a id="cijoberasedat"></a>`erasedAt` | [`Time`](#time) | When the job was erased. |
| <a id="cijobfailuremessage"></a>`failureMessage` | [`String`](#string) | Message on why the job failed. |
| <a id="cijobfinishedat"></a>`finishedAt` | [`Time`](#time) | When a job has finished running. |
| <a id="cijobid"></a>`id` | [`JobID`](#jobid) | ID of the job. |
| <a id="cijobkind"></a>`kind` | [`CiJobKind!`](#cijobkind) | Indicates the type of job. |
| <a id="cijobmanualjob"></a>`manualJob` | [`Boolean`](#boolean) | Whether the job has a manual action. |
| <a id="cijobmanualvariables"></a>`manualVariables` | [`CiManualVariableConnection`](#cimanualvariableconnection) | Variables added to a manual job when the job is triggered. (see [Connections](#connections)) |
| <a id="cijobname"></a>`name` | [`String`](#string) | Name of the job. |
| <a id="cijobneeds"></a>`needs` | [`CiBuildNeedConnection`](#cibuildneedconnection) | References to builds that must complete before the jobs run. (see [Connections](#connections)) |
| <a id="cijobpipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | Pipeline the job belongs to. |
| <a id="cijobplaypath"></a>`playPath` | [`String`](#string) | Play path of the job. |
| <a id="cijobplayable"></a>`playable` | [`Boolean!`](#boolean) | Indicates the job can be played. |
| <a id="cijobpreviousstagejobsorneeds"></a>`previousStageJobsOrNeeds` | [`JobNeedUnionConnection`](#jobneedunionconnection) | Jobs that must complete before the job runs. Returns `BuildNeed`, which is the needed jobs if the job uses the `needs` keyword, or the previous stage jobs otherwise. (see [Connections](#connections)) |
| <a id="cijobproject"></a>`project` | [`Project`](#project) | Project that the job belongs to. |
| <a id="cijobqueuedat"></a>`queuedAt` | [`Time`](#time) | When the job was enqueued and marked as pending. |
| <a id="cijobqueuedduration"></a>`queuedDuration` | [`Duration`](#duration) | How long the job was enqueued before starting. |
| <a id="cijobrefname"></a>`refName` | [`String`](#string) | Ref name of the job. |
| <a id="cijobrefpath"></a>`refPath` | [`String`](#string) | Path to the ref. |
| <a id="cijobretried"></a>`retried` | [`Boolean`](#boolean) | Indicates that the job has been retried. |
| <a id="cijobretryable"></a>`retryable` | [`Boolean!`](#boolean) | Indicates the job can be retried. |
| <a id="cijobrunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner assigned to execute the job. |
| <a id="cijobrunnermanager"></a>`runnerManager` **{warning-solid}** | [`CiRunnerManager`](#cirunnermanager) | **Introduced** in 15.11. This feature is an Experiment. It can be changed or removed at any time. Runner manager assigned to the job. |
| <a id="cijobscheduled"></a>`scheduled` | [`Boolean!`](#boolean) | Indicates the job is scheduled. |
| <a id="cijobscheduledat"></a>`scheduledAt` | [`Time`](#time) | Schedule for the build. |
| <a id="cijobschedulingtype"></a>`schedulingType` | [`String`](#string) | Type of job scheduling. Value is `dag` if the job uses the `needs` keyword, and `stage` otherwise. |
| <a id="cijobshortsha"></a>`shortSha` | [`String!`](#string) | Short SHA1 ID of the commit. |
| <a id="cijobstage"></a>`stage` | [`CiStage`](#cistage) | Stage of the job. |
| <a id="cijobstartedat"></a>`startedAt` | [`Time`](#time) | When the job was started. |
| <a id="cijobstatus"></a>`status` | [`CiJobStatus`](#cijobstatus) | Status of the job. |
| <a id="cijobstuck"></a>`stuck` | [`Boolean!`](#boolean) | Indicates the job is stuck. |
| <a id="cijobtags"></a>`tags` | [`[String!]`](#string) | Tags for the current job. |
| <a id="cijobtrace"></a>`trace` | [`CiJobTrace`](#cijobtrace) | Trace generated by the job. |
| <a id="cijobtriggered"></a>`triggered` | [`Boolean`](#boolean) | Whether the job was triggered. |
| <a id="cijobuserpermissions"></a>`userPermissions` | [`JobPermissions!`](#jobpermissions) | Permissions for the current user on the resource. |
| <a id="cijobwebpath"></a>`webPath` | [`String`](#string) | Web path of the job. |

### `CiJobArtifact`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobartifactdownloadpath"></a>`downloadPath` | [`String`](#string) | URL for downloading the artifact's file. |
| <a id="cijobartifactexpireat"></a>`expireAt` | [`Time`](#time) | Expiry date of the artifact. |
| <a id="cijobartifactfiletype"></a>`fileType` | [`JobArtifactFileType`](#jobartifactfiletype) | File type of the artifact. |
| <a id="cijobartifactid"></a>`id` | [`CiJobArtifactID!`](#cijobartifactid) | ID of the artifact. |
| <a id="cijobartifactname"></a>`name` | [`String`](#string) | File name of the artifact. |
| <a id="cijobartifactsize"></a>`size` | [`Int!`](#int) | Size of the artifact in bytes. |

### `CiJobTokenScopeType`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenscopetypeinboundallowlist"></a>`inboundAllowlist` | [`ProjectConnection!`](#projectconnection) | Allow list of projects that can access the current project through its CI Job tokens. (see [Connections](#connections)) |
| <a id="cijobtokenscopetypeoutboundallowlist"></a>`outboundAllowlist` | [`ProjectConnection!`](#projectconnection) | Allow list of projects that are accessible using the current project's CI Job tokens. (see [Connections](#connections)) |
| <a id="cijobtokenscopetypeprojects"></a>`projects` **{warning-solid}** | [`ProjectConnection!`](#projectconnection) | **Deprecated** in 15.9. The `projects` attribute is being deprecated. Use `outbound_allowlist`. |

### `CiJobTrace`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtracehtmlsummary"></a>`htmlSummary` **{warning-solid}** | [`String!`](#string) | **Introduced** in 15.11. This feature is an Experiment. It can be changed or removed at any time. HTML summary containing the last 10 lines of the trace. |

### `CiJobsDurationStatistics`

Representation of duration statistics for a group of CI jobs.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobsdurationstatisticsp50"></a>`p50` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in 15.8. This feature is an Experiment. It can be changed or removed at any time. 50th percentile. 50% of the durations are lower than this value. |
| <a id="cijobsdurationstatisticsp75"></a>`p75` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in 15.8. This feature is an Experiment. It can be changed or removed at any time. 75th percentile. 75% of the durations are lower than this value. |
| <a id="cijobsdurationstatisticsp90"></a>`p90` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in 15.8. This feature is an Experiment. It can be changed or removed at any time. 90th percentile. 90% of the durations are lower than this value. |
| <a id="cijobsdurationstatisticsp95"></a>`p95` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in 15.8. This feature is an Experiment. It can be changed or removed at any time. 95th percentile. 95% of the durations are lower than this value. |
| <a id="cijobsdurationstatisticsp99"></a>`p99` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in 15.8. This feature is an Experiment. It can be changed or removed at any time. 99th percentile. 99% of the durations are lower than this value. |

### `CiJobsStatistics`

Statistics for a group of CI jobs.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobsstatisticsqueuedduration"></a>`queuedDuration` **{warning-solid}** | [`CiJobsDurationStatistics`](#cijobsdurationstatistics) | **Introduced** in 15.8. This feature is an Experiment. It can be changed or removed at any time. Statistics for amount of time that jobs were waiting to be picked up. The calculation is performed based on the most recent 100 jobs executed by the 5000 most recently created runners in context. If no filter is applied to runners, the calculation is performed based on the most recent 100 jobs globally. |

### `CiManualVariable`

CI/CD variables given to a manual job.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cimanualvariableenvironmentscope"></a>`environmentScope` **{warning-solid}** | [`String`](#string) | **Deprecated** in 15.3. No longer used, only available for GroupVariableType and ProjectVariableType. |
| <a id="cimanualvariableid"></a>`id` | [`ID!`](#id) | ID of the variable. |
| <a id="cimanualvariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="cimanualvariableraw"></a>`raw` | [`Boolean`](#boolean) | Indicates whether the variable is raw. |
| <a id="cimanualvariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="cimanualvariablevariabletype"></a>`variableType` | [`CiVariableType`](#civariabletype) | Type of the variable. |

### `CiMinutesNamespaceMonthlyUsage`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageminutes"></a>`minutes` | [`Int`](#int) | Total number of minutes used by all projects in the namespace. |
| <a id="ciminutesnamespacemonthlyusagemonth"></a>`month` | [`String`](#string) | Month related to the usage data. |
| <a id="ciminutesnamespacemonthlyusagemonthiso8601"></a>`monthIso8601` | [`ISO8601Date`](#iso8601date) | Month related to the usage data in ISO 8601 date format. |
| <a id="ciminutesnamespacemonthlyusageprojects"></a>`projects` | [`CiMinutesProjectMonthlyUsageConnection`](#ciminutesprojectmonthlyusageconnection) | CI/CD minutes usage data for projects in the namespace. (see [Connections](#connections)) |
| <a id="ciminutesnamespacemonthlyusagesharedrunnersduration"></a>`sharedRunnersDuration` | [`Int`](#int) | Total duration (in seconds) of shared runners use by the namespace for the month. |

### `CiMinutesProjectMonthlyUsage`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageminutes"></a>`minutes` | [`Int`](#int) | Number of CI/CD minutes used by the project in the month. |
| <a id="ciminutesprojectmonthlyusagename"></a>`name` **{warning-solid}** | [`String`](#string) | **Deprecated** in 15.6. Use `project.name`. |
| <a id="ciminutesprojectmonthlyusageproject"></a>`project` | [`Project`](#project) | Project having the recorded usage. |
| <a id="ciminutesprojectmonthlyusagesharedrunnersduration"></a>`sharedRunnersDuration` | [`Int`](#int) | Total duration (in seconds) of shared runners use by the project for the month. |

### `CiProjectVariable`

CI/CD variables for a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableenvironmentscope"></a>`environmentScope` | [`String`](#string) | Scope defining the environments that can use the variable. |
| <a id="ciprojectvariableid"></a>`id` | [`ID!`](#id) | ID of the variable. |
| <a id="ciprojectvariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="ciprojectvariablemasked"></a>`masked` | [`Boolean`](#boolean) | Indicates whether the variable is masked. |
| <a id="ciprojectvariableprotected"></a>`protected` | [`Boolean`](#boolean) | Indicates whether the variable is protected. |
| <a id="ciprojectvariableraw"></a>`raw` | [`Boolean`](#boolean) | Indicates whether the variable is raw. |
| <a id="ciprojectvariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="ciprojectvariablevariabletype"></a>`variableType` | [`CiVariableType`](#civariabletype) | Type of the variable. |

### `CiRunner`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunneraccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel!`](#cirunneraccesslevel) | Access level of the runner. |
| <a id="cirunneractive"></a>`active` **{warning-solid}** | [`Boolean!`](#boolean) | **Deprecated** in 14.8. Use paused. |
| <a id="cirunneradminurl"></a>`adminUrl` | [`String`](#string) | Admin URL of the runner. Only available for administrators. |
| <a id="cirunnerarchitecturename"></a>`architectureName` | [`String`](#string) | Architecture provided by the the runner. |
| <a id="cirunnercontactedat"></a>`contactedAt` | [`Time`](#time) | Timestamp of last contact from this runner. |
| <a id="cirunnercreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of creation of this runner. |
| <a id="cirunnercreatedby"></a>`createdBy` | [`UserCore`](#usercore) | User that created this runner. |
| <a id="cirunnerdescription"></a>`description` | [`String`](#string) | Description of the runner. |
| <a id="cirunnereditadminurl"></a>`editAdminUrl` | [`String`](#string) | Admin form URL of the runner. Only available for administrators. |
| <a id="cirunnerephemeralauthenticationtoken"></a>`ephemeralAuthenticationToken` **{warning-solid}** | [`String`](#string) | **Introduced** in 15.9. This feature is an Experiment. It can be changed or removed at any time. Ephemeral authentication token used for runner manager registration. Only available for the creator of the runner for a limited time during registration. |
| <a id="cirunnerephemeralregisterurl"></a>`ephemeralRegisterUrl` **{warning-solid}** | [`String`](#string) | **Introduced** in 15.11. This feature is an Experiment. It can be changed or removed at any time. URL of the registration page of the runner manager. Only available for the creator of the runner for a limited time during registration. |
| <a id="cirunnerexecutorname"></a>`executorName` | [`String`](#string) | Executor last advertised by the runner. |
| <a id="cirunnergroups"></a>`groups` | [`GroupConnection`](#groupconnection) | Groups the runner is associated with. For group runners only. (see [Connections](#connections)) |
| <a id="cirunnerid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | ID of the runner. |
| <a id="cirunneripaddress"></a>`ipAddress` | [`String`](#string) | IP address of the runner. |
| <a id="cirunnerjobcount"></a>`jobCount` | [`Int`](#int) | Number of jobs processed by the runner (limited to 1000, plus one to indicate that more items exist). |
| <a id="cirunnerjobexecutionstatus"></a>`jobExecutionStatus` **{warning-solid}** | [`CiRunnerJobExecutionStatus`](#cirunnerjobexecutionstatus) | **Introduced** in 15.7. This feature is an Experiment. It can be changed or removed at any time. Job execution status of the runner. |
| <a id="cirunnerlocked"></a>`locked` | [`Boolean`](#boolean) | Indicates the runner is locked. |
| <a id="cirunnermaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runner's maintenance notes. |
| <a id="cirunnermaintenancenotehtml"></a>`maintenanceNoteHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `maintenance_note`. |
| <a id="cirunnermanagers"></a>`managers` **{warning-solid}** | [`CiRunnerManagerConnection`](#cirunnermanagerconnection) | **Introduced** in 15.10. This feature is an Experiment. It can be changed or removed at any time. Machines associated with the runner configuration. |
| <a id="cirunnermaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Maximum timeout (in seconds) for jobs processed by the runner. |
| <a id="cirunnerownerproject"></a>`ownerProject` | [`Project`](#project) | Project that owns the runner. For project runners only. |
| <a id="cirunnerpaused"></a>`paused` | [`Boolean!`](#boolean) | Indicates the runner is paused and not available to run jobs. |
| <a id="cirunnerplatformname"></a>`platformName` | [`String`](#string) | Platform provided by the runner. |
| <a id="cirunnerprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` | [`Float`](#float) | Private projects' "minutes cost factor" associated with the runner (GitLab.com only). |
| <a id="cirunnerprojectcount"></a>`projectCount` | [`Int`](#int) | Number of projects that the runner is associated with. |
| <a id="cirunnerpublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` | [`Float`](#float) | Public projects' "minutes cost factor" associated with the runner (GitLab.com only). |
| <a id="cirunnerregisteradminurl"></a>`registerAdminUrl` | [`String`](#string) | URL of the temporary registration page of the runner. Only available before the runner is registered. Only available for administrators. |
| <a id="cirunnerrevision"></a>`revision` | [`String`](#string) | Revision of the runner. |
| <a id="cirunnerrununtagged"></a>`runUntagged` | [`Boolean!`](#boolean) | Indicates the runner is able to run untagged jobs. |
| <a id="cirunnerrunnertype"></a>`runnerType` | [`CiRunnerType!`](#cirunnertype) | Type of the runner. |
| <a id="cirunnershortsha"></a>`shortSha` | [`String`](#string) | First eight characters of the runner's token used to authenticate new job requests. Used as the runner's unique ID. |
| <a id="cirunnertaglist"></a>`tagList` | [`[String!]`](#string) | Tags associated with the runner. |
| <a id="cirunnertokenexpiresat"></a>`tokenExpiresAt` | [`Time`](#time) | Runner token expiration time. |
| <a id="cirunnerupgradestatus"></a>`upgradeStatus` **{warning-solid}** | [`CiRunnerUpgradeStatus`](#cirunnerupgradestatus) | **Introduced** in 14.10. This feature is an Experiment. It can be changed or removed at any time. Availability of upgrades for the runner. |
| <a id="cirunneruserpermissions"></a>`userPermissions` | [`RunnerPermissions!`](#runnerpermissions) | Permissions for the current user on the resource. |
| <a id="cirunnerversion"></a>`version` | [`String`](#string) | Version of the runner. |

#### Fields with arguments

##### `CiRunner.jobs`

Jobs assigned to the runner. This field can only be resolved for one runner in any single request.

Returns [`CiJobConnection`](#cijobconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerjobsstatuses"></a>`statuses` | [`[CiJobStatus!]`](#cijobstatus) | Filter jobs by status. |

##### `CiRunner.projects`

Find projects the runner is associated with. For project runners only.

Returns [`ProjectConnection`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerprojectsmembership"></a>`membership` | [`Boolean`](#boolean) | Return only projects that the current user is a member of. |
| <a id="cirunnerprojectssearch"></a>`search` | [`String`](#string) | Search query, which can be for the project name, a path, or a description. |
| <a id="cirunnerprojectssearchnamespaces"></a>`searchNamespaces` | [`Boolean`](#boolean) | Include namespace in project search. |
| <a id="cirunnerprojectssort"></a>`sort` **{warning-solid}** | [`String`](#string) | **Deprecated** in 15.4. Default sort order will change in GitLab 17.0. Specify `"id_asc"` if you require the query results to be ordered by ascending IDs. |
| <a id="cirunnerprojectstopics"></a>`topics` | [`[String!]`](#string) | Filter projects by topics. |

##### `CiRunner.status`

Status of the runner.

Returns [`CiRunnerStatus!`](#cirunnerstatus).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerstatuslegacymode"></a>`legacyMode` **{warning-solid}** | [`String`](#string) | **Deprecated** in 15.0. Will be removed in 17.0. |

### `CiRunnerManager`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnermanagerarchitecturename"></a>`architectureName` | [`String`](#string) | Architecture provided by the runner manager. |
| <a id="cirunnermanagercontactedat"></a>`contactedAt` | [`Time`](#time) | Timestamp of last contact from the runner manager. |
| <a id="cirunnermanagercreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of creation of the runner manager. |
| <a id="cirunnermanagerexecutorname"></a>`executorName` | [`String`](#string) | Executor last advertised by the runner. |
| <a id="cirunnermanagerid"></a>`id` | [`CiRunnerManagerID!`](#cirunnermanagerid) | ID of the runner manager. |
| <a id="cirunnermanageripaddress"></a>`ipAddress` | [`String`](#string) | IP address of the runner manager. |
| <a id="cirunnermanagerplatformname"></a>`platformName` | [`String`](#string) | Platform provided by the runner manager. |
| <a id="cirunnermanagerrevision"></a>`revision` | [`String`](#string) | Revision of the runner. |
| <a id="cirunnermanagerrunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner configuration for the runner manager. |
| <a id="cirunnermanagerstatus"></a>`status` | [`CiRunnerStatus!`](#cirunnerstatus) | Status of the runner manager. |
| <a id="cirunnermanagersystemid"></a>`systemId` | [`String!`](#string) | System ID associated with the runner manager. |
| <a id="cirunnermanagerversion"></a>`version` | [`String`](#string) | Version of the runner. |

### `CiSecureFileRegistry`

Represents the Geo replication and verification state of a ci_secure_file.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistrycisecurefileid"></a>`ciSecureFileId` | [`ID!`](#id) | ID of the Ci Secure File. |
| <a id="cisecurefileregistrycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the CiSecureFileRegistry was created. |
| <a id="cisecurefileregistryid"></a>`id` | [`ID!`](#id) | ID of the CiSecureFileRegistry. |
| <a id="cisecurefileregistrylastsyncfailure"></a>`lastSyncFailure` | [`String`](#string) | Error message during sync of the CiSecureFileRegistry. |
| <a id="cisecurefileregistrylastsyncedat"></a>`lastSyncedAt` | [`Time`](#time) | Timestamp of the most recent successful sync of the CiSecureFileRegistry. |
| <a id="cisecurefileregistryretryat"></a>`retryAt` | [`Time`](#time) | Timestamp after which the CiSecureFileRegistry is resynced. |
| <a id="cisecurefileregistryretrycount"></a>`retryCount` | [`Int`](#int) | Number of consecutive failed sync attempts of the CiSecureFileRegistry. |
| <a id="cisecurefileregistrystate"></a>`state` | [`RegistryState`](#registrystate) | Sync state of the CiSecureFileRegistry. |
| <a id="cisecurefileregistryverificationretryat"></a>`verificationRetryAt` | [`Time`](#time) | Timestamp after which the CiSecureFileRegistry is reverified. |
| <a id="cisecurefileregistryverifiedat"></a>`verifiedAt` | [`Time`](#time) | Timestamp of the most recent successful verification of the CiSecureFileRegistry. |

### `CiStage`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cistagedetailedstatus"></a>`detailedStatus` | [`DetailedStatus`](#detailedstatus) | Detailed status of the stage. |
| <a id="cistagegroups"></a>`groups` | [`CiGroupConnection`](#cigroupconnection) | Group of jobs for the stage. (see [Connections](#connections)) |
| <a id="cistageid"></a>`id` | [`ID!`](#id) | ID of the stage. |
| <a id="cistagejobs"></a>`jobs` | [`CiJobConnection`](#cijobconnection) | Jobs for the stage. (see [Connections](#connections)) |
| <a id="cistagename"></a>`name` | [`String`](#string) | Name of the stage. |
| <a id="cistagestatus"></a>`status` | [`String`](#string) | Status of the pipeline stage. |

### `CiTemplate`

GitLab CI/CD configuration template.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="citemplatecontent"></a>`content` | [`String!`](#string) | Contents of the CI template. |
| <a id="citemplatename"></a>`name` | [`String!`](#string) | Name of the CI template. |

### `ClusterAgent`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityevents"></a>`activityEvents` | [`ClusterAgentActivityEventConnection`](#clusteragentactivityeventconnection) | Recent activity for the cluster agent. (see [Connections](#connections)) |
| <a id="clusteragentconnections"></a>`connections` | [`ConnectedAgentConnection`](#connectedagentconnection) | Active connections for the cluster agent. (see [Connections](#connections)) |
| <a id="clusteragentcreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp the cluster agent was created. |
| <a id="clusteragentcreatedbyuser"></a>`createdByUser` | [`UserCore`](#usercore) | User object, containing information about the person who created the agent. |
| <a id="clusteragentid"></a>`id` | [`ID!`](#id) | ID of the cluster agent. |
| <a id="clusteragentname"></a>`name` | [`String`](#string) | Name of the cluster agent. |
| <a id="clusteragentproject"></a>`project` | [`Project`](#project) | Project this cluster agent is associated with. |
| <a id="clusteragenttokens"></a>`tokens` | [`ClusterAgentTokenConnection`](#clusteragenttokenconnection) | Tokens associated with the cluster agent. (see [Connections](#connections)) |
| <a id="clusteragentupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp the cluster agent was updated. |
| <a id="clusteragentvulnerabilityimages"></a>`vulnerabilityImages` | [`VulnerabilityContainerImageConnection`](#vulnerabilitycontainerimageconnection) | Container images reported on the agent vulnerabilities. (see [Connections](#connections)) |
| <a id="clusteragentwebpath"></a>`webPath` | [`String`](#string) | Web path of the cluster agent. |

### `ClusterAgentActivityEvent`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventagenttoken"></a>`agentToken` | [`ClusterAgentToken`](#clusteragenttoken) | Agent token associated with the event. |
| <a id="clusteragentactivityeventkind"></a>`kind` | [`String`](#string) | Type of event. |
| <a id="clusteragentactivityeventlevel"></a>`level` | [`String`](#string) | Severity of the event. |
| <a id="clusteragentactivityeventrecordedat"></a>`recordedAt` | [`Time`](#time) | Timestamp the event was recorded. |
| <a id="clusteragentactivityeventuser"></a>`user` | [`UserCore`](#usercore) | User associated with the event. |

### `ClusterAgentAuthorizationCiAccess`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessagent"></a>`agent` | [`ClusterAgent`](#clusteragent) | Authorized cluster agent. |
| <a id="clusteragentauthorizationciaccessconfig"></a>`config` | [`JSON`](#json) | Configuration for the authorized project. |

### `ClusterAgentAuthorizationUserAccess`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessagent"></a>`agent` | [`ClusterAgent`](#clusteragent) | Authorized cluster agent. |
| <a id="clusteragentauthorizationuseraccessconfig"></a>`config` | [`JSON`](#json) | Configuration for the authorized project. |

### `ClusterAgentToken`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenclusteragent"></a>`clusterAgent` | [`ClusterAgent`](#clusteragent) | Cluster agent this token is associated with. |
| <a id="clusteragenttokencreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp the token was created. |
| <a id="clusteragenttokencreatedbyuser"></a>`createdByUser` | [`UserCore`](#usercore) | User who created the token. |
| <a id="clusteragenttokendescription"></a>`description` | [`String`](#string) | Description of the token. |
| <a id="clusteragenttokenid"></a>`id` | [`ClustersAgentTokenID!`](#clustersagenttokenid) | Global ID of the token. |
| <a id="clusteragenttokenlastusedat"></a>`lastUsedAt` | [`Time`](#time) | Timestamp the token was last used. |
| <a id="clusteragenttokenname"></a>`name` | [`String`](#string) | Name given to the token. |
| <a id="clusteragenttokenstatus"></a>`status` | [`AgentTokenStatus`](#agenttokenstatus) | Current status of the token. |

### `CodeCoverageActivity`

Represents the code coverage activity for a group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityaveragecoverage"></a>`averageCoverage` | [`Float`](#float) | Average percentage of the different code coverage results available for the group. |
| <a id="codecoverageactivitycoveragecount"></a>`coverageCount` | [`Int`](#int) | Number of different code coverage results available for the group. |
| <a id="codecoverageactivitydate"></a>`date` | [`Date!`](#date) | Date when the code coverage was created. |
| <a id="codecoverageactivityprojectcount"></a>`projectCount` | [`Int`](#int) | Number of projects with code coverage results for the group. |

### `CodeCoverageSummary`

Represents the code coverage summary for a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoveragesummaryaveragecoverage"></a>`averageCoverage` | [`Float`](#float) | Average percentage of the different code coverage results available for the project. |
| <a id="codecoveragesummarycoveragecount"></a>`coverageCount` | [`Int`](#int) | Number of different code coverage results available. |
| <a id="codecoveragesummarylastupdatedon"></a>`lastUpdatedOn` | [`Date`](#date) | Latest date when the code coverage was created for the project. |

### `CodeQualityDegradation`

Represents a code quality degradation on the pipeline.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationdescription"></a>`description` | [`String!`](#string) | Description of the code quality degradation. |
| <a id="codequalitydegradationenginename"></a>`engineName` | [`String!`](#string) | Code Quality plugin that reported the finding. |
| <a id="codequalitydegradationfingerprint"></a>`fingerprint` | [`String!`](#string) | Unique fingerprint to identify the code quality degradation. For example, an MD5 hash. |
| <a id="codequalitydegradationline"></a>`line` | [`Int!`](#int) | Line on which the code quality degradation occurred. |
| <a id="codequalitydegradationpath"></a>`path` | [`String!`](#string) | Relative path to the file containing the code quality degradation. |
| <a id="codequalitydegradationseverity"></a>`severity` | [`CodeQualityDegradationSeverity!`](#codequalitydegradationseverity) | Status of the degradation (BLOCKER, CRITICAL, MAJOR, MINOR, INFO, UNKNOWN). |
| <a id="codequalitydegradationweburl"></a>`webUrl` | [`String`](#string) | URL to the file along with line number. |

### `CodeQualityReportSummary`

Code Quality report for a pipeline.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalityreportsummaryblocker"></a>`blocker` | [`Int`](#int) | Total number of blocker status. |
| <a id="codequalityreportsummarycount"></a>`count` | [`Int`](#int) | Total number of Code Quality reports. |
| <a id="codequalityreportsummarycritical"></a>`critical` | [`Int`](#int) | Total number of critical status. |
| <a id="codequalityreportsummaryinfo"></a>`info` | [`Int`](#int) | Total number of info status. |
| <a id="codequalityreportsummarymajor"></a>`major` | [`Int`](#int) | Total number of major status. |
| <a id="codequalityreportsummaryminor"></a>`minor` | [`Int`](#int) | Total number of minor status. |
| <a id="codequalityreportsummaryunknown"></a>`unknown` | [`Int`](#int) | Total number of unknown status. |

### `Commit`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitauthor"></a>`author` | [`UserCore`](#usercore) | Author of the commit. |
| <a id="commitauthoremail"></a>`authorEmail` | [`String`](#string) | Commit author's email. |
| <a id="commitauthorgravatar"></a>`authorGravatar` | [`String`](#string) | Commit authors gravatar. |
| <a id="commitauthorname"></a>`authorName` | [`String`](#string) | Commit authors name. |
| <a id="commitauthoreddate"></a>`authoredDate` | [`Time`](#time) | Timestamp of when the commit was authored. |
| <a id="commitdescription"></a>`description` | [`String`](#string) | Description of the commit message. |
| <a id="commitdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="commitfulltitle"></a>`fullTitle` | [`String`](#string) | Full title of the commit message. |
| <a id="commitfulltitlehtml"></a>`fullTitleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `full_title`. |
| <a id="commitid"></a>`id` | [`ID!`](#id) | ID (global ID) of the commit. |
| <a id="commitmessage"></a>`message` | [`String`](#string) | Raw commit message. |
| <a id="commitsha"></a>`sha` | [`String!`](#string) | SHA1 ID of the commit. |
| <a id="commitshortid"></a>`shortId` | [`String!`](#string) | Short SHA1 ID of the commit. |
| <a id="commitsignature"></a>`signature` | [`CommitSignature`](#commitsignature) | Signature of the commit. |
| <a id="commitsignaturehtml"></a>`signatureHtml` | [`String`](#string) | Rendered HTML of the commit signature. |
| <a id="committitle"></a>`title` | [`String`](#string) | Title of the commit message. |
| <a id="committitlehtml"></a>`titleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `title`. |
| <a id="commitwebpath"></a>`webPath` | [`String!`](#string) | Web path of the commit. |
| <a id="commitweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the commit. |

#### Fields with arguments

##### `Commit.pipelines`

Pipelines of the commit ordered latest first.

Returns [`PipelineConnection`](#pipelineconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitpipelinesref"></a>`ref` | [`String`](#string) | Filter pipelines by the ref they are run for. |
| <a id="commitpipelinesscope"></a>`scope` | [`PipelineScopeEnum`](#pipelinescopeenum) | Filter pipelines by scope. |
| <a id="commitpipelinessha"></a>`sha` | [`String`](#string) | Filter pipelines by the sha of the commit they are run for. |
| <a id="commitpipelinessource"></a>`source` | [`String`](#string) | Filter pipelines by their source. |
| <a id="commitpipelinesstatus"></a>`status` | [`PipelineStatusEnum`](#pipelinestatusenum) | Filter pipelines by their status. |
| <a id="commitpipelinesupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Pipelines updated after this date. |
| <a id="commitpipelinesupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Pipelines updated before this date. |
| <a id="commitpipelinesusername"></a>`username` | [`String`](#string) | Filter pipelines by the user that triggered the pipeline. |

### `CommitParentNames`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitparentnamesnames"></a>`names` | [`[String!]`](#string) | Names of the commit parent (branch or tag). |

### `CommitReferences`

#### Fields with arguments

##### `CommitReferences.containingBranches`

Get branch names containing a given commit.

Returns [`CommitParentNames`](#commitparentnames).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitreferencescontainingbranchesexcludetipped"></a>`excludeTipped` | [`Boolean!`](#boolean) | Exclude tipping refs. WARNING: This argument can be confusing, if there is a limit. for example set the limit to 5 and in the 5 out a total of 25 refs there is 2 tipped refs, then the method will only 3 refs, even though there is more. |
| <a id="commitreferencescontainingbrancheslimit"></a>`limit` | [`Int!`](#int) | Number of ref names to return. |

##### `CommitReferences.containingTags`

Get tag names containing a given commit.

Returns [`CommitParentNames`](#commitparentnames).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitreferencescontainingtagsexcludetipped"></a>`excludeTipped` | [`Boolean!`](#boolean) | Exclude tipping refs. WARNING: This argument can be confusing, if there is a limit. for example set the limit to 5 and in the 5 out a total of 25 refs there is 2 tipped refs, then the method will only 3 refs, even though there is more. |
| <a id="commitreferencescontainingtagslimit"></a>`limit` | [`Int!`](#int) | Number of ref names to return. |

##### `CommitReferences.tippingBranches`

Get branch names tipping at a given commit.

Returns [`CommitParentNames`](#commitparentnames).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitreferencestippingbrancheslimit"></a>`limit` | [`Int!`](#int) | Number of ref names to return. |

##### `CommitReferences.tippingTags`

Get tag names tipping at a given commit.

Returns [`CommitParentNames`](#commitparentnames).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitreferencestippingtagslimit"></a>`limit` | [`Int!`](#int) | Number of ref names to return. |

### `ComplianceFramework`

Represents a ComplianceFramework associated with a Project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworkcolor"></a>`color` | [`String!`](#string) | Hexadecimal representation of compliance framework's label color. |
| <a id="complianceframeworkdefault"></a>`default` | [`Boolean`](#boolean) | Default compliance framework for the group. |
| <a id="complianceframeworkdescription"></a>`description` | [`String!`](#string) | Description of the compliance framework. |
| <a id="complianceframeworkid"></a>`id` | [`ID!`](#id) | Compliance framework ID. |
| <a id="complianceframeworkname"></a>`name` | [`String!`](#string) | Name of the compliance framework. |
| <a id="complianceframeworkpipelineconfigurationfullpath"></a>`pipelineConfigurationFullPath` | [`String`](#string) | Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa` **(ULTIMATE)**. |

### `ComplianceViolation`

Compliance violation associated with a merged merge request.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceviolationid"></a>`id` | [`ID!`](#id) | Compliance violation ID. |
| <a id="complianceviolationmergerequest"></a>`mergeRequest` | [`MergeRequest!`](#mergerequest) | Merge request the compliance violation occurred in. |
| <a id="complianceviolationreason"></a>`reason` | [`ComplianceViolationReason!`](#complianceviolationreason) | Reason the compliance violation occurred. |
| <a id="complianceviolationseveritylevel"></a>`severityLevel` | [`ComplianceViolationSeverity!`](#complianceviolationseverity) | Severity of the compliance violation. |
| <a id="complianceviolationviolatinguser"></a>`violatingUser` | [`UserCore!`](#usercore) | User suspected of causing the compliance violation. |

### `ComposerMetadata`

Composer metadata.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="composermetadatacomposerjson"></a>`composerJson` | [`PackageComposerJsonType!`](#packagecomposerjsontype) | Data of the Composer JSON file. |
| <a id="composermetadatatargetsha"></a>`targetSha` | [`String!`](#string) | Target SHA of the package. |

### `ConanFileMetadata`

Conan file metadata.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="conanfilemetadataconanfiletype"></a>`conanFileType` | [`ConanMetadatumFileTypeEnum!`](#conanmetadatumfiletypeenum) | Type of the Conan file. |
| <a id="conanfilemetadataconanpackagereference"></a>`conanPackageReference` | [`String`](#string) | Reference of the Conan package. |
| <a id="conanfilemetadatacreatedat"></a>`createdAt` | [`Time!`](#time) | Date of creation. |
| <a id="conanfilemetadataid"></a>`id` | [`PackagesConanFileMetadatumID!`](#packagesconanfilemetadatumid) | ID of the metadatum. |
| <a id="conanfilemetadatapackagerevision"></a>`packageRevision` | [`String`](#string) | Revision of the package. |
| <a id="conanfilemetadatareciperevision"></a>`recipeRevision` | [`String!`](#string) | Revision of the Conan recipe. |
| <a id="conanfilemetadataupdatedat"></a>`updatedAt` | [`Time!`](#time) | Date of most recent update. |

### `ConanMetadata`

Conan metadata.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="conanmetadatacreatedat"></a>`createdAt` | [`Time!`](#time) | Date of creation. |
| <a id="conanmetadataid"></a>`id` | [`PackagesConanMetadatumID!`](#packagesconanmetadatumid) | ID of the metadatum. |
| <a id="conanmetadatapackagechannel"></a>`packageChannel` | [`String!`](#string) | Channel of the Conan package. |
| <a id="conanmetadatapackageusername"></a>`packageUsername` | [`String!`](#string) | Username of the Conan package. |
| <a id="conanmetadatarecipe"></a>`recipe` | [`String!`](#string) | Recipe of the Conan package. |
| <a id="conanmetadatarecipepath"></a>`recipePath` | [`String!`](#string) | Recipe path of the Conan package. |
| <a id="conanmetadataupdatedat"></a>`updatedAt` | [`Time!`](#time) | Date of most recent update. |

### `ConnectedAgent`

Connection details for an Agent.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="connectedagentconnectedat"></a>`connectedAt` | [`Time`](#time) | When the connection was established. |
| <a id="connectedagentconnectionid"></a>`connectionId` | [`BigInt`](#bigint) | ID of the connection. |
| <a id="connectedagentmetadata"></a>`metadata` | [`AgentMetadata`](#agentmetadata) | Information about the Agent. |

### `ContactStateCounts`

Represents the total number of contacts for the represented states.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="contactstatecountsactive"></a>`active` | [`Int`](#int) | Number of contacts with state `ACTIVE`. |
| <a id="contactstatecountsall"></a>`all` | [`Int`](#int) | Number of contacts with state `ALL`. |
| <a id="contactstatecountsinactive"></a>`inactive` | [`Int`](#int) | Number of contacts with state `INACTIVE`. |

### `ContainerExpirationPolicy`

A tag expiration policy designed to keep only the images that matter most.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerexpirationpolicycadence"></a>`cadence` | [`ContainerExpirationPolicyCadenceEnum!`](#containerexpirationpolicycadenceenum) | This container expiration policy schedule. |
| <a id="containerexpirationpolicycreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of when the container expiration policy was created. |
| <a id="containerexpirationpolicyenabled"></a>`enabled` | [`Boolean!`](#boolean) | Indicates whether this container expiration policy is enabled. |
| <a id="containerexpirationpolicykeepn"></a>`keepN` | [`ContainerExpirationPolicyKeepEnum`](#containerexpirationpolicykeepenum) | Number of tags to retain. |
| <a id="containerexpirationpolicynameregex"></a>`nameRegex` | [`UntrustedRegexp`](#untrustedregexp) | Tags with names matching this regex pattern will expire. |
| <a id="containerexpirationpolicynameregexkeep"></a>`nameRegexKeep` | [`UntrustedRegexp`](#untrustedregexp) | Tags with names matching this regex pattern will be preserved. |
| <a id="containerexpirationpolicynextrunat"></a>`nextRunAt` | [`Time`](#time) | Next time that this container expiration policy will get executed. |
| <a id="containerexpirationpolicyolderthan"></a>`olderThan` | [`ContainerExpirationPolicyOlderThanEnum`](#containerexpirationpolicyolderthanenum) | Tags older that this will expire. |
| <a id="containerexpirationpolicyupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of when the container expiration policy was updated. |

### `ContainerRepository`

A container repository.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorycandelete"></a>`canDelete` | [`Boolean!`](#boolean) | Can the current user delete the container repository. |
| <a id="containerrepositorycreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp when the container repository was created. |
| <a id="containerrepositoryexpirationpolicycleanupstatus"></a>`expirationPolicyCleanupStatus` | [`ContainerRepositoryCleanupStatus`](#containerrepositorycleanupstatus) | Tags cleanup status for the container repository. |
| <a id="containerrepositoryexpirationpolicystartedat"></a>`expirationPolicyStartedAt` | [`Time`](#time) | Timestamp when the cleanup done by the expiration policy was started on the container repository. |
| <a id="containerrepositoryid"></a>`id` | [`ID!`](#id) | ID of the container repository. |
| <a id="containerrepositorylastcleanupdeletedtagscount"></a>`lastCleanupDeletedTagsCount` | [`Int`](#int) | Number of deleted tags from the last cleanup. |
| <a id="containerrepositorylocation"></a>`location` | [`String!`](#string) | URL of the container repository. |
| <a id="containerrepositorymigrationstate"></a>`migrationState` | [`String!`](#string) | Migration state of the container repository. |
| <a id="containerrepositoryname"></a>`name` | [`String!`](#string) | Name of the container repository. |
| <a id="containerrepositorypath"></a>`path` | [`String!`](#string) | Path of the container repository. |
| <a id="containerrepositoryproject"></a>`project` | [`Project!`](#project) | Project of the container registry. |
| <a id="containerrepositorystatus"></a>`status` | [`ContainerRepositoryStatus`](#containerrepositorystatus) | Status of the container repository. |
| <a id="containerrepositorytagscount"></a>`tagsCount` | [`Int!`](#int) | Number of tags associated with this image. |
| <a id="containerrepositoryupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp when the container repository was updated. |

### `ContainerRepositoryDetails`

Details of a container repository.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorydetailscandelete"></a>`canDelete` | [`Boolean!`](#boolean) | Can the current user delete the container repository. |
| <a id="containerrepositorydetailscreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp when the container repository was created. |
| <a id="containerrepositorydetailsexpirationpolicycleanupstatus"></a>`expirationPolicyCleanupStatus` | [`ContainerRepositoryCleanupStatus`](#containerrepositorycleanupstatus) | Tags cleanup status for the container repository. |
| <a id="containerrepositorydetailsexpirationpolicystartedat"></a>`expirationPolicyStartedAt` | [`Time`](#time) | Timestamp when the cleanup done by the expiration policy was started on the container repository. |
| <a id="containerrepositorydetailsid"></a>`id` | [`ID!`](#id) | ID of the container repository. |
| <a id="containerrepositorydetailslastcleanupdeletedtagscount"></a>`lastCleanupDeletedTagsCount` | [`Int`](#int) | Number of deleted tags from the last cleanup. |
| <a id="containerrepositorydetailslocation"></a>`location` | [`String!`](#string) | URL of the container repository. |
| <a id="containerrepositorydetailsmigrationstate"></a>`migrationState` | [`String!`](#string) | Migration state of the container repository. |
| <a id="containerrepositorydetailsname"></a>`name` | [`String!`](#string) | Name of the container repository. |
| <a id="containerrepositorydetailspath"></a>`path` | [`String!`](#string) | Path of the container repository. |
| <a id="containerrepositorydetailsproject"></a>`project` | [`Project!`](#project) | Project of the container registry. |
| <a id="containerrepositorydetailssize"></a>`size` | [`Float`](#float) | Deduplicated size of the image repository in bytes. This is only available on GitLab.com for repositories created after `2021-11-04`. |
| <a id="containerrepositorydetailsstatus"></a>`status` | [`ContainerRepositoryStatus`](#containerrepositorystatus) | Status of the container repository. |
| <a id="containerrepositorydetailstagscount"></a>`tagsCount` | [`Int!`](#int) | Number of tags associated with this image. |
| <a id="containerrepositorydetailsupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp when the container repository was updated. |

#### Fields with arguments

##### `ContainerRepositoryDetails.tags`

Tags of the container repository.

Returns [`ContainerRepositoryTagConnection`](#containerrepositorytagconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorydetailstagsname"></a>`name` | [`String`](#string) | Search by tag name. |
| <a id="containerrepositorydetailstagssort"></a>`sort` | [`ContainerRepositoryTagSort`](#containerrepositorytagsort) | Sort tags by these criteria. |

### `ContainerRepositoryRegistry`

Represents the Geo replication and verification state of an Container Repository.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistrycontainerrepositoryid"></a>`containerRepositoryId` | [`ID!`](#id) | ID of the ContainerRepository. |
| <a id="containerrepositoryregistrycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the ContainerRepositoryRegistry was created. |
| <a id="containerrepositoryregistryid"></a>`id` | [`ID!`](#id) | ID of the ContainerRepositoryRegistry. |
| <a id="containerrepositoryregistrylastsyncfailure"></a>`lastSyncFailure` | [`String`](#string) | Error message during sync of the ContainerRepositoryRegistry. |
| <a id="containerrepositoryregistrylastsyncedat"></a>`lastSyncedAt` | [`Time`](#time) | Timestamp of the most recent successful sync of the ContainerRepositoryRegistry. |
| <a id="containerrepositoryregistryretryat"></a>`retryAt` | [`Time`](#time) | Timestamp after which the ContainerRepositoryRegistry is resynced. |
| <a id="containerrepositoryregistryretrycount"></a>`retryCount` | [`Int`](#int) | Number of consecutive failed sync attempts of the ContainerRepositoryRegistry. |
| <a id="containerrepositoryregistrystate"></a>`state` | [`RegistryState`](#registrystate) | Sync state of the ContainerRepositoryRegistry. |
| <a id="containerrepositoryregistryverificationretryat"></a>`verificationRetryAt` | [`Time`](#time) | Timestamp after which the ContainerRepositoryRegistry is reverified. |
| <a id="containerrepositoryregistryverifiedat"></a>`verifiedAt` | [`Time`](#time) | Timestamp of the most recent successful verification of the ContainerRepositoryRegistry. |

### `ContainerRepositoryTag`

A tag from a container repository.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagcandelete"></a>`canDelete` | [`Boolean!`](#boolean) | Can the current user delete this tag. |
| <a id="containerrepositorytagcreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the tag was created. |
| <a id="containerrepositorytagdigest"></a>`digest` | [`String`](#string) | Digest of the tag. |
| <a id="containerrepositorytaglocation"></a>`location` | [`String!`](#string) | URL of the tag. |
| <a id="containerrepositorytagname"></a>`name` | [`String!`](#string) | Name of the tag. |
| <a id="containerrepositorytagpath"></a>`path` | [`String!`](#string) | Path of the tag. |
| <a id="containerrepositorytagrevision"></a>`revision` | [`String`](#string) | Revision of the tag. |
| <a id="containerrepositorytagshortrevision"></a>`shortRevision` | [`String`](#string) | Short revision of the tag. |
| <a id="containerrepositorytagtotalsize"></a>`totalSize` | [`BigInt`](#bigint) | Size of the tag. |

### `ContributionAnalyticsContribution`

Represents the contributions of a user.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionissuesclosed"></a>`issuesClosed` | [`Int`](#int) | Number of issues closed by the user. |
| <a id="contributionanalyticscontributionissuescreated"></a>`issuesCreated` | [`Int`](#int) | Number of issues created by the user. |
| <a id="contributionanalyticscontributionmergerequestsapproved"></a>`mergeRequestsApproved` | [`Int`](#int) | Number of merge requests approved by the user. |
| <a id="contributionanalyticscontributionmergerequestsclosed"></a>`mergeRequestsClosed` | [`Int`](#int) | Number of merge requests closed by the user. |
| <a id="contributionanalyticscontributionmergerequestscreated"></a>`mergeRequestsCreated` | [`Int`](#int) | Number of merge requests created by the user. |
| <a id="contributionanalyticscontributionmergerequestsmerged"></a>`mergeRequestsMerged` | [`Int`](#int) | Number of merge requests merged by the user. |
| <a id="contributionanalyticscontributionrepopushed"></a>`repoPushed` | [`Int`](#int) | Number of repository pushes the user made. |
| <a id="contributionanalyticscontributiontotalevents"></a>`totalEvents` | [`Int`](#int) | Total number of events contributed by the user. |
| <a id="contributionanalyticscontributionuser"></a>`user` | [`UserCore`](#usercore) | Contributor User object. |

### `CoverageFuzzingCorpus`

Corpus for a coverage fuzzing job.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusid"></a>`id` | [`AppSecFuzzingCoverageCorpusID!`](#appsecfuzzingcoveragecorpusid) | ID of the corpus. |
| <a id="coveragefuzzingcorpuspackage"></a>`package` | [`PackageDetailsType!`](#packagedetailstype) | Package of the corpus. |

### `CurrentLicense`

Represents the current license.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="currentlicenseactivatedat"></a>`activatedAt` | [`Date`](#date) | Date when the license was activated. |
| <a id="currentlicensebillableuserscount"></a>`billableUsersCount` | [`Int`](#int) | Number of billable users on the system. |
| <a id="currentlicenseblockchangesat"></a>`blockChangesAt` | [`Date`](#date) | Date, including grace period, when licensed features will be blocked. |
| <a id="currentlicensecompany"></a>`company` | [`String`](#string) | Company of the licensee. |
| <a id="currentlicensecreatedat"></a>`createdAt` | [`Date`](#date) | Date when the license was added. |
| <a id="currentlicenseemail"></a>`email` | [`String`](#string) | Email of the licensee. |
| <a id="currentlicenseexpiresat"></a>`expiresAt` | [`Date`](#date) | Date when the license expires. |
| <a id="currentlicenseid"></a>`id` | [`ID!`](#id) | ID of the license extracted from the license data. |
| <a id="currentlicenselastsync"></a>`lastSync` | [`Time`](#time) | Date when the license was last synced. |
| <a id="currentlicensemaximumusercount"></a>`maximumUserCount` | [`Int`](#int) | Highest number of billable users on the system during the term of the current license. |
| <a id="currentlicensename"></a>`name` | [`String`](#string) | Name of the licensee. |
| <a id="currentlicenseplan"></a>`plan` | [`String!`](#string) | Name of the subscription plan. |
| <a id="currentlicensestartsat"></a>`startsAt` | [`Date`](#date) | Date when the license started. |
| <a id="currentlicensetype"></a>`type` | [`String!`](#string) | Type of the license. |
| <a id="currentlicenseusersinlicensecount"></a>`usersInLicenseCount` | [`Int`](#int) | Number of paid users in the license. |
| <a id="currentlicenseusersoverlicensecount"></a>`usersOverLicenseCount` | [`Int`](#int) | Number of users over the paid users in the license. |

### `CustomEmoji`

A custom emoji uploaded by user.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customemojiexternal"></a>`external` | [`Boolean!`](#boolean) | Whether the emoji is an external link. |
| <a id="customemojiid"></a>`id` | [`CustomEmojiID!`](#customemojiid) | ID of the emoji. |
| <a id="customemojiname"></a>`name` | [`String!`](#string) | Name of the emoji. |
| <a id="customemojiurl"></a>`url` | [`String!`](#string) | Link to file of the emoji. |

### `CustomerRelationsContact`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactactive"></a>`active` | [`Boolean!`](#boolean) | State of the contact. |
| <a id="customerrelationscontactcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp the contact was created. |
| <a id="customerrelationscontactdescription"></a>`description` | [`String`](#string) | Description of or notes for the contact. |
| <a id="customerrelationscontactemail"></a>`email` | [`String`](#string) | Email address of the contact. |
| <a id="customerrelationscontactfirstname"></a>`firstName` | [`String!`](#string) | First name of the contact. |
| <a id="customerrelationscontactid"></a>`id` | [`ID!`](#id) | Internal ID of the contact. |
| <a id="customerrelationscontactlastname"></a>`lastName` | [`String!`](#string) | Last name of the contact. |
| <a id="customerrelationscontactorganization"></a>`organization` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | Organization of the contact. |
| <a id="customerrelationscontactphone"></a>`phone` | [`String`](#string) | Phone number of the contact. |
| <a id="customerrelationscontactupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp the contact was last updated. |

### `CustomerRelationsOrganization`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationactive"></a>`active` | [`Boolean!`](#boolean) | State of the organization. |
| <a id="customerrelationsorganizationcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp the organization was created. |
| <a id="customerrelationsorganizationdefaultrate"></a>`defaultRate` | [`Float`](#float) | Standard billing rate for the organization. |
| <a id="customerrelationsorganizationdescription"></a>`description` | [`String`](#string) | Description of or notes for the organization. |
| <a id="customerrelationsorganizationid"></a>`id` | [`ID!`](#id) | Internal ID of the organization. |
| <a id="customerrelationsorganizationname"></a>`name` | [`String!`](#string) | Name of the organization. |
| <a id="customerrelationsorganizationupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp the organization was last updated. |

### `DastPreScanVerification`

Represents a DAST Pre Scan Verification.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprescanverificationprescanverificationsteps"></a>`preScanVerificationSteps` | [`[DastPreScanVerificationStep!]`](#dastprescanverificationstep) | Pre Scan Verifications Steps. |
| <a id="dastprescanverificationstatus"></a>`status` | [`DastPreScanVerificationStatus`](#dastprescanverificationstatus) | Status of the pre scan verification. |
| <a id="dastprescanverificationvalid"></a>`valid` | [`Boolean!`](#boolean) | Whether or not the configuration has changed after the last pre scan run. |

### `DastPreScanVerificationStep`

Represents a DAST Pre Scan Verification Step.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprescanverificationstepchecktype"></a>`checkType` | [`DastPreScanVerificationCheckType`](#dastprescanverificationchecktype) | Type of the pre scan verification check. |
| <a id="dastprescanverificationsteperrors"></a>`errors` | [`[String!]`](#string) | Errors that occurred in the pre scan verification step. |
| <a id="dastprescanverificationstepname"></a>`name` **{warning-solid}** | [`String`](#string) | **Deprecated** in 15.10. This was renamed. Use: [`DastPreScanVerificationStep.checkType`](#dastprescanverificationstepchecktype). |
| <a id="dastprescanverificationstepsuccess"></a>`success` | [`Boolean!`](#boolean) | Whether or not the pre scan verification step has errors. |

### `DastProfile`

Represents a DAST Profile.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprofilebranch"></a>`branch` | [`DastProfileBranch`](#dastprofilebranch) | Associated branch. |
| <a id="dastprofiledastprescanverification"></a>`dastPreScanVerification` | [`DastPreScanVerification`](#dastprescanverification) | DAST Pre Scan Verification associated with the site profile. Will always return `null` if `dast_on_demand_scans_scheduler` feature flag is disabled. |
| <a id="dastprofiledastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileSchedule`](#dastprofileschedule) | Associated profile schedule. |
| <a id="dastprofiledastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | Associated scanner profile. |
| <a id="dastprofiledastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | Associated site profile. |
| <a id="dastprofiledescription"></a>`description` | [`String`](#string) | Description of the scan. |
| <a id="dastprofileeditpath"></a>`editPath` | [`String`](#string) | Relative web path to the edit page of a profile. |
| <a id="dastprofileid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile. |
| <a id="dastprofilename"></a>`name` | [`String`](#string) | Name of the profile. |
| <a id="dastprofiletaglist"></a>`tagList` | [`[String!]`](#string) | Runner tags associated with the profile. |

### `DastProfileBranch`

Represents a DAST Profile Branch.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprofilebranchexists"></a>`exists` | [`Boolean`](#boolean) | Indicates whether or not the branch exists. |
| <a id="dastprofilebranchname"></a>`name` | [`String`](#string) | Name of the branch. |

### `DastProfileCadence`

Represents DAST Profile Cadence.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprofilecadenceduration"></a>`duration` | [`Int`](#int) | Duration of the DAST profile cadence. |
| <a id="dastprofilecadenceunit"></a>`unit` | [`DastProfileCadenceUnit`](#dastprofilecadenceunit) | Unit for the duration of DAST profile cadence. |

### `DastProfileSchedule`

Represents a DAST profile schedule.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprofilescheduleactive"></a>`active` | [`Boolean`](#boolean) | Status of the DAST profile schedule. |
| <a id="dastprofileschedulecadence"></a>`cadence` | [`DastProfileCadence`](#dastprofilecadence) | Cadence of the DAST profile schedule. |
| <a id="dastprofilescheduleid"></a>`id` | [`DastProfileScheduleID!`](#dastprofilescheduleid) | ID of the DAST profile schedule. |
| <a id="dastprofileschedulenextrunat"></a>`nextRunAt` | [`Time`](#time) | Next run time of the DAST profile schedule in the given timezone. |
| <a id="dastprofilescheduleownervalid"></a>`ownerValid` | [`Boolean`](#boolean) | Status of the current owner of the DAST profile schedule. |
| <a id="dastprofileschedulestartsat"></a>`startsAt` | [`Time`](#time) | Start time of the DAST profile schedule in the given timezone. |
| <a id="dastprofilescheduletimezone"></a>`timezone` | [`String`](#string) | Time zone of the start time of the DAST profile schedule. |

### `DastScannerProfile`

Represents a DAST scanner profile.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastscannerprofileeditpath"></a>`editPath` | [`String`](#string) | Relative web path to the edit page of a scanner profile. |
| <a id="dastscannerprofileid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the DAST scanner profile. |
| <a id="dastscannerprofileprofilename"></a>`profileName` | [`String`](#string) | Name of the DAST scanner profile. |
| <a id="dastscannerprofilereferencedinsecuritypolicies"></a>`referencedInSecurityPolicies` | [`[String!]`](#string) | List of security policy names that are referencing given project. |
| <a id="dastscannerprofilescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | Indicates the type of DAST scan that will run. Either a Passive Scan or an Active Scan. |
| <a id="dastscannerprofileshowdebugmessages"></a>`showDebugMessages` | [`Boolean!`](#boolean) | Indicates if debug messages should be included in DAST console output. True to include the debug messages. |
| <a id="dastscannerprofilespidertimeout"></a>`spiderTimeout` | [`Int`](#int) | Maximum number of minutes allowed for the spider to traverse the site. |
| <a id="dastscannerprofiletaglist"></a>`tagList` **{warning-solid}** | [`[String!]`](#string) | **Deprecated** in 15.8. Moved to DastProfile. |
| <a id="dastscannerprofiletargettimeout"></a>`targetTimeout` | [`Int`](#int) | Maximum number of seconds allowed for the site under test to respond to a request. |
| <a id="dastscannerprofileuseajaxspider"></a>`useAjaxSpider` | [`Boolean!`](#boolean) | Indicates if the AJAX spider should be used to crawl the target site. True to run the AJAX spider in addition to the traditional spider, and false to run only the traditional spider. |

### `DastSiteProfile`

Represents a DAST Site Profile.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileauth"></a>`auth` | [`DastSiteProfileAuth`](#dastsiteprofileauth) | Target authentication details. |
| <a id="dastsiteprofileeditpath"></a>`editPath` | [`String`](#string) | Relative web path to the edit page of a site profile. |
| <a id="dastsiteprofileexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | URLs to skip during an authenticated scan. |
| <a id="dastsiteprofileid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile. |
| <a id="dastsiteprofilenormalizedtargeturl"></a>`normalizedTargetUrl` | [`String`](#string) | Normalized URL of the target to be scanned. |
| <a id="dastsiteprofileprofilename"></a>`profileName` | [`String`](#string) | Name of the site profile. |
| <a id="dastsiteprofilereferencedinsecuritypolicies"></a>`referencedInSecurityPolicies` | [`[String!]`](#string) | List of security policy names that are referencing given project. |
| <a id="dastsiteprofilerequestheaders"></a>`requestHeaders` | [`String`](#string) | Comma-separated list of request header names and values to be added to every request made by DAST. |
| <a id="dastsiteprofilescanfilepath"></a>`scanFilePath` | [`String`](#string) | Scan File Path used as input for the scanner. |
| <a id="dastsiteprofilescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | Scan method used by the scanner. |
| <a id="dastsiteprofiletargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | Type of target to be scanned. |
| <a id="dastsiteprofiletargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be scanned. |
| <a id="dastsiteprofileuserpermissions"></a>`userPermissions` | [`DastSiteProfilePermissions!`](#dastsiteprofilepermissions) | Permissions for the current user on the resource. |
| <a id="dastsiteprofilevalidationstartedat"></a>`validationStartedAt` | [`Time`](#time) | Site profile validation start time. |
| <a id="dastsiteprofilevalidationstatus"></a>`validationStatus` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | Current validation status of the site profile. |

### `DastSiteProfileAuth`

Input type for DastSiteProfile authentication.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileauthenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether authentication is enabled. |
| <a id="dastsiteprofileauthpassword"></a>`password` | [`String`](#string) | Redacted password to authenticate with on the target website. |
| <a id="dastsiteprofileauthpasswordfield"></a>`passwordField` | [`String`](#string) | Name of password field at the sign-in HTML form. |
| <a id="dastsiteprofileauthsubmitfield"></a>`submitField` | [`String`](#string) | Name or ID of sign-in submit button at the sign-in HTML form. |
| <a id="dastsiteprofileauthurl"></a>`url` | [`String`](#string) | The URL of the page containing the sign-in HTML form on the target website. |
| <a id="dastsiteprofileauthusername"></a>`username` | [`String`](#string) | Username to authenticate with on the target website. |
| <a id="dastsiteprofileauthusernamefield"></a>`usernameField` | [`String`](#string) | Name of username field at the sign-in HTML form. |

### `DastSiteProfilePermissions`

Check permissions for the current user on site profile.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsiteprofilepermissionscreateondemanddastscan"></a>`createOnDemandDastScan` | [`Boolean!`](#boolean) | Indicates the user can perform `create_on_demand_dast_scan` on this resource. |

### `DastSiteValidation`

Represents a DAST Site Validation.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsitevalidationid"></a>`id` | [`DastSiteValidationID!`](#dastsitevalidationid) | Global ID of the site validation. |
| <a id="dastsitevalidationnormalizedtargeturl"></a>`normalizedTargetUrl` | [`String`](#string) | Normalized URL of the target to be validated. |
| <a id="dastsitevalidationstatus"></a>`status` | [`DastSiteProfileValidationStatusEnum!`](#dastsiteprofilevalidationstatusenum) | Status of the site validation. |
| <a id="dastsitevalidationvalidationstartedat"></a>`validationStartedAt` | [`Time`](#time) | Timestamp of when the validation started. |

### `DeleteJobsResponse`

The response from the AdminSidekiqQueuesDeleteJobs mutation.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deletejobsresponsecompleted"></a>`completed` | [`Boolean`](#boolean) | Whether or not the entire queue was processed in time; if not, retrying the same request is safe. |
| <a id="deletejobsresponsedeletedjobs"></a>`deletedJobs` | [`Int`](#int) | Number of matching jobs deleted. |
| <a id="deletejobsresponsequeuesize"></a>`queueSize` | [`Int`](#int) | Queue size after processing. |

### `DeletedNote`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deletednotediscussionid"></a>`discussionId` | [`DiscussionID`](#discussionid) | ID of the discussion for the deleted note. |
| <a id="deletednoteid"></a>`id` | [`NoteID!`](#noteid) | ID of the deleted note. |
| <a id="deletednotelastdiscussionnote"></a>`lastDiscussionNote` | [`Boolean`](#boolean) | Whether deleted note is the last note in the discussion. |

### `Dependency`

A software dependency used by a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyid"></a>`id` | [`GlobalID!`](#globalid) | ID of the dependency. |
| <a id="dependencylocation"></a>`location` | [`Location`](#location) | Information about where the dependency is located. |
| <a id="dependencyname"></a>`name` | [`String!`](#string) | Name of the dependency. |
| <a id="dependencypackager"></a>`packager` | [`PackageManager`](#packagemanager) | Description of the tool used to manage the dependency. |
| <a id="dependencyversion"></a>`version` | [`String`](#string) | Version of the dependency. |

### `DependencyProxyBlob`

Dependency proxy blob.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobcreatedat"></a>`createdAt` | [`Time!`](#time) | Date of creation. |
| <a id="dependencyproxyblobfilename"></a>`fileName` | [`String!`](#string) | Name of the blob. |
| <a id="dependencyproxyblobsize"></a>`size` | [`String!`](#string) | Size of the blob file. |
| <a id="dependencyproxyblobupdatedat"></a>`updatedAt` | [`Time!`](#time) | Date of most recent update. |

### `DependencyProxyBlobRegistry`

Represents the Geo replication and verification state of a dependency_proxy_blob.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistrycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the DependencyProxyBlobRegistry was created. |
| <a id="dependencyproxyblobregistrydependencyproxyblobid"></a>`dependencyProxyBlobId` | [`ID!`](#id) | ID of the Dependency Proxy Blob. |
| <a id="dependencyproxyblobregistryid"></a>`id` | [`ID!`](#id) | ID of the DependencyProxyBlobRegistry. |
| <a id="dependencyproxyblobregistrylastsyncfailure"></a>`lastSyncFailure` | [`String`](#string) | Error message during sync of the DependencyProxyBlobRegistry. |
| <a id="dependencyproxyblobregistrylastsyncedat"></a>`lastSyncedAt` | [`Time`](#time) | Timestamp of the most recent successful sync of the DependencyProxyBlobRegistry. |
| <a id="dependencyproxyblobregistryretryat"></a>`retryAt` | [`Time`](#time) | Timestamp after which the DependencyProxyBlobRegistry is resynced. |
| <a id="dependencyproxyblobregistryretrycount"></a>`retryCount` | [`Int`](#int) | Number of consecutive failed sync attempts of the DependencyProxyBlobRegistry. |
| <a id="dependencyproxyblobregistrystate"></a>`state` | [`RegistryState`](#registrystate) | Sync state of the DependencyProxyBlobRegistry. |
| <a id="dependencyproxyblobregistryverificationretryat"></a>`verificationRetryAt` | [`Time`](#time) | Timestamp after which the DependencyProxyBlobRegistry is reverified. |
| <a id="dependencyproxyblobregistryverifiedat"></a>`verifiedAt` | [`Time`](#time) | Timestamp of the most recent successful verification of the DependencyProxyBlobRegistry. |

### `DependencyProxyImageTtlGroupPolicy`

Group-level Dependency Proxy TTL policy settings.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyimagettlgrouppolicycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of creation. |
| <a id="dependencyproxyimagettlgrouppolicyenabled"></a>`enabled` | [`Boolean!`](#boolean) | Indicates whether the policy is enabled or disabled. |
| <a id="dependencyproxyimagettlgrouppolicyttl"></a>`ttl` | [`Int`](#int) | Number of days to retain a cached image file. |
| <a id="dependencyproxyimagettlgrouppolicyupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp of the most recent update. |

### `DependencyProxyManifest`

Dependency proxy manifest.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestcreatedat"></a>`createdAt` | [`Time!`](#time) | Date of creation. |
| <a id="dependencyproxymanifestdigest"></a>`digest` | [`String!`](#string) | Digest of the manifest. |
| <a id="dependencyproxymanifestfilename"></a>`fileName` | [`String!`](#string) | Name of the manifest. |
| <a id="dependencyproxymanifestid"></a>`id` | [`DependencyProxyManifestID!`](#dependencyproxymanifestid) | ID of the manifest. |
| <a id="dependencyproxymanifestimagename"></a>`imageName` | [`String!`](#string) | Name of the image. |
| <a id="dependencyproxymanifestsize"></a>`size` | [`String!`](#string) | Size of the manifest file. |
| <a id="dependencyproxymanifeststatus"></a>`status` | [`DependencyProxyManifestStatus!`](#dependencyproxymanifeststatus) | Status of the manifest (default, pending_destruction, processing, error). |
| <a id="dependencyproxymanifestupdatedat"></a>`updatedAt` | [`Time!`](#time) | Date of most recent update. |

### `DependencyProxyManifestRegistry`

Represents the Geo replication and verification state of a dependency_proxy_manifest.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistrycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the DependencyProxyManifestRegistry was created. |
| <a id="dependencyproxymanifestregistrydependencyproxymanifestid"></a>`dependencyProxyManifestId` | [`ID!`](#id) | ID of the Dependency Proxy Manifest. |
| <a id="dependencyproxymanifestregistryid"></a>`id` | [`ID!`](#id) | ID of the DependencyProxyManifestRegistry. |
| <a id="dependencyproxymanifestregistrylastsyncfailure"></a>`lastSyncFailure` | [`String`](#string) | Error message during sync of the DependencyProxyManifestRegistry. |
| <a id="dependencyproxymanifestregistrylastsyncedat"></a>`lastSyncedAt` | [`Time`](#time) | Timestamp of the most recent successful sync of the DependencyProxyManifestRegistry. |
| <a id="dependencyproxymanifestregistryretryat"></a>`retryAt` | [`Time`](#time) | Timestamp after which the DependencyProxyManifestRegistry is resynced. |
| <a id="dependencyproxymanifestregistryretrycount"></a>`retryCount` | [`Int`](#int) | Number of consecutive failed sync attempts of the DependencyProxyManifestRegistry. |
| <a id="dependencyproxymanifestregistrystate"></a>`state` | [`RegistryState`](#registrystate) | Sync state of the DependencyProxyManifestRegistry. |
| <a id="dependencyproxymanifestregistryverificationretryat"></a>`verificationRetryAt` | [`Time`](#time) | Timestamp after which the DependencyProxyManifestRegistry is reverified. |
| <a id="dependencyproxymanifestregistryverifiedat"></a>`verifiedAt` | [`Time`](#time) | Timestamp of the most recent successful verification of the DependencyProxyManifestRegistry. |

### `DependencyProxySetting`

Group-level Dependency Proxy settings.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxysettingenabled"></a>`enabled` | [`Boolean!`](#boolean) | Indicates whether the dependency proxy is enabled for the group. |

### `Deployment`

The deployment of an environment.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deploymentapprovalsummary"></a>`approvalSummary` | [`DeploymentApprovalSummary`](#deploymentapprovalsummary) | Approval summary of the deployment.This field can only be resolved for one deployment in any single request. |
| <a id="deploymentapprovals"></a>`approvals` | [`[DeploymentApproval!]`](#deploymentapproval) | Current approvals of the deployment. |
| <a id="deploymentcommit"></a>`commit` | [`Commit`](#commit) | Commit details of the deployment. |
| <a id="deploymentcreatedat"></a>`createdAt` | [`Time`](#time) | When the deployment record was created. |
| <a id="deploymentfinishedat"></a>`finishedAt` | [`Time`](#time) | When the deployment finished. |
| <a id="deploymentid"></a>`id` | [`ID`](#id) | Global ID of the deployment. |
| <a id="deploymentiid"></a>`iid` | [`ID`](#id) | Project-level internal ID of the deployment. |
| <a id="deploymentjob"></a>`job` | [`CiJob`](#cijob) | Pipeline job of the deployment. |
| <a id="deploymentpendingapprovalcount"></a>`pendingApprovalCount` | [`Int`](#int) | Number of pending unified approvals on the deployment. |
| <a id="deploymentref"></a>`ref` | [`String`](#string) | Git-Ref that the deployment ran on. |
| <a id="deploymentsha"></a>`sha` | [`String`](#string) | Git-SHA that the deployment ran on. |
| <a id="deploymentstatus"></a>`status` | [`DeploymentStatus`](#deploymentstatus) | Status of the deployment. |
| <a id="deploymenttag"></a>`tag` | [`Boolean`](#boolean) | True or false if the deployment ran on a Git-tag. |
| <a id="deploymenttags"></a>`tags` | [`[DeploymentTag!]`](#deploymenttag) | Git tags that contain this deployment. This field can only be resolved for two deployments in any single request. |
| <a id="deploymenttriggerer"></a>`triggerer` | [`UserCore`](#usercore) | User who executed the deployment. |
| <a id="deploymentupdatedat"></a>`updatedAt` | [`Time`](#time) | When the deployment record was updated. |
| <a id="deploymentuserpermissions"></a>`userPermissions` | [`DeploymentPermissions!`](#deploymentpermissions) | Permissions for the current user on the resource. |

### `DeploymentApproval`

Approval of the deployment.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deploymentapprovalcomment"></a>`comment` | [`String`](#string) | Additional comment. |
| <a id="deploymentapprovalcreatedat"></a>`createdAt` | [`Time`](#time) | When the user approved/rejected first time. |
| <a id="deploymentapprovalstatus"></a>`status` | [`DeploymentsApprovalStatus`](#deploymentsapprovalstatus) | Whether the deployment was approved/rejected. |
| <a id="deploymentapprovalupdatedat"></a>`updatedAt` | [`Time`](#time) | When the user updated the approval. |
| <a id="deploymentapprovaluser"></a>`user` | [`UserCore`](#usercore) | User who approved or rejected the deployment. |

### `DeploymentApprovalSummary`

Approval summary of the deployment.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deploymentapprovalsummaryrules"></a>`rules` | [`[ProtectedEnvironmentApprovalRuleForSummary!]`](#protectedenvironmentapprovalruleforsummary) | Approval Rules for the deployment. |
| <a id="deploymentapprovalsummarystatus"></a>`status` | [`DeploymentApprovalSummaryStatus`](#deploymentapprovalsummarystatus) | Status of the approvals. |
| <a id="deploymentapprovalsummarytotalpendingapprovalcount"></a>`totalPendingApprovalCount` | [`Int`](#int) | Total pending approval count. |
| <a id="deploymentapprovalsummarytotalrequiredapprovals"></a>`totalRequiredApprovals` | [`Int`](#int) | Total number of required approvals. |

### `DeploymentPermissions`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deploymentpermissionsapprovedeployment"></a>`approveDeployment` | [`Boolean!`](#boolean) | Indicates the user can perform `approve_deployment` on this resource. This field can only be resolved for one environment in any single request. |
| <a id="deploymentpermissionsdestroydeployment"></a>`destroyDeployment` | [`Boolean!`](#boolean) | Indicates the user can perform `destroy_deployment` on this resource. |
| <a id="deploymentpermissionsupdatedeployment"></a>`updateDeployment` | [`Boolean!`](#boolean) | Indicates the user can perform `update_deployment` on this resource. |

### `DeploymentTag`

Tags for a given deployment.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deploymenttagname"></a>`name` | [`String`](#string) | Name of this git tag. |
| <a id="deploymenttagpath"></a>`path` | [`String`](#string) | Path for this tag. |

### `DescriptionVersion`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="descriptionversioncandelete"></a>`canDelete` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated** in 15.7. For backwards compatibility with REST API version and to be removed in a next iteration. |
| <a id="descriptionversiondeletepath"></a>`deletePath` **{warning-solid}** | [`String`](#string) | **Deprecated** in 15.7. For backwards compatibility with REST API version and to be removed in a next iteration. |
| <a id="descriptionversiondeleted"></a>`deleted` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated** in 15.7. For backwards compatibility with REST API version and to be removed in a next iteration. |
| <a id="descriptionversiondescription"></a>`description` | [`String`](#string) | Content of the given description version. |
| <a id="descriptionversiondiffpath"></a>`diffPath` **{warning-solid}** | [`String`](#string) | **Deprecated** in 15.7. For backwards compatibility with REST API version and to be removed in a next iteration. |
| <a id="descriptionversionid"></a>`id` | [`DescriptionVersionID!`](#descriptionversionid) | ID of the description version. |

#### Fields with arguments

##### `DescriptionVersion.diff`

Description diff between versions.

Returns [`String`](#string).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="descriptionversiondiffversionid"></a>`versionId` | [`DescriptionVersionID`](#descriptionversionid) | ID of a previous version to compare. If not specified first previous version is used. |

### `Design`

A single design.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designcommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="designdescription"></a>`description` | [`String`](#string) | Description of the design. |
| <a id="designdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="designdiffrefs"></a>`diffRefs` | [`DiffRefs!`](#diffrefs) | Diff refs for this design. |
| <a id="designdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="designevent"></a>`event` | [`DesignVersionEvent!`](#designversionevent) | How this design was changed in the current version. |
| <a id="designfilename"></a>`filename` | [`String!`](#string) | Filename of the design. |
| <a id="designfullpath"></a>`fullPath` | [`String!`](#string) | Full path to the design file. |
| <a id="designid"></a>`id` | [`ID!`](#id) | ID of this design. |
| <a id="designimage"></a>`image` | [`String!`](#string) | URL of the full-sized image. |
| <a id="designimagev432x230"></a>`imageV432x230` | [`String`](#string) | The URL of the design resized to fit within the bounds of 432x230. This will be `null` if the image has not been generated. |
| <a id="designissue"></a>`issue` | [`Issue!`](#issue) | Issue the design belongs to. |
| <a id="designnotes"></a>`notes` | [`NoteConnection!`](#noteconnection) | All notes on this noteable. (see [Connections](#connections)) |
| <a id="designnotescount"></a>`notesCount` | [`Int!`](#int) | Total count of user-created notes for this design. |
| <a id="designproject"></a>`project` | [`Project!`](#project) | Project the design belongs to. |
| <a id="designweburl"></a>`webUrl` | [`String!`](#string) | URL of the design. |

#### Fields with arguments

##### `Design.currentUserTodos`

To-do items for the current user.

Returns [`TodoConnection!`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designcurrentusertodosstate"></a>`state` | [`TodoStateEnum`](#todostateenum) | State of the to-do items. |

##### `Design.versions`

All versions related to this design ordered newest first.

Returns [`DesignVersionConnection!`](#designversionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designversionsearlierorequaltoid"></a>`earlierOrEqualToId` | [`DesignManagementVersionID`](#designmanagementversionid) | Global ID of the most recent acceptable version. |
| <a id="designversionsearlierorequaltosha"></a>`earlierOrEqualToSha` | [`String`](#string) | SHA256 of the most recent acceptable version. |

### `DesignAtVersion`

A design pinned to a specific version. The image field reflects the design as of the associated version.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designatversiondesign"></a>`design` | [`Design!`](#design) | Underlying design. |
| <a id="designatversiondiffrefs"></a>`diffRefs` | [`DiffRefs!`](#diffrefs) | Diff refs for this design. |
| <a id="designatversionevent"></a>`event` | [`DesignVersionEvent!`](#designversionevent) | How this design was changed in the current version. |
| <a id="designatversionfilename"></a>`filename` | [`String!`](#string) | Filename of the design. |
| <a id="designatversionfullpath"></a>`fullPath` | [`String!`](#string) | Full path to the design file. |
| <a id="designatversionid"></a>`id` | [`ID!`](#id) | ID of this design. |
| <a id="designatversionimage"></a>`image` | [`String!`](#string) | URL of the full-sized image. |
| <a id="designatversionimagev432x230"></a>`imageV432x230` | [`String`](#string) | The URL of the design resized to fit within the bounds of 432x230. This will be `null` if the image has not been generated. |
| <a id="designatversionissue"></a>`issue` | [`Issue!`](#issue) | Issue the design belongs to. |
| <a id="designatversionnotescount"></a>`notesCount` | [`Int!`](#int) | Total count of user-created notes for this design. |
| <a id="designatversionproject"></a>`project` | [`Project!`](#project) | Project the design belongs to. |
| <a id="designatversionversion"></a>`version` | [`DesignVersion!`](#designversion) | Version this design-at-versions is pinned to. |

### `DesignCollection`

A collection of designs.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designcollectioncopystate"></a>`copyState` | [`DesignCollectionCopyState`](#designcollectioncopystate) | Copy state of the design collection. |
| <a id="designcollectionissue"></a>`issue` | [`Issue!`](#issue) | Issue associated with the design collection. |
| <a id="designcollectionproject"></a>`project` | [`Project!`](#project) | Project associated with the design collection. |

#### Fields with arguments

##### `DesignCollection.design`

Find a specific design.

Returns [`Design`](#design).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designcollectiondesignfilename"></a>`filename` | [`String`](#string) | Find a design by its filename. |
| <a id="designcollectiondesignid"></a>`id` | [`DesignManagementDesignID`](#designmanagementdesignid) | Find a design by its ID. |

##### `DesignCollection.designAtVersion`

Find a design as of a version.

Returns [`DesignAtVersion`](#designatversion).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designcollectiondesignatversionid"></a>`id` | [`DesignManagementDesignAtVersionID!`](#designmanagementdesignatversionid) | Global ID of the design at this version. |

##### `DesignCollection.designs`

All designs for the design collection.

Returns [`DesignConnection!`](#designconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designcollectiondesignsatversion"></a>`atVersion` | [`DesignManagementVersionID`](#designmanagementversionid) | Filters designs to only those that existed at the version. If argument is omitted or nil then all designs will reflect the latest version. |
| <a id="designcollectiondesignsfilenames"></a>`filenames` | [`[String!]`](#string) | Filters designs by their filename. |
| <a id="designcollectiondesignsids"></a>`ids` | [`[DesignManagementDesignID!]`](#designmanagementdesignid) | Filters designs by their ID. |

##### `DesignCollection.version`

A specific version.

Returns [`DesignVersion`](#designversion).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designcollectionversionid"></a>`id` | [`DesignManagementVersionID`](#designmanagementversionid) | Global ID of the version. |
| <a id="designcollectionversionsha"></a>`sha` | [`String`](#string) | SHA256 of a specific version. |

##### `DesignCollection.versions`

All versions related to all designs, ordered newest first.

Returns [`DesignVersionConnection!`](#designversionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designcollectionversionsearlierorequaltoid"></a>`earlierOrEqualToId` | [`DesignManagementVersionID`](#designmanagementversionid) | Global ID of the most recent acceptable version. |
| <a id="designcollectionversionsearlierorequaltosha"></a>`earlierOrEqualToSha` | [`String`](#string) | SHA256 of the most recent acceptable version. |

### `DesignManagement`

#### Fields with arguments

##### `DesignManagement.designAtVersion`

Find a design as of a version.

Returns [`DesignAtVersion`](#designatversion).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designmanagementdesignatversionid"></a>`id` | [`DesignManagementDesignAtVersionID!`](#designmanagementdesignatversionid) | Global ID of the design at this version. |

##### `DesignManagement.version`

Find a version.

Returns [`DesignVersion`](#designversion).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designmanagementversionid"></a>`id` | [`DesignManagementVersionID!`](#designmanagementversionid) | Global ID of the version. |

### `DesignManagementRepositoryRegistry`

Represents the Geo replication and verification state of a Design Management Repository.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistrycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the DesignManagementRepositoryRegistry was created. |
| <a id="designmanagementrepositoryregistrydesignmanagementrepositoryid"></a>`designManagementRepositoryId` | [`ID!`](#id) | ID of the Design Management Repository. |
| <a id="designmanagementrepositoryregistryid"></a>`id` | [`ID!`](#id) | ID of the DesignManagementRepositoryRegistry. |
| <a id="designmanagementrepositoryregistrylastsyncfailure"></a>`lastSyncFailure` | [`String`](#string) | Error message during sync of the DesignManagementRepositoryRegistry. |
| <a id="designmanagementrepositoryregistrylastsyncedat"></a>`lastSyncedAt` | [`Time`](#time) | Timestamp of the most recent successful sync of the DesignManagementRepositoryRegistry. |
| <a id="designmanagementrepositoryregistryretryat"></a>`retryAt` | [`Time`](#time) | Timestamp after which the DesignManagementRepositoryRegistry is resynced. |
| <a id="designmanagementrepositoryregistryretrycount"></a>`retryCount` | [`Int`](#int) | Number of consecutive failed sync attempts of the DesignManagementRepositoryRegistry. |
| <a id="designmanagementrepositoryregistrystate"></a>`state` | [`RegistryState`](#registrystate) | Sync state of the DesignManagementRepositoryRegistry. |
| <a id="designmanagementrepositoryregistryverificationretryat"></a>`verificationRetryAt` | [`Time`](#time) | Timestamp after which the DesignManagementRepositoryRegistry is reverified. |
| <a id="designmanagementrepositoryregistryverifiedat"></a>`verifiedAt` | [`Time`](#time) | Timestamp of the most recent successful verification of the DesignManagementRepositoryRegistry. |

### `DesignVersion`

A specific version in which designs were added, modified or deleted.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designversionauthor"></a>`author` | [`UserCore!`](#usercore) | Author of the version. |
| <a id="designversioncreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of when the version was created. |
| <a id="designversiondesigns"></a>`designs` | [`DesignConnection!`](#designconnection) | All designs that were changed in the version. (see [Connections](#connections)) |
| <a id="designversionid"></a>`id` | [`ID!`](#id) | ID of the design version. |
| <a id="designversionsha"></a>`sha` | [`ID!`](#id) | SHA of the design version. |

#### Fields with arguments

##### `DesignVersion.designAtVersion`

A particular design as of this version, provided it is visible at this version.

Returns [`DesignAtVersion!`](#designatversion).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designversiondesignatversiondesignid"></a>`designId` | [`DesignManagementDesignID`](#designmanagementdesignid) | ID of a specific design. |
| <a id="designversiondesignatversionfilename"></a>`filename` | [`String`](#string) | Filename of a specific design. |
| <a id="designversiondesignatversionid"></a>`id` | [`DesignManagementDesignAtVersionID`](#designmanagementdesignatversionid) | ID of the DesignAtVersion. |

##### `DesignVersion.designsAtVersion`

All designs that are visible at this version, as of this version.

Returns [`DesignAtVersionConnection!`](#designatversionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designversiondesignsatversionfilenames"></a>`filenames` | [`[String!]`](#string) | Filters designs by their filename. |
| <a id="designversiondesignsatversionids"></a>`ids` | [`[DesignManagementDesignID!]`](#designmanagementdesignid) | Filters designs by their ID. |

### `DetailedStatus`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="detailedstatusaction"></a>`action` | [`StatusAction`](#statusaction) | Action information for the status. This includes method, button title, icon, path, and title. |
| <a id="detailedstatusdetailspath"></a>`detailsPath` | [`String`](#string) | Path of the details for the status. |
| <a id="detailedstatusfavicon"></a>`favicon` | [`String`](#string) | Favicon of the status. |
| <a id="detailedstatusgroup"></a>`group` | [`String`](#string) | Group of the status. |
| <a id="detailedstatushasdetails"></a>`hasDetails` | [`Boolean`](#boolean) | Indicates if the status has further details. |
| <a id="detailedstatusicon"></a>`icon` | [`String`](#string) | Icon of the status. |
| <a id="detailedstatusid"></a>`id` | [`String!`](#string) | ID for a detailed status. |
| <a id="detailedstatuslabel"></a>`label` | [`String`](#string) | Label of the status. |
| <a id="detailedstatustext"></a>`text` | [`String`](#string) | Text of the status. |
| <a id="detailedstatustooltip"></a>`tooltip` | [`String`](#string) | Tooltip associated with the status. |

### `DevopsAdoptionEnabledNamespace`

Enabled namespace for DevopsAdoption.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespacedisplaynamespace"></a>`displayNamespace` | [`Namespace`](#namespace) | Namespace where data should be displayed. |
| <a id="devopsadoptionenablednamespaceid"></a>`id` | [`ID!`](#id) | ID of the enabled namespace. |
| <a id="devopsadoptionenablednamespacelatestsnapshot"></a>`latestSnapshot` | [`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot) | Metrics snapshot for previous month for the enabled namespace. |
| <a id="devopsadoptionenablednamespacenamespace"></a>`namespace` | [`Namespace`](#namespace) | Namespace which should be calculated. |

#### Fields with arguments

##### `DevopsAdoptionEnabledNamespace.snapshots`

Data snapshots of the namespace.

Returns [`DevopsAdoptionSnapshotConnection`](#devopsadoptionsnapshotconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespacesnapshotsendtimeafter"></a>`endTimeAfter` | [`Time`](#time) | Filter to snapshots with month end after the provided date. |
| <a id="devopsadoptionenablednamespacesnapshotsendtimebefore"></a>`endTimeBefore` | [`Time`](#time) | Filter to snapshots with month end before the provided date. |

### `DevopsAdoptionSnapshot`

Snapshot.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionsnapshotcodeownersusedcount"></a>`codeOwnersUsedCount` | [`Int`](#int) | Total number of projects with existing CODEOWNERS file. |
| <a id="devopsadoptionsnapshotcoveragefuzzingenabledcount"></a>`coverageFuzzingEnabledCount` | [`Int`](#int) | Total number of projects with enabled coverage fuzzing. |
| <a id="devopsadoptionsnapshotdastenabledcount"></a>`dastEnabledCount` | [`Int`](#int) | Total number of projects with enabled DAST. |
| <a id="devopsadoptionsnapshotdependencyscanningenabledcount"></a>`dependencyScanningEnabledCount` | [`Int`](#int) | Total number of projects with enabled dependency scanning. |
| <a id="devopsadoptionsnapshotdeploysucceeded"></a>`deploySucceeded` | [`Boolean!`](#boolean) | At least one deployment succeeded. |
| <a id="devopsadoptionsnapshotendtime"></a>`endTime` | [`Time!`](#time) | End time for the snapshot where the data points were collected. |
| <a id="devopsadoptionsnapshotissueopened"></a>`issueOpened` | [`Boolean!`](#boolean) | At least one issue was opened. |
| <a id="devopsadoptionsnapshotmergerequestapproved"></a>`mergeRequestApproved` | [`Boolean!`](#boolean) | At least one merge request was approved. |
| <a id="devopsadoptionsnapshotmergerequestopened"></a>`mergeRequestOpened` | [`Boolean!`](#boolean) | At least one merge request was opened. |
| <a id="devopsadoptionsnapshotpipelinesucceeded"></a>`pipelineSucceeded` | [`Boolean!`](#boolean) | At least one pipeline succeeded. |
| <a id="devopsadoptionsnapshotrecordedat"></a>`recordedAt` | [`Time!`](#time) | Time the snapshot was recorded. |
| <a id="devopsadoptionsnapshotrunnerconfigured"></a>`runnerConfigured` | [`Boolean!`](#boolean) | At least one runner was used. |
| <a id="devopsadoptionsnapshotsastenabledcount"></a>`sastEnabledCount` | [`Int`](#int) | Total number of projects with enabled SAST. |
| <a id="devopsadoptionsnapshotstarttime"></a>`startTime` | [`Time!`](#time) | Start time for the snapshot where the data points were collected. |
| <a id="devopsadoptionsnapshottotalprojectscount"></a>`totalProjectsCount` | [`Int`](#int) | Total number of projects. |
| <a id="devopsadoptionsnapshotvulnerabilitymanagementusedcount"></a>`vulnerabilityManagementUsedCount` | [`Int`](#int) | Total number of projects with vulnerability management used at least once. |

### `DiffPosition`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="diffpositiondiffrefs"></a>`diffRefs` | [`DiffRefs!`](#diffrefs) | Information about the branch, HEAD, and base at the time of commenting. |
| <a id="diffpositionfilepath"></a>`filePath` | [`String!`](#string) | Path of the file that was changed. |
| <a id="diffpositionheight"></a>`height` | [`Int`](#int) | Total height of the image. |
| <a id="diffpositionnewline"></a>`newLine` | [`Int`](#int) | Line on HEAD SHA that was changed. |
| <a id="diffpositionnewpath"></a>`newPath` | [`String`](#string) | Path of the file on the HEAD SHA. |
| <a id="diffpositionoldline"></a>`oldLine` | [`Int`](#int) | Line on start SHA that was changed. |
| <a id="diffpositionoldpath"></a>`oldPath` | [`String`](#string) | Path of the file on the start SHA. |
| <a id="diffpositionpositiontype"></a>`positionType` | [`DiffPositionType!`](#diffpositiontype) | Type of file the position refers to. |
| <a id="diffpositionwidth"></a>`width` | [`Int`](#int) | Total width of the image. |
| <a id="diffpositionx"></a>`x` | [`Int`](#int) | X position of the note. |
| <a id="diffpositiony"></a>`y` | [`Int`](#int) | Y position of the note. |

### `DiffRefs`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="diffrefsbasesha"></a>`baseSha` | [`String`](#string) | Merge base of the branch the comment was made on. |
| <a id="diffrefsheadsha"></a>`headSha` | [`String!`](#string) | SHA of the HEAD at the time the comment was made. |
| <a id="diffrefsstartsha"></a>`startSha` | [`String!`](#string) | SHA of the branch being compared against. |

### `DiffStats`

Changes to a single file.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="diffstatsadditions"></a>`additions` | [`Int!`](#int) | Number of lines added to this file. |
| <a id="diffstatsdeletions"></a>`deletions` | [`Int!`](#int) | Number of lines deleted from this file. |
| <a id="diffstatspath"></a>`path` | [`String!`](#string) | File path, relative to repository root. |

### `DiffStatsSummary`

Aggregated summary of changes.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="diffstatssummaryadditions"></a>`additions` | [`Int!`](#int) | Number of lines added. |
| <a id="diffstatssummarychanges"></a>`changes` | [`Int!`](#int) | Number of lines changed. |
| <a id="diffstatssummarydeletions"></a>`deletions` | [`Int!`](#int) | Number of lines deleted. |
| <a id="diffstatssummaryfilecount"></a>`fileCount` | [`Int!`](#int) | Number of files changed. |

### `Discussion`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="discussioncreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of the discussion's creation. |
| <a id="discussionid"></a>`id` | [`DiscussionID!`](#discussionid) | ID of this discussion. |
| <a id="discussionnoteable"></a>`noteable` | [`NoteableType`](#noteabletype) | Object which the discussion belongs to. |
| <a id="discussionnotes"></a>`notes` | [`NoteConnection!`](#noteconnection) | All notes in the discussion. (see [Connections](#connections)) |
| <a id="discussionreplyid"></a>`replyId` | [`DiscussionID!`](#discussionid) | ID used to reply to this discussion. |
| <a id="discussionresolvable"></a>`resolvable` | [`Boolean!`](#boolean) | Indicates if the object can be resolved. |
| <a id="discussionresolved"></a>`resolved` | [`Boolean!`](#boolean) | Indicates if the object is resolved. |
| <a id="discussionresolvedat"></a>`resolvedAt` | [`Time`](#time) | Timestamp of when the object was resolved. |
| <a id="discussionresolvedby"></a>`resolvedBy` | [`UserCore`](#usercore) | User who resolved the object. |

### `Dora`

All information related to DORA metrics.

#### Fields with arguments

##### `Dora.metrics`

DORA metrics for the current group or project.

Returns [`[DoraMetric!]`](#dorametric).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dorametricsenddate"></a>`endDate` | [`Date`](#date) | Date range to end at. Default is the current date. |
| <a id="dorametricsenvironmenttiers"></a>`environmentTiers` | [`[DeploymentTier!]`](#deploymenttier) | Deployment tiers of the environments to return. Defaults to `[PRODUCTION]`. |
| <a id="dorametricsinterval"></a>`interval` | [`DoraMetricBucketingInterval`](#dorametricbucketinginterval) | How the metric should be aggregated. Defaults to `DAILY`. In the case of `ALL`, the `date` field in the response will be `null`. |
| <a id="dorametricsmetric"></a>`metric` **{warning-solid}** | [`DoraMetricType`](#dorametrictype) | **Deprecated** in 15.10. Superseded by metrics fields. See `DoraMetric` type. |
| <a id="dorametricsstartdate"></a>`startDate` | [`Date`](#date) | Date range to start from. Default is 3 months ago. |

### `DoraMetric`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dorametricchangefailurerate"></a>`changeFailureRate` | [`Float`](#float) | Percentage of deployments that caused incidents in production. |
| <a id="dorametricdate"></a>`date` | [`String`](#string) | Date of the data point. |
| <a id="dorametricdeploymentfrequency"></a>`deploymentFrequency` | [`Float`](#float) | Number of deployments per day. |
| <a id="dorametricleadtimeforchanges"></a>`leadTimeForChanges` | [`Float`](#float) | Median time to deploy a merged merge request. |
| <a id="dorametrictimetorestoreservice"></a>`timeToRestoreService` | [`Float`](#float) | Median time to close an incident. |
| <a id="dorametricvalue"></a>`value` **{warning-solid}** | [`Float`](#float) | **Deprecated** in 15.10. Moved to corresponding metric field. |

### `EgressNode`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="egressnodeartifactsegress"></a>`artifactsEgress` | [`BigInt!`](#bigint) | Artifacts egress for that project in that period of time. |
| <a id="egressnodedate"></a>`date` | [`String!`](#string) | First day of the node range. There is one node per month. |
| <a id="egressnodepackagesegress"></a>`packagesEgress` | [`BigInt!`](#bigint) | Packages egress for that project in that period of time. |
| <a id="egressnoderegistryegress"></a>`registryEgress` | [`BigInt!`](#bigint) | Registry egress for that project in that period of time. |
| <a id="egressnoderepositoryegress"></a>`repositoryEgress` | [`BigInt!`](#bigint) | Repository egress for that project in that period of time. |
| <a id="egressnodetotalegress"></a>`totalEgress` | [`BigInt!`](#bigint) | Total egress for that project in that period of time. |

### `Email`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="emailconfirmedat"></a>`confirmedAt` | [`Time`](#time) | Timestamp the email was confirmed. |
| <a id="emailcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp the email was created. |
| <a id="emailemail"></a>`email` | [`String!`](#string) | Email address. |
| <a id="emailid"></a>`id` | [`ID!`](#id) | Internal ID of the email. |
| <a id="emailupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp the email was last updated. |

### `Environment`

Describes where code is deployed for a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="environmentautodeleteat"></a>`autoDeleteAt` | [`Time`](#time) | When the environment is going to be deleted automatically. |
| <a id="environmentautostopat"></a>`autoStopAt` | [`Time`](#time) | When the environment is going to be stopped automatically. |
| <a id="environmentclusteragent"></a>`clusterAgent` | [`ClusterAgent`](#clusteragent) | Cluster agent of the environment. |
| <a id="environmentcreatedat"></a>`createdAt` | [`Time`](#time) | When the environment was created. |
| <a id="environmentdeployfreezes"></a>`deployFreezes` | [`[CiFreezePeriod!]`](#cifreezeperiod) | Deployment freeze periods of the environment. |
| <a id="environmentenvironmenttype"></a>`environmentType` | [`String`](#string) | Folder name of the environment. |
| <a id="environmentexternalurl"></a>`externalUrl` | [`String`](#string) | External URL of the environment. |
| <a id="environmentid"></a>`id` | [`ID!`](#id) | ID of the environment. |
| <a id="environmentlatestopenedmostseverealert"></a>`latestOpenedMostSevereAlert` | [`AlertManagementAlert`](#alertmanagementalert) | Most severe open alert for the environment. If multiple alerts have equal severity, the most recent is returned. |
| <a id="environmentname"></a>`name` | [`String!`](#string) | Human-readable name of the environment. |
| <a id="environmentpath"></a>`path` | [`String!`](#string) | Path to the environment. |
| <a id="environmentprotectedenvironments"></a>`protectedEnvironments` | [`ProtectedEnvironmentConnection`](#protectedenvironmentconnection) | Protected Environments for the environment. (see [Connections](#connections)) |
| <a id="environmentslug"></a>`slug` | [`String`](#string) | Slug of the environment. |
| <a id="environmentstate"></a>`state` | [`String!`](#string) | State of the environment, for example: available/stopped. |
| <a id="environmenttier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | Deployment tier of the environment. |
| <a id="environmentupdatedat"></a>`updatedAt` | [`Time`](#time) | When the environment was updated. |
| <a id="environmentuserpermissions"></a>`userPermissions` | [`EnvironmentPermissions!`](#environmentpermissions) | Permissions for the current user on the resource. This field can only be resolved for one environment in any single request. |

#### Fields with arguments

##### `Environment.deployments`

Deployments of the environment. This field can only be resolved for one environment in any single request.

Returns [`DeploymentConnection`](#deploymentconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="environmentdeploymentsorderby"></a>`orderBy` | [`DeploymentsOrderByInput`](#deploymentsorderbyinput) | Order by a specified field. |
| <a id="environmentdeploymentsstatuses"></a>`statuses` | [`[DeploymentStatus!]`](#deploymentstatus) | Statuses of the deployments. |

##### `Environment.lastDeployment`

Last deployment of the environment.

Returns [`Deployment`](#deployment).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="environmentlastdeploymentstatus"></a>`status` | [`DeploymentStatus!`](#deploymentstatus) | Status of the Deployment. |

##### `Environment.metricsDashboard`

Metrics dashboard schema for the environment.

WARNING:
**Deprecated** in 16.0.
Returns no data. Underlying feature was removed in 16.0.

Returns [`MetricsDashboard`](#metricsdashboard).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="environmentmetricsdashboardpath"></a>`path` | [`String!`](#string) | Path to a file which defines a metrics dashboard eg: `"config/prometheus/common_metrics.yml"`. |

### `EnvironmentPermissions`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="environmentpermissionsdestroyenvironment"></a>`destroyEnvironment` | [`Boolean!`](#boolean) | Indicates the user can perform `destroy_environment` on this resource. |
| <a id="environmentpermissionsstopenvironment"></a>`stopEnvironment` | [`Boolean!`](#boolean) | Indicates the user can perform `stop_environment` on this resource. |
| <a id="environmentpermissionsupdateenvironment"></a>`updateEnvironment` | [`Boolean!`](#boolean) | Indicates the user can perform `update_environment` on this resource. |

### `Epic`

Represents an epic.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicauthor"></a>`author` | [`UserCore!`](#usercore) | Author of the epic. |
| <a id="epicawardemoji"></a>`awardEmoji` | [`AwardEmojiConnection`](#awardemojiconnection) | List of award emojis associated with the epic. (see [Connections](#connections)) |
| <a id="epicblocked"></a>`blocked` | [`Boolean`](#boolean) | Indicates the epic is blocked. |
| <a id="epicblockedbycount"></a>`blockedByCount` | [`Int`](#int) | Count of epics blocking this epic. |
| <a id="epicblockedbyepics"></a>`blockedByEpics` | [`EpicConnection`](#epicconnection) | Epics blocking this epic. (see [Connections](#connections)) |
| <a id="epicblockingcount"></a>`blockingCount` | [`Int`](#int) | Count of epics that this epic is blocking. |
| <a id="epicclosedat"></a>`closedAt` | [`Time`](#time) | Timestamp of when the epic was closed. |
| <a id="epiccolor"></a>`color` | [`String`](#string) | Color of the epic. Returns `null` if `epic_color_highlight` feature flag is disabled. |
| <a id="epiccommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="epicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates if the epic is confidential. |
| <a id="epiccreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of when the epic was created. |
| <a id="epicdefaultprojectforissuecreation"></a>`defaultProjectForIssueCreation` | [`Project`](#project) | Default Project for issue creation. Based on the project the user created the last issue in. |
| <a id="epicdescendantcounts"></a>`descendantCounts` | [`EpicDescendantCount`](#epicdescendantcount) | Number of open and closed descendant epics and issues. |
| <a id="epicdescendantweightsum"></a>`descendantWeightSum` | [`EpicDescendantWeights`](#epicdescendantweights) | Total weight of open and closed issues in the epic and its descendants. |
| <a id="epicdescription"></a>`description` | [`String`](#string) | Description of the epic. |
| <a id="epicdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="epicdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="epicdownvotes"></a>`downvotes` | [`Int!`](#int) | Number of downvotes the epic has received. |
| <a id="epicduedate"></a>`dueDate` | [`Time`](#time) | Due date of the epic. |
| <a id="epicduedatefixed"></a>`dueDateFixed` | [`Time`](#time) | Fixed due date of the epic. |
| <a id="epicduedatefrominheritedsource"></a>`dueDateFromInheritedSource` | [`Time`](#time) | Inherited due date of the epic from child epics or milestones. |
| <a id="epicduedatefrommilestones"></a>`dueDateFromMilestones` | [`Time`](#time) | Inherited due date of the epic from milestones. |
| <a id="epicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | Indicates if the due date has been manually set. |
| <a id="epicevents"></a>`events` | [`EventConnection`](#eventconnection) | List of events associated with the object. (see [Connections](#connections)) |
| <a id="epicgroup"></a>`group` | [`Group!`](#group) | Group to which the epic belongs. |
| <a id="epichaschildren"></a>`hasChildren` | [`Boolean!`](#boolean) | Indicates if the epic has children. |
| <a id="epichasissues"></a>`hasIssues` | [`Boolean!`](#boolean) | Indicates if the epic has direct issues. |
| <a id="epichasparent"></a>`hasParent` | [`Boolean!`](#boolean) | Indicates if the epic has a parent epic. |
| <a id="epichealthstatus"></a>`healthStatus` | [`EpicHealthStatus`](#epichealthstatus) | Current health status of the epic. |
| <a id="epicid"></a>`id` | [`ID!`](#id) | ID of the epic. |
| <a id="epiciid"></a>`iid` | [`ID!`](#id) | Internal ID of the epic. |
| <a id="epicissues"></a>`issues` | [`EpicIssueConnection`](#epicissueconnection) | A list of issues associated with the epic. (see [Connections](#connections)) |
| <a id="epiclabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels assigned to the epic. (see [Connections](#connections)) |
| <a id="epicnotes"></a>`notes` | [`NoteConnection!`](#noteconnection) | All notes on this noteable. (see [Connections](#connections)) |
| <a id="epicparent"></a>`parent` | [`Epic`](#epic) | Parent epic of the epic. |
| <a id="epicparticipants"></a>`participants` | [`UserCoreConnection`](#usercoreconnection) | List of participants for the epic. (see [Connections](#connections)) |
| <a id="epicrelationpath"></a>`relationPath` | [`String`](#string) | URI path of the epic-issue relationship. |
| <a id="epicrelativeposition"></a>`relativePosition` | [`Int`](#int) | Relative position of the epic in the epic tree. |
| <a id="epicstartdate"></a>`startDate` | [`Time`](#time) | Start date of the epic. |
| <a id="epicstartdatefixed"></a>`startDateFixed` | [`Time`](#time) | Fixed start date of the epic. |
| <a id="epicstartdatefrominheritedsource"></a>`startDateFromInheritedSource` | [`Time`](#time) | Inherited start date of the epic from child epics or milestones. |
| <a id="epicstartdatefrommilestones"></a>`startDateFromMilestones` | [`Time`](#time) | Inherited start date of the epic from milestones. |
| <a id="epicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | Indicates if the start date has been manually set. |
| <a id="epicstate"></a>`state` | [`EpicState!`](#epicstate) | State of the epic. |
| <a id="epicsubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | Indicates the currently logged in user is subscribed to the epic. |
| <a id="epictextcolor"></a>`textColor` | [`String`](#string) | Text color generated for the epic. Returns `null` if `epic_color_highlight` feature flag is disabled. |
| <a id="epictitle"></a>`title` | [`String`](#string) | Title of the epic. |
| <a id="epictitlehtml"></a>`titleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `title`. |
| <a id="epicupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp of when the epic was updated. |
| <a id="epicupvotes"></a>`upvotes` | [`Int!`](#int) | Number of upvotes the epic has received. |
| <a id="epicuserdiscussionscount"></a>`userDiscussionsCount` | [`Int!`](#int) | Number of user discussions in the epic. |
| <a id="epicusernotescount"></a>`userNotesCount` | [`Int!`](#int) | Number of user notes of the epic. |
| <a id="epicuserpermissions"></a>`userPermissions` | [`EpicPermissions!`](#epicpermissions) | Permissions for the current user on the resource. |
| <a id="epicwebpath"></a>`webPath` | [`String!`](#string) | Web path of the epic. |
| <a id="epicweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the epic. |

#### Fields with arguments

##### `Epic.ancestors`

Ancestors (parents) of the epic.

Returns [`EpicConnection`](#epicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicancestorsauthorusername"></a>`authorUsername` | [`String`](#string) | Filter epics by author. |
| <a id="epicancestorsconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter epics by given confidentiality. |
| <a id="epicancestorscreatedafter"></a>`createdAfter` | [`Time`](#time) | Epics created after this date. |
| <a id="epicancestorscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Epics created before this date. |
| <a id="epicancestorsiid"></a>`iid` | [`ID`](#id) | IID of the epic, e.g., "1". |
| <a id="epicancestorsiidstartswith"></a>`iidStartsWith` | [`String`](#string) | Filter epics by IID for autocomplete. |
| <a id="epicancestorsiids"></a>`iids` | [`[ID!]`](#id) | List of IIDs of epics, e.g., `[1, 2]`. |
| <a id="epicancestorsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="epicancestorsincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Include epics from ancestor groups. |
| <a id="epicancestorsincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | Include epics from descendant groups. |
| <a id="epicancestorslabelname"></a>`labelName` | [`[String!]`](#string) | Filter epics by labels. |
| <a id="epicancestorsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Filter epics by milestone title, computed from epic's issues. |
| <a id="epicancestorsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. |
| <a id="epicancestorsnot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | Negated epic arguments. |
| <a id="epicancestorsor"></a>`or` **{warning-solid}** | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | **Introduced** in 15.9. This feature is an Experiment. It can be changed or removed at any time. List of arguments with inclusive OR. Ignored unless `or_issuable_queries` flag is enabled. |
| <a id="epicancestorssearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="epicancestorssort"></a>`sort` | [`EpicSort`](#epicsort) | List epics by sort order. |
| <a id="epicancestorsstate"></a>`state` | [`EpicState`](#epicstate) | Filter epics by state. |
| <a id="epicancestorstimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="epicancestorstoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | Filter epics with a top-level hierarchy. |
| <a id="epicancestorsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Epics updated after this date. |
| <a id="epicancestorsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Epics updated before this date. |

##### `Epic.children`

Children (sub-epics) of the epic.

Returns [`EpicConnection`](#epicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicchildrenauthorusername"></a>`authorUsername` | [`String`](#string) | Filter epics by author. |
| <a id="epicchildrenconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter epics by given confidentiality. |
| <a id="epicchildrencreatedafter"></a>`createdAfter` | [`Time`](#time) | Epics created after this date. |
| <a id="epicchildrencreatedbefore"></a>`createdBefore` | [`Time`](#time) | Epics created before this date. |
| <a id="epicchildreniid"></a>`iid` | [`ID`](#id) | IID of the epic, e.g., "1". |
| <a id="epicchildreniidstartswith"></a>`iidStartsWith` | [`String`](#string) | Filter epics by IID for autocomplete. |
| <a id="epicchildreniids"></a>`iids` | [`[ID!]`](#id) | List of IIDs of epics, e.g., `[1, 2]`. |
| <a id="epicchildrenin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="epicchildrenincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Include child epics from ancestor groups. |
| <a id="epicchildrenincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | Include epics from descendant groups. |
| <a id="epicchildrenlabelname"></a>`labelName` | [`[String!]`](#string) | Filter epics by labels. |
| <a id="epicchildrenmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Filter epics by milestone title, computed from epic's issues. |
| <a id="epicchildrenmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. |
| <a id="epicchildrennot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | Negated epic arguments. |
| <a id="epicchildrenor"></a>`or` **{warning-solid}** | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | **Introduced** in 15.9. This feature is an Experiment. It can be changed or removed at any time. List of arguments with inclusive OR. Ignored unless `or_issuable_queries` flag is enabled. |
| <a id="epicchildrensearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="epicchildrensort"></a>`sort` | [`EpicSort`](#epicsort) | List epics by sort order. |
| <a id="epicchildrenstate"></a>`state` | [`EpicState`](#epicstate) | Filter epics by state. |
| <a id="epicchildrentimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="epicchildrentoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | Filter epics with a top-level hierarchy. |
| <a id="epicchildrenupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Epics updated after this date. |
| <a id="epicchildrenupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Epics updated before this date. |

##### `Epic.currentUserTodos`

To-do items for the current user.

Returns [`TodoConnection!`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epiccurrentusertodosstate"></a>`state` | [`TodoStateEnum`](#todostateenum) | State of the to-do items. |

##### `Epic.reference`

Internal reference of the epic. Returned in shortened format by default.

Returns [`String!`](#string).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicreferencefull"></a>`full` | [`Boolean`](#boolean) | Indicates if the reference should be returned in full. |

### `EpicBoard`

Represents an epic board.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicboarddisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | Whether or not display epic colors. |
| <a id="epicboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="epicboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="epicboardid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the epic board. |
| <a id="epicboardlabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels of the board. (see [Connections](#connections)) |
| <a id="epicboardname"></a>`name` | [`String`](#string) | Name of the epic board. |
| <a id="epicboardwebpath"></a>`webPath` | [`String!`](#string) | Web path of the epic board. |
| <a id="epicboardweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the epic board. |

#### Fields with arguments

##### `EpicBoard.lists`

Epic board lists.

Returns [`EpicListConnection`](#epiclistconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicboardlistsepicfilters"></a>`epicFilters` | [`EpicFilters`](#epicfilters) | Filters applied when getting epic metadata in the epic board list. |
| <a id="epicboardlistsid"></a>`id` | [`BoardsEpicListID`](#boardsepiclistid) | Find an epic board list by ID. |

### `EpicDescendantCount`

Counts of descendent epics.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicdescendantcountclosedepics"></a>`closedEpics` | [`Int`](#int) | Number of closed child epics. |
| <a id="epicdescendantcountclosedissues"></a>`closedIssues` | [`Int`](#int) | Number of closed epic issues. |
| <a id="epicdescendantcountopenedepics"></a>`openedEpics` | [`Int`](#int) | Number of opened child epics. |
| <a id="epicdescendantcountopenedissues"></a>`openedIssues` | [`Int`](#int) | Number of opened epic issues. |

### `EpicDescendantWeights`

Total weight of open and closed descendant issues.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicdescendantweightsclosedissues"></a>`closedIssues` | [`Int`](#int) | Total weight of completed (closed) issues in this epic, including epic descendants. |
| <a id="epicdescendantweightsopenedissues"></a>`openedIssues` | [`Int`](#int) | Total weight of opened issues in this epic, including epic descendants. |

### `EpicHealthStatus`

Health status of child issues.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epichealthstatusissuesatrisk"></a>`issuesAtRisk` | [`Int`](#int) | Number of issues at risk. |
| <a id="epichealthstatusissuesneedingattention"></a>`issuesNeedingAttention` | [`Int`](#int) | Number of issues that need attention. |
| <a id="epichealthstatusissuesontrack"></a>`issuesOnTrack` | [`Int`](#int) | Number of issues on track. |

### `EpicIssue`

Relationship between an epic and an issue.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicissuealertmanagementalert"></a>`alertManagementAlert` **{warning-solid}** | [`AlertManagementAlert`](#alertmanagementalert) | **Deprecated** in 15.6. Use `alert_management_alerts`. |
| <a id="epicissueassignees"></a>`assignees` | [`UserCoreConnection`](#usercoreconnection) | Assignees of the issue. (see [Connections](#connections)) |
| <a id="epicissueauthor"></a>`author` | [`UserCore!`](#usercore) | User that created the issue. |
| <a id="epicissueblocked"></a>`blocked` | [`Boolean!`](#boolean) | Indicates the issue is blocked. |
| <a id="epicissueblockedbycount"></a>`blockedByCount` | [`Int`](#int) | Count of issues blocking this issue. |
| <a id="epicissueblockedbyissues"></a>`blockedByIssues` | [`IssueConnection`](#issueconnection) | Issues blocking this issue. (see [Connections](#connections)) |
| <a id="epicissueblockingcount"></a>`blockingCount` | [`Int!`](#int) | Count of issues this issue is blocking. |
| <a id="epicissueclosedasduplicateof"></a>`closedAsDuplicateOf` | [`Issue`](#issue) | Issue this issue was closed as a duplicate of. |
| <a id="epicissueclosedat"></a>`closedAt` | [`Time`](#time) | Timestamp of when the issue was closed. |
| <a id="epicissuecommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="epicissueconfidential"></a>`confidential` | [`Boolean!`](#boolean) | Indicates the issue is confidential. |
| <a id="epicissuecreatenoteemail"></a>`createNoteEmail` | [`String`](#string) | User specific email address for the issue. |
| <a id="epicissuecreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of when the issue was created. |
| <a id="epicissuecustomerrelationscontacts"></a>`customerRelationsContacts` | [`CustomerRelationsContactConnection`](#customerrelationscontactconnection) | Customer relations contacts of the issue. (see [Connections](#connections)) |
| <a id="epicissuedescription"></a>`description` | [`String`](#string) | Description of the issue. |
| <a id="epicissuedescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="epicissuedesigncollection"></a>`designCollection` | [`DesignCollection`](#designcollection) | Collection of design images associated with this issue. |
| <a id="epicissuediscussionlocked"></a>`discussionLocked` | [`Boolean!`](#boolean) | Indicates discussion is locked on the issue. |
| <a id="epicissuediscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="epicissuedownvotes"></a>`downvotes` | [`Int!`](#int) | Number of downvotes the issue has received. |
| <a id="epicissueduedate"></a>`dueDate` | [`Time`](#time) | Due date of the issue. |
| <a id="epicissueemailsdisabled"></a>`emailsDisabled` | [`Boolean!`](#boolean) | Indicates if a project has email notifications disabled: `true` if email notifications are disabled. |
| <a id="epicissueepic"></a>`epic` | [`Epic`](#epic) | Epic to which this issue belongs. |
| <a id="epicissueepicissueid"></a>`epicIssueId` | [`ID!`](#id) | ID of the epic-issue relation. |
| <a id="epicissueescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy associated with the issue. Available for issues which support escalation. |
| <a id="epicissueescalationstatus"></a>`escalationStatus` | [`IssueEscalationStatus`](#issueescalationstatus) | Escalation status of the issue. |
| <a id="epicissuehasepic"></a>`hasEpic` | [`Boolean!`](#boolean) | Indicates if the issue belongs to an epic. Can return true and not show an associated epic when the user has no access to the epic. |
| <a id="epicissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Current health status. |
| <a id="epicissuehidden"></a>`hidden` | [`Boolean`](#boolean) | Indicates the issue is hidden because the author has been banned. |
| <a id="epicissuehumantimeestimate"></a>`humanTimeEstimate` | [`String`](#string) | Human-readable time estimate of the issue. |
| <a id="epicissuehumantotaltimespent"></a>`humanTotalTimeSpent` | [`String`](#string) | Human-readable total time reported as spent on the issue. |
| <a id="epicissueid"></a>`id` | [`ID`](#id) | Global ID of the epic-issue relation. |
| <a id="epicissueiid"></a>`iid` | [`ID!`](#id) | Internal ID of the issue. |
| <a id="epicissueiteration"></a>`iteration` | [`Iteration`](#iteration) | Iteration of the issue. |
| <a id="epicissuelabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels of the issue. (see [Connections](#connections)) |
| <a id="epicissuemergerequestscount"></a>`mergeRequestsCount` | [`Int!`](#int) | Number of merge requests that close the issue on merge. |
| <a id="epicissuemetricimages"></a>`metricImages` | [`[MetricImage!]`](#metricimage) | Metric images associated to the issue. |
| <a id="epicissuemilestone"></a>`milestone` | [`Milestone`](#milestone) | Milestone of the issue. |
| <a id="epicissuemoved"></a>`moved` | [`Boolean`](#boolean) | Indicates if issue got moved from other project. |
| <a id="epicissuemovedto"></a>`movedTo` | [`Issue`](#issue) | Updated Issue after it got moved to another project. |
| <a id="epicissuenotes"></a>`notes` | [`NoteConnection!`](#noteconnection) | All notes on this noteable. (see [Connections](#connections)) |
| <a id="epicissueparticipants"></a>`participants` | [`UserCoreConnection`](#usercoreconnection) | List of participants in the issue. (see [Connections](#connections)) |
| <a id="epicissueprojectid"></a>`projectId` | [`Int!`](#int) | ID of the issue project. |
| <a id="epicissuerelatedmergerequests"></a>`relatedMergeRequests` | [`MergeRequestConnection`](#mergerequestconnection) | Merge requests related to the issue. This field can only be resolved for one issue in any single request. (see [Connections](#connections)) |
| <a id="epicissuerelatedvulnerabilities"></a>`relatedVulnerabilities` | [`VulnerabilityConnection`](#vulnerabilityconnection) | Related vulnerabilities of the issue. (see [Connections](#connections)) |
| <a id="epicissuerelationpath"></a>`relationPath` | [`String`](#string) | URI path of the epic-issue relation. |
| <a id="epicissuerelativeposition"></a>`relativePosition` | [`Int`](#int) | Relative position of the issue (used for positioning in epic tree and issue boards). |
| <a id="epicissueseverity"></a>`severity` | [`IssuableSeverity`](#issuableseverity) | Severity level of the incident. |
| <a id="epicissuesladueat"></a>`slaDueAt` | [`Time`](#time) | Timestamp of when the issue SLA expires. |
| <a id="epicissuestate"></a>`state` | [`IssueState!`](#issuestate) | State of the issue. |
| <a id="epicissuestatuspagepublishedincident"></a>`statusPagePublishedIncident` | [`Boolean`](#boolean) | Indicates whether an issue is published to the status page. |
| <a id="epicissuesubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | Indicates the currently logged in user is subscribed to the issue. |
| <a id="epicissuetaskcompletionstatus"></a>`taskCompletionStatus` | [`TaskCompletionStatus!`](#taskcompletionstatus) | Task completion status of the issue. |
| <a id="epicissuetimeestimate"></a>`timeEstimate` | [`Int!`](#int) | Time estimate of the issue. |
| <a id="epicissuetimelogs"></a>`timelogs` | [`TimelogConnection!`](#timelogconnection) | Timelogs on the issue. (see [Connections](#connections)) |
| <a id="epicissuetitle"></a>`title` | [`String!`](#string) | Title of the issue. |
| <a id="epicissuetitlehtml"></a>`titleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `title`. |
| <a id="epicissuetotaltimespent"></a>`totalTimeSpent` | [`Int!`](#int) | Total time reported as spent on the issue. |
| <a id="epicissuetype"></a>`type` | [`IssueType`](#issuetype) | Type of the issue. |
| <a id="epicissueupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of when the issue was last updated. |
| <a id="epicissueupdatedby"></a>`updatedBy` | [`UserCore`](#usercore) | User that last updated the issue. |
| <a id="epicissueupvotes"></a>`upvotes` | [`Int!`](#int) | Number of upvotes the issue has received. |
| <a id="epicissueuserdiscussionscount"></a>`userDiscussionsCount` | [`Int!`](#int) | Number of user discussions in the issue. |
| <a id="epicissueusernotescount"></a>`userNotesCount` | [`Int!`](#int) | Number of user notes of the issue. |
| <a id="epicissueuserpermissions"></a>`userPermissions` | [`IssuePermissions!`](#issuepermissions) | Permissions for the current user on the resource. |
| <a id="epicissuewebpath"></a>`webPath` | [`String!`](#string) | Web path of the issue. |
| <a id="epicissueweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the issue. |
| <a id="epicissueweight"></a>`weight` | [`Int`](#int) | Weight of the issue. |

#### Fields with arguments

##### `EpicIssue.alertManagementAlerts`

Alert Management alerts associated to this issue.

Returns [`AlertManagementAlertConnection`](#alertmanagementalertconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicissuealertmanagementalertsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | Username of a user assigned to the issue. |
| <a id="epicissuealertmanagementalertsdomain"></a>`domain` | [`AlertManagementDomainFilter!`](#alertmanagementdomainfilter) | Filter query for given domain. |
| <a id="epicissuealertmanagementalertsiid"></a>`iid` | [`String`](#string) | IID of the alert. For example, "1". |
| <a id="epicissuealertmanagementalertssearch"></a>`search` | [`String`](#string) | Search query for title, description, service, or monitoring_tool. |
| <a id="epicissuealertmanagementalertssort"></a>`sort` | [`AlertManagementAlertSort`](#alertmanagementalertsort) | Sort alerts by this criteria. |
| <a id="epicissuealertmanagementalertsstatuses"></a>`statuses` | [`[AlertManagementStatus!]`](#alertmanagementstatus) | Alerts with the specified statues. For example, `[TRIGGERED]`. |

##### `EpicIssue.currentUserTodos`

To-do items for the current user.

Returns [`TodoConnection!`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicissuecurrentusertodosstate"></a>`state` | [`TodoStateEnum`](#todostateenum) | State of the to-do items. |

##### `EpicIssue.issuableResourceLinks`

Issuable resource links of the incident issue.

Returns [`IssuableResourceLinkConnection`](#issuableresourcelinkconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicissueissuableresourcelinksincidentid"></a>`incidentId` | [`IssueID!`](#issueid) | ID of the incident. |

##### `EpicIssue.reference`

Internal reference of the issue. Returned in shortened format by default.

Returns [`String!`](#string).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicissuereferencefull"></a>`full` | [`Boolean`](#boolean) | Boolean option specifying whether the reference should be returned in full. |

### `EpicList`

Represents an epic board list.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epiclistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | Indicates if this list is collapsed for this user. |
| <a id="epiclistepicscount"></a>`epicsCount` **{warning-solid}** | [`Int`](#int) | **Deprecated** in 14.9. This was renamed. Use: `metadata`. |
| <a id="epiclistid"></a>`id` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the board list. |
| <a id="epiclistlabel"></a>`label` | [`Label`](#label) | Label of the list. |
| <a id="epiclistlisttype"></a>`listType` | [`String!`](#string) | Type of the list. |
| <a id="epiclistmetadata"></a>`metadata` | [`EpicListMetadata`](#epiclistmetadata) | Epic list metatada. |
| <a id="epiclistposition"></a>`position` | [`Int`](#int) | Position of the list within the board. |
| <a id="epiclisttitle"></a>`title` | [`String!`](#string) | Title of the list. |

#### Fields with arguments

##### `EpicList.epics`

List epics.

Returns [`EpicConnection`](#epicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epiclistepicsfilters"></a>`filters` | [`EpicFilters`](#epicfilters) | Filters applied when selecting epics in the board list. |

### `EpicListMetadata`

Represents epic board list metadata.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epiclistmetadataepicscount"></a>`epicsCount` | [`Int`](#int) | Count of epics in the list. |
| <a id="epiclistmetadatatotalweight"></a>`totalWeight` **{warning-solid}** | [`Int`](#int) | **Introduced** in 14.7. This feature is an Experiment. It can be changed or removed at any time. Total weight of all issues in the list. |

### `EpicPermissions`

Check permissions for the current user on an epic.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicpermissionsadminepic"></a>`adminEpic` | [`Boolean!`](#boolean) | Indicates the user can perform `admin_epic` on this resource. |
| <a id="epicpermissionsawardemoji"></a>`awardEmoji` | [`Boolean!`](#boolean) | Indicates the user can perform `award_emoji` on this resource. |
| <a id="epicpermissionscreateepic"></a>`createEpic` | [`Boolean!`](#boolean) | Indicates the user can perform `create_epic` on this resource. |
| <a id="epicpermissionscreatenote"></a>`createNote` | [`Boolean!`](#boolean) | Indicates the user can perform `create_note` on this resource. |
| <a id="epicpermissionsdestroyepic"></a>`destroyEpic` | [`Boolean!`](#boolean) | Indicates the user can perform `destroy_epic` on this resource. |
| <a id="epicpermissionsreadepic"></a>`readEpic` | [`Boolean!`](#boolean) | Indicates the user can perform `read_epic` on this resource. |
| <a id="epicpermissionsreadepiciid"></a>`readEpicIid` | [`Boolean!`](#boolean) | Indicates the user can perform `read_epic_iid` on this resource. |
| <a id="epicpermissionsupdateepic"></a>`updateEpic` | [`Boolean!`](#boolean) | Indicates the user can perform `update_epic` on this resource. |

### `EscalationPolicyType`

Represents an escalation policy.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="escalationpolicytypedescription"></a>`description` | [`String`](#string) | Description of the escalation policy. |
| <a id="escalationpolicytypeid"></a>`id` | [`IncidentManagementEscalationPolicyID`](#incidentmanagementescalationpolicyid) | ID of the escalation policy. |
| <a id="escalationpolicytypename"></a>`name` | [`String`](#string) | Name of the escalation policy. |
| <a id="escalationpolicytyperules"></a>`rules` | [`[EscalationRuleType!]`](#escalationruletype) | Steps of the escalation policy. |

### `EscalationRuleType`

Represents an escalation rule for an escalation policy.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="escalationruletypeelapsedtimeseconds"></a>`elapsedTimeSeconds` | [`Int`](#int) | Time in seconds before the rule is activated. |
| <a id="escalationruletypeid"></a>`id` | [`IncidentManagementEscalationRuleID`](#incidentmanagementescalationruleid) | ID of the escalation policy. |
| <a id="escalationruletypeoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule to notify. |
| <a id="escalationruletypestatus"></a>`status` | [`EscalationRuleStatus`](#escalationrulestatus) | Status required to prevent the rule from activating. |
| <a id="escalationruletypeuser"></a>`user` | [`UserCore`](#usercore) | User to notify. |

### `Event`

Representing an event.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="eventaction"></a>`action` | [`EventAction!`](#eventaction) | Action of the event. |
| <a id="eventauthor"></a>`author` | [`UserCore!`](#usercore) | Author of this event. |
| <a id="eventcreatedat"></a>`createdAt` | [`Time!`](#time) | When this event was created. |
| <a id="eventid"></a>`id` | [`ID!`](#id) | ID of the event. |
| <a id="eventupdatedat"></a>`updatedAt` | [`Time!`](#time) | When this event was updated. |

### `ExternalAuditEventDestination`

Represents an external resource to send audit events to.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalauditeventdestinationdestinationurl"></a>`destinationUrl` | [`String!`](#string) | External destination to send audit events to. |
| <a id="externalauditeventdestinationeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters added for streaming. |
| <a id="externalauditeventdestinationgroup"></a>`group` | [`Group!`](#group) | Group the destination belongs to. |
| <a id="externalauditeventdestinationheaders"></a>`headers` | [`AuditEventStreamingHeaderConnection!`](#auditeventstreamingheaderconnection) | List of additional HTTP headers sent with each event. (see [Connections](#connections)) |
| <a id="externalauditeventdestinationid"></a>`id` | [`ID!`](#id) | ID of the destination. |
| <a id="externalauditeventdestinationverificationtoken"></a>`verificationToken` | [`String!`](#string) | Verification token to validate source of event. |

### `ExternalIssue`

Represents an external issue.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalissuecreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of when the issue was created. |
| <a id="externalissueexternaltracker"></a>`externalTracker` | [`String`](#string) | Type of external tracker. |
| <a id="externalissuerelativereference"></a>`relativeReference` | [`String`](#string) | Relative reference of the issue in the external tracker. |
| <a id="externalissuestatus"></a>`status` | [`String`](#string) | Status of the issue in the external tracker. |
| <a id="externalissuetitle"></a>`title` | [`String`](#string) | Title of the issue in the external tracker. |
| <a id="externalissueupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp of when the issue was updated. |
| <a id="externalissueweburl"></a>`webUrl` | [`String`](#string) | URL to the issue in the external tracker. |

### `ExternalStatusCheck`

Describes an external status check.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalstatuscheckexternalurl"></a>`externalUrl` | [`String!`](#string) | External URL for the status check. |
| <a id="externalstatuscheckid"></a>`id` | [`GlobalID!`](#globalid) | ID of the rule. |
| <a id="externalstatuscheckname"></a>`name` | [`String!`](#string) | Name of the rule. |

### `FileUpload`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="fileuploadid"></a>`id` | [`UploadID!`](#uploadid) | Global ID of the upload. |
| <a id="fileuploadpath"></a>`path` | [`String!`](#string) | Path of the upload. |
| <a id="fileuploadsize"></a>`size` | [`Int!`](#int) | Size of the upload in bytes. |

### `Forecast`

Information about specific forecast created.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="forecaststatus"></a>`status` | [`ForecastStatus!`](#forecaststatus) | Status of the forecast. |
| <a id="forecastvalues"></a>`values` | [`ForecastDatapointConnection`](#forecastdatapointconnection) | Actual forecast values. (see [Connections](#connections)) |

### `ForecastDatapoint`

Information about specific forecast datapoint.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="forecastdatapointdatapoint"></a>`datapoint` | [`String!`](#string) | Datapoint of the forecast. Usually a date. |
| <a id="forecastdatapointvalue"></a>`value` | [`Float`](#float) | Value of the given datapoint. |

### `ForkDetails`

Details of the fork project compared to its upstream project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="forkdetailsahead"></a>`ahead` | [`Int`](#int) | Number of commits ahead of upstream. |
| <a id="forkdetailsbehind"></a>`behind` | [`Int`](#int) | Number of commits behind upstream. |
| <a id="forkdetailshasconflicts"></a>`hasConflicts` | [`Boolean`](#boolean) | Indicates if the fork conflicts with its upstream project. |
| <a id="forkdetailsissyncing"></a>`isSyncing` | [`Boolean`](#boolean) | Indicates if there is a synchronization in progress. |

### `GeoNode`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodecontainerrepositoriesmaxcapacity"></a>`containerRepositoriesMaxCapacity` | [`Int`](#int) | Maximum concurrency of container repository sync for this secondary node. |
| <a id="geonodeenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether this Geo node is enabled. |
| <a id="geonodefilesmaxcapacity"></a>`filesMaxCapacity` | [`Int`](#int) | Maximum concurrency of LFS/attachment backfill for this secondary node. |
| <a id="geonodeid"></a>`id` | [`ID!`](#id) | ID of this GeoNode. |
| <a id="geonodeinternalurl"></a>`internalUrl` | [`String`](#string) | URL defined on the primary node secondary nodes should use to contact it. |
| <a id="geonodeminimumreverificationinterval"></a>`minimumReverificationInterval` | [`Int`](#int) | Interval (in days) in which the repository verification is valid. After expiry, it is reverted. |
| <a id="geonodename"></a>`name` | [`String`](#string) | Unique identifier for this Geo node. |
| <a id="geonodeprimary"></a>`primary` | [`Boolean`](#boolean) | Indicates whether this Geo node is the primary. |
| <a id="geonodereposmaxcapacity"></a>`reposMaxCapacity` | [`Int`](#int) | Maximum concurrency of repository backfill for this secondary node. |
| <a id="geonodeselectivesyncnamespaces"></a>`selectiveSyncNamespaces` | [`NamespaceConnection`](#namespaceconnection) | Namespaces that should be synced, if `selective_sync_type` == `namespaces`. (see [Connections](#connections)) |
| <a id="geonodeselectivesyncshards"></a>`selectiveSyncShards` | [`[String!]`](#string) | Repository storages whose projects should be synced, if `selective_sync_type` == `shards`. |
| <a id="geonodeselectivesynctype"></a>`selectiveSyncType` | [`String`](#string) | Indicates if syncing is limited to only specific groups, or shards. |
| <a id="geonodesyncobjectstorage"></a>`syncObjectStorage` | [`Boolean`](#boolean) | Indicates if this secondary node will replicate blobs in Object Storage. |
| <a id="geonodeurl"></a>`url` | [`String`](#string) | User-facing URL for this Geo node. |
| <a id="geonodeverificationmaxcapacity"></a>`verificationMaxCapacity` | [`Int`](#int) | Maximum concurrency of repository verification for this secondary node. |

#### Fields with arguments

##### `GeoNode.ciSecureFileRegistries`

Find Ci Secure File registries on this Geo node.

Returns [`CiSecureFileRegistryConnection`](#cisecurefileregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodecisecurefileregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodecisecurefileregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodecisecurefileregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodecisecurefileregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.containerRepositoryRegistries`

Find Container Repository registries on this Geo node.

Returns [`ContainerRepositoryRegistryConnection`](#containerrepositoryregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodecontainerrepositoryregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodecontainerrepositoryregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodecontainerrepositoryregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodecontainerrepositoryregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.dependencyProxyBlobRegistries`

Find Dependency Proxy Blob registries on this Geo node.

WARNING:
**Introduced** in 15.6.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`DependencyProxyBlobRegistryConnection`](#dependencyproxyblobregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodedependencyproxyblobregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodedependencyproxyblobregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodedependencyproxyblobregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodedependencyproxyblobregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.dependencyProxyManifestRegistries`

Find Dependency Proxy Manifest registries on this Geo node.

Returns [`DependencyProxyManifestRegistryConnection`](#dependencyproxymanifestregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodedependencyproxymanifestregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodedependencyproxymanifestregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodedependencyproxymanifestregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodedependencyproxymanifestregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.designManagementRepositoryRegistries`

Find Design Repository registries on this Geo node. Ignored if `geo_design_management_repository_replication` feature flag is disabled.

WARNING:
**Introduced** in 16.1.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`DesignManagementRepositoryRegistryConnection`](#designmanagementrepositoryregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodedesignmanagementrepositoryregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodedesignmanagementrepositoryregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodedesignmanagementrepositoryregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodedesignmanagementrepositoryregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.groupWikiRepositoryRegistries`

Find group wiki repository registries on this Geo node.

Returns [`GroupWikiRepositoryRegistryConnection`](#groupwikirepositoryregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodegroupwikirepositoryregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodegroupwikirepositoryregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodegroupwikirepositoryregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodegroupwikirepositoryregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.jobArtifactRegistries`

Find Job Artifact registries on this Geo node.

Returns [`JobArtifactRegistryConnection`](#jobartifactregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodejobartifactregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodejobartifactregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodejobartifactregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodejobartifactregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.lfsObjectRegistries`

Find LFS object registries on this Geo node.

Returns [`LfsObjectRegistryConnection`](#lfsobjectregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodelfsobjectregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodelfsobjectregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodelfsobjectregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodelfsobjectregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.mergeRequestDiffRegistries`

Find merge request diff registries on this Geo node.

Returns [`MergeRequestDiffRegistryConnection`](#mergerequestdiffregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodemergerequestdiffregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodemergerequestdiffregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodemergerequestdiffregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodemergerequestdiffregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.packageFileRegistries`

Package file registries of the GeoNode.

Returns [`PackageFileRegistryConnection`](#packagefileregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodepackagefileregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodepackagefileregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodepackagefileregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodepackagefileregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.pagesDeploymentRegistries`

Find Pages Deployment registries on this Geo node.

Returns [`PagesDeploymentRegistryConnection`](#pagesdeploymentregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodepagesdeploymentregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodepagesdeploymentregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodepagesdeploymentregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodepagesdeploymentregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.pipelineArtifactRegistries`

Find pipeline artifact registries on this Geo node.

Returns [`PipelineArtifactRegistryConnection`](#pipelineartifactregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodepipelineartifactregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodepipelineartifactregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodepipelineartifactregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodepipelineartifactregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.projectWikiRepositoryRegistries`

Find Project Wiki Repository registries on this Geo node. Ignored if `geo_project_wiki_repository_replication` feature flag is disabled.

Returns [`ProjectWikiRepositoryRegistryConnection`](#projectwikirepositoryregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodeprojectwikirepositoryregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodeprojectwikirepositoryregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodeprojectwikirepositoryregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodeprojectwikirepositoryregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.snippetRepositoryRegistries`

Find snippet repository registries on this Geo node.

Returns [`SnippetRepositoryRegistryConnection`](#snippetrepositoryregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodesnippetrepositoryregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodesnippetrepositoryregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodesnippetrepositoryregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodesnippetrepositoryregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.terraformStateVersionRegistries`

Find terraform state version registries on this Geo node.

Returns [`TerraformStateVersionRegistryConnection`](#terraformstateversionregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodeterraformstateversionregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodeterraformstateversionregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodeterraformstateversionregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodeterraformstateversionregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

##### `GeoNode.uploadRegistries`

Find Upload registries on this Geo node.

Returns [`UploadRegistryConnection`](#uploadregistryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="geonodeuploadregistriesids"></a>`ids` | [`[ID!]`](#id) | Filters registries by their ID. |
| <a id="geonodeuploadregistrieskeyword"></a>`keyword` | [`String`](#string) | Filters registries by their attributes using a keyword. |
| <a id="geonodeuploadregistriesreplicationstate"></a>`replicationState` | [`ReplicationStateEnum`](#replicationstateenum) | Filters registries by their replication state. |
| <a id="geonodeuploadregistriesverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Filters registries by their verification state. |

### `GoogleCloudLoggingConfigurationType`

Stores Google Cloud Logging configurations associated with IAM service accounts,used for generating access tokens.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="googlecloudloggingconfigurationtypeclientemail"></a>`clientEmail` | [`String!`](#string) | Client email. |
| <a id="googlecloudloggingconfigurationtypegoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | Google project ID. |
| <a id="googlecloudloggingconfigurationtypegroup"></a>`group` | [`Group!`](#group) | Group the configuration belongs to. |
| <a id="googlecloudloggingconfigurationtypeid"></a>`id` | [`ID!`](#id) | ID of the configuration. |
| <a id="googlecloudloggingconfigurationtypelogidname"></a>`logIdName` | [`String!`](#string) | Log ID. |
| <a id="googlecloudloggingconfigurationtypeprivatekey"></a>`privateKey` | [`String!`](#string) | Private key. |

### `GpgSignature`

GPG signature for a signed commit.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="gpgsignaturecommitsha"></a>`commitSha` | [`String`](#string) | SHA of the associated commit. |
| <a id="gpgsignaturegpgkeyprimarykeyid"></a>`gpgKeyPrimaryKeyid` | [`String`](#string) | ID of the GPG key. |
| <a id="gpgsignaturegpgkeyuseremail"></a>`gpgKeyUserEmail` | [`String`](#string) | User email associated with the GPG key. |
| <a id="gpgsignaturegpgkeyusername"></a>`gpgKeyUserName` | [`String`](#string) | User name associated with the GPG key. |
| <a id="gpgsignatureproject"></a>`project` | [`Project`](#project) | Project of the associated commit. |
| <a id="gpgsignatureuser"></a>`user` | [`UserCore`](#usercore) | User associated with the key. |
| <a id="gpgsignatureverificationstatus"></a>`verificationStatus` | [`VerificationStatus`](#verificationstatus) | Indicates verification status of the associated key or certificate. |

### `GrafanaIntegration`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="grafanaintegrationcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of the issue's creation. |
| <a id="grafanaintegrationenabled"></a>`enabled` | [`Boolean!`](#boolean) | Indicates whether Grafana integration is enabled. |
| <a id="grafanaintegrationgrafanaurl"></a>`grafanaUrl` | [`String!`](#string) | URL for the Grafana host for the Grafana integration. |
| <a id="grafanaintegrationid"></a>`id` | [`ID!`](#id) | Internal ID of the Grafana integration. |
| <a id="grafanaintegrationupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of the issue's last activity. |

### `Group`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupactualrepositorysizelimit"></a>`actualRepositorySizeLimit` | [`Float`](#float) | Size limit for repositories in the namespace in bytes. |
| <a id="groupadditionalpurchasedstoragesize"></a>`additionalPurchasedStorageSize` | [`Float`](#float) | Additional storage purchased for the root namespace in bytes. |
| <a id="groupallowstalerunnerpruning"></a>`allowStaleRunnerPruning` | [`Boolean!`](#boolean) | Indicates whether to regularly prune stale group runners. Defaults to false. |
| <a id="groupautodevopsenabled"></a>`autoDevopsEnabled` | [`Boolean`](#boolean) | Indicates whether Auto DevOps is enabled for all projects within this group. |
| <a id="groupavatarurl"></a>`avatarUrl` | [`String`](#string) | Avatar URL of the group. |
| <a id="groupcontainerrepositoriescount"></a>`containerRepositoriesCount` | [`Int!`](#int) | Number of container repositories in the group. |
| <a id="groupcontainslockedprojects"></a>`containsLockedProjects` | [`Boolean!`](#boolean) | Includes at least one project where the repository size exceeds the limit. |
| <a id="groupcrossprojectpipelineavailable"></a>`crossProjectPipelineAvailable` | [`Boolean!`](#boolean) | Indicates if the cross_project_pipeline feature is available for the namespace. |
| <a id="groupcustomemoji"></a>`customEmoji` **{warning-solid}** | [`CustomEmojiConnection`](#customemojiconnection) | **Introduced** in 13.6. This feature is an Experiment. It can be changed or removed at any time. Custom emoji within this namespace. |
| <a id="groupdependencyproxyblobcount"></a>`dependencyProxyBlobCount` | [`Int!`](#int) | Number of dependency proxy blobs cached in the group. |
| <a id="groupdependencyproxyblobs"></a>`dependencyProxyBlobs` | [`DependencyProxyBlobConnection`](#dependencyproxyblobconnection) | Dependency Proxy blobs. (see [Connections](#connections)) |
| <a id="groupdependencyproxyimagecount"></a>`dependencyProxyImageCount` | [`Int!`](#int) | Number of dependency proxy images cached in the group. |
| <a id="groupdependencyproxyimageprefix"></a>`dependencyProxyImagePrefix` | [`String!`](#string) | Prefix for pulling images when using the dependency proxy. |
| <a id="groupdependencyproxyimagettlpolicy"></a>`dependencyProxyImageTtlPolicy` | [`DependencyProxyImageTtlGroupPolicy`](#dependencyproxyimagettlgrouppolicy) | Dependency proxy TTL policy for the group. |
| <a id="groupdependencyproxymanifests"></a>`dependencyProxyManifests` | [`DependencyProxyManifestConnection`](#dependencyproxymanifestconnection) | Dependency Proxy manifests. (see [Connections](#connections)) |
| <a id="groupdependencyproxysetting"></a>`dependencyProxySetting` | [`DependencyProxySetting`](#dependencyproxysetting) | Dependency Proxy settings for the group. |
| <a id="groupdependencyproxytotalsize"></a>`dependencyProxyTotalSize` | [`String!`](#string) | Total size of the dependency proxy cached images. |
| <a id="groupdependencyproxytotalsizeinbytes"></a>`dependencyProxyTotalSizeInBytes` | [`Int!`](#int) | Total size of the dependency proxy cached images in bytes. |
| <a id="groupdescription"></a>`description` | [`String`](#string) | Description of the namespace. |
| <a id="groupdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="groupdora"></a>`dora` | [`Dora`](#dora) | Group's DORA metrics. |
| <a id="groupemailsdisabled"></a>`emailsDisabled` | [`Boolean`](#boolean) | Indicates if a group has email notifications disabled. |
| <a id="groupenforcefreeusercap"></a>`enforceFreeUserCap` | [`Boolean`](#boolean) | Indicates whether the group has limited users for a free plan. |
| <a id="groupepicboards"></a>`epicBoards` | [`EpicBoardConnection`](#epicboardconnection) | Find epic boards. (see [Connections](#connections)) |
| <a id="groupepicsenabled"></a>`epicsEnabled` | [`Boolean`](#boolean) | Indicates if Epics are enabled for namespace. |
| <a id="groupexternalauditeventdestinations"></a>`externalAuditEventDestinations` | [`ExternalAuditEventDestinationConnection`](#externalauditeventdestinationconnection) | External locations that receive audit events belonging to the group. (see [Connections](#connections)) |
| <a id="groupflowmetrics"></a>`flowMetrics` **{warning-solid}** | [`GroupValueStreamAnalyticsFlowMetrics`](#groupvaluestreamanalyticsflowmetrics) | **Introduced** in 15.10. This feature is an Experiment. It can be changed or removed at any time. Flow metrics for value stream analytics. |
| <a id="groupfullname"></a>`fullName` | [`String!`](#string) | Full name of the namespace. |
| <a id="groupfullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the namespace. |
| <a id="groupid"></a>`id` | [`ID!`](#id) | ID of the namespace. |
| <a id="groupistemporarystorageincreaseenabled"></a>`isTemporaryStorageIncreaseEnabled` | [`Boolean!`](#boolean) | Status of the temporary storage increase. |
| <a id="grouplfsenabled"></a>`lfsEnabled` | [`Boolean`](#boolean) | Indicates if Large File Storage (LFS) is enabled for namespace. |
| <a id="groupmentionsdisabled"></a>`mentionsDisabled` | [`Boolean`](#boolean) | Indicates if a group is disabled from getting mentioned. |
| <a id="groupname"></a>`name` | [`String!`](#string) | Name of the namespace. |
| <a id="grouppackagesettings"></a>`packageSettings` | [`PackageSettings`](#packagesettings) | Package settings for the namespace. |
| <a id="groupparent"></a>`parent` | [`Group`](#group) | Parent group. |
| <a id="grouppath"></a>`path` | [`String!`](#string) | Path of the namespace. |
| <a id="groupprojectcreationlevel"></a>`projectCreationLevel` | [`String`](#string) | Permission level required to create projects in the group. |
| <a id="grouprecentissueboards"></a>`recentIssueBoards` | [`BoardConnection`](#boardconnection) | List of recently visited boards of the group. Maximum size is 4. (see [Connections](#connections)) |
| <a id="grouprepositorysizeexcessprojectcount"></a>`repositorySizeExcessProjectCount` | [`Int!`](#int) | Number of projects in the root namespace where the repository size exceeds the limit. |
| <a id="grouprequestaccessenabled"></a>`requestAccessEnabled` | [`Boolean`](#boolean) | Indicates if users can request access to namespace. |
| <a id="grouprequiretwofactorauthentication"></a>`requireTwoFactorAuthentication` | [`Boolean`](#boolean) | Indicates if all users in this group are required to set up two-factor authentication. |
| <a id="grouprootstoragestatistics"></a>`rootStorageStatistics` | [`RootStorageStatistics`](#rootstoragestatistics) | Aggregated storage statistics of the namespace. Only available for root namespaces. |
| <a id="groupsharewithgrouplock"></a>`shareWithGroupLock` | [`Boolean`](#boolean) | Indicates if sharing a project with another group within this group is prevented. |
| <a id="groupsharedrunnerssetting"></a>`sharedRunnersSetting` | [`SharedRunnersSetting`](#sharedrunnerssetting) | Shared runners availability for the namespace and its descendants. |
| <a id="groupstats"></a>`stats` | [`GroupStats`](#groupstats) | Group statistics. |
| <a id="groupstoragesizelimit"></a>`storageSizeLimit` | [`Float`](#float) | Total storage limit of the root namespace in bytes. |
| <a id="groupsubgroupcreationlevel"></a>`subgroupCreationLevel` | [`String`](#string) | Permission level required to create subgroups within the group. |
| <a id="grouptemporarystorageincreaseendson"></a>`temporaryStorageIncreaseEndsOn` | [`Time`](#time) | Date until the temporary storage increase is active. |
| <a id="grouptimelogcategories"></a>`timelogCategories` **{warning-solid}** | [`TimeTrackingTimelogCategoryConnection`](#timetrackingtimelogcategoryconnection) | **Introduced** in 15.3. This feature is an Experiment. It can be changed or removed at any time. Timelog categories for the namespace. |
| <a id="grouptotalrepositorysize"></a>`totalRepositorySize` | [`Float`](#float) | Total repository size of all projects in the root namespace in bytes. |
| <a id="grouptotalrepositorysizeexcess"></a>`totalRepositorySizeExcess` | [`Float`](#float) | Total excess repository size of all projects in the root namespace in bytes. |
| <a id="grouptwofactorgraceperiod"></a>`twoFactorGracePeriod` | [`Int`](#int) | Time before two-factor authentication is enforced. |
| <a id="groupuserpermissions"></a>`userPermissions` | [`GroupPermissions!`](#grouppermissions) | Permissions for the current user on the resource. |
| <a id="groupvisibility"></a>`visibility` | [`String`](#string) | Visibility of the namespace. |
| <a id="groupvulnerabilityscanners"></a>`vulnerabilityScanners` | [`VulnerabilityScannerConnection`](#vulnerabilityscannerconnection) | Vulnerability scanners reported on the project vulnerabilities of the group and its subgroups. (see [Connections](#connections)) |
| <a id="groupweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the group. |

#### Fields with arguments

##### `Group.achievements`

Achievements for the namespace. Returns `null` if the `achievements` feature flag is disabled.

WARNING:
**Introduced** in 15.8.
This feature is an Experiment. It can be changed or removed at any time.

Returns [`AchievementConnection`](#achievementconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupachievementsids"></a>`ids` | [`[AchievementsAchievementID!]`](#achievementsachievementid) | Filter achievements by IDs. |

##### `Group.billableMembersCount`

Number of billable users in the group.

Returns [`Int`](#int).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupbillablememberscountrequestedhostedplan"></a>`requestedHostedPlan` | [`String`](#string) | Plan from which to get billable members. |

##### `Group.board`

A single board of the group.

Returns [`Board`](#board).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupboardid"></a>`id` | [`BoardID!`](#boardid) | ID of the board. |

##### `Group.boards`

Boards of the group.

Returns [`BoardConnection`](#boardconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupboardsid"></a>`id` | [`BoardID`](#boardid) | Find a board by its ID. |

##### `Group.ciVariables`

List of the group's CI/CD variables.

Returns [`CiGroupVariableConnection`](#cigroupvariableconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupcivariablessort"></a>`sort` | [`CiVariableSort`](#civariablesort) | Sort order of results. |

##### `Group.clusterAgents`

Cluster agents associated with projects in the group and its subgroups.

Returns [`ClusterAgentConnection`](#clusteragentconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupclusteragentshasremotedevelopmentagentconfig"></a>`hasRemoteDevelopmentAgentConfig` | [`Boolean`](#boolean) | Returns only cluster agents which have an associated remote development agent config. |
| <a id="groupclusteragentshasvulnerabilities"></a>`hasVulnerabilities` | [`Boolean`](#boolean) | Returns only cluster agents which have vulnerabilities. |

##### `Group.codeCoverageActivities`

Represents the code coverage activity for this group.

Returns [`CodeCoverageActivityConnection`](#codecoverageactivityconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupcodecoverageactivitiesstartdate"></a>`startDate` | [`Date!`](#date) | First day for which to fetch code coverage activity (maximum time window is set to 90 days). |

##### `Group.complianceFrameworks`

Compliance frameworks available to projects in this namespace.

Returns [`ComplianceFrameworkConnection`](#complianceframeworkconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupcomplianceframeworksid"></a>`id` | [`ComplianceManagementFrameworkID`](#compliancemanagementframeworkid) | Global ID of a specific compliance framework to return. |

##### `Group.contactStateCounts`

Counts of contacts by state for the group.

Returns [`ContactStateCounts`](#contactstatecounts).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupcontactstatecountssearch"></a>`search` | [`String`](#string) | Search term to find contacts with. |
| <a id="groupcontactstatecountsstate"></a>`state` | [`CustomerRelationsContactState`](#customerrelationscontactstate) | State of the contacts to search for. |

##### `Group.contacts`

Find contacts of this group.

Returns [`CustomerRelationsContactConnection`](#customerrelationscontactconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupcontactsids"></a>`ids` | [`[CustomerRelationsContactID!]`](#customerrelationscontactid) | Filter contacts by IDs. |
| <a id="groupcontactssearch"></a>`search` | [`String`](#string) | Search term to find contacts with. |
| <a id="groupcontactssort"></a>`sort` | [`ContactSort`](#contactsort) | Criteria to sort contacts by. |
| <a id="groupcontactsstate"></a>`state` | [`CustomerRelationsContactState`](#customerrelationscontactstate) | State of the contacts to search for. |

##### `Group.containerRepositories`

Container repositories of the group.

Returns [`ContainerRepositoryConnection`](#containerrepositoryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupcontainerrepositoriesname"></a>`name` | [`String`](#string) | Filter the container repositories by their name. |
| <a id="groupcontainerrepositoriessort"></a>`sort` | [`ContainerRepositorySort`](#containerrepositorysort) | Sort container repositories by this criteria. |

##### `Group.contributions`

Provides the aggregated contributions by users within the group and its subgroups.

Returns [`ContributionAnalyticsContributionConnection`](#contributionanalyticscontributionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupcontributionsfrom"></a>`from` | [`ISO8601Date!`](#iso8601date) | Start date of the reporting time range. |
| <a id="groupcontributionsto"></a>`to` | [`ISO8601Date!`](#iso8601date) | End date of the reporting time range. The end date must be within 93 days after the start date. |

##### `Group.dataTransfer`

Data transfer data point for a specific period. This is mocked data under a development feature flag.

Returns [`GroupDataTransfer`](#groupdatatransfer).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupdatatransferfrom"></a>`from` | [`Date`](#date) | Retain egress data for one year. Data for the current month will increase dynamically as egress occurs. |
| <a id="groupdatatransferto"></a>`to` | [`Date`](#date) | End date for the data. |

##### `Group.descendantGroups`

List of descendant groups of this group.

Returns [`GroupConnection`](#groupconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupdescendantgroupsincludeparentdescendants"></a>`includeParentDescendants` | [`Boolean`](#boolean) | List of descendant groups of the parent group. |
| <a id="groupdescendantgroupsowned"></a>`owned` | [`Boolean`](#boolean) | Limit result to groups owned by authenticated user. |
| <a id="groupdescendantgroupssearch"></a>`search` | [`String`](#string) | Search query for group name or group full path. |

##### `Group.epic`

Find a single epic.

Returns [`Epic`](#epic).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupepicauthorusername"></a>`authorUsername` | [`String`](#string) | Filter epics by author. |
| <a id="groupepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter epics by given confidentiality. |
| <a id="groupepiccreatedafter"></a>`createdAfter` | [`Time`](#time) | Epics created after this date. |
| <a id="groupepiccreatedbefore"></a>`createdBefore` | [`Time`](#time) | Epics created before this date. |
| <a id="groupepiciid"></a>`iid` | [`ID`](#id) | IID of the epic, e.g., "1". |
| <a id="groupepiciidstartswith"></a>`iidStartsWith` | [`String`](#string) | Filter epics by IID for autocomplete. |
| <a id="groupepiciids"></a>`iids` | [`[ID!]`](#id) | List of IIDs of epics, e.g., `[1, 2]`. |
| <a id="groupepicin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="groupepicincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Include epics from ancestor groups. |
| <a id="groupepicincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | Include epics from descendant groups. |
| <a id="groupepiclabelname"></a>`labelName` | [`[String!]`](#string) | Filter epics by labels. |
| <a id="groupepicmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Filter epics by milestone title, computed from epic's issues. |
| <a id="groupepicmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. |
| <a id="groupepicnot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | Negated epic arguments. |
| <a id="groupepicor"></a>`or` **{warning-solid}** | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | **Introduced** in 15.9. This feature is an Experiment. It can be changed or removed at any time. List of arguments with inclusive OR. Ignored unless `or_issuable_queries` flag is enabled. |
| <a id="groupepicsearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="groupepicsort"></a>`sort` | [`EpicSort`](#epicsort) | List epics by sort order. |
| <a id="groupepicstate"></a>`state` | [`EpicState`](#epicstate) | Filter epics by state. |
| <a id="groupepictimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="groupepictoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | Filter epics with a top-level hierarchy. |
| <a id="groupepicupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Epics updated after this date. |
| <a id="groupepicupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Epics updated before this date. |

##### `Group.epicBoard`

Find a single epic board.

Returns [`EpicBoard`](#epicboard).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupepicboardid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Find an epic board by ID. |

##### `Group.epics`

Find epics.

Returns [`EpicConnection`](#epicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupepicsauthorusername"></a>`authorUsername` | [`String`](#string) | Filter epics by author. |
| <a id="groupepicsconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter epics by given confidentiality. |
| <a id="groupepicscreatedafter"></a>`createdAfter` | [`Time`](#time) | Epics created after this date. |
| <a id="groupepicscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Epics created before this date. |
| <a id="groupepicsiid"></a>`iid` | [`ID`](#id) | IID of the epic, e.g., "1". |
| <a id="groupepicsiidstartswith"></a>`iidStartsWith` | [`String`](#string) | Filter epics by IID for autocomplete. |
| <a id="groupepicsiids"></a>`iids` | [`[ID!]`](#id) | List of IIDs of epics, e.g., `[1, 2]`. |
| <a id="groupepicsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="groupepicsincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Include epics from ancestor groups. |
| <a id="groupepicsincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | Include epics from descendant groups. |
| <a id="groupepicslabelname"></a>`labelName` | [`[String!]`](#string) | Filter epics by labels. |
| <a id="groupepicsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Filter epics by milestone title, computed from epic's issues. |
| <a id="groupepicsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. |
| <a id="groupepicsnot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | Negated epic arguments. |
| <a id="groupepicsor"></a>`or` **{warning-solid}** | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | **Introduced** in 15.9. This feature is an Experiment. It can be changed or removed at any time. List of arguments with inclusive OR. Ignored unless `or_issuable_queries` flag is enabled. |
| <a id="groupepicssearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="groupepicssort"></a>`sort` | [`EpicSort`](#epicsort) | List epics by sort order. |
| <a id="groupepicsstate"></a>`state` | [`EpicState`](#epicstate) | Filter epics by state. |
| <a id="groupepicstimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="groupepicstoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | Filter epics with a top-level hierarchy. |
| <a id="groupepicsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Epics updated after this date. |
| <a id="groupepicsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Epics updated before this date. |

##### `Group.gitlabSubscriptionsPreviewBillableUserChange`

Preview Billable User Changes.

Returns [`PreviewBillableUserChange`](#previewbillableuserchange).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupgitlabsubscriptionspreviewbillableuserchangeaddgroupid"></a>`addGroupId` | [`Int`](#int) | Group ID to add. |
| <a id="groupgitlabsubscriptionspreviewbillableuserchangeadduseremails"></a>`addUserEmails` | [`[String!]`](#string) | User emails to add. |
| <a id="groupgitlabsubscriptionspreviewbillableuserchangeadduserids"></a>`addUserIds` | [`[Int!]`](#int) | User IDs to add. |
| <a id="groupgitlabsubscriptionspreviewbillableuserchangerole"></a>`role` | [`GitlabSubscriptionsUserRole!`](#gitlabsubscriptionsuserrole) | Role of users being added to group. |

##### `Group.groupMembers`

A membership of a user within this group.

Returns [`GroupMemberConnection`](#groupmemberconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupgroupmembersaccesslevels"></a>`accessLevels` | [`[AccessLevelEnum!]`](#accesslevelenum) | Filter members by the given access levels. |
| <a id="groupgroupmembersrelations"></a>`relations` | [`[GroupMemberRelation!]`](#groupmemberrelation) | Filter members by the given member relations. |
| <a id="groupgroupmemberssearch"></a>`search` | [`String`](#string) | Search query. |
| <a id="groupgroupmemberssort"></a>`sort` | [`MemberSort`](#membersort) | sort query. |

##### `Group.issues`

Issues for projects in this group.

Returns [`IssueConnection`](#issueconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupissuesassigneeid"></a>`assigneeId` | [`String`](#string) | ID of a user assigned to the issues. Wildcard values "NONE" and "ANY" are supported. |
| <a id="groupissuesassigneeusername"></a>`assigneeUsername` **{warning-solid}** | [`String`](#string) | **Deprecated** in 13.11. Use `assigneeUsernames`. |
| <a id="groupissuesassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the issue. |
| <a id="groupissuesauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author of the issue. |
| <a id="groupissuesclosedafter"></a>`closedAfter` | [`Time`](#time) | Issues closed after this date. |
| <a id="groupissuesclosedbefore"></a>`closedBefore` | [`Time`](#time) | Issues closed before this date. |
| <a id="groupissuesconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter for confidential issues. If "false", excludes confidential issues. If "true", returns only confidential issues. |
| <a id="groupissuescreatedafter"></a>`createdAfter` | [`Time`](#time) | Issues created after this date. |
| <a id="groupissuescreatedbefore"></a>`createdBefore` | [`Time`](#time) | Issues created before this date. |
| <a id="groupissuescrmcontactid"></a>`crmContactId` | [`String`](#string) | ID of a contact assigned to the issues. |
| <a id="groupissuescrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | ID of an organization assigned to the issues. |
| <a id="groupissuesepicid"></a>`epicId` | [`String`](#string) | ID of an epic associated with the issues, "none" and "any" values are supported. |
| <a id="groupissueshealthstatus"></a>`healthStatus` **{warning-solid}** | [`HealthStatus`](#healthstatus) | **Deprecated** in 15.4. Use `healthStatusFilter`. |
| <a id="groupissueshealthstatusfilter"></a>`healthStatusFilter` | [`HealthStatusFilter`](#healthstatusfilter) | Health status of the issue, "none" and "any" values are supported. |
| <a id="groupissuesiid"></a>`iid` | [`String`](#string) | IID of the issue. For example, "1". |
| <a id="groupissuesiids"></a>`iids` | [`[String!]`](#string) | List of IIDs of issues. For example, `["1", "2"]`. |
| <a id="groupissuesin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="groupissuesincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | Return issues from archived projects. |
| <a id="groupissuesincludesubepics"></a>`includeSubepics` | [`Boolean`](#boolean) | Whether to include subepics when filtering issues by epicId. |
| <a id="groupissuesincludesubgroups"></a>`includeSubgroups` | [`Boolean`](#boolean) | Include issues belonging to subgroups. |
| <a id="groupissuesiterationid"></a>`iterationId` | [`[ID]`](#id) | List of iteration Global IDs applied to the issue. |
| <a id="groupissuesiterationwildcardid"></a>`iterationWildcardId` | [`IterationWildcardId`](#iterationwildcardid) | Filter by iteration ID wildcard. |
| <a id="groupissueslabelname"></a>`labelName` | [`[String]`](#string) | Labels applied to this issue. |
| <a id="groupissuesmilestonetitle"></a>`milestoneTitle` | [`[String]`](#string) | Milestone applied to this issue. |
| <a id="groupissuesmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | Filter issues by milestone ID wildcard. |
| <a id="groupissuesmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. Wildcard values "NONE" and "ANY" are supported. |
| <a id="groupissuesnot"></a>`not` | [`NegatedIssueFilterInput`](#negatedissuefilterinput) | Negated arguments. |
| <a id="groupissuesor"></a>`or` | [`UnionedIssueFilterInput`](#unionedissuefilterinput) | List of arguments with inclusive OR. |
| <a id="groupissuessearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="groupissuessort"></a>`sort` | [`IssueSort`](#issuesort) | Sort issues by this criteria. |
| <a id="groupissuesstate"></a>`state` | [`IssuableState`](#issuablestate) | Current state of this issue. |
| <a id="groupissuestypes"></a>`types` | [`[IssueType!]`](#issuetype) | Filter issues by the given issue types. |
| <a id="groupissuesupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Issues updated after this date. |
| <a id="groupissuesupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Issues updated before this date. |
| <a id="groupissuesweight"></a>`weight` | [`String`](#string) | Weight applied to the issue, "none" and "any" values are supported. |

##### `Group.iterationCadences`

Find iteration cadences.

Returns [`IterationCadenceConnection`](#iterationcadenceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupiterationcadencesactive"></a>`active` | [`Boolean`](#boolean) | Whether the iteration cadence is active. |
| <a id="groupiterationcadencesautomatic"></a>`automatic` | [`Boolean`](#boolean) | Whether the iteration cadence should automatically generate upcoming iterations. |
| <a id="groupiterationcadencesdurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | Duration in weeks of the iterations within this cadence. |
| <a id="groupiterationcadencesid"></a>`id` | [`IterationsCadenceID`](#iterationscadenceid) | Global ID of the iteration cadence to look up. |
| <a id="groupiterationcadencesincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Whether to include ancestor groups to search iterations cadences in. |
| <a id="groupiterationcadencestitle"></a>`title` | [`String`](#string) | Fuzzy search by title. |

##### `Group.iterations`

Find iterations.

Returns [`IterationConnection`](#iterationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupiterationsid"></a>`id` | [`ID`](#id) | Global ID of the Iteration to look up. |
| <a id="groupiterationsiid"></a>`iid` | [`ID`](#id) | Internal ID of the Iteration to look up. |
| <a id="groupiterationsin"></a>`in` | [`[IterationSearchableField!]`](#iterationsearchablefield) | Fields in which the fuzzy-search should be performed with the query given in the argument `search`. Defaults to `[title]`. |
| <a id="groupiterationsincludeancestors"></a>`includeAncestors` | [`Boolean`](#boolean) | Whether to include ancestor iterations. Defaults to true. |
| <a id="groupiterationsiterationcadenceids"></a>`iterationCadenceIds` | [`[IterationsCadenceID!]`](#iterationscadenceid) | Global iteration cadence IDs by which to look up the iterations. |
| <a id="groupiterationssearch"></a>`search` | [`String`](#string) | Query used for fuzzy-searching in the fields selected in the argument `in`. Returns all iterations if empty. |
| <a id="groupiterationssort"></a>`sort` | [`IterationSort`](#iterationsort) | List iterations by sort order. If unspecified, an arbitrary order (subject to change) is used. |
| <a id="groupiterationsstate"></a>`state` | [`IterationState`](#iterationstate) | Filter iterations by state. |
| <a id="groupiterationstimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="groupiterationstitle"></a>`title` **{warning-solid}** | [`String`](#string) | **Deprecated** in 15.4. The argument will be removed in 15.4. Please use `search` and `in` fields instead. |

##### `Group.label`

Label available on this group.

Returns [`Label`](#label).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="grouplabeltitle"></a>`title` | [`String!`](#string) | Title of the label. |

##### `Group.labels`

Labels available on this group.

Returns [`LabelConnection`](#labelconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="grouplabelsincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Include labels from ancestor groups. |
| <a id="grouplabelsincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | Include labels from descendant groups. |
| <a id="grouplabelsonlygrouplabels"></a>`onlyGroupLabels` | [`Boolean`](#boolean) | Include only group level labels. |
| <a id="grouplabelssearchterm"></a>`searchTerm` | [`String`](#string) | Search term to find labels with. |

##### `Group.mergeRequestViolations`

Compliance violations reported on merge requests merged within the group.

Returns [`ComplianceViolationConnection`](#complianceviolationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupmergerequestviolationsfilters"></a>`filters` | [`ComplianceViolationInput`](#complianceviolationinput) | Filters applied when retrieving compliance violations. |
| <a id="groupmergerequestviolationssort"></a>`sort` | [`ComplianceViolationSort`](#complianceviolationsort) | List compliance violations by sort order. |

##### `Group.mergeRequests`

Merge requests for projects in this group.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="groupmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | Username of the assignee. |
| <a id="groupmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author. |
| <a id="groupmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="groupmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="groupmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="groupmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="groupmergerequestsincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | Return merge requests from archived projects. |
| <a id="groupmergerequestsincludesubgroups"></a>`includeSubgroups` | [`Boolean`](#boolean) | Include merge requests belonging to subgroups. |
| <a id="groupmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="groupmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="groupmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="groupmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="groupmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="groupmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="groupmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="groupmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="groupmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="groupmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="groupmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `Group.milestones`

Milestones of the group.

Returns [`MilestoneConnection`](#milestoneconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupmilestonescontainingdate"></a>`containingDate` | [`Time`](#time) | Date the milestone contains. |
| <a id="groupmilestonesids"></a>`ids` | [`[ID!]`](#id) | Array of global milestone IDs, e.g., `"gid://gitlab/Milestone/1"`. |
| <a id="groupmilestonesincludeancestors"></a>`includeAncestors` | [`Boolean`](#boolean) | Include milestones from all parent groups. |
| <a id="groupmilestonesincludedescendants"></a>`includeDescendants` | [`Boolean`](#boolean) | Include milestones from all subgroups and subprojects. |
| <a id="groupmilestonessearchtitle"></a>`searchTitle` | [`String`](#string) | Search string for the title. |
| <a id="groupmilestonessort"></a>`sort` | [`MilestoneSort`](#milestonesort) | Sort milestones by this criteria. |
| <a id="groupmilestonesstate"></a>`state` | [`MilestoneStateEnum`](#milestonestateenum) | Filter milestones by state. |
| <a id="groupmilestonestimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="groupmilestonestitle"></a>`title` | [`String`](#string) | Title of the milestone. |

##### `Group.organizationStateCounts`

Counts of organizations by status for the group.

Returns [`OrganizationStateCounts`](#organizationstatecounts).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="grouporganizationstatecountssearch"></a>`search` | [`String`](#string) | Search term to find organizations with. |
| <a id="grouporganizationstatecountsstate"></a>`state` | [`CustomerRelationsOrganizationState`](#customerrelationsorganizationstate) | State of the organizations to search for. |

##### `Group.organizations`

Find organizations of this group.

Returns [`CustomerRelationsOrganizationConnection`](#customerrelationsorganizationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="grouporganizationsids"></a>`ids` | [`[CustomerRelationsOrganizationID!]`](#customerrelationsorganizationid) | Filter organizations by IDs. |
| <a id="grouporganizationssearch"></a>`search` | [`String`](#string) | Search term used to find organizations with. |
| <a id="grouporganizationssort"></a>`sort` | [`OrganizationSort`](#organizationsort) | Criteria to sort organizations by. |
| <a id="grouporganizationsstate"></a>`state` | [`CustomerRelationsOrganizationState`](#customerrelationsorganizationstate) | State of the organization to search for. |

##### `Group.packages`

Packages of the group. This field can only be resolved for one group in any single request.

Returns [`PackageConnection`](#packageconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="grouppackagesincludeversionless"></a>`includeVersionless` | [`Boolean`](#boolean) | Include versionless packages. |
| <a id="grouppackagespackagename"></a>`packageName` | [`String`](#string) | Search a package by name. |
| <a id="grouppackagespackagetype"></a>`packageType` | [`PackageTypeEnum`](#packagetypeenum) | Filter a package by type. |
| <a id="grouppackagessort"></a>`sort` | [`PackageGroupSort`](#packagegroupsort) | Sort packages by this criteria. |
| <a id="grouppackagesstatus"></a>`status` | [`PackageStatus`](#packagestatus) | Filter a package by status. |

##### `Group.projects`

Projects within this namespace.

Returns [`ProjectConnection!`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupprojectscomplianceframeworkfilters"></a>`complianceFrameworkFilters` | [`ComplianceFrameworkFilters`](#complianceframeworkfilters) | Filters applied when selecting a compliance framework. |
| <a id="groupprojectshascodecoverage"></a>`hasCodeCoverage` | [`Boolean`](#boolean) | Returns only the projects which have code coverage. |
| <a id="groupprojectshasvulnerabilities"></a>`hasVulnerabilities` | [`Boolean`](#boolean) | Returns only the projects which have vulnerabilities. |
| <a id="groupprojectsids"></a>`ids` | [`[ID!]`](#id) | Filter projects by IDs. |
| <a id="groupprojectsincludesubgroups"></a>`includeSubgroups` | [`Boolean`](#boolean) | Include also subgroup projects. |
| <a id="groupprojectssearch"></a>`search` | [`String`](#string) | Search project with most similar names or paths. |
| <a id="groupprojectssort"></a>`sort` | [`NamespaceProjectSort`](#namespaceprojectsort) | Sort projects by this criteria. |
| <a id="groupprojectswithissuesenabled"></a>`withIssuesEnabled` | [`Boolean`](#boolean) | Return only projects with issues enabled. |
| <a id="groupprojectswithmergerequestsenabled"></a>`withMergeRequestsEnabled` | [`Boolean`](#boolean) | Return only projects with merge requests enabled. |

##### `Group.releases`

Releases belonging to projects in the group.

Returns [`ReleaseConnection`](#releaseconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupreleasessort"></a>`sort` | [`GroupReleaseSort`](#groupreleasesort) | Sort group releases by given criteria. |

##### `Group.runners`

Find runners visible to the current user.

Returns [`CiRunnerConnection`](#cirunnerconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="grouprunnersactive"></a>`active` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated** in 14.8. This was renamed. Use: `paused`. |
| <a id="grouprunnersmembership"></a>`membership` | [`CiRunnerMembershipFilter`](#cirunnermembershipfilter) | Control which runners to include in the results. |
| <a id="grouprunnerspaused"></a>`paused` | [`Boolean`](#boolean) | Filter runners by `paused` (true) or `active` (false) status. |
| <a id="grouprunnerssearch"></a>`search` | [`String`](#string) | Filter by full token or partial text in description field. |
| <a id="grouprunnerssort"></a>`sort` | [`CiRunnerSort`](#cirunnersort) | Sort order of results. |
| <a id="grouprunnersstatus"></a>`status` | [`CiRunnerStatus`](#cirunnerstatus) | Filter runners by status. |
| <a id="grouprunnerstaglist"></a>`tagList` | [`[String!]`](#string) | Filter by tags associated with the runner (comma-separated or array). |
| <a id="grouprunnerstype"></a>`type` | [`CiRunnerType`](#cirunnertype) | Filter runners by type. |
| <a id="grouprunnersupgradestatus"></a>`upgradeStatus` | [`CiRunnerUpgradeStatus`](#cirunnerupgradestatus) | Filter by upgrade status. |

##### `Group.scanExecutionPolicies`

Scan Execution Policies of the namespace.

Returns [`ScanExecutionPolicyConnection`](#scanexecutionpolicyconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupscanexecutionpoliciesactionscantypes"></a>`actionScanTypes` | [`[SecurityReportTypeEnum!]`](#securityreporttypeenum) | Filters policies by the action scan type. Only these scan types are supported: `dast`, `secret_detection`, `cluster_image_scanning`, `container_scanning`, `sast`, `sast_iac`, `dependency_scanning`. |
| <a id="groupscanexecutionpoliciesrelationship"></a>`relationship` | [`SecurityPolicyRelationType`](#securitypolicyrelationtype) | Filter policies by the given policy relationship. |

##### `Group.scanResultPolicies`

Scan Result Policies of the project.

Returns [`ScanResultPolicyConnection`](#scanresultpolicyconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupscanresultpoliciesrelationship"></a>`relationship` | [`SecurityPolicyRelationType`](#securitypolicyrelationtype) | Filter policies by the given policy relationship. |

##### `Group.timelogs`

Time logged on issues and merge requests in the group and its subgroups.

Returns [`TimelogConnection!`](#timelogconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="grouptimelogsenddate"></a>`endDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or before endDate. |
| <a id="grouptimelogsendtime"></a>`endTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or before endTime. |
| <a id="grouptimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | List timelogs for a group. |
| <a id="grouptimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | List timelogs for a project. |
| <a id="grouptimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | List timelogs in a particular order. |
| <a id="grouptimelogsstartdate"></a>`startDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or after startDate. |
| <a id="grouptimelogsstarttime"></a>`startTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or after startTime. |
| <a id="grouptimelogsusername"></a>`username` | [`String`](#string) | List timelogs for a user. |

##### `Group.vulnerabilities`

Vulnerabilities reported on the projects in the group and its subgroups.

Returns [`VulnerabilityConnection`](#vulnerabilityconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupvulnerabilitiesclusteragentid"></a>`clusterAgentId` | [`[ClustersAgentID!]`](#clustersagentid) | Filter vulnerabilities by `cluster_agent_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="groupvulnerabilitiesclusterid"></a>`clusterId` | [`[ClustersClusterID!]`](#clustersclusterid) | Filter vulnerabilities by `cluster_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="groupvulnerabilitieshasissues"></a>`hasIssues` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have linked issues. |
| <a id="groupvulnerabilitieshasresolution"></a>`hasResolution` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have been resolved on default branch. |
| <a id="groupvulnerabilitiesimage"></a>`image` | [`[String!]`](#string) | Filter vulnerabilities by location image. When this filter is present, the response only matches entries for a `reportType` that includes `container_scanning`, `cluster_image_scanning`. |
| <a id="groupvulnerabilitiesprojectid"></a>`projectId` | [`[ID!]`](#id) | Filter vulnerabilities by project. |
| <a id="groupvulnerabilitiesreporttype"></a>`reportType` | [`[VulnerabilityReportType!]`](#vulnerabilityreporttype) | Filter vulnerabilities by report type. |
| <a id="groupvulnerabilitiesscanner"></a>`scanner` | [`[String!]`](#string) | Filter vulnerabilities by VulnerabilityScanner.externalId. |
| <a id="groupvulnerabilitiesscannerid"></a>`scannerId` | [`[VulnerabilitiesScannerID!]`](#vulnerabilitiesscannerid) | Filter vulnerabilities by scanner ID. |
| <a id="groupvulnerabilitiesseverity"></a>`severity` | [`[VulnerabilitySeverity!]`](#vulnerabilityseverity) | Filter vulnerabilities by severity. |
| <a id="groupvulnerabilitiessort"></a>`sort` | [`VulnerabilitySort`](#vulnerabilitysort) | List vulnerabilities by sort order. |
| <a id="groupvulnerabilitiesstate"></a>`state` | [`[VulnerabilityState!]`](#vulnerabilitystate) | Filter vulnerabilities by state. |

##### `Group.vulnerabilitiesCountByDay`

The historical number of vulnerabilities per day for the projects in the group and its subgroups.

Returns [`VulnerabilitiesCountByDayConnection`](#vulnerabilitiescountbydayconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupvulnerabilitiescountbydayenddate"></a>`endDate` | [`ISO8601Date!`](#iso8601date) | Last day for which to fetch vulnerability history. |
| <a id="groupvulnerabilitiescountbydaystartdate"></a>`startDate` | [`ISO8601Date!`](#iso8601date) | First day for which to fetch vulnerability history. |

##### `Group.vulnerabilityGrades`

Represents vulnerable project counts for each grade.

Returns [`[VulnerableProjectsByGrade!]!`](#vulnerableprojectsbygrade).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupvulnerabilitygradesincludesubgroups"></a>`includeSubgroups` | [`Boolean`](#boolean) | Include grades belonging to subgroups. |
| <a id="groupvulnerabilitygradeslettergrade"></a>`letterGrade` | [`VulnerabilityGrade`](#vulnerabilitygrade) | Filter the response by given letter grade. |

##### `Group.vulnerabilitySeveritiesCount`

Counts for each vulnerability severity in the group and its subgroups.

Returns [`VulnerabilitySeveritiesCount`](#vulnerabilityseveritiescount).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupvulnerabilityseveritiescountclusteragentid"></a>`clusterAgentId` | [`[ClustersAgentID!]`](#clustersagentid) | Filter vulnerabilities by `cluster_agent_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="groupvulnerabilityseveritiescounthasissues"></a>`hasIssues` | [`Boolean`](#boolean) | Filter vulnerabilities that do or do not have issues. |
| <a id="groupvulnerabilityseveritiescounthasresolution"></a>`hasResolution` | [`Boolean`](#boolean) | Filter vulnerabilities that do or do not have a resolution. |
| <a id="groupvulnerabilityseveritiescountimage"></a>`image` | [`[String!]`](#string) | Filter vulnerabilities by location image. When this filter is present, the response only matches entries for a `reportType` that includes `container_scanning`, `cluster_image_scanning`. |
| <a id="groupvulnerabilityseveritiescountprojectid"></a>`projectId` | [`[ID!]`](#id) | Filter vulnerabilities by project. |
| <a id="groupvulnerabilityseveritiescountreporttype"></a>`reportType` | [`[VulnerabilityReportType!]`](#vulnerabilityreporttype) | Filter vulnerabilities by report type. |
| <a id="groupvulnerabilityseveritiescountscanner"></a>`scanner` | [`[String!]`](#string) | Filter vulnerabilities by scanner. |
| <a id="groupvulnerabilityseveritiescountscannerid"></a>`scannerId` | [`[VulnerabilitiesScannerID!]`](#vulnerabilitiesscannerid) | Filter vulnerabilities by scanner ID. |
| <a id="groupvulnerabilityseveritiescountseverity"></a>`severity` | [`[VulnerabilitySeverity!]`](#vulnerabilityseverity) | Filter vulnerabilities by severity. |
| <a id="groupvulnerabilityseveritiescountstate"></a>`state` | [`[VulnerabilityState!]`](#vulnerabilitystate) | Filter vulnerabilities by state. |

##### `Group.workItemTypes`

Work item types available to the group.

Returns [`WorkItemTypeConnection`](#workitemtypeconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupworkitemtypestaskable"></a>`taskable` | [`Boolean`](#boolean) | If `true`, only taskable work item types will be returned. Argument is experimental and can be removed in the future without notice. |

### `GroupDataTransfer`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupdatatransferegressnodes"></a>`egressNodes` | [`EgressNodeConnection`](#egressnodeconnection) | Data nodes. (see [Connections](#connections)) |

### `GroupMember`

Represents a Group Membership.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupmemberaccesslevel"></a>`accessLevel` | [`AccessLevel`](#accesslevel) | GitLab::Access level. |
| <a id="groupmembercreatedat"></a>`createdAt` | [`Time`](#time) | Date and time the membership was created. |
| <a id="groupmembercreatedby"></a>`createdBy` | [`UserCore`](#usercore) | User that authorized membership. |
| <a id="groupmemberexpiresat"></a>`expiresAt` | [`Time`](#time) | Date and time the membership expires. |
| <a id="groupmembergroup"></a>`group` | [`Group`](#group) | Group that a User is a member of. |
| <a id="groupmemberid"></a>`id` | [`ID!`](#id) | ID of the member. |
| <a id="groupmembernotificationemail"></a>`notificationEmail` | [`String`](#string) | Group notification email for User. Only available for admins. |
| <a id="groupmemberupdatedat"></a>`updatedAt` | [`Time`](#time) | Date and time the membership was last updated. |
| <a id="groupmemberuser"></a>`user` | [`UserCore`](#usercore) | User that is associated with the member object. |
| <a id="groupmemberuserpermissions"></a>`userPermissions` | [`GroupPermissions!`](#grouppermissions) | Permissions for the current user on the resource. |

#### Fields with arguments

##### `GroupMember.mergeRequestInteraction`

Find a merge request.

Returns [`UserMergeRequestInteraction`](#usermergerequestinteraction).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupmembermergerequestinteractionid"></a>`id` | [`MergeRequestID!`](#mergerequestid) | Global ID of the merge request. |

### `GroupPermissions`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="grouppermissionscreateprojects"></a>`createProjects` | [`Boolean!`](#boolean) | Indicates the user can perform `create_projects` on this resource. |
| <a id="grouppermissionsreadgroup"></a>`readGroup` | [`Boolean!`](#boolean) | Indicates the user can perform `read_group` on this resource. |

### `GroupReleaseStats`

Contains release-related statistics about a group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupreleasestatsreleasescount"></a>`releasesCount` | [`Int`](#int) | Total number of releases in all descendant projects of the group. |
| <a id="groupreleasestatsreleasespercentage"></a>`releasesPercentage` | [`Int`](#int) | Percentage of the group's descendant projects that have at least one release. |

### `GroupSecurityPolicySource`

Represents the source of a security policy belonging to a group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupsecuritypolicysourceinherited"></a>`inherited` | [`Boolean!`](#boolean) | Indicates whether this policy is inherited from parent group. |
| <a id="groupsecuritypolicysourcenamespace"></a>`namespace` | [`Namespace`](#namespace) | Project the policy is associated with. |

### `GroupStats`

Contains statistics about a group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupstatsreleasestats"></a>`releaseStats` | [`GroupReleaseStats`](#groupreleasestats) | Statistics related to releases within the group. |

### `GroupValueStreamAnalyticsFlowMetrics`

Exposes aggregated value stream flow metrics.

#### Fields with arguments

##### `GroupValueStreamAnalyticsFlowMetrics.cycleTime`

Median time from first commit to issue closed.

Returns [`ValueStreamAnalyticsMetric`](#valuestreamanalyticsmetric).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupvaluestreamanalyticsflowmetricscycletimeassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricscycletimeauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author of the issue. |
| <a id="groupvaluestreamanalyticsflowmetricscycletimefrom"></a>`from` | [`Time!`](#time) | Timestamp marking the start date and time. |
| <a id="groupvaluestreamanalyticsflowmetricscycletimelabelnames"></a>`labelNames` | [`[String!]`](#string) | Labels applied to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricscycletimemilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Milestone applied to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricscycletimeprojectids"></a>`projectIds` | [`[ID!]`](#id) | Project IDs within the group hierarchy. |
| <a id="groupvaluestreamanalyticsflowmetricscycletimeto"></a>`to` | [`Time!`](#time) | Timestamp marking the end date and time. |

##### `GroupValueStreamAnalyticsFlowMetrics.deploymentCount`

Number of production deployments in the given period.

Returns [`ValueStreamAnalyticsMetric`](#valuestreamanalyticsmetric).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupvaluestreamanalyticsflowmetricsdeploymentcountfrom"></a>`from` | [`Time!`](#time) | Timestamp marking the start date and time. |
| <a id="groupvaluestreamanalyticsflowmetricsdeploymentcountprojectids"></a>`projectIds` | [`[ID!]`](#id) | Project IDs within the group hierarchy. |
| <a id="groupvaluestreamanalyticsflowmetricsdeploymentcountto"></a>`to` | [`Time!`](#time) | Timestamp marking the end date and time. |

##### `GroupValueStreamAnalyticsFlowMetrics.issueCount`

Number of issues opened in the given period.

Returns [`ValueStreamAnalyticsMetric`](#valuestreamanalyticsmetric).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupvaluestreamanalyticsflowmetricsissuecountassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsissuecountauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author of the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsissuecountfrom"></a>`from` | [`Time!`](#time) | Timestamp marking the start date and time. |
| <a id="groupvaluestreamanalyticsflowmetricsissuecountlabelnames"></a>`labelNames` | [`[String!]`](#string) | Labels applied to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsissuecountmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Milestone applied to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsissuecountprojectids"></a>`projectIds` | [`[ID!]`](#id) | Project IDs within the group hierarchy. |
| <a id="groupvaluestreamanalyticsflowmetricsissuecountto"></a>`to` | [`Time!`](#time) | Timestamp marking the end date and time. |

##### `GroupValueStreamAnalyticsFlowMetrics.issuesCompletedCount`

Number of open issues closed (completed) in the given period. Maximum value is 10,001.

Returns [`ValueStreamAnalyticsMetric`](#valuestreamanalyticsmetric).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupvaluestreamanalyticsflowmetricsissuescompletedcountassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsissuescompletedcountauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author of the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsissuescompletedcountfrom"></a>`from` | [`Time!`](#time) | Timestamp marking the start date and time. |
| <a id="groupvaluestreamanalyticsflowmetricsissuescompletedcountlabelnames"></a>`labelNames` | [`[String!]`](#string) | Labels applied to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsissuescompletedcountmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Milestone applied to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsissuescompletedcountprojectids"></a>`projectIds` | [`[ID!]`](#id) | Project IDs within the group hierarchy. |
| <a id="groupvaluestreamanalyticsflowmetricsissuescompletedcountto"></a>`to` | [`Time!`](#time) | Timestamp marking the end date and time. |

##### `GroupValueStreamAnalyticsFlowMetrics.leadTime`

Median time from when the issue was created to when it was closed.

Returns [`ValueStreamAnalyticsMetric`](#valuestreamanalyticsmetric).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupvaluestreamanalyticsflowmetricsleadtimeassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsleadtimeauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author of the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsleadtimefrom"></a>`from` | [`Time!`](#time) | Timestamp marking the start date and time. |
| <a id="groupvaluestreamanalyticsflowmetricsleadtimelabelnames"></a>`labelNames` | [`[String!]`](#string) | Labels applied to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsleadtimemilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Milestone applied to the issue. |
| <a id="groupvaluestreamanalyticsflowmetricsleadtimeprojectids"></a>`projectIds` | [`[ID!]`](#id) | Project IDs within the group hierarchy. |
| <a id="groupvaluestreamanalyticsflowmetricsleadtimeto"></a>`to` | [`Time!`](#time) | Timestamp marking the end date and time. |

### `GroupWikiRepositoryRegistry`

Represents the Geo sync and verification state of a group wiki repository.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistrycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the GroupWikiRepositoryRegistry was created. |
| <a id="groupwikirepositoryregistrygroupwikirepositoryid"></a>`groupWikiRepositoryId` | [`ID!`](#id) | ID of the Group Wiki Repository. |
| <a id="groupwikirepositoryregistryid"></a>`id` | [`ID!`](#id) | ID of the GroupWikiRepositoryRegistry. |
| <a id="groupwikirepositoryregistrylastsyncfailure"></a>`lastSyncFailure` | [`String`](#string) | Error message during sync of the GroupWikiRepositoryRegistry. |
| <a id="groupwikirepositoryregistrylastsyncedat"></a>`lastSyncedAt` | [`Time`](#time) | Timestamp of the most recent successful sync of the GroupWikiRepositoryRegistry. |
| <a id="groupwikirepositoryregistryretryat"></a>`retryAt` | [`Time`](#time) | Timestamp after which the GroupWikiRepositoryRegistry is resynced. |
| <a id="groupwikirepositoryregistryretrycount"></a>`retryCount` | [`Int`](#int) | Number of consecutive failed sync attempts of the GroupWikiRepositoryRegistry. |
| <a id="groupwikirepositoryregistrystate"></a>`state` | [`RegistryState`](#registrystate) | Sync state of the GroupWikiRepositoryRegistry. |
| <a id="groupwikirepositoryregistryverificationretryat"></a>`verificationRetryAt` | [`Time`](#time) | Timestamp after which the GroupWikiRepositoryRegistry is reverified. |
| <a id="groupwikirepositoryregistryverifiedat"></a>`verifiedAt` | [`Time`](#time) | Timestamp of the most recent successful verification of the GroupWikiRepositoryRegistry. |

### `HelmFileMetadata`

Helm file metadata.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="helmfilemetadatachannel"></a>`channel` | [`String!`](#string) | Channel of the Helm chart. |
| <a id="helmfilemetadatacreatedat"></a>`createdAt` | [`Time!`](#time) | Date of creation. |
| <a id="helmfilemetadatametadata"></a>`metadata` | [`PackageHelmMetadataType!`](#packagehelmmetadatatype) | Metadata of the Helm chart. |
| <a id="helmfilemetadataupdatedat"></a>`updatedAt` | [`Time!`](#time) | Date of most recent update. |

### `IncidentManagementOncallRotation`

Describes an incident management on-call rotation.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodType`](#oncallrotationactiveperiodtype) | Active period for the on-call rotation. |
| <a id="incidentmanagementoncallrotationendsat"></a>`endsAt` | [`Time`](#time) | End date and time of the on-call rotation. |
| <a id="incidentmanagementoncallrotationid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | ID of the on-call rotation. |
| <a id="incidentmanagementoncallrotationlength"></a>`length` | [`Int`](#int) | Length of the on-call schedule, in the units specified by lengthUnit. |
| <a id="incidentmanagementoncallrotationlengthunit"></a>`lengthUnit` | [`OncallRotationUnitEnum`](#oncallrotationunitenum) | Unit of the on-call rotation length. |
| <a id="incidentmanagementoncallrotationname"></a>`name` | [`String!`](#string) | Name of the on-call rotation. |
| <a id="incidentmanagementoncallrotationparticipants"></a>`participants` | [`OncallParticipantTypeConnection`](#oncallparticipanttypeconnection) | Participants of the on-call rotation. (see [Connections](#connections)) |
| <a id="incidentmanagementoncallrotationstartsat"></a>`startsAt` | [`Time`](#time) | Start date of the on-call rotation. |

#### Fields with arguments

##### `IncidentManagementOncallRotation.shifts`

Blocks of time for which a participant is on-call within a given time frame. Time frame cannot exceed one month.

Returns [`IncidentManagementOncallShiftConnection`](#incidentmanagementoncallshiftconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationshiftsendtime"></a>`endTime` | [`Time!`](#time) | End of timeframe to include shifts for. Cannot exceed one month after start. |
| <a id="incidentmanagementoncallrotationshiftsstarttime"></a>`startTime` | [`Time!`](#time) | Start of timeframe to include shifts for. |

### `IncidentManagementOncallSchedule`

Describes an incident management on-call schedule.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallscheduledescription"></a>`description` | [`String`](#string) | Description of the on-call schedule. |
| <a id="incidentmanagementoncallscheduleiid"></a>`iid` | [`ID!`](#id) | Internal ID of the on-call schedule. |
| <a id="incidentmanagementoncallschedulename"></a>`name` | [`String!`](#string) | Name of the on-call schedule. |
| <a id="incidentmanagementoncallscheduleoncallusers"></a>`oncallUsers` | [`[UserCore!]`](#usercore) |  |
| <a id="incidentmanagementoncallschedulerotations"></a>`rotations` | [`IncidentManagementOncallRotationConnection!`](#incidentmanagementoncallrotationconnection) | On-call rotations for the on-call schedule. (see [Connections](#connections)) |
| <a id="incidentmanagementoncallscheduletimezone"></a>`timezone` | [`String!`](#string) | Time zone of the on-call schedule. |

#### Fields with arguments

##### `IncidentManagementOncallSchedule.rotation`

On-call rotation for the on-call schedule.

Returns [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallschedulerotationid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | ID of the on-call rotation. |

### `IncidentManagementOncallShift`

A block of time for which a participant is on-call.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallshiftendsat"></a>`endsAt` | [`Time`](#time) | End time of the on-call shift. |
| <a id="incidentmanagementoncallshiftparticipant"></a>`participant` | [`OncallParticipantType`](#oncallparticipanttype) | Participant assigned to the on-call shift. |
| <a id="incidentmanagementoncallshiftstartsat"></a>`startsAt` | [`Time`](#time) | Start time of the on-call shift. |

### `InheritedCiVariable`

CI/CD variables a project inherites from its parent group and ancestors.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="inheritedcivariableenvironmentscope"></a>`environmentScope` | [`String`](#string) | Scope defining the environments that can use the variable. |
| <a id="inheritedcivariablegroupcicdsettingspath"></a>`groupCiCdSettingsPath` | [`String`](#string) | Indicates the path to the CI/CD settings of the group the variable belongs to. |
| <a id="inheritedcivariablegroupname"></a>`groupName` | [`String`](#string) | Indicates group the variable belongs to. |
| <a id="inheritedcivariableid"></a>`id` | [`ID!`](#id) | ID of the variable. |
| <a id="inheritedcivariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="inheritedcivariablemasked"></a>`masked` | [`Boolean`](#boolean) | Indicates whether the variable is masked. |
| <a id="inheritedcivariableprotected"></a>`protected` | [`Boolean`](#boolean) | Indicates whether the variable is protected. |
| <a id="inheritedcivariableraw"></a>`raw` | [`Boolean`](#boolean) | Indicates whether the variable is raw. |
| <a id="inheritedcivariablevariabletype"></a>`variableType` | [`CiVariableType`](#civariabletype) | Type of the variable. |

### `InstanceExternalAuditEventDestination`

Represents an external resource to send instance audit events to.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instanceexternalauditeventdestinationdestinationurl"></a>`destinationUrl` | [`String!`](#string) | External destination to send audit events to. |
| <a id="instanceexternalauditeventdestinationid"></a>`id` | [`ID!`](#id) | ID of the destination. |
| <a id="instanceexternalauditeventdestinationverificationtoken"></a>`verificationToken` | [`String!`](#string) | Verification token to validate source of event. |

### `InstanceSecurityDashboard`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instancesecuritydashboardvulnerabilityscanners"></a>`vulnerabilityScanners` | [`VulnerabilityScannerConnection`](#vulnerabilityscannerconnection) | Vulnerability scanners reported on the vulnerabilities from projects selected in Instance Security Dashboard. (see [Connections](#connections)) |

#### Fields with arguments

##### `InstanceSecurityDashboard.clusterAgents`

Cluster agents associated with projects selected in the Instance Security Dashboard.

Returns [`ClusterAgentConnection`](#clusteragentconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instancesecuritydashboardclusteragentshasremotedevelopmentagentconfig"></a>`hasRemoteDevelopmentAgentConfig` | [`Boolean`](#boolean) | Returns only cluster agents which have an associated remote development agent config. |
| <a id="instancesecuritydashboardclusteragentshasvulnerabilities"></a>`hasVulnerabilities` | [`Boolean`](#boolean) | Returns only cluster agents which have vulnerabilities. |

##### `InstanceSecurityDashboard.projects`

Projects selected in Instance Security Dashboard.

Returns [`ProjectConnection!`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instancesecuritydashboardprojectssearch"></a>`search` | [`String`](#string) | Search query, which can be for the project name, a path, or a description. |

##### `InstanceSecurityDashboard.vulnerabilityGrades`

Represents vulnerable project counts for each grade.

Returns [`[VulnerableProjectsByGrade!]!`](#vulnerableprojectsbygrade).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instancesecuritydashboardvulnerabilitygradeslettergrade"></a>`letterGrade` | [`VulnerabilityGrade`](#vulnerabilitygrade) | Filter the response by given letter grade. |

##### `InstanceSecurityDashboard.vulnerabilitySeveritiesCount`

Counts for each vulnerability severity from projects selected in Instance Security Dashboard.

Returns [`VulnerabilitySeveritiesCount`](#vulnerabilityseveritiescount).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instancesecuritydashboardvulnerabilityseveritiescountclusteragentid"></a>`clusterAgentId` | [`[ClustersAgentID!]`](#clustersagentid) | Filter vulnerabilities by `cluster_agent_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="instancesecuritydashboardvulnerabilityseveritiescounthasissues"></a>`hasIssues` | [`Boolean`](#boolean) | Filter vulnerabilities that do or do not have issues. |
| <a id="instancesecuritydashboardvulnerabilityseveritiescounthasresolution"></a>`hasResolution` | [`Boolean`](#boolean) | Filter vulnerabilities that do or do not have a resolution. |
| <a id="instancesecuritydashboardvulnerabilityseveritiescountimage"></a>`image` | [`[String!]`](#string) | Filter vulnerabilities by location image. When this filter is present, the response only matches entries for a `reportType` that includes `container_scanning`, `cluster_image_scanning`. |
| <a id="instancesecuritydashboardvulnerabilityseveritiescountprojectid"></a>`projectId` | [`[ID!]`](#id) | Filter vulnerabilities by project. |
| <a id="instancesecuritydashboardvulnerabilityseveritiescountreporttype"></a>`reportType` | [`[VulnerabilityReportType!]`](#vulnerabilityreporttype) | Filter vulnerabilities by report type. |
| <a id="instancesecuritydashboardvulnerabilityseveritiescountscanner"></a>`scanner` | [`[String!]`](#string) | Filter vulnerabilities by scanner. |
| <a id="instancesecuritydashboardvulnerabilityseveritiescountscannerid"></a>`scannerId` | [`[VulnerabilitiesScannerID!]`](#vulnerabilitiesscannerid) | Filter vulnerabilities by scanner ID. |
| <a id="instancesecuritydashboardvulnerabilityseveritiescountseverity"></a>`severity` | [`[VulnerabilitySeverity!]`](#vulnerabilityseverity) | Filter vulnerabilities by severity. |
| <a id="instancesecuritydashboardvulnerabilityseveritiescountstate"></a>`state` | [`[VulnerabilityState!]`](#vulnerabilitystate) | Filter vulnerabilities by state. |

### `IssuableResourceLink`

Describes an issuable resource link for incident issues.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuableresourcelinkid"></a>`id` | [`IncidentManagementIssuableResourceLinkID!`](#incidentmanagementissuableresourcelinkid) | ID of the Issuable resource link. |
| <a id="issuableresourcelinkissue"></a>`issue` | [`Issue!`](#issue) | Incident of the resource link. |
| <a id="issuableresourcelinklink"></a>`link` | [`String!`](#string) | Web Link to the resource. |
| <a id="issuableresourcelinklinktext"></a>`linkText` | [`String`](#string) | Optional text for the link. |
| <a id="issuableresourcelinklinktype"></a>`linkType` | [`IssuableResourceLinkType!`](#issuableresourcelinktype) | Type of the resource link. |

### `Issue`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuealertmanagementalert"></a>`alertManagementAlert` **{warning-solid}** | [`AlertManagementAlert`](#alertmanagementalert) | **Deprecated** in 15.6. Use `alert_management_alerts`. |
| <a id="issueassignees"></a>`assignees` | [`UserCoreConnection`](#usercoreconnection) | Assignees of the issue. (see [Connections](#connections)) |
| <a id="issueauthor"></a>`author` | [`UserCore!`](#usercore) | User that created the issue. |
| <a id="issueblocked"></a>`blocked` | [`Boolean!`](#boolean) | Indicates the issue is blocked. |
| <a id="issueblockedbycount"></a>`blockedByCount` | [`Int`](#int) | Count of issues blocking this issue. |
| <a id="issueblockedbyissues"></a>`blockedByIssues` | [`IssueConnection`](#issueconnection) | Issues blocking this issue. (see [Connections](#connections)) |
| <a id="issueblockingcount"></a>`blockingCount` | [`Int!`](#int) | Count of issues this issue is blocking. |
| <a id="issueclosedasduplicateof"></a>`closedAsDuplicateOf` | [`Issue`](#issue) | Issue this issue was closed as a duplicate of. |
| <a id="issueclosedat"></a>`closedAt` | [`Time`](#time) | Timestamp of when the issue was closed. |
| <a id="issuecommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="issueconfidential"></a>`confidential` | [`Boolean!`](#boolean) | Indicates the issue is confidential. |
| <a id="issuecreatenoteemail"></a>`createNoteEmail` | [`String`](#string) | User specific email address for the issue. |
| <a id="issuecreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of when the issue was created. |
| <a id="issuecustomerrelationscontacts"></a>`customerRelationsContacts` | [`CustomerRelationsContactConnection`](#customerrelationscontactconnection) | Customer relations contacts of the issue. (see [Connections](#connections)) |
| <a id="issuedescription"></a>`description` | [`String`](#string) | Description of the issue. |
| <a id="issuedescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="issuedesigncollection"></a>`designCollection` | [`DesignCollection`](#designcollection) | Collection of design images associated with this issue. |
| <a id="issuediscussionlocked"></a>`discussionLocked` | [`Boolean!`](#boolean) | Indicates discussion is locked on the issue. |
| <a id="issuediscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="issuedownvotes"></a>`downvotes` | [`Int!`](#int) | Number of downvotes the issue has received. |
| <a id="issueduedate"></a>`dueDate` | [`Time`](#time) | Due date of the issue. |
| <a id="issueemailsdisabled"></a>`emailsDisabled` | [`Boolean!`](#boolean) | Indicates if a project has email notifications disabled: `true` if email notifications are disabled. |
| <a id="issueepic"></a>`epic` | [`Epic`](#epic) | Epic to which this issue belongs. |
| <a id="issueescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy associated with the issue. Available for issues which support escalation. |
| <a id="issueescalationstatus"></a>`escalationStatus` | [`IssueEscalationStatus`](#issueescalationstatus) | Escalation status of the issue. |
| <a id="issuehasepic"></a>`hasEpic` | [`Boolean!`](#boolean) | Indicates if the issue belongs to an epic. Can return true and not show an associated epic when the user has no access to the epic. |
| <a id="issuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Current health status. |
| <a id="issuehidden"></a>`hidden` | [`Boolean`](#boolean) | Indicates the issue is hidden because the author has been banned. |
| <a id="issuehumantimeestimate"></a>`humanTimeEstimate` | [`String`](#string) | Human-readable time estimate of the issue. |
| <a id="issuehumantotaltimespent"></a>`humanTotalTimeSpent` | [`String`](#string) | Human-readable total time reported as spent on the issue. |
| <a id="issueid"></a>`id` | [`ID!`](#id) | ID of the issue. |
| <a id="issueiid"></a>`iid` | [`ID!`](#id) | Internal ID of the issue. |
| <a id="issueiteration"></a>`iteration` | [`Iteration`](#iteration) | Iteration of the issue. |
| <a id="issuelabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels of the issue. (see [Connections](#connections)) |
| <a id="issuemergerequestscount"></a>`mergeRequestsCount` | [`Int!`](#int) | Number of merge requests that close the issue on merge. |
| <a id="issuemetricimages"></a>`metricImages` | [`[MetricImage!]`](#metricimage) | Metric images associated to the issue. |
| <a id="issuemilestone"></a>`milestone` | [`Milestone`](#milestone) | Milestone of the issue. |
| <a id="issuemoved"></a>`moved` | [`Boolean`](#boolean) | Indicates if issue got moved from other project. |
| <a id="issuemovedto"></a>`movedTo` | [`Issue`](#issue) | Updated Issue after it got moved to another project. |
| <a id="issuenotes"></a>`notes` | [`NoteConnection!`](#noteconnection) | All notes on this noteable. (see [Connections](#connections)) |
| <a id="issueparticipants"></a>`participants` | [`UserCoreConnection`](#usercoreconnection) | List of participants in the issue. (see [Connections](#connections)) |
| <a id="issueprojectid"></a>`projectId` | [`Int!`](#int) | ID of the issue project. |
| <a id="issuerelatedmergerequests"></a>`relatedMergeRequests` | [`MergeRequestConnection`](#mergerequestconnection) | Merge requests related to the issue. This field can only be resolved for one issue in any single request. (see [Connections](#connections)) |
| <a id="issuerelatedvulnerabilities"></a>`relatedVulnerabilities` | [`VulnerabilityConnection`](#vulnerabilityconnection) | Related vulnerabilities of the issue. (see [Connections](#connections)) |
| <a id="issuerelativeposition"></a>`relativePosition` | [`Int`](#int) | Relative position of the issue (used for positioning in epic tree and issue boards). |
| <a id="issueseverity"></a>`severity` | [`IssuableSeverity`](#issuableseverity) | Severity level of the incident. |
| <a id="issuesladueat"></a>`slaDueAt` | [`Time`](#time) | Timestamp of when the issue SLA expires. |
| <a id="issuestate"></a>`state` | [`IssueState!`](#issuestate) | State of the issue. |
| <a id="issuestatuspagepublishedincident"></a>`statusPagePublishedIncident` | [`Boolean`](#boolean) | Indicates whether an issue is published to the status page. |
| <a id="issuesubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | Indicates the currently logged in user is subscribed to the issue. |
| <a id="issuetaskcompletionstatus"></a>`taskCompletionStatus` | [`TaskCompletionStatus!`](#taskcompletionstatus) | Task completion status of the issue. |
| <a id="issuetimeestimate"></a>`timeEstimate` | [`Int!`](#int) | Time estimate of the issue. |
| <a id="issuetimelogs"></a>`timelogs` | [`TimelogConnection!`](#timelogconnection) | Timelogs on the issue. (see [Connections](#connections)) |
| <a id="issuetitle"></a>`title` | [`String!`](#string) | Title of the issue. |
| <a id="issuetitlehtml"></a>`titleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `title`. |
| <a id="issuetotaltimespent"></a>`totalTimeSpent` | [`Int!`](#int) | Total time reported as spent on the issue. |
| <a id="issuetype"></a>`type` | [`IssueType`](#issuetype) | Type of the issue. |
| <a id="issueupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of when the issue was last updated. |
| <a id="issueupdatedby"></a>`updatedBy` | [`UserCore`](#usercore) | User that last updated the issue. |
| <a id="issueupvotes"></a>`upvotes` | [`Int!`](#int) | Number of upvotes the issue has received. |
| <a id="issueuserdiscussionscount"></a>`userDiscussionsCount` | [`Int!`](#int) | Number of user discussions in the issue. |
| <a id="issueusernotescount"></a>`userNotesCount` | [`Int!`](#int) | Number of user notes of the issue. |
| <a id="issueuserpermissions"></a>`userPermissions` | [`IssuePermissions!`](#issuepermissions) | Permissions for the current user on the resource. |
| <a id="issuewebpath"></a>`webPath` | [`String!`](#string) | Web path of the issue. |
| <a id="issueweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the issue. |
| <a id="issueweight"></a>`weight` | [`Int`](#int) | Weight of the issue. |

#### Fields with arguments

##### `Issue.alertManagementAlerts`

Alert Management alerts associated to this issue.

Returns [`AlertManagementAlertConnection`](#alertmanagementalertconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuealertmanagementalertsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | Username of a user assigned to the issue. |
| <a id="issuealertmanagementalertsdomain"></a>`domain` | [`AlertManagementDomainFilter!`](#alertmanagementdomainfilter) | Filter query for given domain. |
| <a id="issuealertmanagementalertsiid"></a>`iid` | [`String`](#string) | IID of the alert. For example, "1". |
| <a id="issuealertmanagementalertssearch"></a>`search` | [`String`](#string) | Search query for title, description, service, or monitoring_tool. |
| <a id="issuealertmanagementalertssort"></a>`sort` | [`AlertManagementAlertSort`](#alertmanagementalertsort) | Sort alerts by this criteria. |
| <a id="issuealertmanagementalertsstatuses"></a>`statuses` | [`[AlertManagementStatus!]`](#alertmanagementstatus) | Alerts with the specified statues. For example, `[TRIGGERED]`. |

##### `Issue.currentUserTodos`

To-do items for the current user.

Returns [`TodoConnection!`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuecurrentusertodosstate"></a>`state` | [`TodoStateEnum`](#todostateenum) | State of the to-do items. |

##### `Issue.issuableResourceLinks`

Issuable resource links of the incident issue.

Returns [`IssuableResourceLinkConnection`](#issuableresourcelinkconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issueissuableresourcelinksincidentid"></a>`incidentId` | [`IssueID!`](#issueid) | ID of the incident. |

##### `Issue.reference`

Internal reference of the issue. Returned in shortened format by default.

Returns [`String!`](#string).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuereferencefull"></a>`full` | [`Boolean`](#boolean) | Boolean option specifying whether the reference should be returned in full. |

### `IssuePermissions`

Check permissions for the current user on a issue.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuepermissionsadminissue"></a>`adminIssue` | [`Boolean!`](#boolean) | Indicates the user can perform `admin_issue` on this resource. |
| <a id="issuepermissionscreatedesign"></a>`createDesign` | [`Boolean!`](#boolean) | Indicates the user can perform `create_design` on this resource. |
| <a id="issuepermissionscreatenote"></a>`createNote` | [`Boolean!`](#boolean) | Indicates the user can perform `create_note` on this resource. |
| <a id="issuepermissionsdestroydesign"></a>`destroyDesign` | [`Boolean!`](#boolean) | Indicates the user can perform `destroy_design` on this resource. |
| <a id="issuepermissionsreaddesign"></a>`readDesign` | [`Boolean!`](#boolean) | Indicates the user can perform `read_design` on this resource. |
| <a id="issuepermissionsreadissue"></a>`readIssue` | [`Boolean!`](#boolean) | Indicates the user can perform `read_issue` on this resource. |
| <a id="issuepermissionsreopenissue"></a>`reopenIssue` | [`Boolean!`](#boolean) | Indicates the user can perform `reopen_issue` on this resource. |
| <a id="issuepermissionsupdatedesign"></a>`updateDesign` | [`Boolean!`](#boolean) | Indicates the user can perform `update_design` on this resource. |
| <a id="issuepermissionsupdateissue"></a>`updateIssue` | [`Boolean!`](#boolean) | Indicates the user can perform `update_issue` on this resource. |

### `IssueStatusCountsType`

Represents total number of issues for the represented statuses.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuestatuscountstypeall"></a>`all` | [`Int`](#int) | Number of issues with status ALL for the project. |
| <a id="issuestatuscountstypeclosed"></a>`closed` | [`Int`](#int) | Number of issues with status CLOSED for the project. |
| <a id="issuestatuscountstypeopened"></a>`opened` | [`Int`](#int) | Number of issues with status OPENED for the project. |

### `Iteration`

Represents an iteration object.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of iteration creation. |
| <a id="iterationdescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="iterationdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="iterationduedate"></a>`dueDate` | [`Time`](#time) | Timestamp of the iteration due date. |
| <a id="iterationid"></a>`id` | [`ID!`](#id) | ID of the iteration. |
| <a id="iterationiid"></a>`iid` | [`ID!`](#id) | Internal ID of the iteration. |
| <a id="iterationiterationcadence"></a>`iterationCadence` | [`IterationCadence!`](#iterationcadence) | Cadence of the iteration. |
| <a id="iterationscopedpath"></a>`scopedPath` | [`String`](#string) | Web path of the iteration, scoped to the query parent. Only valid for Project parents. Returns null in other contexts. |
| <a id="iterationscopedurl"></a>`scopedUrl` | [`String`](#string) | Web URL of the iteration, scoped to the query parent. Only valid for Project parents. Returns null in other contexts. |
| <a id="iterationsequence"></a>`sequence` | [`Int!`](#int) | Sequence number for the iteration when you sort the containing cadence's iterations by the start and end date. The earliest starting and ending iteration is assigned 1. |
| <a id="iterationstartdate"></a>`startDate` | [`Time`](#time) | Timestamp of the iteration start date. |
| <a id="iterationstate"></a>`state` | [`IterationState!`](#iterationstate) | State of the iteration. |
| <a id="iterationtitle"></a>`title` | [`String`](#string) | Title of the iteration. |
| <a id="iterationupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of last iteration update. |
| <a id="iterationwebpath"></a>`webPath` | [`String!`](#string) | Web path of the iteration. |
| <a id="iterationweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the iteration. |

#### Fields with arguments

##### `Iteration.report`

Historically accurate report about the timebox.

Returns [`TimeboxReport`](#timeboxreport).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationreportfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group used as a scope for report. For example, `gitlab-org` or `gitlab-org/gitlab`. |

### `IterationCadence`

Represents an iteration cadence.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationcadenceactive"></a>`active` | [`Boolean`](#boolean) | Whether the iteration cadence is active. |
| <a id="iterationcadenceautomatic"></a>`automatic` | [`Boolean`](#boolean) | Whether the iteration cadence should automatically generate upcoming iterations. |
| <a id="iterationcadencedescription"></a>`description` | [`String`](#string) | Description of the iteration cadence. Maximum length is 5000 characters. |
| <a id="iterationcadencedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | Duration in weeks of the iterations within this cadence. |
| <a id="iterationcadenceid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | Global ID of the iteration cadence. |
| <a id="iterationcadenceiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | Upcoming iterations to be created when iteration cadence is set to automatic. |
| <a id="iterationcadencerollover"></a>`rollOver` | [`Boolean!`](#boolean) | Whether the iteration cadence should roll over issues to the next iteration or not. |
| <a id="iterationcadencestartdate"></a>`startDate` | [`Time`](#time) | Timestamp of the automation start date. |
| <a id="iterationcadencetitle"></a>`title` | [`String!`](#string) | Title of the iteration cadence. |

### `JiraImport`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraimportcreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of when the Jira import was created. |
| <a id="jiraimportfailedtoimportcount"></a>`failedToImportCount` | [`Int!`](#int) | Count of issues that failed to import. |
| <a id="jiraimportimportedissuescount"></a>`importedIssuesCount` | [`Int!`](#int) | Count of issues that were successfully imported. |
| <a id="jiraimportjiraprojectkey"></a>`jiraProjectKey` | [`String!`](#string) | Project key for the imported Jira project. |
| <a id="jiraimportscheduledat"></a>`scheduledAt` | [`Time`](#time) | Timestamp of when the Jira import was scheduled. |
| <a id="jiraimportscheduledby"></a>`scheduledBy` | [`UserCore`](#usercore) | User that started the Jira import. |
| <a id="jiraimporttotalissuecount"></a>`totalIssueCount` | [`Int!`](#int) | Total count of issues that were attempted to import. |

### `JiraProject`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraprojectkey"></a>`key` | [`String!`](#string) | Key of the Jira project. |
| <a id="jiraprojectname"></a>`name` | [`String`](#string) | Name of the Jira project. |
| <a id="jiraprojectprojectid"></a>`projectId` | [`Int!`](#int) | ID of the Jira project. |

### `JiraService`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraserviceactive"></a>`active` | [`Boolean`](#boolean) | Indicates if the service is active. |
| <a id="jiraserviceservicetype"></a>`serviceType` | [`ServiceType`](#servicetype) | Type of the service. |
| <a id="jiraservicetype"></a>`type` | [`String`](#string) | Class name of the service. |

#### Fields with arguments

##### `JiraService.projects`

List of all Jira projects fetched through Jira REST API.

Returns [`JiraProjectConnection`](#jiraprojectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraserviceprojectsname"></a>`name` | [`String`](#string) | Project name or key. |

### `JiraUser`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jirausergitlabid"></a>`gitlabId` | [`Int`](#int) | ID of the matched GitLab user. |
| <a id="jirausergitlabname"></a>`gitlabName` | [`String`](#string) | Name of the matched GitLab user. |
| <a id="jirausergitlabusername"></a>`gitlabUsername` | [`String`](#string) | Username of the matched GitLab user. |
| <a id="jirauserjiraaccountid"></a>`jiraAccountId` | [`String!`](#string) | Account ID of the Jira user. |
| <a id="jirauserjiradisplayname"></a>`jiraDisplayName` | [`String!`](#string) | Display name of the Jira user. |
| <a id="jirauserjiraemail"></a>`jiraEmail` | [`String`](#string) | Email of the Jira user, returned only for users with public emails. |

### `JobArtifactRegistry`

Represents the Geo replication and verification state of a job_artifact.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryartifactid"></a>`artifactId` | [`ID!`](#id) | ID of the Job Artifact. |
| <a id="jobartifactregistrycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the JobArtifactRegistry was created. |
| <a id="jobartifactregistryid"></a>`id` | [`ID!`](#id) | ID of the JobArtifactRegistry. |
| <a id="jobartifactregistrylastsyncfailure"></a>`lastSyncFailure` | [`String`](#string) | Error message during sync of the JobArtifactRegistry. |
| <a id="jobartifactregistrylastsyncedat"></a>`lastSyncedAt` | [`Time`](#time) | Timestamp of the most recent successful sync of the JobArtifactRegistry. |
| <a id="jobartifactregistryretryat"></a>`retryAt` | [`Time`](#time) | Timestamp after which the JobArtifactRegistry is resynced. |
| <a id="jobartifactregistryretrycount"></a>`retryCount` | [`Int`](#int) | Number of consecutive failed sync attempts of the JobArtifactRegistry. |
| <a id="jobartifactregistrystate"></a>`state` | [`RegistryState`](#registrystate) | Sync state of the JobArtifactRegistry. |
| <a id="jobartifactregistryverificationretryat"></a>`verificationRetryAt` | [`Time`](#time) | Timestamp after which the JobArtifactRegistry is reverified. |
| <a id="jobartifactregistryverifiedat"></a>`verifiedAt` | [`Time`](#time) | Timestamp of the most recent successful verification of the JobArtifactRegistry. |

### `JobPermissions`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobpermissionsreadbuild"></a>`readBuild` | [`Boolean!`](#boolean) | Indicates the user can perform `read_build` on this resource. |
| <a id="jobpermissionsreadjobartifacts"></a>`readJobArtifacts` | [`Boolean!`](#boolean) | Indicates the user can perform `read_job_artifacts` on this resource. |
| <a id="jobpermissionsupdatebuild"></a>`updateBuild` | [`Boolean!`](#boolean) | Indicates the user can perform `update_build` on this resource. |

### `Kas`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="kasenabled"></a>`enabled` | [`Boolean!`](#boolean) | Indicates whether the Kubernetes Agent Server is enabled. |
| <a id="kasexternalurl"></a>`externalUrl` | [`String`](#string) | URL used by the Agents to communicate with KAS. |
| <a id="kasversion"></a>`version` | [`String`](#string) | KAS version. |

### `Key`

Represents an SSH key.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="keycreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of when the key was created. |
| <a id="keyexpiresat"></a>`expiresAt` | [`Time!`](#time) | Timestamp of when the key expires. It's null if it never expires. |
| <a id="keyid"></a>`id` | [`ID!`](#id) | ID of the key. |
| <a id="keykey"></a>`key` | [`String!`](#string) | Public key of the key pair. |
| <a id="keytitle"></a>`title` | [`String!`](#string) | Title of the key. |

### `Label`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="labelcolor"></a>`color` | [`String!`](#string) | Background color of the label. |
| <a id="labelcreatedat"></a>`createdAt` | [`Time!`](#time) | When this label was created. |
| <a id="labeldescription"></a>`description` | [`String`](#string) | Description of the label (Markdown rendered as HTML for caching). |
| <a id="labeldescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="labelid"></a>`id` | [`ID!`](#id) | Label ID. |
| <a id="labeltextcolor"></a>`textColor` | [`String!`](#string) | Text color of the label. |
| <a id="labeltitle"></a>`title` | [`String!`](#string) | Content of the label. |
| <a id="labelupdatedat"></a>`updatedAt` | [`Time!`](#time) | When this label was last updated. |

### `LfsObjectRegistry`

Represents the Geo sync and verification state of an LFS object.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistrycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the LfsObjectRegistry was created. |
| <a id="lfsobjectregistryid"></a>`id` | [`ID!`](#id) | ID of the LfsObjectRegistry. |
| <a id="lfsobjectregistrylastsyncfailure"></a>`lastSyncFailure` | [`String`](#string) | Error message during sync of the LfsObjectRegistry. |
| <a id="lfsobjectregistrylastsyncedat"></a>`lastSyncedAt` | [`Time`](#time) | Timestamp of the most recent successful sync of the LfsObjectRegistry. |
| <a id="lfsobjectregistrylfsobjectid"></a>`lfsObjectId` | [`ID!`](#id) | ID of the LFS object. |
| <a id="lfsobjectregistryretryat"></a>`retryAt` | [`Time`](#time) | Timestamp after which the LfsObjectRegistry is resynced. |
| <a id="lfsobjectregistryretrycount"></a>`retryCount` | [`Int`](#int) | Number of consecutive failed sync attempts of the LfsObjectRegistry. |
| <a id="lfsobjectregistrystate"></a>`state` | [`RegistryState`](#registrystate) | Sync state of the LfsObjectRegistry. |
| <a id="lfsobjectregistryverificationretryat"></a>`verificationRetryAt` | [`Time`](#time) | Timestamp after which the LfsObjectRegistry is reverified. |
| <a id="lfsobjectregistryverifiedat"></a>`verifiedAt` | [`Time`](#time) | Timestamp of the most recent successful verification of the LfsObjectRegistry. |

### `LicenseHistoryEntry`

Represents an entry from the Cloud License history.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="licensehistoryentryactivatedat"></a>`activatedAt` | [`Date`](#date) | Date when the license was activated. |
| <a id="licensehistoryentryblockchangesat"></a>`blockChangesAt` | [`Date`](#date) | Date, including grace period, when licensed features will be blocked. |
| <a id="licensehistoryentrycompany"></a>`company` | [`String`](#string) | Company of the licensee. |
| <a id="licensehistoryentrycreatedat"></a>`createdAt` | [`Date`](#date) | Date when the license was added. |
| <a id="licensehistoryentryemail"></a>`email` | [`String`](#string) | Email of the licensee. |
| <a id="licensehistoryentryexpiresat"></a>`expiresAt` | [`Date`](#date) | Date when the license expires. |
| <a id="licensehistoryentryid"></a>`id` | [`ID!`](#id) | ID of the license extracted from the license data. |
| <a id="licensehistoryentryname"></a>`name` | [`String`](#string) | Name of the licensee. |
| <a id="licensehistoryentryplan"></a>`plan` | [`String!`](#string) | Name of the subscription plan. |
| <a id="licensehistoryentrystartsat"></a>`startsAt` | [`Date`](#date) | Date when the license started. |
| <a id="licensehistoryentrytype"></a>`type` | [`String!`](#string) | Type of the license. |
| <a id="licensehistoryentryusersinlicensecount"></a>`usersInLicenseCount` | [`Int`](#int) | Number of paid users in the license. |

### `Location`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="locationblobpath"></a>`blobPath` | [`String`](#string) | HTTP URI path to view the input file in GitLab. |
| <a id="locationpath"></a>`path` | [`String`](#string) | Path, relative to the root of the repository, of the filewhich was analyzed to detect the dependency. |

### `MavenMetadata`

Maven metadata.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mavenmetadataappgroup"></a>`appGroup` | [`String!`](#string) | App group of the Maven package. |
| <a id="mavenmetadataappname"></a>`appName` | [`String!`](#string) | App name of the Maven package. |
| <a id="mavenmetadataappversion"></a>`appVersion` | [`String`](#string) | App version of the Maven package. |
| <a id="mavenmetadatacreatedat"></a>`createdAt` | [`Time!`](#time) | Date of creation. |
| <a id="mavenmetadataid"></a>`id` | [`PackagesMavenMetadatumID!`](#packagesmavenmetadatumid) | ID of the metadatum. |
| <a id="mavenmetadatapath"></a>`path` | [`String!`](#string) | Path of the Maven package. |
| <a id="mavenmetadataupdatedat"></a>`updatedAt` | [`Time!`](#time) | Date of most recent update. |

### `MergeAccessLevel`

Defines which user roles, users, or groups can merge into a protected branch.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergeaccesslevelaccesslevel"></a>`accessLevel` | [`Int!`](#int) | GitLab::Access level. |
| <a id="mergeaccesslevelaccessleveldescription"></a>`accessLevelDescription` | [`String!`](#string) | Human readable representation for this access level. |
| <a id="mergeaccesslevelgroup"></a>`group` | [`AccessLevelGroup`](#accesslevelgroup) | Group associated with this access level. |
| <a id="mergeaccessleveluser"></a>`user` | [`AccessLevelUser`](#accessleveluser) | User associated with this access level. |

### `MergeRequest`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestallowcollaboration"></a>`allowCollaboration` | [`Boolean`](#boolean) | Indicates if members of the target project can push to the fork. |
| <a id="mergerequestapprovalstate"></a>`approvalState` | [`MergeRequestApprovalState!`](#mergerequestapprovalstate) | Information relating to rules that must be satisfied to merge this merge request. |
| <a id="mergerequestapprovalsleft"></a>`approvalsLeft` | [`Int`](#int) | Number of approvals left. |
| <a id="mergerequestapprovalsrequired"></a>`approvalsRequired` | [`Int`](#int) | Number of approvals required. |
| <a id="mergerequestapproved"></a>`approved` | [`Boolean!`](#boolean) | Indicates if the merge request has all the required approvals. Returns true if no required approvals are configured. |
| <a id="mergerequestapprovedby"></a>`approvedBy` | [`UserCoreConnection`](#usercoreconnection) | Users who approved the merge request. (see [Connections](#connections)) |
| <a id="mergerequestassignees"></a>`assignees` | [`MergeRequestAssigneeConnection`](#mergerequestassigneeconnection) | Assignees of the merge request. (see [Connections](#connections)) |
| <a id="mergerequestauthor"></a>`author` | [`MergeRequestAuthor`](#mergerequestauthor) | User who created this merge request. |
| <a id="mergerequestautomergeenabled"></a>`autoMergeEnabled` | [`Boolean!`](#boolean) | Indicates if auto merge is enabled for the merge request. |
| <a id="mergerequestautomergestrategy"></a>`autoMergeStrategy` | [`String`](#string) | Selected auto merge strategy. |
| <a id="mergerequestavailableautomergestrategies"></a>`availableAutoMergeStrategies` | [`[String!]`](#string) | Array of available auto merge strategies. |
| <a id="mergerequestawardemoji"></a>`awardEmoji` | [`AwardEmojiConnection`](#awardemojiconnection) | List of award emojis associated with the merge request. (see [Connections](#connections)) |
| <a id="mergerequestcommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="mergerequestcommitcount"></a>`commitCount` | [`Int`](#int) | Number of commits in the merge request. |
| <a id="mergerequestcommits"></a>`commits` | [`CommitConnection`](#commitconnection) | Merge request commits. (see [Connections](#connections)) |
| <a id="mergerequestcommitswithoutmergecommits"></a>`commitsWithoutMergeCommits` | [`CommitConnection`](#commitconnection) | Merge request commits excluding merge commits. (see [Connections](#connections)) |
| <a id="mergerequestcommitters"></a>`committers` | [`UserCoreConnection`](#usercoreconnection) | Users who have added commits to the merge request. (see [Connections](#connections)) |
| <a id="mergerequestconflicts"></a>`conflicts` | [`Boolean!`](#boolean) | Indicates if the merge request has conflicts. |
| <a id="mergerequestcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of when the merge request was created. |
| <a id="mergerequestdefaultmergecommitmessage"></a>`defaultMergeCommitMessage` | [`String`](#string) | Default merge commit message of the merge request. |
| <a id="mergerequestdefaultsquashcommitmessage"></a>`defaultSquashCommitMessage` | [`String`](#string) | Default squash commit message of the merge request. |
| <a id="mergerequestdescription"></a>`description` | [`String`](#string) | Description of the merge request (Markdown rendered as HTML for caching). |
| <a id="mergerequestdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="mergerequestdetailedmergestatus"></a>`detailedMergeStatus` | [`DetailedMergeStatus`](#detailedmergestatus) | Detailed merge status of the merge request. |
| <a id="mergerequestdiffheadsha"></a>`diffHeadSha` | [`String`](#string) | Diff head SHA of the merge request. |
| <a id="mergerequestdiffrefs"></a>`diffRefs` | [`DiffRefs`](#diffrefs) | References of the base SHA, the head SHA, and the start SHA for this merge request. |
| <a id="mergerequestdiffstatssummary"></a>`diffStatsSummary` | [`DiffStatsSummary`](#diffstatssummary) | Summary of which files were changed in this merge request. |
| <a id="mergerequestdiscussionlocked"></a>`discussionLocked` | [`Boolean!`](#boolean) | Indicates if comments on the merge request are locked to members only. |
| <a id="mergerequestdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="mergerequestdivergedfromtargetbranch"></a>`divergedFromTargetBranch` | [`Boolean!`](#boolean) | Indicates if the source branch is behind the target branch. |
| <a id="mergerequestdownvotes"></a>`downvotes` | [`Int!`](#int) | Number of downvotes for the merge request. |
| <a id="mergerequestdraft"></a>`draft` | [`Boolean!`](#boolean) | Indicates if the merge request is a draft. |
| <a id="mergerequestforceremovesourcebranch"></a>`forceRemoveSourceBranch` | [`Boolean`](#boolean) | Indicates if the project settings will lead to source branch deletion after merge. |
| <a id="mergerequesthasci"></a>`hasCi` | [`Boolean!`](#boolean) | Indicates if the merge request has CI. |
| <a id="mergerequesthassecurityreports"></a>`hasSecurityReports` | [`Boolean!`](#boolean) | Indicates if the source branch has any security reports. |
| <a id="mergerequestheadpipeline"></a>`headPipeline` | [`Pipeline`](#pipeline) | Pipeline running on the branch HEAD of the merge request. |
| <a id="mergerequesthumantimeestimate"></a>`humanTimeEstimate` | [`String`](#string) | Human-readable time estimate of the merge request. |
| <a id="mergerequesthumantotaltimespent"></a>`humanTotalTimeSpent` | [`String`](#string) | Human-readable total time reported as spent on the merge request. |
| <a id="mergerequestid"></a>`id` | [`ID!`](#id) | ID of the merge request. |
| <a id="mergerequestiid"></a>`iid` | [`String!`](#string) | Internal ID of the merge request. |
| <a id="mergerequestinprogressmergecommitsha"></a>`inProgressMergeCommitSha` | [`String`](#string) | Commit SHA of the merge request if merge is in progress. |
| <a id="mergerequestlabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels of the merge request. (see [Connections](#connections)) |
| <a id="mergerequestmergecommitsha"></a>`mergeCommitSha` | [`String`](#string) | SHA of the merge request commit (set once merged). |
| <a id="mergerequestmergeerror"></a>`mergeError` | [`String`](#string) | Error message due to a merge error. |
| <a id="mergerequestmergeongoing"></a>`mergeOngoing` | [`Boolean!`](#boolean) | Indicates if a merge is currently occurring. |
| <a id="mergerequestmergestatus"></a>`mergeStatus` **{warning-solid}** | [`String`](#string) | **Deprecated** in 14.0. This was renamed. Use: [`MergeRequest.mergeStatusEnum`](#mergerequestmergestatusenum). |
| <a id="mergerequestmergestatusenum"></a>`mergeStatusEnum` | [`MergeStatus`](#mergestatus) | Merge status of the merge request. |
| <a id="mergerequestmergetrainscount"></a>`mergeTrainsCount` | [`Int`](#int) | Number of merge requests in the merge train. |
| <a id="mergerequestmergeuser"></a>`mergeUser` | [`UserCore`](#usercore) | User who merged this merge request or set it to merge when pipeline succeeds. |
| <a id="mergerequestmergewhenpipelinesucceeds"></a>`mergeWhenPipelineSucceeds` | [`Boolean`](#boolean) | Indicates if the merge has been set to be merged when its pipeline succeeds (MWPS). |
| <a id="mergerequestmergeable"></a>`mergeable` | [`Boolean!`](#boolean) | Indicates if the merge request is mergeable. |
| <a id="mergerequestmergeablediscussionsstate"></a>`mergeableDiscussionsState` | [`Boolean`](#boolean) | Indicates if all discussions in the merge request have been resolved, allowing the merge request to be merged. |
| <a id="mergerequestmergedat"></a>`mergedAt` | [`Time`](#time) | Timestamp of when the merge request was merged, null if not merged. |
| <a id="mergerequestmilestone"></a>`milestone` | [`Milestone`](#milestone) | Milestone of the merge request. |
| <a id="mergerequestnotes"></a>`notes` | [`NoteConnection!`](#noteconnection) | All notes on this noteable. (see [Connections](#connections)) |
| <a id="mergerequestparticipants"></a>`participants` | [`MergeRequestParticipantConnection`](#mergerequestparticipantconnection) | Participants in the merge request. This includes the author, assignees, reviewers, and users mentioned in notes. (see [Connections](#connections)) |
| <a id="mergerequestpreparedat"></a>`preparedAt` | [`Time`](#time) | Timestamp of when the merge request was prepared. |
| <a id="mergerequestproject"></a>`project` | [`Project!`](#project) | Alias for target_project. |
| <a id="mergerequestprojectid"></a>`projectId` | [`Int!`](#int) | ID of the merge request project. |
| <a id="mergerequestrebasecommitsha"></a>`rebaseCommitSha` | [`String`](#string) | Rebase commit SHA of the merge request. |
| <a id="mergerequestrebaseinprogress"></a>`rebaseInProgress` | [`Boolean!`](#boolean) | Indicates if there is a rebase currently in progress for the merge request. |
| <a id="mergerequestreviewers"></a>`reviewers` | [`MergeRequestReviewerConnection`](#mergerequestreviewerconnection) | Users from whom a review has been requested. (see [Connections](#connections)) |
| <a id="mergerequestsecurityautofix"></a>`securityAutoFix` | [`Boolean`](#boolean) | Indicates if the merge request is created by @GitLab-Security-Bot. |
| <a id="mergerequestsecurityreportsuptodateontargetbranch"></a>`securityReportsUpToDateOnTargetBranch` | [`Boolean!`](#boolean) | Indicates if the target branch security reports are out of date. |
| <a id="mergerequestshouldberebased"></a>`shouldBeRebased` | [`Boolean!`](#boolean) | Indicates if the merge request will be rebased. |
| <a id="mergerequestshouldremovesourcebranch"></a>`shouldRemoveSourceBranch` | [`Boolean`](#boolean) | Indicates if the source branch of the merge request will be deleted after merge. |
| <a id="mergerequestsourcebranch"></a>`sourceBranch` | [`String!`](#string) | Source branch of the merge request. |
| <a id="mergerequestsourcebranchexists"></a>`sourceBranchExists` | [`Boolean!`](#boolean) | Indicates if the source branch of the merge request exists. |
| <a id="mergerequestsourcebranchprotected"></a>`sourceBranchProtected` | [`Boolean!`](#boolean) | Indicates if the source branch is protected. |
| <a id="mergerequestsourceproject"></a>`sourceProject` | [`Project`](#project) | Source project of the merge request. |
| <a id="mergerequestsourceprojectid"></a>`sourceProjectId` | [`Int`](#int) | ID of the merge request source project. |
| <a id="mergerequestsquash"></a>`squash` | [`Boolean!`](#boolean) | Indicates if the merge request is set to be squashed when merged. [Project settings](https://docs.gitlab.com/ee/user/project/merge_requests/squash_and_merge.html#configure-squash-options-for-a-project) may override this value. Use `squash_on_merge` instead to take project squash options into account. |
| <a id="mergerequestsquashonmerge"></a>`squashOnMerge` | [`Boolean!`](#boolean) | Indicates if the merge request will be squashed when merged. |
| <a id="mergerequeststate"></a>`state` | [`MergeRequestState!`](#mergerequeststate) | State of the merge request. |
| <a id="mergerequestsubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | Indicates if the currently logged in user is subscribed to this merge request. |
| <a id="mergerequestsuggestedreviewers"></a>`suggestedReviewers` **{warning-solid}** | [`SuggestedReviewersType`](#suggestedreviewerstype) | **Introduced** in 15.4. This feature is an Experiment. It can be changed or removed at any time. Suggested reviewers for merge request. Returns `null` if `suggested_reviewers` feature flag is disabled. This flag is disabled by default and only available on GitLab.com because the feature is experimental and is subject to change without notice. |
| <a id="mergerequesttargetbranch"></a>`targetBranch` | [`String!`](#string) | Target branch of the merge request. |
| <a id="mergerequesttargetbranchexists"></a>`targetBranchExists` | [`Boolean!`](#boolean) | Indicates if the target branch of the merge request exists. |
| <a id="mergerequesttargetproject"></a>`targetProject` | [`Project!`](#project) | Target project of the merge request. |
| <a id="mergerequesttargetprojectid"></a>`targetProjectId` | [`Int!`](#int) | ID of the merge request target project. |
| <a id="mergerequesttaskcompletionstatus"></a>`taskCompletionStatus` | [`TaskCompletionStatus!`](#taskcompletionstatus) | Completion status of tasks. |
| <a id="mergerequesttimeestimate"></a>`timeEstimate` | [`Int!`](#int) | Time estimate of the merge request. |
| <a id="mergerequesttimelogs"></a>`timelogs` | [`TimelogConnection!`](#timelogconnection) | Timelogs on the merge request. (see [Connections](#connections)) |
| <a id="mergerequesttitle"></a>`title` | [`String!`](#string) | Title of the merge request. |
| <a id="mergerequesttitlehtml"></a>`titleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `title`. |
| <a id="mergerequesttotaltimespent"></a>`totalTimeSpent` | [`Int!`](#int) | Total time reported as spent on the merge request. |
| <a id="mergerequestupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of when the merge request was last updated. |
| <a id="mergerequestupvotes"></a>`upvotes` | [`Int!`](#int) | Number of upvotes for the merge request. |
| <a id="mergerequestuserdiscussionscount"></a>`userDiscussionsCount` | [`Int`](#int) | Number of user discussions in the merge request. |
| <a id="mergerequestusernotescount"></a>`userNotesCount` | [`Int`](#int) | User notes count of the merge request. |
| <a id="mergerequestuserpermissions"></a>`userPermissions` | [`MergeRequestPermissions!`](#mergerequestpermissions) | Permissions for the current user on the resource. |
| <a id="mergerequestweburl"></a>`webUrl` | [`String`](#string) | Web URL of the merge request. |

#### Fields with arguments

##### `MergeRequest.currentUserTodos`

To-do items for the current user.

Returns [`TodoConnection!`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestcurrentusertodosstate"></a>`state` | [`TodoStateEnum`](#todostateenum) | State of the to-do items. |

##### `MergeRequest.diffStats`

Details about which files were changed in this merge request.

Returns [`[DiffStats!]`](#diffstats).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffstatspath"></a>`path` | [`String`](#string) | Specific file path. |

##### `MergeRequest.pipelines`

Pipelines for the merge request. Note: for performance reasons, no more than the most recent 500 pipelines will be returned.

Returns [`PipelineConnection`](#pipelineconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestpipelinesref"></a>`ref` | [`String`](#string) | Filter pipelines by the ref they are run for. |
| <a id="mergerequestpipelinesscope"></a>`scope` | [`PipelineScopeEnum`](#pipelinescopeenum) | Filter pipelines by scope. |
| <a id="mergerequestpipelinessha"></a>`sha` | [`String`](#string) | Filter pipelines by the sha of the commit they are run for. |
| <a id="mergerequestpipelinessource"></a>`source` | [`String`](#string) | Filter pipelines by their source. |
| <a id="mergerequestpipelinesstatus"></a>`status` | [`PipelineStatusEnum`](#pipelinestatusenum) | Filter pipelines by their status. |
| <a id="mergerequestpipelinesupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Pipelines updated after this date. |
| <a id="mergerequestpipelinesupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Pipelines updated before this date. |
| <a id="mergerequestpipelinesusername"></a>`username` | [`String`](#string) | Filter pipelines by the user that triggered the pipeline. |

##### `MergeRequest.reference`

Internal reference of the merge request. Returned in shortened format by default.

Returns [`String!`](#string).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestreferencefull"></a>`full` | [`Boolean`](#boolean) | Boolean option specifying whether the reference should be returned in full. |

### `MergeRequestApprovalState`

Information relating to rules that must be satisfied to merge this merge request.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestapprovalstateapprovalrulesoverwritten"></a>`approvalRulesOverwritten` | [`Boolean`](#boolean) | Indicates if the merge request approval rules are overwritten for the merge request. |
| <a id="mergerequestapprovalstateinvalidapproversrules"></a>`invalidApproversRules` | [`[ApprovalRule!]`](#approvalrule) | List of approval rules that are associated with the merge request, but invalid. |
| <a id="mergerequestapprovalstaterules"></a>`rules` | [`[ApprovalRule!]`](#approvalrule) | List of approval rules associated with the merge request. |
| <a id="mergerequestapprovalstatesuggestedapprovers"></a>`suggestedApprovers` | [`UserCoreConnection`](#usercoreconnection) | List of suggested approvers. (see [Connections](#connections)) |

### `MergeRequestAssignee`

A user assigned to a merge request.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeavatarurl"></a>`avatarUrl` | [`String`](#string) | URL of the user's avatar. |
| <a id="mergerequestassigneebot"></a>`bot` | [`Boolean!`](#boolean) | Indicates if the user is a bot. |
| <a id="mergerequestassigneecallouts"></a>`callouts` | [`UserCalloutConnection`](#usercalloutconnection) | User callouts that belong to the user. (see [Connections](#connections)) |
| <a id="mergerequestassigneecommitemail"></a>`commitEmail` | [`String`](#string) | User's default commit email. |
| <a id="mergerequestassigneeemail"></a>`email` **{warning-solid}** | [`String`](#string) | **Deprecated** in 13.7. This was renamed. Use: [`User.publicEmail`](#userpublicemail). |
| <a id="mergerequestassigneeemails"></a>`emails` | [`EmailConnection`](#emailconnection) | User's email addresses. (see [Connections](#connections)) |
| <a id="mergerequestassigneegitpodenabled"></a>`gitpodEnabled` | [`Boolean`](#boolean) | Whether Gitpod is enabled at the user level. |
| <a id="mergerequestassigneegroupcount"></a>`groupCount` | [`Int`](#int) | Group count for the user. |
| <a id="mergerequestassigneegroupmemberships"></a>`groupMemberships` | [`GroupMemberConnection`](#groupmemberconnection) | Group memberships of the user. (see [Connections](#connections)) |
| <a id="mergerequestassigneeid"></a>`id` | [`ID!`](#id) | ID of the user. |
| <a id="mergerequestassigneelocation"></a>`location` | [`String`](#string) | Location of the user. |
| <a id="mergerequestassigneemergerequestinteraction"></a>`mergeRequestInteraction` | [`UserMergeRequestInteraction`](#usermergerequestinteraction) | Details of this user's interactions with the merge request. |
| <a id="mergerequestassigneename"></a>`name` | [`String!`](#string) | Human-readable name of the user. Returns `****` if the user is a project bot and the requester does not have permission to view the project. |
| <a id="mergerequestassigneenamespace"></a>`namespace` | [`Namespace`](#namespace) | Personal namespace of the user. |
| <a id="mergerequestassigneenamespacecommitemails"></a>`namespaceCommitEmails` | [`NamespaceCommitEmailConnection`](#namespacecommitemailconnection) | User's custom namespace commit emails. (see [Connections](#connections)) |
| <a id="mergerequestassigneepreferencesgitpodpath"></a>`preferencesGitpodPath` | [`String`](#string) | Web path to the Gitpod section within user preferences. |
| <a id="mergerequestassigneeprofileenablegitpodpath"></a>`profileEnableGitpodPath` | [`String`](#string) | Web path to enable Gitpod for the user. |
| <a id="mergerequestassigneeprojectmemberships"></a>`projectMemberships` | [`ProjectMemberConnection`](#projectmemberconnection) | Project memberships of the user. (see [Connections](#connections)) |
| <a id="mergerequestassigneepublicemail"></a>`publicEmail` | [`String`](#string) | User's public email. |
| <a id="mergerequestassigneesavedreplies"></a>`savedReplies` | [`SavedReplyConnection`](#savedreplyconnection) | Saved replies authored by the user. Will not return saved replies if `saved_replies` feature flag is disabled. (see [Connections](#connections)) |
| <a id="mergerequestassigneestate"></a>`state` | [`UserState!`](#userstate) | State of the user. |
| <a id="mergerequestassigneestatus"></a>`status` | [`UserStatus`](#userstatus) | User status. |
| <a id="mergerequestassigneeuserachievements"></a>`userAchievements` **{warning-solid}** | [`UserAchievementConnection`](#userachievementconnection) | **Introduced** in 15.10. This feature is an Experiment. It can be changed or removed at any time. Achievements for the user. Only returns for namespaces where the `achievements` feature flag is enabled. |
| <a id="mergerequestassigneeuserpermissions"></a>`userPermissions` | [`UserPermissions!`](#userpermissions) | Permissions for the current user on the resource. |
| <a id="mergerequestassigneeusername"></a>`username` | [`String!`](#string) | Username of the user. Unique within this instance of GitLab. |
| <a id="mergerequestassigneewebpath"></a>`webPath` | [`String!`](#string) | Web path of the user. |
| <a id="mergerequestassigneeweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the user. |

#### Fields with arguments

##### `MergeRequestAssignee.assignedMergeRequests`

Merge requests assigned to the user.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeassignedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="mergerequestassigneeassignedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author. |
| <a id="mergerequestassigneeassignedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="mergerequestassigneeassignedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="mergerequestassigneeassignedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="mergerequestassigneeassignedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="mergerequestassigneeassignedmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="mergerequestassigneeassignedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="mergerequestassigneeassignedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="mergerequestassigneeassignedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="mergerequestassigneeassignedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="mergerequestassigneeassignedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="mergerequestassigneeassignedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="mergerequestassigneeassignedmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | Username of the reviewer. |
| <a id="mergerequestassigneeassignedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="mergerequestassigneeassignedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="mergerequestassigneeassignedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="mergerequestassigneeassignedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="mergerequestassigneeassignedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="mergerequestassigneeassignedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `MergeRequestAssignee.authoredMergeRequests`

Merge requests authored by the user.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeauthoredmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="mergerequestassigneeauthoredmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | Username of the assignee. |
| <a id="mergerequestassigneeauthoredmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="mergerequestassigneeauthoredmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="mergerequestassigneeauthoredmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="mergerequestassigneeauthoredmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="mergerequestassigneeauthoredmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="mergerequestassigneeauthoredmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="mergerequestassigneeauthoredmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="mergerequestassigneeauthoredmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="mergerequestassigneeauthoredmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="mergerequestassigneeauthoredmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="mergerequestassigneeauthoredmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="mergerequestassigneeauthoredmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | Username of the reviewer. |
| <a id="mergerequestassigneeauthoredmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="mergerequestassigneeauthoredmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="mergerequestassigneeauthoredmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="mergerequestassigneeauthoredmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="mergerequestassigneeauthoredmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="mergerequestassigneeauthoredmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `MergeRequestAssignee.groups`

Groups where the user has access.

Returns [`GroupConnection`](#groupconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneegroupspermissionscope"></a>`permissionScope` | [`GroupPermission`](#grouppermission) | Filter by permissions the user has on groups. |
| <a id="mergerequestassigneegroupssearch"></a>`search` | [`String`](#string) | Search by group name or path. |

##### `MergeRequestAssignee.reviewRequestedMergeRequests`

Merge requests assigned to the user for review.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneereviewrequestedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="mergerequestassigneereviewrequestedmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | Username of the assignee. |
| <a id="mergerequestassigneereviewrequestedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author. |
| <a id="mergerequestassigneereviewrequestedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="mergerequestassigneereviewrequestedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="mergerequestassigneereviewrequestedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="mergerequestassigneereviewrequestedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="mergerequestassigneereviewrequestedmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="mergerequestassigneereviewrequestedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="mergerequestassigneereviewrequestedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="mergerequestassigneereviewrequestedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="mergerequestassigneereviewrequestedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="mergerequestassigneereviewrequestedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="mergerequestassigneereviewrequestedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="mergerequestassigneereviewrequestedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="mergerequestassigneereviewrequestedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="mergerequestassigneereviewrequestedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="mergerequestassigneereviewrequestedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="mergerequestassigneereviewrequestedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="mergerequestassigneereviewrequestedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `MergeRequestAssignee.savedReply`

Saved reply authored by the user. Will not return saved reply if `saved_replies` feature flag is disabled.

Returns [`SavedReply`](#savedreply).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneesavedreplyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | ID of a saved reply. |

##### `MergeRequestAssignee.snippets`

Snippets authored by the user.

Returns [`SnippetConnection`](#snippetconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneesnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | Array of global snippet IDs. For example, `gid://gitlab/ProjectSnippet/1`. |
| <a id="mergerequestassigneesnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | Type of snippet. |
| <a id="mergerequestassigneesnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | Visibility of the snippet. |

##### `MergeRequestAssignee.starredProjects`

Projects starred by the user.

Returns [`ProjectConnection`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneestarredprojectssearch"></a>`search` | [`String`](#string) | Search query. |

##### `MergeRequestAssignee.timelogs`

Time logged by the user.

Returns [`TimelogConnection`](#timelogconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneetimelogsenddate"></a>`endDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or before endDate. |
| <a id="mergerequestassigneetimelogsendtime"></a>`endTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or before endTime. |
| <a id="mergerequestassigneetimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | List timelogs for a group. |
| <a id="mergerequestassigneetimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | List timelogs for a project. |
| <a id="mergerequestassigneetimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | List timelogs in a particular order. |
| <a id="mergerequestassigneetimelogsstartdate"></a>`startDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or after startDate. |
| <a id="mergerequestassigneetimelogsstarttime"></a>`startTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or after startTime. |
| <a id="mergerequestassigneetimelogsusername"></a>`username` | [`String`](#string) | List timelogs for a user. |

##### `MergeRequestAssignee.todos`

To-do items of the user.

Returns [`TodoConnection`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneetodosaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | Action to be filtered. |
| <a id="mergerequestassigneetodosauthorid"></a>`authorId` | [`[ID!]`](#id) | ID of an author. |
| <a id="mergerequestassigneetodosgroupid"></a>`groupId` | [`[ID!]`](#id) | ID of a group. |
| <a id="mergerequestassigneetodosprojectid"></a>`projectId` | [`[ID!]`](#id) | ID of a project. |
| <a id="mergerequestassigneetodosstate"></a>`state` | [`[TodoStateEnum!]`](#todostateenum) | State of the todo. |
| <a id="mergerequestassigneetodostype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | Type of the todo. |

##### `MergeRequestAssignee.workspaces`

Workspaces owned by the current user.

Returns [`WorkspaceConnection`](#workspaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | Array of global workspace IDs. For example, `["gid://gitlab/RemoteDevelopment::Workspace/1"]`. |

### `MergeRequestAuthor`

The author of the merge request.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestauthoravatarurl"></a>`avatarUrl` | [`String`](#string) | URL of the user's avatar. |
| <a id="mergerequestauthorbot"></a>`bot` | [`Boolean!`](#boolean) | Indicates if the user is a bot. |
| <a id="mergerequestauthorcallouts"></a>`callouts` | [`UserCalloutConnection`](#usercalloutconnection) | User callouts that belong to the user. (see [Connections](#connections)) |
| <a id="mergerequestauthorcommitemail"></a>`commitEmail` | [`String`](#string) | User's default commit email. |
| <a id="mergerequestauthoremail"></a>`email` **{warning-solid}** | [`String`](#string) | **Deprecated** in 13.7. This was renamed. Use: [`User.publicEmail`](#userpublicemail). |
| <a id="mergerequestauthoremails"></a>`emails` | [`EmailConnection`](#emailconnection) | User's email addresses. (see [Connections](#connections)) |
| <a id="mergerequestauthorgitpodenabled"></a>`gitpodEnabled` | [`Boolean`](#boolean) | Whether Gitpod is enabled at the user level. |
| <a id="mergerequestauthorgroupcount"></a>`groupCount` | [`Int`](#int) | Group count for the user. |
| <a id="mergerequestauthorgroupmemberships"></a>`groupMemberships` | [`GroupMemberConnection`](#groupmemberconnection) | Group memberships of the user. (see [Connections](#connections)) |
| <a id="mergerequestauthorid"></a>`id` | [`ID!`](#id) | ID of the user. |
| <a id="mergerequestauthorlocation"></a>`location` | [`String`](#string) | Location of the user. |
| <a id="mergerequestauthormergerequestinteraction"></a>`mergeRequestInteraction` | [`UserMergeRequestInteraction`](#usermergerequestinteraction) | Details of this user's interactions with the merge request. |
| <a id="mergerequestauthorname"></a>`name` | [`String!`](#string) | Human-readable name of the user. Returns `****` if the user is a project bot and the requester does not have permission to view the project. |
| <a id="mergerequestauthornamespace"></a>`namespace` | [`Namespace`](#namespace) | Personal namespace of the user. |
| <a id="mergerequestauthornamespacecommitemails"></a>`namespaceCommitEmails` | [`NamespaceCommitEmailConnection`](#namespacecommitemailconnection) | User's custom namespace commit emails. (see [Connections](#connections)) |
| <a id="mergerequestauthorpreferencesgitpodpath"></a>`preferencesGitpodPath` | [`String`](#string) | Web path to the Gitpod section within user preferences. |
| <a id="mergerequestauthorprofileenablegitpodpath"></a>`profileEnableGitpodPath` | [`String`](#string) | Web path to enable Gitpod for the user. |
| <a id="mergerequestauthorprojectmemberships"></a>`projectMemberships` | [`ProjectMemberConnection`](#projectmemberconnection) | Project memberships of the user. (see [Connections](#connections)) |
| <a id="mergerequestauthorpublicemail"></a>`publicEmail` | [`String`](#string) | User's public email. |
| <a id="mergerequestauthorsavedreplies"></a>`savedReplies` | [`SavedReplyConnection`](#savedreplyconnection) | Saved replies authored by the user. Will not return saved replies if `saved_replies` feature flag is disabled. (see [Connections](#connections)) |
| <a id="mergerequestauthorstate"></a>`state` | [`UserState!`](#userstate) | State of the user. |
| <a id="mergerequestauthorstatus"></a>`status` | [`UserStatus`](#userstatus) | User status. |
| <a id="mergerequestauthoruserachievements"></a>`userAchievements` **{warning-solid}** | [`UserAchievementConnection`](#userachievementconnection) | **Introduced** in 15.10. This feature is an Experiment. It can be changed or removed at any time. Achievements for the user. Only returns for namespaces where the `achievements` feature flag is enabled. |
| <a id="mergerequestauthoruserpermissions"></a>`userPermissions` | [`UserPermissions!`](#userpermissions) | Permissions for the current user on the resource. |
| <a id="mergerequestauthorusername"></a>`username` | [`String!`](#string) | Username of the user. Unique within this instance of GitLab. |
| <a id="mergerequestauthorwebpath"></a>`webPath` | [`String!`](#string) | Web path of the user. |
| <a id="mergerequestauthorweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the user. |

#### Fields with arguments

##### `MergeRequestAuthor.assignedMergeRequests`

Merge requests assigned to the user.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestauthorassignedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="mergerequestauthorassignedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author. |
| <a id="mergerequestauthorassignedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="mergerequestauthorassignedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="mergerequestauthorassignedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="mergerequestauthorassignedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="mergerequestauthorassignedmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="mergerequestauthorassignedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="mergerequestauthorassignedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="mergerequestauthorassignedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="mergerequestauthorassignedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="mergerequestauthorassignedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="mergerequestauthorassignedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="mergerequestauthorassignedmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | Username of the reviewer. |
| <a id="mergerequestauthorassignedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="mergerequestauthorassignedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="mergerequestauthorassignedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="mergerequestauthorassignedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="mergerequestauthorassignedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="mergerequestauthorassignedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `MergeRequestAuthor.authoredMergeRequests`

Merge requests authored by the user.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#connection-pagination-arguments):
`before: String`, `after: String`, `first: Int`, `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestauthorauthoredmergerequestsapproved"></a>`approved` | [`Boolean