import { shallowMount } from '@vue/test-utils';
import InstanceVulnerabilityReport from 'ee/security_dashboard/components/instance/instance_vulnerability_report.vue';
import VulnerabilityReportTabs from 'ee/security_dashboard/components/shared/vulnerability_report/vulnerability_report_tabs.vue';
import ReportNotConfiguredInstance from 'ee/security_dashboard/components/instance/report_not_configured_instance.vue';

describe('Instance vulnerabilities report component', () => {
  let wrapper;

  const createWrapper = ({ hasProjects = true } = {}) => {
    wrapper = shallowMount(InstanceVulnerabilityReport, {
      provide: { hasProjects },
    });
  };

  const findReportNotConfiguredInstance = () => wrapper.findComponent(ReportNotConfiguredInstance);
  const findVulnerabilityReportTabs = () => wrapper.findComponent(VulnerabilityReportTabs);

  it('shows the report not configured component if there are no projects', () => {
    createWrapper({ hasProjects: false });

    expect(findReportNotConfiguredInstance().exists()).toBe(true);
    expect(findVulnerabilityReportTabs().exists()).toBe(false);
  });

  it('shows the vulnerability report tabs component if there are projects', () => {
    createWrapper({ hasProjects: true });

    expect(findReportNotConfiguredInstance().exists()).toBe(false);
    expect(findVulnerabilityReportTabs().exists()).toBe(true);
  });
});
