# frozen_string_literal: true

module Gitlab
  module Vulnerabilities
    class BaseVulnerability
      attr_reader :data

      def initialize(data)
        @data = data.deep_symbolize_keys
      end

      # Passthrough properties
      %i[
        severity
        confidence
        solution
        identifiers
        links
        remediations
        target_branch
        scanner
        scan
      ].each { |method_name| define_method(method_name) { @data[method_name] } }

      # Ensure mandatory properties are defined
      %i[title description].each do |method_name|
        define_method(method_name) { raise NotImplementedError }
      end
    end
  end
end
