# frozen_string_literal: true

class VulnerabilityEntity < Grape::Entity
  include RequestAwareEntity

  expose :id,
    :title,
    :state,
    :severity,
    :confidence,
    :report_type,
    :resolved_on_default_branch,
    :project_default_branch,
    :resolved_at,
    :resolved_by_id,
    :dismissed_at,
    :dismissed_by_id,
    :confirmed_at,
    :confirmed_by_id
  expose :state_transitions, using: Vulnerabilities::StateTransitionEntity
  expose :issue_links, using: Vulnerabilities::IssueLinkEntity
  expose :merge_request_links, using: Vulnerabilities::MergeRequestLinkEntity
end
