# frozen_string_literal: true

module Types
  class VulnerabilitySeverityEnum < BaseEnum
    graphql_name 'VulnerabilitySeverity'
    description 'The severity of the vulnerability'

    ::Enums::Vulnerability.severity_levels.keys.each do |severity|
      value severity.to_s.upcase, value: severity.to_s, description: "#{severity.to_s.titleize} severity"
    end
  end
end
