# frozen_string_literal: true

module Types
  class VulnerabilityLocationType < BaseUnion
    graphql_name 'VulnerabilityLocation'
    description 'Represents a vulnerability location. The fields with data will depend on the vulnerability report type'

    UnexpectedReportType = Class.new(StandardError)

    possible_types VulnerabilityLocation::ClusterImageScanningType,
                   VulnerabilityLocation::ContainerScanningType,
                   VulnerabilityLocation::DependencyScanningType,
                   VulnerabilityLocation::DastType,
                   VulnerabilityLocation::SastType,
                   VulnerabilityLocation::SecretDetectionType,
                   VulnerabilityLocation::CoverageFuzzingType,
                   VulnerabilityLocation::GenericType

    def self.resolve_type(object, context)
      case object[:report_type]
      when 'cluster_image_scanning'
        VulnerabilityLocation::ClusterImageScanningType
      when 'container_scanning'
        VulnerabilityLocation::ContainerScanningType
      when 'dependency_scanning'
        VulnerabilityLocation::DependencyScanningType
      when 'dast', 'api_fuzzing'
        VulnerabilityLocation::DastType
      when 'sast'
        VulnerabilityLocation::SastType
      when 'secret_detection'
        VulnerabilityLocation::SecretDetectionType
      when 'coverage_fuzzing'
        VulnerabilityLocation::CoverageFuzzingType
      when 'generic'
        VulnerabilityLocation::GenericType
      else
        raise UnexpectedReportType, "Report type must be one of #{::Enums::Vulnerability.report_types.keys}"
      end
    end
  end
end
