# frozen_string_literal: true

module Types
  module VulnerabilityLocation
    # rubocop: disable Graphql/AuthorizeTypes
    class ContainerScanningType < BaseObject
      graphql_name 'VulnerabilityLocationContainerScanning'
      description 'Represents the location of a vulnerability found by a container security scan'

      field :dependency, ::Types::VulnerableDependencyType,
        null: true, description: 'Dependency containing the vulnerability.'

      field :image, GraphQL::Types::String,
        null: true, description: 'Name of the vulnerable container image.'

      field :operating_system, GraphQL::Types::String,
        null: true, description: 'Operating system that runs on the vulnerable container image.'
    end
  end
end
